/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.devel.extension;

import com.sap.tc.jtools.jlint.eclipse.devel.DevelPlugin;
import com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;

public class ExtensionManager {
    private static final String TESTGENERATOR_EXT_POINT = "testGenerator";
    private static final String TESTGENERATOR_ELEMENT = "testGenerator";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String DISPLAYNAME_ATTRIBUTE = "displayName";
    private static ExtensionManager manager;
    private Map testGenerators = new HashMap();
    private Map name2WizardPagesMap = new HashMap();

    public static ExtensionManager getExtensionManager() {
        if (manager != null) {
            return manager;
        }
        manager = new ExtensionManager();
        return manager;
    }

    private ExtensionManager() {
        try {
            this.init();
        }
        catch (CoreException e) {
            DevelPlugin.log(e);
            throw new IllegalArgumentException();
        }
    }

    private void init() throws CoreException {
        IPluginRegistry registry = Platform.getPluginRegistry();
        this.initTestGenerators(registry.getExtensionPoint(DevelPlugin.getPluginId(), "testGenerator"));
    }

    private void initTestGenerators(IExtensionPoint testGenExtensionPoint) throws CoreException {
        IExtension[] testGeneratorExtensions = testGenExtensionPoint.getExtensions();
        int i = 0;
        while (i < testGeneratorExtensions.length) {
            IConfigurationElement[] elements = testGeneratorExtensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if ("testGenerator".equals(elements[j].getName())) {
                    ITestGenerator testGenerator = (ITestGenerator)elements[j].createExecutableExtension(CLASS_ATTRIBUTE);
                    String displayName = elements[j].getAttribute(DISPLAYNAME_ATTRIBUTE);
                    this.testGenerators.put(displayName, testGenerator);
                    this.name2WizardPagesMap.put(displayName, testGenerator.getAdditionalPages());
                }
                ++j;
            }
            ++i;
        }
    }

    public String[] getTestGeneratorNames() {
        return this.testGenerators.keySet().toArray(new String[0]);
    }

    public ITestGenerator getTestGenerator(String generatorName) {
        return (ITestGenerator)this.testGenerators.get(generatorName);
    }

    public IWizardPage[] getAdditionalPages(String generatorName) {
        return (IWizardPage[])this.name2WizardPagesMap.get(generatorName);
    }
}

