/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.devel.extension;

import com.sap.tc.jtools.jlint.TestDefinition;
import com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.wizard.IWizardPage;

public abstract class AbstractTestGenerator
implements ITestGenerator {
    private String className;
    private String packageName;
    private String responsible;
    private String description;
    private String displayName;
    private String testGroup;
    private ParameterInterface[] inputParameters;
    private ITestMessageDescription[] messages;

    public void createTypeMembers(IType testclass, NewTypeWizardPage.ImportsManager importsMan) {
    }

    public abstract String getTestObjectType();

    public IWizardPage[] getAdditionalPages() {
        return new IWizardPage[0];
    }

    public ParameterInterface[] getInternalParameters() {
        return new ParameterInterface[0];
    }

    protected final String getClassName() {
        return this.className;
    }

    protected final String getDescription() {
        return this.description;
    }

    protected final String getDisplayName() {
        return this.displayName;
    }

    protected String getResourceBundle() {
        return null;
    }

    protected final String getTestGroup() {
        return this.testGroup;
    }

    private ParameterInterface[] getMergedInputParameters() {
        ArrayList<ParameterInterface> params = new ArrayList<ParameterInterface>();
        params.addAll(Arrays.asList(this.inputParameters));
        params.addAll(Arrays.asList(this.getAdditionalInputParameters()));
        return params.toArray(new ParameterInterface[0]);
    }

    protected ParameterInterface[] getAdditionalInputParameters() {
        return new ParameterInterface[0];
    }

    protected final String getPackageName() {
        return this.packageName;
    }

    protected final String getResponsible() {
        return this.responsible;
    }

    public TestDefinition getTestDefinition() {
        String testPackage = this.getPackageName().trim();
        String testClass = testPackage.equals("") ? this.getClassName().trim() : testPackage + "." + this.getClassName().trim();
        ParameterInterface classNameParameter = ParameterTool.createParameter((String)"TEST_CLASS", (String)"STRING", (Object)testClass);
        List<ParameterInterface> internalParams = Arrays.asList(this.getInternalParameters());
        ArrayList<ParameterInterface> newParams = new ArrayList<ParameterInterface>();
        newParams.addAll(internalParams);
        newParams.add(classNameParameter);
        try {
            return new TestDefinition(this.getDisplayName(), this.getDescription(), this.getResponsible(), this.getResourceBundle(), "1.0", newParams.toArray(new ParameterInterface[0]), this.getTestObjectType(), this.getMergedInputParameters(), this.messages);
        }
        catch (BadTreeException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public final void init(String packageName, String className, String displayName, String testGroup, String description, String responsible, ParameterInterface[] inputParameters, ITestMessageDescription[] messages) {
        this.packageName = packageName;
        this.className = className;
        this.displayName = displayName;
        this.testGroup = testGroup;
        this.description = description;
        this.responsible = responsible;
        this.inputParameters = inputParameters;
        this.messages = messages;
    }

    public void wizardFinished() {
    }

    public abstract String[] getRequiredPluginIds();

    public abstract String getSuperClass();
}

