/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.types.mdi.util;

import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DdNameTranslator;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.UnitServiceKind;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.dictionary.types.mdi.util.DataTypeMapping;
import com.sap.dictionary.types.mdi.util.MessagePool;
import com.sap.dictionary.types.services.IBackendConversionRule;
import com.sap.mdi.ddtypes.DDFixedValue;
import com.sap.typeservices.ISimpleValueServices;
import com.sap.typeservices.ITextServices;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public abstract class ProviderUtil {
    public static boolean stringIsEmpty(String string) {
        return string == null || string.trim().equals("");
    }

    public static String[][] getFixedValues(Iterator fixedValues) {
        String[] values;
        boolean upperValuesExist = false;
        if (fixedValues == null) {
            return null;
        }
        Vector<String[]> vFixedValues = new Vector<String[]>();
        while (fixedValues.hasNext()) {
            values = new String[2];
            DDFixedValue ddFixedValue = (DDFixedValue)fixedValues.next();
            String fixedValueHigh = ddFixedValue.getFixedValueHigh();
            if (fixedValueHigh.length() == 0) {
                String fixedValueLow = ddFixedValue.getFixedValueLow();
                if (ProviderUtil.stringIsEmpty(fixedValueLow)) {
                    fixedValueLow = null;
                }
                values[0] = fixedValueLow;
                values[1] = ddFixedValue.getDescription();
                vFixedValues.add(values);
                continue;
            }
            upperValuesExist = true;
        }
        if (upperValuesExist) {
            return null;
        }
        if (vFixedValues.isEmpty()) {
            return null;
        }
        values = (String[][])vFixedValues.toArray((T[])new String[0][]);
        return values;
    }

    public static String[][] getCurrencies(HashMap r3Currencies) {
        String[] currencies;
        if (r3Currencies == null || r3Currencies.isEmpty()) {
            return null;
        }
        Set currencyKeys = r3Currencies.keySet();
        TreeMap<String, String> tCurrencyKeys = new TreeMap<String, String>();
        Iterator iter = currencyKeys.iterator();
        while (iter.hasNext()) {
            String currencyKey = (String)iter.next();
            tCurrencyKeys.put(currencyKey, "");
        }
        currencyKeys = tCurrencyKeys.keySet();
        Vector<String[]> vCurrencies = new Vector<String[]>();
        Iterator iter2 = currencyKeys.iterator();
        while (iter2.hasNext()) {
            String currencyKey = (String)iter2.next();
            currencies = new String[]{currencyKey, (String)r3Currencies.get(currencyKey)};
            vCurrencies.add(currencies);
        }
        if (vCurrencies.isEmpty()) {
            return null;
        }
        currencies = (String[][])vCurrencies.toArray((T[])new String[0][]);
        return currencies;
    }

    public static IDataType getFromCache(Map cache, String typeName, Locale locale) {
        HashMap dataTypes;
        Object object = cache.get(typeName);
        if (object != null && (object = (dataTypes = (HashMap)object).get(locale)) != null) {
            return (IDataType)object;
        }
        return null;
    }

    public static void putIntoCache(Map cache, String typeName, IDataType dataType, Locale locale) {
        Object object = cache.get(typeName);
        if (object != null) {
            HashMap dataTypes = (HashMap)object;
            dataTypes.put(locale, dataType);
        } else {
            HashMap<Locale, IDataType> dataTypes = new HashMap<Locale, IDataType>();
            dataTypes.put(locale, dataType);
            cache.put(typeName, dataTypes);
        }
    }

    public static String getCurrencyFormat(XmlMap schemaType) {
        if (schemaType == null || schemaType.isEmpty()) {
            return null;
        }
        String fractionDigits = (String)schemaType.get("fractionDigits");
        if (ProviderUtil.stringIsEmpty(fractionDigits)) {
            return null;
        }
        int numberOfDecimals = Integer.valueOf(fractionDigits);
        String format = "#,##0";
        if (numberOfDecimals > 0) {
            format = format.concat(".");
            int i = 1;
            while (i <= numberOfDecimals) {
                format = format.concat("0");
                ++i;
            }
        }
        return format;
    }

    public static XmlMap createSchemaTypeXmlMap(String r3BuiltInType, int r3Length, int r3Decimals) {
        String length = "";
        String maxLength = "";
        String totalDigits = "";
        String fractionDigits = "";
        String uppercase = "";
        if (DataTypeMapping.hasMaxLength(r3BuiltInType)) {
            if (r3Length > 0) {
                maxLength = Integer.toString(r3Length);
            }
        } else if (DataTypeMapping.hasTotalDigits(r3BuiltInType)) {
            int i = DataTypeMapping.getTotalDigits(r3BuiltInType);
            if (i > 0) {
                totalDigits = Integer.toString(i);
            } else if (r3Length > 0) {
                totalDigits = Integer.toString(r3Length);
            }
            fractionDigits = Integer.toString(r3Decimals);
        } else {
            int i = DataTypeMapping.getLength(r3BuiltInType);
            if (i >= 0) {
                length = Integer.toString(i);
            }
        }
        XmlMap schemaType = new XmlMap();
        if (!ProviderUtil.stringIsEmpty(length)) {
            schemaType.put("length", length);
        }
        if (!ProviderUtil.stringIsEmpty(maxLength)) {
            schemaType.put("maxLength", maxLength);
        }
        if (!ProviderUtil.stringIsEmpty(totalDigits)) {
            schemaType.put("totalDigits", totalDigits);
        }
        if (!ProviderUtil.stringIsEmpty(fractionDigits)) {
            schemaType.put("fractionDigits", fractionDigits);
        }
        if (schemaType.isEmpty()) {
            return null;
        }
        return schemaType;
    }

    public static XmlMap createBuiltInTypeXmlMap(String r3BuiltInType, int r3Length, int r3Decimals) {
        String javaBuiltInType = DataTypeMapping.getJavaBuiltInType(r3BuiltInType);
        if (javaBuiltInType == null) {
            javaBuiltInType = "";
        }
        XmlMap schemaType = ProviderUtil.createSchemaTypeXmlMap(r3BuiltInType, r3Length, r3Decimals);
        XmlMap externalRepresentation = ProviderUtil.createExternalRepresentationXmlMap(r3Length, null, null);
        XmlMap builtInTypeXmlMap = new XmlMap();
        builtInTypeXmlMap.put("name", "Embedded");
        builtInTypeXmlMap.put("builtInType", javaBuiltInType);
        if (schemaType != null) {
            builtInTypeXmlMap.put("SchemaType", schemaType);
        }
        if (externalRepresentation != null) {
            builtInTypeXmlMap.put("ExternalRepresentation", externalRepresentation);
        }
        XmlMap simpleTypeXmlMap = new XmlMap();
        simpleTypeXmlMap.put("SimpleType", builtInTypeXmlMap);
        return simpleTypeXmlMap;
    }

    public static XmlMap createAbapTypeXmlMap(String abapTypeName, Locale locale, DdNameTranslator ddNameTranslator, String cacheName) throws DdException {
        String javaBuiltInType = DataTypeMapping.getJavaBuiltInType(abapTypeName);
        if (ProviderUtil.stringIsEmpty(javaBuiltInType)) {
            throw new DdException(MessagePool.getMessage("Type & does not exist", cacheName));
        }
        String javaName = ddNameTranslator.typeNameToFrontend(abapTypeName);
        if (javaName == null) {
            javaName = "";
        }
        XmlMap simpleTypeMap = new XmlMap();
        simpleTypeMap.put("name", javaName);
        simpleTypeMap.put("backendName", ddNameTranslator.typeNameToBackend(abapTypeName));
        simpleTypeMap.put("builtInType", javaBuiltInType);
        XmlMap simpleTypeXmlMap = new XmlMap();
        simpleTypeXmlMap.put("SimpleType", simpleTypeMap);
        return simpleTypeXmlMap;
    }

    public static XmlMap createExternalRepresentationXmlMap(int r3OutputLength, String format, Boolean uppercase) {
        String maxExtLength = "";
        XmlMap externalRepresentation = new XmlMap();
        if (r3OutputLength > 0) {
            maxExtLength = Integer.toString(r3OutputLength);
        }
        if (!ProviderUtil.stringIsEmpty(maxExtLength)) {
            externalRepresentation.put("maxExternalLength", maxExtLength);
        }
        if (!ProviderUtil.stringIsEmpty(format)) {
            externalRepresentation.put("format", format);
        }
        if (uppercase != null) {
            if (uppercase.booleanValue()) {
                externalRepresentation.put("uppercase", "true");
            } else {
                externalRepresentation.put("uppercase", "false");
            }
        }
        if (externalRepresentation.isEmpty()) {
            return null;
        }
        return externalRepresentation;
    }

    public static XmlMap createStructureXmlMap(String r3Name, XmlMap columns, DdNameTranslator ddNameTranslator) throws DdException {
        XmlMap structure = new XmlMap();
        structure.put("name", ddNameTranslator.typeNameToFrontend(r3Name));
        structure.put("backendName", ddNameTranslator.typeNameToBackend(r3Name));
        if (columns != null) {
            structure.put("columns", columns);
        }
        XmlMap structureXmlMap = new XmlMap();
        structureXmlMap.put("Structure", structure);
        return structureXmlMap;
    }

    public static XmlMap createEnumerationValuesXmlMap(String[][] fixedValues) {
        if (fixedValues == null) {
            return null;
        }
        XmlMap enumerationValues = new XmlMap();
        int i = 0;
        while (i < fixedValues.length) {
            XmlMap enumerationValue = new XmlMap();
            enumerationValue.put("value", fixedValues[i][0]);
            enumerationValue.put("description", fixedValues[i][1]);
            enumerationValues.put("EnumerationValue" + (i == 0 ? "" : "" + i), enumerationValue);
            ++i;
        }
        if (enumerationValues.isEmpty()) {
            return null;
        }
        return enumerationValues;
    }

    public static XmlMap createSimpleTypeXmlMap(String r3Name, String r3BuiltInType, String javaBuiltInType, IBackendConversionRule conversionRule, XmlMap schemaType, XmlMap externalRepresentation, XmlMap enumerationValues, ITextServices textServices, ISimpleValueServices simpleValueServices, Locale locale, DdNameTranslator ddNameTranslator) throws DdException {
        boolean isNumeric;
        String javaName = ddNameTranslator.typeNameToFrontend(r3Name);
        if (javaName == null) {
            javaName = "";
        }
        XmlMap simpleType = new XmlMap();
        simpleType.put("name", javaName);
        simpleType.put("backendName", ddNameTranslator.typeNameToBackend(r3Name));
        simpleType.put("builtInType", javaBuiltInType);
        if (schemaType != null) {
            simpleType.put("SchemaType", schemaType);
        }
        if (isNumeric = r3BuiltInType != null ? DataTypeMapping.isNumeric(r3BuiltInType, javaBuiltInType) : false) {
            simpleType.put("isNumeric", "true");
        } else {
            simpleType.put("isNumeric", "false");
        }
        if (externalRepresentation != null) {
            simpleType.put("ExternalRepresentation", externalRepresentation);
        }
        if (conversionRule != null) {
            simpleType.put("backendConversionRule", conversionRule);
        }
        if (textServices != null) {
            simpleType.put("textServices", textServices);
        }
        if (simpleValueServices != null) {
            simpleType.put("simpleValueServices", simpleValueServices);
        }
        if (enumerationValues != null) {
            simpleType.put("EnumerationValues", enumerationValues);
        }
        XmlMap simpleTypeXmlMap = new XmlMap();
        simpleTypeXmlMap.put("SimpleType", simpleType);
        return simpleTypeXmlMap;
    }

    public static XmlMap createColumnXmlMap(String columnName, String position, String r3TypeName, boolean isScalar, boolean belongsToAppend, Boolean hasCurrencyKey, String referenceTable, String referenceField, XmlMap embeddedType, DdNameTranslator ddNameTranslator) {
        XmlMap column = new XmlMap();
        column.put("position", position);
        column.put("name", ddNameTranslator.fieldNameToFrontend(columnName));
        column.put("backendName", ddNameTranslator.fieldNameToBackend(columnName));
        column.put("typeName", ddNameTranslator.typeNameToFrontend(r3TypeName));
        column.put("backendTypeName", ddNameTranslator.typeNameToBackend(r3TypeName));
        if (isScalar) {
            column.put("isScalar", "true");
        } else {
            column.put("isScalar", "false");
        }
        if (belongsToAppend) {
            column.put("belongsToAppend", "true");
        } else {
            column.put("belongsToAppend", "false");
        }
        if (hasCurrencyKey != null) {
            if (hasCurrencyKey.booleanValue()) {
                column.put("unitServiceKind", UnitServiceKind.CURRENCY);
            } else if (!hasCurrencyKey.booleanValue()) {
                column.put("unitServiceKind", UnitServiceKind.QUANTITY_NORMALIZED);
            }
        }
        if (!ProviderUtil.stringIsEmpty(referenceField)) {
            XmlMap referenceFieldInfo = new XmlMap();
            referenceFieldInfo.put("referenceStructureName", ddNameTranslator.typeNameToFrontend(referenceTable));
            referenceFieldInfo.put("referenceFieldName", ddNameTranslator.fieldNameToFrontend(referenceField));
            column.put("referenceFieldInfo", referenceFieldInfo);
        }
        if (embeddedType != null) {
            column.put("embeddedType", embeddedType);
        }
        return column;
    }
}

