/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.types.mdi.util;

public abstract class DataTypeMapping {
    private static final String JAVA_BINARY = "binary";
    public static final String JAVA_BOOLEAN = "boolean";
    private static final String JAVA_DATE = "date";
    public static final String JAVA_DECIMAL = "decimal";
    public static final String JAVA_DOUBLE = "double";
    public static final String JAVA_INTEGER = "integer";
    public static final String JAVA_SHORT = "short";
    public static final String JAVA_STRING = "string";
    private static final String JAVA_TIME = "time";
    private static final String JAVA_TIMESTAMP = "timestamp";
    public static final String R3_CHAR = "CHAR";
    private static final String R3_LCHR = "LCHR";
    private static final String R3_SSTR = "SSTR";
    private static final String R3_STRG = "STRG";
    private static final String R3_NUMC = "NUMC";
    private static final String R3_LANG = "LANG";
    private static final String R3_CLNT = "CLNT";
    private static final String R3_UNIT = "UNIT";
    private static final String R3_CUKY = "CUKY";
    private static final String R3_ACCP = "ACCP";
    private static final String R3_INT1 = "INT1";
    private static final String R3_INT2 = "INT2";
    private static final String R3_INT4 = "INT4";
    private static final String R3_DEC = "DEC";
    private static final String R3_CURR = "CURR";
    private static final String R3_QUAN = "QUAN";
    private static final String R3_PREC = "PREC";
    private static final String R3_FLTP = "FLTP";
    private static final String R3_RAW = "RAW";
    private static final String R3_LRAW = "LRAW";
    private static final String R3_RSTR = "RSTR";
    private static final String R3_DATS = "DATS";
    private static final String R3_TIMS = "TIMS";
    private static final String ABAP_C = "C";
    private static final String ABAP_D = "D";
    private static final String ABAP_F = "F";
    private static final String ABAP_G = "g";
    private static final String ABAP_I = "I";
    private static final String ABAP_N = "N";
    private static final String ABAP_T = "T";
    private static final String ABAP_Y = "y";
    private static final String ABAP_STRING = "STRING";
    private static final String ABAP_XSTRING = "XSTRING";

    public static String getJavaBuiltInType(String r3BuiltInType) {
        if (r3BuiltInType.equalsIgnoreCase(R3_CHAR) || r3BuiltInType.equalsIgnoreCase(R3_LCHR) || r3BuiltInType.equalsIgnoreCase(R3_SSTR) || r3BuiltInType.equalsIgnoreCase(R3_STRG) || r3BuiltInType.equalsIgnoreCase(R3_NUMC) || r3BuiltInType.equalsIgnoreCase(R3_LANG) || r3BuiltInType.equalsIgnoreCase(R3_CLNT) || r3BuiltInType.equalsIgnoreCase(R3_UNIT) || r3BuiltInType.equalsIgnoreCase(R3_CUKY) || r3BuiltInType.equalsIgnoreCase(R3_ACCP) || r3BuiltInType.equals(ABAP_C) || r3BuiltInType.equals(ABAP_N) || r3BuiltInType.equals(ABAP_G) || r3BuiltInType.equals(ABAP_STRING)) {
            return JAVA_STRING;
        }
        if (r3BuiltInType.equalsIgnoreCase(R3_INT1) || r3BuiltInType.equalsIgnoreCase(R3_INT2)) {
            return JAVA_SHORT;
        }
        if (r3BuiltInType.equalsIgnoreCase(R3_INT4) || r3BuiltInType.equals(ABAP_I)) {
            return JAVA_INTEGER;
        }
        if (r3BuiltInType.equalsIgnoreCase(R3_DEC) || r3BuiltInType.equalsIgnoreCase(R3_CURR) || r3BuiltInType.equalsIgnoreCase(R3_QUAN) || r3BuiltInType.equalsIgnoreCase(R3_PREC)) {
            return JAVA_DECIMAL;
        }
        if (r3BuiltInType.equalsIgnoreCase(R3_FLTP) || r3BuiltInType.equals(ABAP_F)) {
            return JAVA_DOUBLE;
        }
        if (r3BuiltInType.equalsIgnoreCase(R3_RAW) || r3BuiltInType.equalsIgnoreCase(R3_LRAW) || r3BuiltInType.equalsIgnoreCase(R3_RSTR) || r3BuiltInType.equals(ABAP_Y) || r3BuiltInType.equals(ABAP_XSTRING)) {
            return JAVA_BINARY;
        }
        if (r3BuiltInType.equalsIgnoreCase(R3_DATS) || r3BuiltInType.equals(ABAP_D)) {
            return JAVA_DATE;
        }
        if (r3BuiltInType.equalsIgnoreCase(R3_TIMS) || r3BuiltInType.equals(ABAP_T)) {
            return JAVA_TIME;
        }
        return null;
    }

    public static int getLength(String r3BuiltInType) {
        if (r3BuiltInType.equalsIgnoreCase(R3_LANG)) {
            return 1;
        }
        if (r3BuiltInType.equalsIgnoreCase(R3_DATS) || r3BuiltInType.equalsIgnoreCase(R3_TIMS)) {
            return -1;
        }
        if (r3BuiltInType.equalsIgnoreCase(R3_CLNT) || r3BuiltInType.equalsIgnoreCase(R3_UNIT)) {
            return 3;
        }
        if (r3BuiltInType.equalsIgnoreCase(R3_CUKY)) {
            return 5;
        }
        if (r3BuiltInType.equalsIgnoreCase(R3_ACCP)) {
            return 6;
        }
        return -1;
    }

    public static int getMaxLength(String r3BuiltInType) {
        return -1;
    }

    public static int getTotalDigits(String r3BuiltInType) {
        if (r3BuiltInType.equalsIgnoreCase(R3_PREC)) {
            return 2;
        }
        if (DataTypeMapping.hasTotalDigits(r3BuiltInType)) {
            return -2;
        }
        return -1;
    }

    public static int getFractionDigits(String r3BuiltInType) {
        if (r3BuiltInType.equalsIgnoreCase(R3_PREC)) {
            return 0;
        }
        if (DataTypeMapping.hasTotalDigits(r3BuiltInType)) {
            return -2;
        }
        return -1;
    }

    public static boolean hasTotalDigits(String r3BuiltInType) {
        return r3BuiltInType.equalsIgnoreCase(R3_DEC) || r3BuiltInType.equalsIgnoreCase(R3_CURR) || r3BuiltInType.equalsIgnoreCase(R3_QUAN) || r3BuiltInType.equalsIgnoreCase(R3_PREC);
    }

    public static boolean hasMaxLength(String r3BuiltInType) {
        return r3BuiltInType.equalsIgnoreCase(R3_CHAR) || r3BuiltInType.equalsIgnoreCase(R3_LCHR) || r3BuiltInType.equalsIgnoreCase(R3_SSTR) || r3BuiltInType.equalsIgnoreCase(R3_STRG) || r3BuiltInType.equalsIgnoreCase(R3_NUMC) || r3BuiltInType.equalsIgnoreCase(R3_RAW) || r3BuiltInType.equalsIgnoreCase(R3_LRAW) || r3BuiltInType.equalsIgnoreCase(R3_RSTR) || r3BuiltInType.equalsIgnoreCase(R3_CUKY) || r3BuiltInType.equalsIgnoreCase(R3_UNIT);
    }

    public static String getExternalAbapType(String internalAbapType) {
        if (internalAbapType.equals(ABAP_G)) {
            return ABAP_STRING;
        }
        if (internalAbapType.equals(ABAP_Y)) {
            return ABAP_XSTRING;
        }
        return internalAbapType;
    }

    public static boolean isNumeric(String r3BuiltInType, String javaBuiltInType) {
        boolean isNumeric = false;
        if (r3BuiltInType.equalsIgnoreCase(R3_NUMC) || r3BuiltInType.equalsIgnoreCase(R3_ACCP)) {
            isNumeric = true;
            if (javaBuiltInType.equals(JAVA_BINARY) || javaBuiltInType.equals(JAVA_BOOLEAN) || javaBuiltInType.equals(JAVA_DATE) || javaBuiltInType.equals(JAVA_TIME) || javaBuiltInType.equals(JAVA_TIMESTAMP)) {
                isNumeric = false;
            }
        }
        return isNumeric;
    }
}

