/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.types.mdi.conversions;

import com.sap.dictionary.types.mdi.conversions.XFeldBoolean;
import com.sap.dictionary.types.mdi.util.DataTypeMapping;
import com.sap.dictionary.types.mdi.util.ProviderUtil;
import com.sap.dictionary.types.services.IBackendConversionRule;
import com.sap.mdi.ddtypes.DDBuiltInType;
import com.sap.mdi.ddtypes.DDDataelement;
import com.sap.mdi.ddtypes.DDDomain;
import com.sap.mdi.ddtypes.DDObject;
import java.util.HashMap;
import java.util.Iterator;

public abstract class TypeConversionService {
    private static HashMap conversionRules = new HashMap();
    private static HashMap conversionRulesCool = new HashMap();

    public static String convertDataElementWithDomainToJava(DDDataelement ddDataelement, DDDomain ddDomain) {
        Iterator values;
        String[][] fixedValues;
        int r3Decimals;
        int r3Length;
        boolean isBoolean = false;
        if (ddDataelement == null || ddDomain == null) {
            return null;
        }
        DDObject domainChild = ddDomain.getChild();
        if (!(domainChild instanceof DDBuiltInType)) {
            conversionRules.put(ddDataelement, null);
            return null;
        }
        String r3BuiltInType = ((DDBuiltInType)domainChild).getDatatype();
        isBoolean = TypeConversionService.hasXfeldProperties(r3BuiltInType, r3Length = ((DDBuiltInType)domainChild).getDDLeng(), r3Decimals = ((DDBuiltInType)domainChild).getDecimals(), fixedValues = ProviderUtil.getFixedValues(values = ddDomain.fixedValuesIterator()));
        XFeldBoolean conversionRule = isBoolean ? new XFeldBoolean() : null;
        conversionRules.put(ddDataelement, conversionRule);
        if (isBoolean) {
            return "boolean";
        }
        return DataTypeMapping.getJavaBuiltInType(r3BuiltInType);
    }

    public static String convertDataElementWithDomainToJavaCool(String typeName, String r3BuiltInType, int r3Length, int r3Decimals, String[][] fixedValues) {
        boolean isBoolean = false;
        if (r3BuiltInType == null) {
            return null;
        }
        isBoolean = TypeConversionService.hasXfeldProperties(r3BuiltInType, r3Length, r3Decimals, fixedValues);
        XFeldBoolean conversionRule = isBoolean ? new XFeldBoolean() : null;
        conversionRulesCool.put(typeName, conversionRule);
        if (isBoolean) {
            return "boolean";
        }
        return DataTypeMapping.getJavaBuiltInType(r3BuiltInType);
    }

    public static boolean hasEnumerationValues(String javaBuiltInType) {
        return javaBuiltInType == null || !javaBuiltInType.equals("boolean");
    }

    public static boolean hasSchemaType(String javaBuiltInType) {
        return javaBuiltInType == null || !javaBuiltInType.equals("boolean");
    }

    public static boolean hasExternalRepresentation(String javaBuiltInType) {
        return javaBuiltInType == null || !javaBuiltInType.equals("boolean");
    }

    public static IBackendConversionRule getConversionRule(DDObject ddObject) {
        if (!conversionRules.containsKey(ddObject)) {
            if (ddObject instanceof DDDataelement) {
                DDObject child = ((DDDataelement)ddObject).getChild();
                if (child instanceof DDDomain) {
                    TypeConversionService.convertDataElementWithDomainToJava((DDDataelement)ddObject, (DDDomain)child);
                } else {
                    conversionRules.put(ddObject, null);
                }
            } else {
                conversionRules.put(ddObject, null);
            }
        }
        return (IBackendConversionRule)conversionRules.get(ddObject);
    }

    public static IBackendConversionRule getConversionRuleCool(String typeName) {
        if (conversionRules.containsKey(typeName)) {
            return (IBackendConversionRule)conversionRules.get(typeName);
        }
        return null;
    }

    public static boolean hasXfeldProperties(String r3BuiltInType, int r3Length, int r3Decimals, String[][] fixedValues) {
        boolean hasXfeldProperties = false;
        if (r3BuiltInType == null) {
            return false;
        }
        if (fixedValues != null && fixedValues.length == 2 && ("X".equalsIgnoreCase(fixedValues[0][0]) && ProviderUtil.stringIsEmpty(fixedValues[1][0]) || "X".equalsIgnoreCase(fixedValues[1][0]) && ProviderUtil.stringIsEmpty(fixedValues[0][0]))) {
            hasXfeldProperties = true;
        }
        if (hasXfeldProperties && (!r3BuiltInType.equals("CHAR") || r3Length != 1 || r3Decimals != 0)) {
            hasXfeldProperties = false;
        }
        return hasXfeldProperties;
    }
}

