/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.mapping.xml;

import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.ForeignKey;
import com.sap.jdo.sql.jdbc.JDBCHelper;
import com.sap.jdo.sql.mapping.MappingClass;
import com.sap.jdo.sql.mapping.MappingDiscriminator;
import com.sap.jdo.sql.mapping.MappingField;
import com.sap.jdo.sql.mapping.MappingForeignKey;
import com.sap.jdo.sql.mapping.MappingInterfaceKey;
import com.sap.jdo.sql.mapping.MappingModel;
import com.sap.jdo.sql.mapping.MappingRelationship;
import com.sap.jdo.sql.mapping.MappingVisitor;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import javax.jdo.JDOFatalInternalException;

public class Renderer_1_0
implements MappingVisitor {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String xmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineSeparator;
    private static final String mapXMLStart = "<map version=\"1.0\">" + lineSeparator;
    private static final String mapXMLEnd = "</map>" + lineSeparator;
    private static final String packageXMLStart = "<package name=\"{0}\">" + lineSeparator;
    private static final String packageXMLEnd = "</package>" + lineSeparator;
    private static final Object[] packageXMLArguments = new Object[1];
    private static final String classXMLStart = "<class name=\"{0}\">" + lineSeparator;
    private static final String classXMLEnd = "</class>" + lineSeparator;
    private static final Object[] classXMLArguments = new Object[1];
    private static final String discriminatorXMLStart = "<discriminator>" + lineSeparator;
    private static final String discriminatorXMLEnd = "</discriminator>" + lineSeparator;
    private static final String columnXMLStart = "<column name=\"{0}\" table=\"{1}\">" + lineSeparator;
    private static final String columnXMLEnd = "</column>" + lineSeparator;
    private static final Object[] columnXMLArguments = new Object[2];
    private static final String fieldXMLStart = "<field name=\"{0}\">" + lineSeparator;
    private static final String virtualFieldXMLStart = "<field name=\"{0}\" virtual=\"true\">" + lineSeparator;
    private static final String fieldXMLEnd = "</field>" + lineSeparator;
    private static final Object[] fieldXMLArguments = new Object[1];
    private static final String relationshipFieldXMLStart = "<relationship-field name=\"{0}\" multiplicity=\"{1}\" join-table=\"{2}\" update=\"{3}\">" + lineSeparator;
    private static final String relationshipFieldXMLEnd = "</relationship-field>" + lineSeparator;
    private static final Object[] relationshipFieldXMLArguments = new Object[4];
    private static final String[] multiplicityTableXML = new String[]{null, "one", "many"};
    private static final String[] booleanTableXML = new String[]{"false", "true"};
    private static final String foreignKeyXMLStart = "<foreign-key name=\"{0}\" foreign-key-table=\"{1}\" primary-key-table=\"{2}\">" + lineSeparator;
    private static final String foreignKeyXMLEnd = "</foreign-key>" + lineSeparator;
    private static final Object[] foreignKeyXMLArguments = new Object[3];
    private static final String columnPairXML = "<column-pair foreign-key-column=\"{0}\" primary-key-column=\"{1}\"/>" + lineSeparator;
    private static final Object[] columnPairXMLArguments = new Object[2];
    private static final String referenceXMLStart = "<reference>" + lineSeparator;
    private static final String referenceXMLEnd = "</reference>" + lineSeparator;
    private static final String countXMLStart = "<count>" + lineSeparator;
    private static final String countXMLEnd = "</count>" + lineSeparator;
    private static final String serializedDataXMLStart = "<serialized-data>" + lineSeparator;
    private static final String serializedDataXMLEnd = "</serialized-data>" + lineSeparator;
    private static final String jdbcTypeXMLStart = "<jdbc-type name=\"{0}\"";
    private static final String jdbcTypeLengthXML = " length=\"{0}\"";
    private static final String jdbcTypeDecimalsXML = " decimals=\"{0}\"";
    private static final String jdbcTypeIsNotNullXML = " is-not-null=\"{0}\"";
    private static final String jdbcTypeIsPrimaryKeyXML = " is-primary-key=\"{0}\"";
    private static final String jdbcTypeXMLEnd = "/>" + lineSeparator;
    private static final Object[] jdbcTypeXMLArguments = new Object[1];
    private OutputStreamWriter _out = null;
    private int _indent = 0;
    private IOException _ioException = null;
    private String _currentPackageName = null;

    public Renderer_1_0(OutputStreamWriter out) {
        this._out = out;
    }

    public void render(MappingModel mappingModel) throws IOException {
        try {
            mappingModel.accept(this);
        }
        catch (IOException ioException) {
            throw ioException;
        }
        catch (Exception e) {
            throw new RuntimeException("error in renderer");
        }
    }

    public void render(MappingClass mappingClass) throws IOException {
        MappingModel mappingModel = mappingClass.getDeclaringModel();
        try {
            this.visitMappingModelPre(mappingModel);
            mappingClass.accept(this);
            this.visitMappingModelPost(mappingModel);
        }
        catch (IOException ioException) {
            throw ioException;
        }
        catch (Exception e) {
            throw new RuntimeException("error in renderer");
        }
    }

    public void visitMappingModelPre(MappingModel mappingModel) throws Exception {
        this._indent = 0;
        this.write(xmlHeader);
        this.write(mapXMLStart);
    }

    public void visitMappingModelPost(MappingModel mappingModel) throws Exception {
        if (this._currentPackageName != null) {
            this.write(packageXMLEnd);
            --this._indent;
        }
        this.write(mapXMLEnd);
    }

    public void visitMappingClassPre(MappingClass mappingClass) throws Exception {
        if (!mappingClass.getPackageName().equals(this._currentPackageName)) {
            if (this._currentPackageName != null) {
                this.write(packageXMLEnd);
            } else {
                ++this._indent;
            }
            this._currentPackageName = mappingClass.getPackageName();
            Renderer_1_0.packageXMLArguments[0] = this._currentPackageName;
            this.write(MessageFormat.format(packageXMLStart, packageXMLArguments));
        }
        ++this._indent;
        Renderer_1_0.classXMLArguments[0] = mappingClass.getNonQualifiedName();
        this.write(MessageFormat.format(classXMLStart, classXMLArguments));
    }

    public void visitMappingClassPost(MappingClass mappingClass) throws Exception {
        this.write(classXMLEnd);
        --this._indent;
    }

    public void visitMappingDiscriminatorPre(MappingDiscriminator mappingDiscriminator) throws Exception {
        ++this._indent;
        this.write(discriminatorXMLStart);
        this.render(mappingDiscriminator.getColumns());
    }

    public void visitMappingDiscriminatorPost(MappingDiscriminator mappingDiscriminator) throws Exception {
        this.write(discriminatorXMLEnd);
        --this._indent;
    }

    public void visitMappingFieldPre(MappingField mappingField) throws Exception {
        if (mappingField.getMappingRelationship() == null) {
            ++this._indent;
            Renderer_1_0.fieldXMLArguments[0] = mappingField.getName();
            if (mappingField.isVirtual()) {
                this.write(MessageFormat.format(virtualFieldXMLStart, fieldXMLArguments));
            } else {
                this.write(MessageFormat.format(fieldXMLStart, fieldXMLArguments));
            }
            this.render(mappingField.getColumns());
        }
    }

    public void visitMappingFieldPost(MappingField mappingField) throws Exception {
        if (mappingField.getMappingRelationship() == null) {
            this.write(fieldXMLEnd);
            --this._indent;
        }
    }

    public void visitMappingRelationshipPre(MappingRelationship mappingRelationship) throws Exception {
        ++this._indent;
        Renderer_1_0.relationshipFieldXMLArguments[0] = mappingRelationship.getDeclaringField().getName();
        Renderer_1_0.relationshipFieldXMLArguments[1] = multiplicityTableXML[mappingRelationship.getMultiplicity()];
        Renderer_1_0.relationshipFieldXMLArguments[2] = booleanTableXML[mappingRelationship.getKeyType() == 2 ? 1 : 0];
        Renderer_1_0.relationshipFieldXMLArguments[3] = booleanTableXML[mappingRelationship.getUpdate() ? 1 : 0];
        this.write(MessageFormat.format(relationshipFieldXMLStart, relationshipFieldXMLArguments));
        if (mappingRelationship.getCountColumn() != null) {
            ++this._indent;
            this.write(countXMLStart);
            this.render(mappingRelationship.getCountColumn());
            this.write(countXMLEnd);
            --this._indent;
        }
    }

    public void visitMappingRelationshipPost(MappingRelationship mappingRelationship) throws Exception {
        this.write(relationshipFieldXMLEnd);
        --this._indent;
    }

    public void visitMappingForeignKeyPre(MappingForeignKey mappingForeignKey) throws Exception {
        this.render(mappingForeignKey.getForeignKey());
    }

    public void visitMappingForeignKeyPost(MappingForeignKey mappingForeignKey) throws Exception {
    }

    public void visitMappingInterfaceKeyPre(MappingInterfaceKey mappingInterfaceKey) throws Exception {
        ++this._indent;
        this.write(discriminatorXMLStart);
        this.render(mappingInterfaceKey.getDiscriminatorColumn());
        this.write(discriminatorXMLEnd);
        this.write(referenceXMLStart);
        this.render(mappingInterfaceKey.getReferenceColumn());
        this.write(referenceXMLEnd);
        if (mappingInterfaceKey.getSerializedDataColumn() != null) {
            this.write(serializedDataXMLStart);
            this.render(mappingInterfaceKey.getSerializedDataColumn());
            this.write(serializedDataXMLEnd);
        }
        --this._indent;
    }

    public void visitMappingInterfaceKeyPost(MappingInterfaceKey mappingInterfaceKey) throws Exception {
    }

    private void render(Column[] columns) throws IOException {
        int i = 0;
        while (i < columns.length) {
            this.render(columns[i]);
            ++i;
        }
    }

    private void render(Column column) throws IOException {
        ++this._indent;
        Renderer_1_0.columnXMLArguments[0] = column.getName();
        Renderer_1_0.columnXMLArguments[1] = column.getTable().getName();
        this.write(MessageFormat.format(columnXMLStart, columnXMLArguments));
        this.render(column.getJdbcType(), column.getSize(), column.getDecimals(), !column.isNullable(), column.isPrimaryKey());
        this.write(columnXMLEnd);
        --this._indent;
    }

    private void render(int jdbcType, long length, int decimals, boolean isNotNull, boolean isPrimaryKey) throws IOException {
        ++this._indent;
        try {
            Renderer_1_0.jdbcTypeXMLArguments[0] = JDBCHelper.getJdbcTypeName(jdbcType);
        }
        catch (JDBCHelper.InvalidJdbcType e) {
            throw new JDOFatalInternalException("invalid JDBC type", (Throwable)e);
        }
        StringBuffer s = new StringBuffer(MessageFormat.format(jdbcTypeXMLStart, jdbcTypeXMLArguments));
        if (length > 0L) {
            Renderer_1_0.jdbcTypeXMLArguments[0] = new Long(length).toString();
            s.append(MessageFormat.format(jdbcTypeLengthXML, jdbcTypeXMLArguments));
            if (jdbcType == 3 || jdbcType == 2) {
                Renderer_1_0.jdbcTypeXMLArguments[0] = new Integer(decimals);
                s.append(MessageFormat.format(jdbcTypeDecimalsXML, jdbcTypeXMLArguments));
            }
        }
        Renderer_1_0.jdbcTypeXMLArguments[0] = new Boolean(isNotNull);
        s.append(MessageFormat.format(jdbcTypeIsNotNullXML, jdbcTypeXMLArguments));
        Renderer_1_0.jdbcTypeXMLArguments[0] = new Boolean(isPrimaryKey);
        s.append(MessageFormat.format(jdbcTypeIsPrimaryKeyXML, jdbcTypeXMLArguments));
        s.append(jdbcTypeXMLEnd);
        this.write(s.toString());
        --this._indent;
    }

    private void render(Column fkColumn, Column pkColumn) throws IOException {
        ++this._indent;
        Renderer_1_0.columnPairXMLArguments[0] = fkColumn.getName();
        Renderer_1_0.columnPairXMLArguments[1] = pkColumn.getName();
        this.write(MessageFormat.format(columnPairXML, columnPairXMLArguments));
        --this._indent;
    }

    private void render(ForeignKey foreignKey) throws IOException {
        ++this._indent;
        Column[] fkColumns = foreignKey.getForeignKeyColumns();
        Column[] pkColumns = foreignKey.getPrimaryKeyColumns();
        Renderer_1_0.foreignKeyXMLArguments[0] = foreignKey.getName();
        Renderer_1_0.foreignKeyXMLArguments[1] = foreignKey.getForeignKeyTable().getName();
        Renderer_1_0.foreignKeyXMLArguments[2] = foreignKey.getPrimaryKeyTable().getName();
        this.write(MessageFormat.format(foreignKeyXMLStart, foreignKeyXMLArguments));
        int i = 0;
        while (i < fkColumns.length) {
            this.render(fkColumns[i], pkColumns[i]);
            ++i;
        }
        this.write(foreignKeyXMLEnd);
        --this._indent;
    }

    private void write(String s) throws IOException {
        Object _indentString = null;
        int i = 0;
        while (i < this._indent) {
            this._out.write(32);
            this._out.write(32);
            ++i;
        }
        this._out.write(s);
    }
}

