/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.mapping.impl;

import com.sap.jdo.model.jdo.JDOArray;
import com.sap.jdo.model.jdo.JDOCollection;
import com.sap.jdo.model.jdo.JDOField;
import com.sap.jdo.model.jdo.JDOMap;
import com.sap.jdo.model.jdo.JDOReference;
import com.sap.jdo.model.jdo.JDORelationship;
import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.JDOCatalogReader;
import com.sap.jdo.sql.catalog.Table;
import com.sap.jdo.sql.mapping.MappingField;
import com.sap.jdo.sql.mapping.MappingForeignKey;
import com.sap.jdo.sql.mapping.MappingInterfaceKey;
import com.sap.jdo.sql.mapping.MappingKey;
import com.sap.jdo.sql.mapping.MappingRelationship;
import com.sap.jdo.sql.mapping.MappingVisitor;
import com.sap.jdo.sql.mapping.impl.MappingClassImpl;
import com.sap.jdo.sql.mapping.impl.MappingFieldImpl;
import com.sap.jdo.sql.mapping.impl.MappingForeignKeyImpl;
import com.sap.jdo.sql.mapping.impl.MappingInterfaceKeyImpl;
import com.sap.jdo.sql.mapping.impl.MappingModelChecker;
import com.sap.jdo.sql.mapping.impl.MappingModelImpl;
import java.sql.SQLException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;

public class MappingRelationshipImpl
implements MappingRelationship {
    MappingFieldImpl _declaringField;
    private JDORelationship _jdoRelationship;
    private int _type;
    private int _relationshipType;
    private MappingKey[] _mappingSingleKeys;
    private MappingKey[] _mappingDoubleKeys;
    private Column _countColumn;
    private boolean _isChecked;
    private int _multiplicity;
    private boolean _update;

    public MappingRelationshipImpl(MappingFieldImpl mappingField, int multiplicity, boolean update) {
        if (mappingField == null) {
            throw new IllegalArgumentException("no mapping field given");
        }
        this._declaringField = mappingField;
        this._jdoRelationship = null;
        this._type = 0;
        this._relationshipType = 0;
        this._mappingSingleKeys = new MappingKey[1];
        this._mappingDoubleKeys = new MappingKey[2];
        this._countColumn = null;
        this._multiplicity = multiplicity;
        this._update = update;
        this._isChecked = false;
    }

    public MappingRelationshipImpl(MappingFieldImpl declaringField, int multiplicity, boolean join, boolean update) {
        this(declaringField, multiplicity, update);
        this._type = join ? 2 : 1;
    }

    public synchronized MappingField getDeclaringField() {
        return this._declaringField;
    }

    public synchronized int getMultiplicity() {
        return this._multiplicity;
    }

    public synchronized boolean getUpdate() {
        return this._update;
    }

    public synchronized JDORelationship getJDORelationship() {
        if (this._jdoRelationship != null) {
            return this._jdoRelationship;
        }
        JDOField jdoField = this.getDeclaringField().getJDOField();
        if (jdoField != null) {
            this._jdoRelationship = jdoField.getRelationship();
            return this._jdoRelationship;
        }
        return null;
    }

    public synchronized MappingForeignKey createMappingForeignKey() {
        this.invalidateCID();
        MappingForeignKeyImpl mappingForeignKey = null;
        int mappingForeignKeyType = 0;
        if (this._type == 0) {
            throw new JDOFatalInternalException("ASSERT: illegal internal state");
        }
        if (this._type == 1) {
            if (this._multiplicity == 1) {
                mappingForeignKeyType = this._update ? 1 : 2;
                this._relationshipType = 1;
            } else if (this._multiplicity == 2) {
                mappingForeignKeyType = 2;
                this._relationshipType = 2;
            } else {
                throw new JDOFatalInternalException("ASSERT: illegal value" + this._multiplicity);
            }
            mappingForeignKey = new MappingForeignKeyImpl(this, mappingForeignKeyType);
            this._mappingSingleKeys[0] = mappingForeignKey;
        } else if (this._type == 2) {
            int i = 0;
            if (this._mappingDoubleKeys[i] == null) {
                mappingForeignKeyType = 3;
            } else if (this._mappingDoubleKeys[++i] == null) {
                mappingForeignKeyType = 4;
                this._relationshipType = 2;
            } else {
                throw new JDOFatalInternalException("ASSERT: illegal internal state");
            }
            mappingForeignKey = new MappingForeignKeyImpl(this, mappingForeignKeyType);
            this._mappingDoubleKeys[i] = mappingForeignKey;
        } else {
            throw new JDOFatalInternalException("ASSERT: illegal value" + this._type);
        }
        return mappingForeignKey;
    }

    public synchronized MappingInterfaceKey createMappingInterfaceKey() {
        this.invalidateCID();
        MappingInterfaceKeyImpl mappingInterfaceKey = null;
        if (this._type == 0) {
            throw new JDOFatalInternalException("ASSERT: illegal internal state");
        }
        if (this._type == 1) {
            if (this._mappingSingleKeys[0] != null) {
                throw new JDOFatalInternalException("ASSERT: illegal internal state");
            }
            mappingInterfaceKey = new MappingInterfaceKeyImpl(this, 5);
            this._relationshipType = 3;
            this._mappingSingleKeys[0] = mappingInterfaceKey;
        } else if (this._type == 2) {
            if (this._mappingDoubleKeys[0] == null || this._mappingDoubleKeys[1] != null) {
                throw new JDOFatalInternalException("ASSERT: illegal internal state");
            }
            mappingInterfaceKey = new MappingInterfaceKeyImpl(this, 6);
            this._relationshipType = 5;
            this._mappingDoubleKeys[1] = mappingInterfaceKey;
        } else {
            throw new JDOFatalInternalException("ASSERT: illegal value" + this._type);
        }
        return mappingInterfaceKey;
    }

    public synchronized int getKeyType() {
        return this._type;
    }

    public synchronized int getRelationshipType() {
        return this._relationshipType;
    }

    public synchronized MappingKey[] getMappingKeys() {
        this.checkConsistency();
        if (this._type == 1) {
            return this._mappingSingleKeys;
        }
        if (this._type == 2) {
            return this._mappingDoubleKeys;
        }
        return null;
    }

    public synchronized MappingKey getMappingKey(int mappingKeyType) {
        this.checkConsistency();
        switch (mappingKeyType) {
            case 1: 
            case 2: {
                return this._mappingSingleKeys[0];
            }
            case 3: {
                return this._mappingDoubleKeys[0];
            }
            case 4: {
                return this._mappingDoubleKeys[1];
            }
        }
        throw new JDOFatalInternalException("ASSERT: illegal value" + mappingKeyType);
    }

    public synchronized MappingKey getMappingSingleKey() {
        this.checkConsistency();
        return this._mappingSingleKeys[0];
    }

    public synchronized MappingKey[] getMappingDoubleKeys() {
        this.checkConsistency();
        return this._mappingDoubleKeys;
    }

    public synchronized Column setCountColumn(String columnName, String tableName) {
        this.invalidateCID();
        Column column = null;
        try {
            MappingClassImpl mappingClass = (MappingClassImpl)this.getDeclaringField().getDeclaringClass();
            JDOCatalogReader catalogReader = mappingClass.getDeclaringModel().getCatalogReader();
            Table table = catalogReader.getTable(tableName);
            if (table == null) {
                throw new JDOFatalUserException("table " + tableName + " not found in catalog");
            }
            column = table.getColumn(columnName);
            if (column == null) {
                throw new JDOFatalUserException("column " + columnName + " in table " + tableName + " not found in catalog");
            }
            this._countColumn = column;
        }
        catch (SQLException e) {
            throw new JDOFatalUserException("catalog error", (Throwable)e);
        }
        return column;
    }

    public synchronized Column getCountColumn() {
        this.checkConsistency();
        return this._countColumn;
    }

    public synchronized Class getReferredType() {
        this.checkConsistency();
        JDORelationship jdoRelationship = this.getJDORelationship();
        Class referredPCClass = null;
        if (jdoRelationship != null) {
            if (jdoRelationship instanceof JDOCollection) {
                referredPCClass = (Class)((JDOCollection)jdoRelationship).getElementType();
                if (referredPCClass == null) {
                    throw new JDOFatalInternalException("referred element type " + ((JDOCollection)jdoRelationship).getElementTypeName() + " not found");
                }
            } else if (jdoRelationship instanceof JDOReference) {
                referredPCClass = (Class)jdoRelationship.getDeclaringField().getType();
                if (referredPCClass == null) {
                    throw new JDOFatalInternalException("referred type " + jdoRelationship.getDeclaringField().getTypeName() + " not found");
                }
            } else {
                if (jdoRelationship instanceof JDOArray) {
                    throw new UnsupportedOperationException("RESTRICTION: arrays not (yet) supported");
                }
                if (jdoRelationship instanceof JDOMap) {
                    throw new UnsupportedOperationException("RESTRICTION: maps not (yet) supported");
                }
                throw new JDOFatalInternalException("ASSERT: illegal type" + jdoRelationship.getClass());
            }
        }
        return referredPCClass;
    }

    public synchronized boolean isInPlace(boolean forceInPlace) {
        this.checkConsistency();
        return this.getKeyType() == 1 && this.getMappingSingleKey().getKeyType() == 1 && (this.getDeclaringField().getJDOField().isDefaultFetchGroup() || forceInPlace);
    }

    public synchronized void checkConsistency() {
        if (this._isChecked) {
            return;
        }
        MappingRelationshipImpl mappingRelationshipImpl = this;
        synchronized (mappingRelationshipImpl) {
            if (!this._isChecked) {
                try {
                    this._isChecked = true;
                    if (((MappingModelImpl)this.getDeclaringField().getDeclaringClass().getDeclaringModel())._checkConsistencyDeep.equals(Boolean.TRUE)) {
                        MappingModelChecker.checkMappingRelationship(this);
                    }
                }
                catch (Exception e) {
                    this._isChecked = false;
                    throw new JDOFatalUserException("consistency check error for " + this._declaringField.getName(), (Throwable)e);
                }
            }
        }
    }

    public synchronized void accept(MappingVisitor mappingVisitor) throws Exception {
        mappingVisitor.visitMappingRelationshipPre(this);
        MappingKey[] mks = this.getMappingKeys();
        int i = 0;
        while (i < mks.length) {
            if (mks[i] == null) {
                System.out.println(this);
            } else {
                mks[i].accept(mappingVisitor);
            }
            ++i;
        }
        mappingVisitor.visitMappingRelationshipPost(this);
    }

    private void invalidateCID() {
        this._declaringField._declaringClass.invalidateClassCID();
    }

    public synchronized String toString() {
        return "MappingRelationship[DeclaringField = " + this._declaringField + "]";
    }
}

