/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.mapping.impl;

import com.sap.jdo.common.model.jdo.util.TypeSupport;
import com.sap.jdo.model.jdo.JDOCollection;
import com.sap.jdo.model.jdo.JDOField;
import com.sap.jdo.model.jdo.JDOReference;
import com.sap.jdo.model.jdo.JDORelationship;
import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.ForeignKey;
import com.sap.jdo.sql.catalog.virtual.VirtualColumn;
import com.sap.jdo.sql.jdbc.JDBCHelper;
import com.sap.jdo.sql.mapping.MappingClass;
import com.sap.jdo.sql.mapping.MappingDiscriminator;
import com.sap.jdo.sql.mapping.MappingField;
import com.sap.jdo.sql.mapping.MappingForeignKey;
import com.sap.jdo.sql.mapping.MappingInterfaceKey;
import com.sap.jdo.sql.mapping.MappingModel;
import com.sap.jdo.sql.mapping.MappingRelationship;
import com.sap.jdo.sql.mapping.MappingVisitor;
import com.sap.jdo.sql.mapping.impl.MappingModelImpl;
import javax.jdo.JDOFatalInternalException;

public class MappingModelJDBCTypeSupplier
implements MappingVisitor {
    private boolean _storeCharacterAsNumber;
    private boolean _storeAllNumbersAsDecimals;
    private boolean _storeFloatAsDouble;
    private boolean _storeDateAsLong;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$io$Serializable;

    private MappingModelJDBCTypeSupplier() {
    }

    public static void process(MappingClass mappingClass) {
        MappingModelJDBCTypeSupplier jdbcTypeSupplier = new MappingModelJDBCTypeSupplier();
        try {
            mappingClass.accept(jdbcTypeSupplier);
        }
        catch (Exception e) {
            if (e instanceof JDOFatalInternalException) {
                throw (JDOFatalInternalException)((Object)e);
            }
            throw new JDOFatalInternalException("ASSERTION FAILED: unexpected exception: ", (Throwable)e);
        }
    }

    public void visitMappingModelPre(MappingModel mappingModel) {
    }

    public void visitMappingModelPost(MappingModel mappingModel) {
    }

    public void visitMappingClassPre(MappingClass mappingClass) {
        MappingModelImpl mappingModel = (MappingModelImpl)mappingClass.getDeclaringModel();
        this._storeCharacterAsNumber = mappingModel._storeCharacterAsNumber;
        this._storeAllNumbersAsDecimals = mappingModel._storeAllNumbersAsDecimals;
        this._storeFloatAsDouble = mappingModel._storeFloatAsDouble;
        this._storeDateAsLong = mappingModel._storeDateAsLong;
    }

    public void visitMappingClassPost(MappingClass mappingClass) {
    }

    public void visitMappingDiscriminatorPre(MappingDiscriminator mappingDiscriminator) {
        Column[] columns = mappingDiscriminator.getColumns();
        if (columns.length != 1) {
            throw new JDOFatalInternalException("ASSERTION FAILED: invalid number of columns: " + columns.length);
        }
        Column discriminatorColumn = columns[0];
        this.set(discriminatorColumn, false, false, class$java$lang$String == null ? (class$java$lang$String = MappingModelJDBCTypeSupplier.class$("java.lang.String")) : class$java$lang$String);
    }

    public void visitMappingDiscriminatorPost(MappingDiscriminator mappingDiscriminator) {
    }

    public void visitMappingFieldPre(MappingField mappingField) {
        Column[] columns = mappingField.getColumns();
        JDOField jdoField = mappingField.getJDOField();
        if (jdoField == null) {
            return;
        }
        JDORelationship jdoRelationship = jdoField.getRelationship();
        if (jdoRelationship == null) {
            if (columns == null) {
                throw new JDOFatalInternalException("ASSERTION FAILED: no columns found");
            }
            if (columns.length <= 0) {
                throw new JDOFatalInternalException("ASSERTION FAILED: invalid number of columns: " + columns.length);
            }
            boolean isPrimaryKey = mappingField.getJDOField().isPrimaryKey();
            Class type = (Class)mappingField.getJDOField().getType();
            int i = 0;
            while (i < columns.length) {
                this.set(columns[i], isPrimaryKey, !isPrimaryKey, type);
                ++i;
            }
        } else {
            Class referencedType = null;
            if (jdoRelationship instanceof JDOReference) {
                referencedType = (Class)jdoRelationship.getDeclaringField().getType();
            } else if (jdoRelationship instanceof JDOCollection) {
                referencedType = (Class)((JDOCollection)jdoRelationship).getElementType();
            } else {
                throw new JDOFatalInternalException("ASSERTION FAILED: unsupported");
            }
            if (!(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = MappingModelJDBCTypeSupplier.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(referencedType) && TypeSupport.isValueType(jdoField.getDeclaringClass().getDeclaringModel(), referencedType)) {
                if (columns == null) {
                    throw new JDOFatalInternalException("ASSERTION FAILED: no columns found");
                }
                if (columns.length != 1) {
                    throw new JDOFatalInternalException("ASSERTION FAILED: invalid number of columns: " + columns.length);
                }
                Column column = columns[0];
                this.set(column, false, true, class$java$sql$Blob == null ? (class$java$sql$Blob = MappingModelJDBCTypeSupplier.class$("java.sql.Blob")) : class$java$sql$Blob);
            }
        }
    }

    public void visitMappingFieldPost(MappingField mappingField) {
    }

    public void visitMappingRelationshipPre(MappingRelationship mappingRelationship) {
        Column countColumn = mappingRelationship.getCountColumn();
        int type = mappingRelationship.getKeyType();
        if (countColumn != null) {
            if (type == 1) {
                this.set(countColumn, false, true, Integer.TYPE);
            } else if (type == 2) {
                this.set(countColumn, false, false, Integer.TYPE);
            }
        }
    }

    public void visitMappingRelationshipPost(MappingRelationship mappingRelationship) {
    }

    public void visitMappingForeignKeyPre(MappingForeignKey mappingForeignKey) {
        int type = mappingForeignKey.getKeyType();
        ForeignKey foreignKey = mappingForeignKey.getForeignKey();
        Column[] foreignKeyColumns = foreignKey.getForeignKeyColumns();
        int i = 0;
        while (i < foreignKeyColumns.length) {
            if (type == 2 || type == 1) {
                this.set(foreignKeyColumns[i], false, true);
            } else if (type == 3 || type == 4) {
                this.set(foreignKeyColumns[i], false, false);
            }
            ++i;
        }
    }

    public void visitMappingForeignKeyPost(MappingForeignKey mappingForeignKey) {
    }

    public void visitMappingInterfaceKeyPre(MappingInterfaceKey mappingInterfaceKey) {
        Column serializedDataColumn;
        Column referenceColumn;
        Column discriminatorColumn = mappingInterfaceKey.getDiscriminatorColumn();
        if (discriminatorColumn != null) {
            this.set(discriminatorColumn, false, true, class$java$lang$String == null ? (class$java$lang$String = MappingModelJDBCTypeSupplier.class$("java.lang.String")) : class$java$lang$String);
        }
        if ((referenceColumn = mappingInterfaceKey.getReferenceColumn()) != null) {
            this.set(referenceColumn, false, true, class$java$lang$String == null ? (class$java$lang$String = MappingModelJDBCTypeSupplier.class$("java.lang.String")) : class$java$lang$String, 2000);
        }
        if ((serializedDataColumn = mappingInterfaceKey.getSerializedDataColumn()) != null) {
            this.set(serializedDataColumn, false, true, class$java$io$Serializable == null ? (class$java$io$Serializable = MappingModelJDBCTypeSupplier.class$("java.io.Serializable")) : class$java$io$Serializable, 0);
        }
    }

    public void visitMappingInterfaceKeyPost(MappingInterfaceKey mappingInterfaceKey) {
    }

    private void set(Column column, boolean isPrimaryKey, boolean isNullable, Class type) {
        if (column == null) {
            throw new IllegalArgumentException("argument column must not be null");
        }
        if (!(column instanceof VirtualColumn) || column.getJdbcType() != 0) {
            return;
        }
        VirtualColumn virtualColumn = (VirtualColumn)column;
        this.set(column, isPrimaryKey, isNullable);
        if (type != null) {
            virtualColumn.setSize(JDBCHelper.getDefaultSizeForClass(type, this._storeCharacterAsNumber, this._storeAllNumbersAsDecimals));
            virtualColumn.setDecimals(JDBCHelper.getDefaultDecimalsForClass(type, this._storeCharacterAsNumber, this._storeAllNumbersAsDecimals));
            virtualColumn.setJdbcType(JDBCHelper.getDefaultJdbcTypeForClass(type, this._storeCharacterAsNumber, this._storeAllNumbersAsDecimals, this._storeFloatAsDouble, this._storeDateAsLong));
        }
    }

    private void set(Column column, boolean isPrimaryKey, boolean isNullable, Class type, int size) {
        if (column == null) {
            throw new IllegalArgumentException("argument column must not be null");
        }
        if (!(column instanceof VirtualColumn) || column.getJdbcType() != 0) {
            return;
        }
        VirtualColumn virtualColumn = (VirtualColumn)column;
        this.set(column, isPrimaryKey, isNullable);
        if (type != null) {
            virtualColumn.setSize(size);
            virtualColumn.setDecimals(JDBCHelper.getDefaultDecimalsForClass(type, this._storeCharacterAsNumber, this._storeAllNumbersAsDecimals));
            virtualColumn.setJdbcType(JDBCHelper.getDefaultJdbcTypeForClass(type, this._storeCharacterAsNumber, this._storeAllNumbersAsDecimals, this._storeFloatAsDouble, this._storeDateAsLong));
        }
    }

    private void set(Column column, boolean isPrimaryKey, boolean isNullable) {
        if (column == null) {
            throw new IllegalArgumentException("argument column must not be null");
        }
        if (!(column instanceof VirtualColumn)) {
            return;
        }
        VirtualColumn virtualColumn = (VirtualColumn)column;
        virtualColumn.setIsPrimaryKey(isPrimaryKey);
        virtualColumn.setIsNullable(isNullable);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

