/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.mapping.impl;

import com.sap.jdo.SAPJDOImplHelper;
import com.sap.jdo.common.model.jdo.util.TypeSupport;
import com.sap.jdo.model.jdo.JDOArray;
import com.sap.jdo.model.jdo.JDOCollection;
import com.sap.jdo.model.jdo.JDOField;
import com.sap.jdo.model.jdo.JDOMap;
import com.sap.jdo.model.jdo.JDOReference;
import com.sap.jdo.model.jdo.JDORelationship;
import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.ForeignKey;
import com.sap.jdo.sql.catalog.Table;
import com.sap.jdo.sql.jdbc.JDBCHelper;
import com.sap.jdo.sql.mapping.MappingClass;
import com.sap.jdo.sql.mapping.MappingDiscriminator;
import com.sap.jdo.sql.mapping.MappingField;
import com.sap.jdo.sql.mapping.MappingForeignKey;
import com.sap.jdo.sql.mapping.MappingInterfaceKey;
import com.sap.jdo.sql.mapping.MappingKey;
import com.sap.jdo.sql.mapping.MappingModel;
import com.sap.jdo.sql.mapping.MappingRelationship;
import com.sap.jdo.sql.mapping.MappingVisitor;
import com.sap.jdo.sql.mapping.impl.MappingModelImpl;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;

public class MappingModelChecker
implements MappingVisitor {
    boolean _checkRelationships;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;

    public static void checkMappingClass(MappingClass mappingClass) throws Exception {
        MappingModelChecker mappingModelChecker = new MappingModelChecker(((MappingModelImpl)mappingClass.getDeclaringModel())._checkConsistencyDeep);
        mappingClass.accept(mappingModelChecker);
    }

    public static void checkMappingRelationship(MappingRelationship mappingRelationship) throws Exception {
        MappingModelChecker mappingModelChecker = new MappingModelChecker(true);
        mappingRelationship.accept(mappingModelChecker);
    }

    private MappingModelChecker(boolean checkRelationships) {
        this._checkRelationships = checkRelationships;
    }

    public void visitMappingModelPre(MappingModel mappingModel) throws Exception {
    }

    public void visitMappingModelPost(MappingModel mappingModel) throws Exception {
    }

    public void visitMappingClassPre(MappingClass mappingClass) throws Exception {
        this.checkJDOModel(mappingClass);
        this.checkDBModel(mappingClass);
        this.checkOIDClassExistence(mappingClass);
        MappingClass mappingRootClass = mappingClass.getMappingRootClass();
        if (mappingRootClass != mappingClass && mappingClass.getMappingDiscriminator() == null) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingClass.getName() + ". Super class " + mappingRootClass.getName() + " has no discriminator column.");
        }
        JDOField[] jdoFields = mappingClass.getJDOClass().getDeclaredManagedFields();
        MappingField[] mappingFields = mappingClass.getMappingFields();
        int i = 0;
        while (i < jdoFields.length) {
            JDOField jdoField = jdoFields[i];
            boolean jdoFieldHasMappingField = false;
            int j = 0;
            while (j < mappingFields.length) {
                MappingField mappingField = mappingFields[j];
                if (mappingField.getJDOField() == jdoField) {
                    jdoFieldHasMappingField = true;
                }
                ++j;
            }
            if (!jdoFieldHasMappingField) {
                throw new JDOFatalUserException("Error in mapping model of class " + mappingClass.getName() + ". Field " + jdoField.getName() + " declared in JDO file has no corresponding mapping declared in MAP file.");
            }
            ++i;
        }
    }

    public void visitMappingClassPost(MappingClass mappingClass) throws Exception {
        this.checkPrimaryKeys(mappingClass);
    }

    protected void checkJDOModel(MappingClass mappingClass) throws Exception {
        if (mappingClass.getJDOClass() == null) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingClass.getName() + ": Cannot find JDO class for mapping class " + mappingClass.getName());
        }
    }

    protected void checkPrimaryKeys(MappingClass mappingClass) {
        MappingField[] pkFields = mappingClass.getMappingPKFields();
        Vector<Table> pkTables = new Vector<Table>();
        int i = 0;
        while (i < pkFields.length) {
            int j;
            if (pkFields[i].getMappingRelationship() != null) {
                throw new JDOFatalUserException("Error in mapping model of class " + mappingClass.getName() + ": Primary key field " + pkFields[i].getName() + " cannot declare relationship. ");
            }
            Column[] cols = pkFields[i].getColumns();
            if (cols == null || cols.length == 0) {
                throw new JDOFatalUserException("Error in mapping model of class " + mappingClass.getName() + ": Primary key field " + pkFields[i].getName() + ": Primary key columns do not exist.");
            }
            int j2 = 0;
            while (j2 < cols.length) {
                if (!cols[j2].isPrimaryKey()) {
                    throw new JDOFatalUserException("Error in mapping model of class " + mappingClass.getName() + ": Relationship of field " + pkFields[j2].getName() + ": Primary key column is not primary key: " + cols[j2].getName() + ". ");
                }
                if (cols[j2].isNullable()) {
                    throw new JDOFatalUserException("Error in mapping model of class " + mappingClass.getName() + ": Relationship of field " + pkFields[j2].getName() + ": Primary key column is nullable: " + cols[j2].getName() + ". ");
                }
                ++j2;
            }
            HashSet<Table> compTables = new HashSet<Table>();
            int j3 = 0;
            while (j3 < cols.length) {
                boolean newElement = compTables.add(cols[j3].getTable());
                if (!newElement) {
                    String excString = "Error in mapping model of class " + mappingClass.getName() + ": Primary key field " + pkFields[i].getName() + " . Multiple columns of a primary key field have to be declared on distinct tables. Table " + cols[j3].getTable().getName() + " occurs more than once.";
                    throw new JDOFatalUserException(excString);
                }
                ++j3;
            }
            if (i == 0) {
                j = 0;
                while (j < cols.length) {
                    pkTables.add(cols[j].getTable());
                    ++j;
                }
            } else {
                j = 0;
                while (j < cols.length) {
                    if (!pkTables.contains(cols[j].getTable())) {
                        String excString = "Error in mapping model of class " + mappingClass.getName() + ": All primary key fields' columns must be in the same tables. Found Mismatch: " + "Primary key field: " + pkFields[i].getName() + ". " + "Column: " + cols[j].getName() + "Table: " + cols[j].getTable().getName() + "Primary key field: " + pkFields[0].getName() + ". ";
                        Column[] compareCols = pkFields[0].getColumns();
                        int k = 0;
                        while (k < compareCols.length) {
                            excString = excString + "Column: " + compareCols[k].getName() + "Table: " + compareCols[k].getTable().getName();
                            ++k;
                        }
                        throw new JDOFatalUserException(excString);
                    }
                    ++j;
                }
                if (pkTables.size() != cols.length) {
                    String excString = "Error in mapping model of class " + mappingClass.getName() + ": Primary key fields' columns must be in the same tables. Found Mismatch: " + "Primary key field: " + pkFields[i].getName() + " declared on " + cols.length + "tables. " + "Primary key field: " + pkFields[0].getName() + " declared on " + pkTables.size() + "tables. ";
                    throw new JDOFatalUserException(excString);
                }
            }
            ++i;
        }
        this.checkPKFieldsWhithOID(mappingClass);
    }

    protected void checkOIDClassExistence(MappingClass mappingClass) {
        try {
            mappingClass.getJDOClass().getObjectIdClass();
        }
        catch (JDOFatalInternalException exc) {
            throw new JDOFatalUserException("Error in mapping model of class: " + mappingClass.getName() + ". " + " There is no OID class with the name defined in the .jdo file.");
        }
    }

    protected void checkPKFieldsWhithOID(MappingClass mappingClass) {
        Class oidClass = (Class)mappingClass.getMappingRootClass().getJDOClass().getObjectIdClass();
        Field[] oidFields = oidClass.getFields();
        HashSet<String> oidFieldNames = new HashSet<String>();
        int i = 0;
        while (i < oidFields.length) {
            oidFieldNames.add(oidFields[i].getName());
            ++i;
        }
        MappingField[] mappingPKFields = mappingClass.getMappingPKFields();
        int i2 = 0;
        while (i2 < mappingPKFields.length) {
            String pkFieldName = mappingPKFields[i2].getName();
            boolean namesMatch = false;
            namesMatch = oidFieldNames.remove(mappingPKFields[i2].getName());
            if (!namesMatch) {
                throw new JDOFatalUserException("Error in mapping model of class: " + mappingClass.getName() + ". " + " Primary key field " + mappingPKFields[i2].getName() + " declared in the .jdo file of the mapping model has no corresponding public attribute in class's OID class.");
            }
            ++i2;
        }
        if (!oidFieldNames.isEmpty()) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingClass.getName() + ". This fields exist in the class's oid class and do not have a corresponding primary key field declared in the .jdo file of the mapping model: " + ((Object)oidFieldNames).toString());
        }
    }

    protected void checkDBModel(MappingClass mappingClass) throws Exception {
        if (mappingClass.getTables() == null) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingClass.getName() + ": Cannot find table for mapping class " + mappingClass.getName());
        }
        if (mappingClass.getTables().length == 0) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingClass.getName() + ": Cannot find table for mapping class " + mappingClass.getName());
        }
    }

    public void visitMappingDiscriminatorPre(MappingDiscriminator mappingDiscriminator) throws Exception {
        this.checkJDOModel(mappingDiscriminator);
        this.checkDBModel(mappingDiscriminator);
    }

    public void visitMappingDiscriminatorPost(MappingDiscriminator mappingDiscriminator) throws Exception {
    }

    protected void checkJDOModel(MappingDiscriminator mappingDiscriminator) throws Exception {
        MappingClass discrDeclaringMappingClass = mappingDiscriminator.getDeclaringClass();
        MappingClass discrDeclaringMappingSuperClass = discrDeclaringMappingClass.getMappingSuperClass();
        if (mappingDiscriminator.getDeclaringClass().getMappingSuperClass() != null) {
            throw new JDOFatalUserException("Error in mapping model of class " + discrDeclaringMappingClass.getName() + ": Mapping Discriminator declaration only in rootclass of class hierarchy. Declaring class is : " + discrDeclaringMappingClass.getName() + ". Rootclass is: " + discrDeclaringMappingClass.getMappingRootClass().getName() + ".");
        }
    }

    protected void checkDBModel(MappingDiscriminator mappingDiscriminator) throws Exception {
        Column[] discriminatorColumns = mappingDiscriminator.getColumns();
        if (discriminatorColumns == null || discriminatorColumns.length == 0) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingDiscriminator.getDeclaringClass().getName() + ": No column given for " + mappingDiscriminator);
        }
        if (discriminatorColumns == null || discriminatorColumns.length > 1) {
            throw new JDOFatalUserException("Error in mapping model: More than one column given for " + mappingDiscriminator);
        }
        if (discriminatorColumns[0].getJdbcType() != 12) {
            throw new JDOFatalUserException("Error in mapping model: Mapping discriminator of class " + mappingDiscriminator.getDeclaringClass() + ". Wrong JDBC tpye. Found" + this.getJdbcTypeName(discriminatorColumns[0].getJdbcType()) + ". Expected " + this.getJdbcTypeName(12) + ". ");
        }
        Table discrTable = discriminatorColumns[0].getTable();
        MappingClass declaringClass = mappingDiscriminator.getDeclaringClass();
        Set declaringClassTables = this.getpkFieldTablesSet(declaringClass);
        if (!declaringClassTables.contains(discrTable)) {
            throw new JDOFatalUserException("Error in mapping model of class " + declaringClass.getName() + " . Discriminator column " + discriminatorColumns[0].getName() + " is declared on table " + discrTable.getName() + ". Has to be declared on one of the declaring class's " + declaringClass.getName() + " tables: " + declaringClassTables.toString() + ". ");
        }
    }

    private Class getjdoRelationshipTargetType(JDORelationship jdoRelationship) {
        if (jdoRelationship instanceof JDOReference) {
            return (Class)jdoRelationship.getDeclaringField().getType();
        }
        if (jdoRelationship instanceof JDOCollection) {
            return (Class)((JDOCollection)jdoRelationship).getElementType();
        }
        throw new JDOFatalUserException("Error in Mapping model of class " + jdoRelationship.getDeclaringField().getDeclaringClass() + ". Unknown JDO relationship type of field " + jdoRelationship.getDeclaringField().getName() + ". Only collections and references are allowed.");
    }

    protected Set getpkFieldTablesSet(MappingClass mappingClass) {
        MappingField[] pkFields = mappingClass.getMappingPKFields();
        HashSet<Table> pkTables = new HashSet<Table>();
        int i = 0;
        while (i < pkFields.length) {
            Column[] colsOfPKField = pkFields[i].getColumns();
            int j = 0;
            while (j < colsOfPKField.length) {
                Table colOfPKFieldTable = colsOfPKField[j].getTable();
                pkTables.add(colOfPKFieldTable);
                ++j;
            }
            ++i;
        }
        return pkTables.size() == 0 ? null : pkTables;
    }

    protected Table[] getpkFieldTablesArr(MappingClass mappingClass) {
        MappingField[] pkFields = mappingClass.getMappingPKFields();
        HashSet<Table> pkTables = new HashSet<Table>();
        int i = 0;
        while (i < pkFields.length) {
            Column[] colsOfPKField = pkFields[i].getColumns();
            int j = 0;
            while (j < colsOfPKField.length) {
                Table colOfPKFieldTable = colsOfPKField[j].getTable();
                pkTables.add(colOfPKFieldTable);
                ++j;
            }
            ++i;
        }
        return pkTables.size() == 0 ? null : pkTables.toArray(new Table[0]);
    }

    protected void checkFieldColumnsDefinedOnMappingClassesTables(MappingField mappingField) {
        MappingClass mappingClass = mappingField.getDeclaringClass();
        Column[] cols = mappingField.getColumns();
        Set pkTables = this.getpkFieldTablesSet(mappingClass);
        int i = 0;
        while (i < cols.length) {
            boolean found = pkTables.contains(cols[i].getTable());
            if (!found) {
                String mc = mappingField.getDeclaringClass().getName();
                String mf = mappingField.getName();
                String col = cols[i].getName();
                throw new JDOFatalUserException("Error in mapping model of class" + mc + ". Column " + col + " is declared on table " + cols[i].getTable().getName() + " but should be declared on mapping classes tables: " + pkTables.toString() + ". ");
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitMappingFieldPre(MappingField mappingField) throws Exception {
        MappingRelationship mappingRelationship = mappingField.getMappingRelationship();
        JDORelationship jdoRelationship = mappingField.getJDOField().getRelationship();
        JDOField jdoField = mappingField.getJDOField();
        if (jdoField == null) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingField.getDeclaringClass().getName() + ". Field " + mappingField.getName() + " in mapping file has no equipollent in jdo file. (JDO field not declared.)");
        }
        Class jdoFieldTypeClass = (Class)jdoField.getType();
        Column[] columns = mappingField.getColumns();
        if (mappingRelationship == null && columns.length == 0) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingField.getDeclaringClass().getName() + ": No column given for " + mappingField.getName() + ". ");
        }
        boolean pkField = mappingField.getJDOField().isPrimaryKey();
        if (!pkField && mappingRelationship == null && columns.length != 1) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingField.getDeclaringClass().getName() + ": Only one column possible for non primary key field " + mappingField + ".");
        }
        if (jdoRelationship != null) {
            Class jdoRelationshipTargetType;
            if (!(jdoRelationship instanceof JDOCollection) && (class$java$util$Collection == null ? (class$java$util$Collection = MappingModelChecker.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(jdoFieldTypeClass)) {
                throw new JDOFatalInternalException("Error in mapping model of class " + mappingField.getDeclaringClass().getName() + " in mapping field " + mappingField.getName() + ". Java field type is java.util.Collection or subtype. jdoRelationship is not instance of collection but is required to be collection.");
            }
            if ((class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = MappingModelChecker.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(jdoRelationshipTargetType = this.getjdoRelationshipTargetType(jdoRelationship))) {
                if (mappingRelationship != null) return;
                throw new JDOFatalUserException("Error in mapping model of class " + mappingField.getDeclaringClass().getName() + ". Field " + mappingField.getName() + " declares a relationship to type PersistenceCapable in JDO file. This has to be reflected in the mapping by declaring a relationship in the MAP file.");
            }
            boolean isValueType = TypeSupport.isValueType(mappingField.getDeclaringClass().getJDOClass().getDeclaringModel(), jdoRelationshipTargetType);
            if (isValueType) {
                Column[] cols = mappingField.getColumns();
                if (cols.length != 1) {
                    String colNames = null;
                    int i = 0;
                    while (i < cols.length) {
                        colNames = colNames + cols[i].getName() + (i == cols.length ? ". " : ", ");
                        ++i;
                    }
                    throw new JDOFatalUserException("Error in mapping model of class: " + mappingField.getDeclaringClass().getName() + ": Field " + mappingField.getName() + " declares relationship to value type (primitive or wrapper type) in JDO file. This needs to be mapped to exactly one column in the MAP file. Current column names are: " + colNames + ". ");
                }
                if (mappingRelationship != null) {
                    throw new JDOFatalUserException("Error in mapping model of class: " + mappingField.getDeclaringClass().getName() + ": Field " + mappingField.getName() + " declares relationship to value type (primitive or wrapper type) in JDO file. This needs to be mapped to exactly one column in the MAP file. Do not declare a relationship for that in the MAP file, map this to a simple field instead.");
                }
                int jdbcType = cols[0].getJdbcType();
                if (jdbcType != 2004 && jdbcType != 2005) {
                    throw new JDOFatalUserException("Error in mapping model of class: " + mappingField.getDeclaringClass().getName() + ": Field " + mappingField.getName() + " declares relationship to value type (primitive or wrapper type) in JDO file. This needs to be mapped to exactly one column of JDBC type CLOB or BLOB. This column named " + cols[0].getName() + " on table " + cols[0].getTable() + "currently is of type " + this.getJdbcTypeName(cols[0].getJdbcType()) + ". ");
                }
                Set classTables = this.getpkFieldTablesSet(mappingField.getDeclaringClass());
                if (classTables.contains(cols[0].getTable())) return;
                throw new JDOFatalUserException("Error in mapping model of class: " + mappingField.getDeclaringClass().getName() + ": Field " + mappingField.getName() + " declares relationship to value type (primitive or wrapper type) in JDO file. This needs to be mapped to exactly one column of the class's tables. Currently, " + cols[0].getName() + " is declared on table " + cols[0].getTable() + " but should be declared on one of the declaring class' tables: " + classTables.toString() + " . ");
            }
            if (mappingRelationship == null) throw new JDOFatalUserException("Error in mapping model of class: " + mappingField.getDeclaringClass().getName() + ": Field " + mappingField.getName() + " declares a relationship to a non-persistence capable non-value type (primitive or wrapper type) in JDO file. This needs to be mapped to an interface relationship in the MAP file. No such interface relationship is declared there.");
            if (this.isInterfaceRelationship(mappingRelationship)) return;
            throw new JDOFatalUserException("Error in mapping model of class: " + mappingField.getDeclaringClass().getName() + ": Field " + mappingField.getName() + " declares a relationship to a non-persistence capable non-value type (primitive or wrapper type) in JDO file. This needs to be mapped to an interface relationship in the MAP file. The declared relationship in the MAP file does not specify an interface relationship.");
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = MappingModelChecker.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(jdoFieldTypeClass)) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingField.getDeclaringClass().getName() + ". Field " + mappingField.getName() + " declares a relationship. The corresponding Java field type is java.util.Collection or subtype. A collection has to be declared at the corresponding field in the JDO file.");
        }
        if (mappingRelationship != null) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingField.getDeclaringClass().getName() + ". Field " + mappingField.getName() + " missleadingly declares a relationship in the MAP file while there is no relationship declared in the JDO model. ");
        }
        boolean isValueType = TypeSupport.isValueType(mappingField.getDeclaringClass().getJDOClass().getDeclaringModel(), jdoFieldTypeClass);
        if (!isValueType) throw new JDOFatalUserException("Error in mapping model of class: " + mappingField.getDeclaringClass().getName() + ": Field " + mappingField.getName() + " declares an attribute to of a non-persistence capable type in the JDO file NOT mapped to an interface relationship in the MAP file. This can only be done for java value types (primitive or wrapper types). But not for attributes of type " + jdoFieldTypeClass.getName() + ". ");
        this.checkDBModel(mappingField);
    }

    protected boolean isInterfaceRelationship(MappingRelationship mappingRelationship) {
        int relationshipType = mappingRelationship.getRelationshipType();
        return relationshipType == 5 || relationshipType == 3;
    }

    protected void checkDBModel(MappingField mappingField) {
        Object javaType = mappingField.getJDOField().getType();
        Class javaClass = (Class)javaType;
        MappingModelImpl mappingModel = (MappingModelImpl)mappingField.getDeclaringClass().getDeclaringModel();
        boolean storeCharacterAsNumber = mappingModel._storeCharacterAsNumber;
        boolean storeAllNumbersAsDecimals = mappingModel._storeAllNumbersAsDecimals;
        boolean storeFloatAsDouble = mappingModel._storeFloatAsDouble;
        boolean storeDateAsLong = mappingModel._storeDateAsLong;
        Column[] cols = mappingField.getColumns();
        int i = 0;
        while (i < cols.length) {
            int jdbcType = cols[i].getJdbcType();
            if (!JDBCHelper.isJdbcTypeCompatible(javaClass, jdbcType)) {
                int defaultJDBCType = JDBCHelper.getDefaultJdbcTypeForClass(javaClass, storeCharacterAsNumber, storeAllNumbersAsDecimals, storeFloatAsDouble, storeDateAsLong);
                throw new JDOFatalUserException("Error in Mapping Model: Mapping field: " + mappingField.getName() + ". Can't map Java type " + javaType.toString() + " to " + this.getJdbcTypeName(jdbcType) + ". You may use " + this.getJdbcTypeName(defaultJDBCType) + " instead (this is the default JDBC type for this Java type). ");
            }
            ++i;
        }
        this.checkFieldColumnsDefinedOnMappingClassesTables(mappingField);
    }

    public void visitMappingFieldPost(MappingField mappingField) throws Exception {
    }

    public void visitMappingRelationshipPre(MappingRelationship mappingRelationship) throws Exception {
        JDORelationship jdoRel;
        if (!this._checkRelationships) {
            return;
        }
        MappingKey[] mKeys = mappingRelationship.getMappingKeys();
        int keyType = mappingRelationship.getKeyType();
        if (mKeys == null || mKeys.length == 0) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship of field " + mappingRelationship.getDeclaringField().getName() + " does not declare any mapping keys.");
        }
        if (keyType == 1) {
            if (mKeys.length != 1 || mKeys[0] == null) {
                throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship of field " + mappingRelationship.getDeclaringField().getName() + " has to declare one single foreign key as join-table is false ");
            }
        } else if (keyType == 2) {
            if (mKeys.length != 2 || mKeys[0] == null || mKeys[1] == null) {
                throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship of field " + mappingRelationship.getDeclaringField().getName() + " has to declare 2 foreign keys as join-table is true.");
            }
        } else {
            throw new JDOFatalInternalException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Field " + mappingRelationship.getDeclaringField().getName() + ": Unknown key type of relationship: " + mappingRelationship.getKeyType());
        }
        if ((jdoRel = mappingRelationship.getJDORelationship()) instanceof JDOMap) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + "Field " + mappingRelationship.getDeclaringField().getName() + ": Maps not supported. ");
        }
        if (jdoRel instanceof JDOArray) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + "Field " + mappingRelationship.getDeclaringField().getName() + ": Arrays not supported. ");
        }
        if (!(jdoRel instanceof JDOReference) && !(jdoRel instanceof JDOCollection)) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + "Field " + mappingRelationship.getDeclaringField().getName() + ": Unknown JDO relationship type not supported: " + jdoRel.getClass());
        }
        Column countCol = mappingRelationship.getCountColumn();
        if (countCol != null) {
            if (jdoRel == null) {
                throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ": Relationship of field " + mappingRelationship.getDeclaringField().getName() + " in MAP file declares count column. JDO file has to declare a collection for that field!");
            }
            if (!(jdoRel instanceof JDOCollection)) {
                throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ": Relationship of field " + mappingRelationship.getDeclaringField().getName() + " in MAP file declares count column. JDO file has to declare a collection for that field!");
            }
            Object javaType = mappingRelationship.getDeclaringField().getJDOField().getType();
            Class trackedClass = SAPJDOImplHelper.getTrackedClass((Class)javaType);
            Class trackedCollectionClass = SAPJDOImplHelper.getTrackedClass(class$java$util$Collection == null ? (class$java$util$Collection = MappingModelChecker.class$("java.util.Collection")) : class$java$util$Collection);
            if (trackedClass != null) {
                if (!trackedCollectionClass.isAssignableFrom(trackedClass)) {
                    throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ": Relationship of field " + mappingRelationship.getDeclaringField().getName() + " in MAP file declares count column. JDO file declares a collection for that field. This indicates a Java Collection type, but actual Java type is : " + trackedClass.getName() + ". ");
                }
            } else {
                throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ": Relationship of field " + mappingRelationship.getDeclaringField().getName() + " in MAP file declares count column. JDO file declares a collection for that field. This indicates a Java Collection type, but actual Java type is : " + trackedClass.getName() + ". This type is not tracked by the JDO implementation and therefore must not declare a count column.");
            }
        }
        if (jdoRel instanceof JDOReference) {
            this.checkJDOReference(mappingRelationship);
        }
        if (jdoRel instanceof JDOCollection) {
            this.checkJDOCollection(mappingRelationship);
        }
    }

    private void checkInterfaceKey(MappingInterfaceKey mappingInterfaceKey, MappingRelationship mappingRelationship, boolean single) {
        Class referencedType;
        Column discrCol = mappingInterfaceKey.getDiscriminatorColumn();
        Column refCol = mappingInterfaceKey.getReferenceColumn();
        if (discrCol == null) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ": Relationship of field " + mappingRelationship.getDeclaringField().getName() + ": Discriminator column does not exist in MAP file.");
        }
        if (refCol == null) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ": Relationship of field " + mappingRelationship.getDeclaringField().getName() + ": Reference column does not exist in MAP file.");
        }
        int dbType = refCol.getJdbcType();
        if (dbType != -3 && dbType != 12) {
            throw new JDOFatalUserException("Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship to interface of field " + mappingRelationship.getDeclaringField().getName() + ". Database type of reference column " + refCol.getName() + " is " + this.getJdbcTypeName(dbType) + ". " + this.getJdbcTypeName(-3) + " or " + this.getJdbcTypeName(12) + " is mandatory for interfaces.");
        }
        dbType = discrCol.getJdbcType();
        if (dbType != 12) {
            throw new JDOFatalUserException("Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship to interface of field " + mappingRelationship.getDeclaringField().getName() + ". Database type of discriminator column " + discrCol.getName() + " is " + this.getJdbcTypeName(dbType) + ". " + this.getJdbcTypeName(12) + " is mandatory for interfaces.");
        }
        Column serializedDataColumn = mappingInterfaceKey.getSerializedDataColumn();
        if (!(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = MappingModelChecker.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(referencedType = single ? (Class)mappingRelationship.getJDORelationship().getDeclaringField().getType() : (Class)((JDOCollection)mappingRelationship.getJDORelationship()).getElementType())) {
            if (serializedDataColumn == null) {
                throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ": Relationship of field " + mappingRelationship.getDeclaringField().getName() + ": serialized data column does not exist in MAP file.");
            }
            dbType = serializedDataColumn.getJdbcType();
            if (dbType != 2004) {
                throw new JDOFatalUserException("Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship to interface of field " + mappingRelationship.getDeclaringField().getName() + ". Database type of serialized data column " + serializedDataColumn.getName() + " is " + this.getJdbcTypeName(dbType) + ". " + this.getJdbcTypeName(2004) + " is mandatory for interfaces.");
            }
        }
        if (discrCol.getTable() != refCol.getTable() || serializedDataColumn != null && discrCol.getTable() != serializedDataColumn.getTable()) {
            throw new JDOFatalUserException("Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship to interface of field " + mappingRelationship.getDeclaringField().getName() + ". Discriminator column " + discrCol.getName() + " defined on table " + discrCol.getTable() + " and " + " reference column " + refCol.getName() + " defined on table " + refCol.getTable() + (serializedDataColumn == null ? " " : "and serialized data column " + serializedDataColumn.getName() + " defined on table " + serializedDataColumn.getTable()) + " are to be declared on the same table.");
        }
        Table[] declaringClassTables = this.getpkFieldTablesArr(mappingRelationship.getDeclaringField().getDeclaringClass());
        boolean found = false;
        int i = 0;
        while (i < declaringClassTables.length) {
            if (declaringClassTables[i] == discrCol.getTable()) {
                found = true;
                break;
            }
            ++i;
        }
        if (single && !found) {
            throw new JDOFatalUserException("Error in mapping model of declared class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship to interface of field " + mappingRelationship.getDeclaringField().getName() + ". Discriminator column " + discrCol.getName() + " and reference column " + refCol.getName() + " defined on table " + discrCol.getTable() + " are not declared on the tables of declared class.");
        }
        if (!single && found) {
            throw new JDOFatalUserException("Error in mapping model of declared class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship to interface of field " + mappingRelationship.getDeclaringField().getName() + ". Discriminator column " + discrCol.getName() + " and reference column " + refCol.getName() + " defined on table " + discrCol.getTable() + " must not be declared on the tables of declared class.");
        }
    }

    private void checkForeignKey(MappingForeignKey mappingForeignKey, MappingRelationship mappingRelationship, MappingClass targetClass) {
        Column[] pkCols = mappingForeignKey.getForeignKey().getPrimaryKeyColumns();
        if (pkCols == null || pkCols.length == 0) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ": Relationship of field " + mappingRelationship.getDeclaringField().getName() + ": Primary key columns do not exist.");
        }
        Column[] fkCols = mappingForeignKey.getForeignKey().getForeignKeyColumns();
        if (fkCols == null || fkCols.length == 0) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ": Relationship of field " + mappingRelationship.getDeclaringField().getName() + ": Foreign key columns do not exist.");
        }
        if (pkCols.length != fkCols.length) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ": Relationship of field " + mappingRelationship.getDeclaringField().getName() + ": Number of primary key columns and foreign key columns do not match.");
        }
        MappingField[] targetPKFields = targetClass.getMappingPKFields();
        HashSet<Column> targetPKColsSet = new HashSet<Column>();
        int i = 0;
        while (i < targetPKFields.length) {
            Column[] targetPKCols = targetPKFields[i].getColumns();
            int j = 0;
            while (j < targetPKCols.length) {
                targetPKColsSet.add(targetPKCols[j]);
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < pkCols.length) {
            boolean wasThere = targetPKColsSet.remove(pkCols[i2]);
            if (!wasThere) {
                throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ": Relationship of field " + mappingRelationship.getDeclaringField().getName() + ": Primary key column " + pkCols[i2].getName() + " of relationship's foreign key and target class's " + targetClass.getName() + " primary key columns do not match.");
            }
            ++i2;
        }
        if (!targetPKColsSet.isEmpty()) {
            String elemString = new String();
            Iterator iter = targetPKColsSet.iterator();
            while (iter.hasNext()) {
                Column element = (Column)iter.next();
                elemString = elemString + element.getName() + ", ";
            }
            throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ": Primary key columns of target class " + targetClass.getName() + " do not match primary key columns declared in mapping relationship of field " + mappingRelationship.getDeclaringField().getName() + " of class " + mappingRelationship.getDeclaringField().getJDOField().getDeclaringClass().getName() + ". ");
        }
    }

    protected void checkJDOReference(MappingRelationship mappingRelationship) {
        MappingKey singleKey;
        MappingModel mappingModel = mappingRelationship.getDeclaringField().getDeclaringClass().getDeclaringModel();
        Object targetType = mappingRelationship.getDeclaringField().getJDOField().getType();
        MappingClass targetMappingClass = null;
        if ((class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = MappingModelChecker.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom((Class)targetType) && !((Class)targetType).isInterface()) {
            try {
                targetMappingClass = mappingModel.getMappingClass((Class)targetType, true);
            }
            catch (JDOFatalInternalException fiexc) {
                String excString = "Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ": Field: " + mappingRelationship.getDeclaringField().getName() + ": Target type " + targetType.getClass().getName() + " of relationship does not exist in mapping model (MAP file).";
                throw new JDOFatalUserException(excString);
            }
        }
        if ((singleKey = mappingRelationship.getMappingSingleKey()) != null) {
            if (singleKey instanceof MappingForeignKey) {
                if (singleKey.getKeyType() == 2) {
                    this.checkForeignKey((MappingForeignKey)singleKey, mappingRelationship, mappingRelationship.getDeclaringField().getDeclaringClass());
                } else {
                    this.checkForeignKey((MappingForeignKey)singleKey, mappingRelationship, targetMappingClass);
                }
            } else if (singleKey instanceof MappingInterfaceKey) {
                this.checkInterfaceKey((MappingInterfaceKey)singleKey, mappingRelationship, true);
            }
        } else {
            throw new JDOFatalUserException("Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Field " + mappingRelationship.getDeclaringField().getName() + " declares a JDO relationship in JDO file. There has to be an equipollent relationship (with join-table = false) in the MAP file.");
        }
    }

    protected void checkCollectionCountColumn(MappingRelationship mappingRelationship, Table[] expectedCountColumnTables) {
        JDORelationship jdoRelship = mappingRelationship.getJDORelationship();
        Object javaType = mappingRelationship.getDeclaringField().getJDOField().getType();
        Class trackedClass = SAPJDOImplHelper.getTrackedClass((Class)javaType);
        Class trackedCollectionClass = SAPJDOImplHelper.getTrackedClass(class$java$util$Collection == null ? (class$java$util$Collection = MappingModelChecker.class$("java.util.Collection")) : class$java$util$Collection);
        if (trackedClass != null) {
            Column countCol = mappingRelationship.getCountColumn();
            if (trackedCollectionClass.isAssignableFrom(trackedClass)) {
                if (countCol == null) {
                    throw new JDOFatalUserException("Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Java field " + mappingRelationship.getDeclaringField().getName() + " is of type Collection. A count column has to be declared in the MAP file in the corresponding mapping relationship of this field. ");
                }
                int countColjdbcType = countCol.getJdbcType();
                if (countColjdbcType != 4) {
                    throw new JDOFatalUserException("Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Field " + mappingRelationship.getDeclaringField().getName() + ": The count column " + countCol.getName() + " declared in the MAP file is not of JDBC type INTEGER. ");
                }
                Table countColTable = countCol.getTable();
                boolean match = false;
                int i = 0;
                while (i < expectedCountColumnTables.length) {
                    if (countColTable == expectedCountColumnTables[i]) {
                        match = true;
                        break;
                    }
                    ++i;
                }
                if (!match) {
                    String expTablesString = "";
                    int i2 = 0;
                    while (i2 < expectedCountColumnTables.length) {
                        expTablesString = expTablesString + expectedCountColumnTables[i2].toString();
                        ++i2;
                    }
                    throw new JDOFatalUserException("Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Field " + mappingRelationship.getDeclaringField().getName() + ": The count column " + countCol.getName() + " is declared on table " + countCol.getTable().getName() + ". Should be declared on one of these tables: " + expTablesString);
                }
            } else if (mappingRelationship.getCountColumn() != null) {
                throw new JDOFatalUserException("Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Field " + mappingRelationship.getDeclaringField().getName() + " declares a count column " + countCol.getName() + ". The corresponding Java type is not java.util.Collection. A count column must not be declared. ");
            }
        } else {
            throw new JDOFatalInternalException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Field " + mappingRelationship.getDeclaringField().getName() + " declares a collection in the JDO file whose Java element type is not tracked by the JDO implementation. Java element type is: " + ((Class)javaType).toString() + ". ");
        }
    }

    protected void checkCollectionCountColumn(MappingRelationship mappingRelationship, MappingClass classWithRelevantPKs) {
        Table[] expectedCountColumnTables = this.getpkFieldTablesArr(classWithRelevantPKs);
        this.checkCollectionCountColumn(mappingRelationship, expectedCountColumnTables);
    }

    protected void checkJDOCollection(MappingRelationship mappingRelationship) {
        Object javaType;
        if (!(class$java$util$Collection == null ? (class$java$util$Collection = MappingModelChecker.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom((Class)(javaType = mappingRelationship.getJDORelationship().getDeclaringField().getType()))) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship declared by field " + mappingRelationship.getDeclaringField().getName() + " corresponds to Java field type " + ((Class)javaType).getName() + ". Only java.util.Collection and subtypes are allowed to declare a collection in the JDO file.");
        }
        MappingModel mappingModel = mappingRelationship.getDeclaringField().getDeclaringClass().getDeclaringModel();
        JDOCollection jdoRelship = (JDOCollection)mappingRelationship.getJDORelationship();
        Object targetType = jdoRelship.getElementType();
        Class targetTypeClass = (Class)targetType;
        MappingClass targetMappingClass = null;
        if ((class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = MappingModelChecker.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(targetTypeClass) && !targetTypeClass.isInterface() && (targetMappingClass = mappingModel.getMappingClass((Class)targetType)) == null) {
            String excString = "Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass() + "Field: " + mappingRelationship.getDeclaringField().getName() + ((Class)mappingRelationship.getDeclaringField().getJDOField().getType()).getName() + ": Target type " + targetType.getClass().getName() + " of relationship does not exist in mapping model.";
            throw new JDOFatalUserException(excString);
        }
        MappingKey singleKey = mappingRelationship.getMappingSingleKey();
        if (singleKey != null) {
            if (singleKey instanceof MappingForeignKey) {
                this.checkForeignKey((MappingForeignKey)singleKey, mappingRelationship, mappingRelationship.getDeclaringField().getDeclaringClass());
                this.checkCollectionCountColumn(mappingRelationship, targetMappingClass);
            } else if (singleKey instanceof MappingInterfaceKey) {
                throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + " at field " + mappingRelationship.getDeclaringField().getName() + ". declared as collection in JDO file. Cannot be mapped to a relationship with join-table=false in the MAP file. ");
            }
        } else {
            MappingKey[] doubleKeys = mappingRelationship.getMappingDoubleKeys();
            if (doubleKeys == null || doubleKeys.length != 2) {
                throw new JDOFatalUserException("Error in mapping model of declared class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship of field " + mappingRelationship.getDeclaringField().getName() + " declares join-table as true. Therefore two foreign keys are mandatory.");
            }
            if (doubleKeys[0] instanceof MappingForeignKey && doubleKeys[1] instanceof MappingForeignKey) {
                Table[] tables;
                int otherKeyType;
                MappingForeignKey oneMappingForeignKey = (MappingForeignKey)doubleKeys[0];
                MappingForeignKey otherMappingForeignKey = (MappingForeignKey)doubleKeys[1];
                Column[] pkColsOne = oneMappingForeignKey.getForeignKey().getPrimaryKeyColumns();
                Column[] fkColsOne = oneMappingForeignKey.getForeignKey().getForeignKeyColumns();
                Column[] pkColsOther = otherMappingForeignKey.getForeignKey().getPrimaryKeyColumns();
                Column[] fkColsOther = otherMappingForeignKey.getForeignKey().getForeignKeyColumns();
                int oneKeyType = oneMappingForeignKey.getKeyType();
                if (oneKeyType == (otherKeyType = otherMappingForeignKey.getKeyType())) {
                    throw new JDOFatalUserException("Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship to interface of field " + mappingRelationship.getDeclaringField().getName() + ": Double foreign keys have to be declared in two distinct parts.");
                }
                if (oneKeyType == 3) {
                    this.checkForeignKey(oneMappingForeignKey, mappingRelationship, mappingRelationship.getDeclaringField().getDeclaringClass());
                    tables = new Table[]{oneMappingForeignKey.getForeignKey().getForeignKeyTable()};
                    this.checkCollectionCountColumn(mappingRelationship, tables);
                } else if (oneKeyType == 4) {
                    this.checkForeignKey(oneMappingForeignKey, mappingRelationship, targetMappingClass);
                }
                if (otherKeyType == 3) {
                    tables = new Table[]{oneMappingForeignKey.getForeignKey().getForeignKeyTable()};
                    this.checkCollectionCountColumn(mappingRelationship, tables);
                    this.checkForeignKey(otherMappingForeignKey, mappingRelationship, mappingRelationship.getDeclaringField().getDeclaringClass());
                } else if (otherKeyType == 4) {
                    this.checkForeignKey(otherMappingForeignKey, mappingRelationship, targetMappingClass);
                }
                if (oneMappingForeignKey.getForeignKey().getForeignKeyTable() != otherMappingForeignKey.getForeignKey().getForeignKeyTable()) {
                    throw new JDOFatalUserException("Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship to interface of field " + mappingRelationship.getDeclaringField().getName() + " declares join-table=true, but double foreign key parts do not declare the same foreign key table: " + "Foreign key " + oneMappingForeignKey.getForeignKey().getName() + " declares table: " + oneMappingForeignKey.getForeignKey().getForeignKeyTable().getName() + ", foreign key " + otherMappingForeignKey.getForeignKey().getName() + " declares table: " + otherMappingForeignKey.getForeignKey().getForeignKeyTable().getName() + ". ");
                }
                Table[] targetTables = this.getpkFieldTablesArr(targetMappingClass);
                int i = 0;
                while (i < targetTables.length) {
                    if (targetTables[i] == oneMappingForeignKey.getForeignKey().getForeignKeyTable()) {
                        throw new JDOFatalUserException("Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship of field " + mappingRelationship.getDeclaringField().getName() + ": Foreign key table of m:n relationship must be different from the ones of source class" + "Foreign key table of m:n relationship is " + oneMappingForeignKey.getForeignKey().getForeignKeyTable() + ". This matches relationship's target class " + targetMappingClass.getName() + " tables. ");
                    }
                    ++i;
                }
                Table[] sourceTables = this.getpkFieldTablesArr(mappingRelationship.getDeclaringField().getDeclaringClass());
                int i2 = 0;
                while (i2 < sourceTables.length) {
                    if (targetTables[i2] == oneMappingForeignKey.getForeignKey().getForeignKeyTable()) {
                        throw new JDOFatalUserException("Error in mapping model of class: " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship of field " + mappingRelationship.getDeclaringField().getName() + "Foreign key table of m:n relationship must be different from the ones of source class" + "Foreign key table of m:n relationship is " + oneMappingForeignKey.getForeignKey().getForeignKeyTable() + ". This matches one of relationship's source class " + targetMappingClass.getName() + "tables. ");
                    }
                    ++i2;
                }
                Column[] oneFKColsArr = oneMappingForeignKey.getForeignKey().getForeignKeyColumns();
                Column[] otherFKColsArr = otherMappingForeignKey.getForeignKey().getForeignKeyColumns();
                HashSet<Column> otherFKColsSet = new HashSet<Column>();
                int i3 = 0;
                while (i3 < otherFKColsArr.length) {
                    otherFKColsSet.add(otherFKColsArr[i3]);
                    ++i3;
                }
                int i4 = 0;
                while (i4 < oneFKColsArr.length) {
                    boolean overlapping = otherFKColsSet.remove(oneFKColsArr[i4]);
                    if (overlapping) {
                        throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Relationship of field " + mappingRelationship.getDeclaringField().getName() + ": Overlapping foreign key column " + oneFKColsArr[i4].getName() + " of relationship's double foreign key columns used by both parts of double foreign key. ");
                    }
                    ++i4;
                }
            } else if (doubleKeys[0] instanceof MappingForeignKey && doubleKeys[1] instanceof MappingInterfaceKey || doubleKeys[0] instanceof MappingInterfaceKey && doubleKeys[1] instanceof MappingForeignKey) {
                MappingForeignKey oneMappingForeignKey = null;
                MappingInterfaceKey oneMappingInterfaceKey = null;
                if (doubleKeys[0] instanceof MappingForeignKey) {
                    oneMappingForeignKey = (MappingForeignKey)doubleKeys[0];
                    oneMappingInterfaceKey = (MappingInterfaceKey)doubleKeys[1];
                } else {
                    oneMappingForeignKey = (MappingForeignKey)doubleKeys[1];
                    oneMappingInterfaceKey = (MappingInterfaceKey)doubleKeys[0];
                }
                this.checkForeignKey(oneMappingForeignKey, mappingRelationship, mappingRelationship.getDeclaringField().getDeclaringClass());
                this.checkInterfaceKey(oneMappingInterfaceKey, mappingRelationship, false);
                this.checkCollectionCountColumn(mappingRelationship, new Table[]{oneMappingForeignKey.getForeignKey().getForeignKeyTable()});
                if (oneMappingForeignKey.getForeignKey().getForeignKeyTable() != oneMappingInterfaceKey.getDiscriminatorColumn().getTable()) {
                    throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Foreign key columns, discriminator and reference columns of double foreign key of relationship " + mappingRelationship.getDeclaringField().getName() + " of class " + mappingRelationship.getDeclaringField().getJDOField().getDeclaringClass().getName() + " have to be declared in the same table. " + "Foreign key table is: " + oneMappingForeignKey.getForeignKey().getForeignKeyTable() + ". Discriminator column's table is: " + oneMappingInterfaceKey.getDiscriminatorColumn().getTable());
                }
                if (oneMappingForeignKey.getForeignKey().getForeignKeyTable() != oneMappingInterfaceKey.getReferenceColumn().getTable()) {
                    throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Foreign key columns, discriminator and reference columns of double foreign key of relationship " + mappingRelationship.getDeclaringField().getName() + " of class " + mappingRelationship.getDeclaringField().getJDOField().getDeclaringClass().getName() + " have to be declared in the same table. " + "Foreign key table is: " + oneMappingForeignKey.getForeignKey().getForeignKeyTable() + ". Reference column's table is: " + oneMappingInterfaceKey.getReferenceColumn().getTable() + ". ");
                }
                if (oneMappingInterfaceKey.getSerializedDataColumn() != null && oneMappingForeignKey.getForeignKey().getForeignKeyTable() != oneMappingInterfaceKey.getSerializedDataColumn().getTable()) {
                    throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Foreign key columns, discriminator, reference columns and serialized data column of double foreign key of relationship " + mappingRelationship.getDeclaringField().getName() + " of class " + mappingRelationship.getDeclaringField().getJDOField().getDeclaringClass().getName() + " have to be declared in the same table. " + "Foreign key table is: " + oneMappingForeignKey.getForeignKey().getForeignKeyTable() + ". Serialized data column's table is: " + oneMappingInterfaceKey.getSerializedDataColumn().getTable() + ". ");
                }
            } else {
                throw new JDOFatalUserException("Error in mapping model of class " + mappingRelationship.getDeclaringField().getDeclaringClass().getName() + ". Field " + mappingRelationship.getDeclaringField().getName() + " of class " + mappingRelationship.getDeclaringField().getJDOField().getDeclaringClass().getName() + " has to declare 2 foreign key parts: either 2 foreign keys or one foreign key and a interface key.");
            }
        }
    }

    public void visitMappingRelationshipPost(MappingRelationship mappingRelationship) throws Exception {
    }

    public void visitMappingForeignKeyPre(MappingForeignKey mappingForeignKey) throws Exception {
        if (!this._checkRelationships) {
            return;
        }
        ForeignKey foreignKey = mappingForeignKey.getForeignKey();
        Column[] pkColumns = foreignKey.getPrimaryKeyColumns();
        Column[] fkColumns = foreignKey.getForeignKeyColumns();
        if (pkColumns.length == 0 && fkColumns.length == 0) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingForeignKey.getDeclaringRelationship().getDeclaringField().getDeclaringClass().getName() + ". Field: " + mappingForeignKey.getDeclaringRelationship().getDeclaringField() + ": No primary key columns and foreign key columns declared for mapping foreign key.");
        }
        if (pkColumns.length == 0 || fkColumns.length == 0 || pkColumns.length != fkColumns.length) {
            throw new JDOFatalInternalException("Error in mapping model of class " + mappingForeignKey.getDeclaringRelationship().getDeclaringField().getDeclaringClass().getName() + ". Field: " + mappingForeignKey.getDeclaringRelationship().getDeclaringField() + ". ASSERT: internal model error for " + mappingForeignKey);
        }
    }

    public void visitMappingForeignKeyPost(MappingForeignKey mappingForeignKey) throws Exception {
    }

    public void visitMappingInterfaceKeyPre(MappingInterfaceKey mappingInterfaceKey) throws Exception {
        JDORelationship jdoRelationship;
        Class referencedType;
        if (!this._checkRelationships) {
            return;
        }
        if (mappingInterfaceKey.getReferenceColumn() == null) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingInterfaceKey.getDeclaringRelationship().getDeclaringField().getDeclaringClass().getName() + ". Field: " + mappingInterfaceKey.getDeclaringRelationship().getDeclaringField() + ": No reference column declared for mapping interface key.");
        }
        if (mappingInterfaceKey.getDiscriminatorColumn() == null) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingInterfaceKey.getDeclaringRelationship().getDeclaringField().getDeclaringClass().getName() + ". Field: " + mappingInterfaceKey.getDeclaringRelationship().getDeclaringField() + ": No discriminator column declared for mapping interface key.");
        }
        if (!(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = MappingModelChecker.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(referencedType = (jdoRelationship = mappingInterfaceKey.getDeclaringRelationship().getJDORelationship()) instanceof JDOReference ? (Class)((JDOReference)jdoRelationship).getDeclaringField().getType() : (Class)((JDOCollection)jdoRelationship).getElementType()) && mappingInterfaceKey.getSerializedDataColumn() == null) {
            throw new JDOFatalUserException("Error in mapping model of class " + mappingInterfaceKey.getDeclaringRelationship().getDeclaringField().getDeclaringClass().getName() + ". Field: " + mappingInterfaceKey.getDeclaringRelationship().getDeclaringField() + ": No serialized data column declared for mapping interface key.");
        }
    }

    public void visitMappingInterfaceKeyPost(MappingInterfaceKey mappingInterfaceKey) throws Exception {
    }

    private String getJdbcTypeName(int jdbcType) {
        String result = null;
        try {
            result = JDBCHelper.getJdbcTypeName(jdbcType);
        }
        catch (JDBCHelper.InvalidJdbcType e) {
            result = "\"unknown JDBC type\"";
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

