/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.mapping.impl;

import com.sap.jdo.model.jdo.JDOClass;
import com.sap.jdo.model.jdo.JDOField;
import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.JDOCatalogReader;
import com.sap.jdo.sql.catalog.Table;
import com.sap.jdo.sql.mapping.MappingClass;
import com.sap.jdo.sql.mapping.MappingField;
import com.sap.jdo.sql.mapping.MappingRelationship;
import com.sap.jdo.sql.mapping.MappingVisitor;
import com.sap.jdo.sql.mapping.impl.MappingClassImpl;
import com.sap.jdo.sql.mapping.impl.MappingRelationshipImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.JDOFatalUserException;

public class MappingFieldImpl
implements MappingField {
    private static final Column[] initialColumnArray = new Column[0];
    MappingClassImpl _declaringClass;
    private JDOField _jdoField;
    private String _name;
    private boolean _virtual;
    private MappingRelationshipImpl _mappingRelationship;
    private List _columns;
    private Map _columnsForTable;
    private Column[] _columnsBuffer;
    private long _columnsBufferCID;
    private Map _columnsBufferForTable;
    private long _columnsBufferForTableCID;

    public MappingFieldImpl(MappingClassImpl mappingClass, String fieldName, boolean virtual) {
        if (mappingClass == null) {
            throw new IllegalArgumentException("no mapping class given");
        }
        this._declaringClass = mappingClass;
        this._jdoField = null;
        this._name = fieldName;
        this._virtual = virtual;
        this._mappingRelationship = null;
        this._columns = new ArrayList();
        this._columnsForTable = new HashMap();
    }

    public MappingFieldImpl(MappingClassImpl mappingClass, JDOField jdoField, boolean virtual) {
        this(mappingClass, jdoField.getName(), virtual);
        this._jdoField = jdoField;
    }

    public synchronized MappingClass getDeclaringClass() {
        return this._declaringClass;
    }

    public synchronized JDOField getJDOField() {
        if (this._jdoField != null) {
            return this._jdoField;
        }
        JDOClass jdoClass = this.getDeclaringClass().getJDOClass();
        if (jdoClass != null) {
            this._jdoField = jdoClass.getField(this._name);
            return this._jdoField;
        }
        return null;
    }

    public synchronized String getName() {
        return this._name;
    }

    public synchronized boolean isVirtual() {
        return this._virtual;
    }

    public synchronized Column addColumn(String columnName, String tableName) {
        this.invalidateCID();
        Column column = null;
        try {
            MappingClassImpl mappingClass = (MappingClassImpl)this.getDeclaringClass();
            JDOCatalogReader catalogReader = mappingClass.getDeclaringModel().getCatalogReader();
            Table table = catalogReader.getTable(tableName);
            if (table == null) {
                throw new JDOFatalUserException("table " + tableName + " not found in catalog");
            }
            column = table.getColumn(columnName);
            if (column == null) {
                throw new JDOFatalUserException("column " + columnName + " in table " + tableName + " not found in catalog");
            }
            boolean found = false;
            Iterator i = this._columns.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(column)) continue;
                found = true;
            }
            if (!found) {
                this._columns.add(column);
                ArrayList<Column> columnsForThisTable = (ArrayList<Column>)this._columnsForTable.get(table);
                if (columnsForThisTable == null) {
                    columnsForThisTable = new ArrayList<Column>();
                    this._columnsForTable.put(table, columnsForThisTable);
                }
                columnsForThisTable.add(column);
            }
        }
        catch (SQLException e) {
            throw new JDOFatalUserException("catalog error", (Throwable)e);
        }
        return column;
    }

    public synchronized Column[] getColumns() {
        if (this._columnsBuffer == null || !this.isValidClassCID(this._columnsBufferCID)) {
            this._columnsBuffer = this.getColumnsInternal();
            this._columnsBufferCID = this.getActualClassCID();
        }
        return this._columnsBuffer;
    }

    private Column[] getColumnsInternal() {
        if (!this._virtual) {
            return this._columns.toArray(initialColumnArray);
        }
        Column[] columns = null;
        Column[] superColumns = this._declaringClass.getMappingSuperClass().getField(this.getName()).getColumns();
        Column[] thisColumns = this._columns.toArray(initialColumnArray);
        columns = new Column[superColumns.length + thisColumns.length];
        System.arraycopy(superColumns, 0, columns, 0, superColumns.length);
        System.arraycopy(thisColumns, 0, columns, superColumns.length, thisColumns.length);
        return columns;
    }

    public synchronized Column[] getColumns(Table table) {
        Column[] result;
        if (this._columnsBufferForTable == null) {
            this._columnsBufferForTable = new HashMap();
        }
        if ((result = (Column[])this._columnsBufferForTable.get(table)) == null || !this.isValidClassCID(this._columnsBufferForTableCID)) {
            result = this.getColumnsInternal(table);
            this._columnsBufferForTable.put(table, result);
            this._columnsBufferForTableCID = this.getActualClassCID();
        }
        return result;
    }

    private Column[] getColumnsInternal(Table table) {
        if (!this._virtual) {
            List columnsForTableList = (List)this._columnsForTable.get(table);
            if (columnsForTableList != null) {
                return columnsForTableList.toArray(initialColumnArray);
            }
            return null;
        }
        Column[] columnsForTable = null;
        Column[] superColumnsForTable = this._declaringClass.getMappingSuperClass().getField(this.getName()).getColumns(table);
        Column[] thisColumnsForTable = null;
        List thisColumnsForTableList = (List)this._columnsForTable.get(table);
        if (thisColumnsForTableList != null) {
            thisColumnsForTable = thisColumnsForTableList.toArray(initialColumnArray);
        }
        if (superColumnsForTable == null && thisColumnsForTable == null) {
            return null;
        }
        if (superColumnsForTable == null) {
            return thisColumnsForTable;
        }
        if (thisColumnsForTable == null) {
            return superColumnsForTable;
        }
        columnsForTable = new Column[superColumnsForTable.length + thisColumnsForTable.length];
        System.arraycopy(superColumnsForTable, 0, columnsForTable, 0, superColumnsForTable.length);
        System.arraycopy(thisColumnsForTable, 0, columnsForTable, superColumnsForTable.length, thisColumnsForTable.length);
        return columnsForTable;
    }

    public synchronized MappingRelationship createMappingRelationship(int multiplicity, boolean update) {
        this.invalidateCID();
        if (this._mappingRelationship == null) {
            this._mappingRelationship = new MappingRelationshipImpl(this, multiplicity, update);
        }
        return this._mappingRelationship;
    }

    public synchronized MappingRelationship createMappingRelationship(int multiplicity, boolean join, boolean update) {
        this.invalidateCID();
        if (this._mappingRelationship == null) {
            this._mappingRelationship = new MappingRelationshipImpl(this, multiplicity, join, update);
        }
        return this._mappingRelationship;
    }

    public synchronized MappingRelationship getMappingRelationship() {
        return this._mappingRelationship;
    }

    public synchronized void accept(MappingVisitor mappingVisitor) throws Exception {
        mappingVisitor.visitMappingFieldPre(this);
        if (this._mappingRelationship != null) {
            this._mappingRelationship.accept(mappingVisitor);
        }
        mappingVisitor.visitMappingFieldPost(this);
    }

    private void invalidateCID() {
        this._declaringClass.invalidateClassCID();
    }

    synchronized boolean isValidClassCID(long CID) {
        return this._declaringClass.isValidClassCID(CID);
    }

    synchronized long getActualClassCID() {
        return this._declaringClass.getActualClassCID();
    }

    public synchronized String toString() {
        return "MappingField[name = " + this.getName() + ", DeclaringClass = " + this._declaringClass + "]";
    }
}

