/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.mapping.impl;

import com.sap.jdo.model.jdo.JDOClass;
import com.sap.jdo.model.jdo.JDOField;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.Table;
import com.sap.jdo.sql.mapping.MappingClass;
import com.sap.jdo.sql.mapping.MappingDiscriminator;
import com.sap.jdo.sql.mapping.MappingField;
import com.sap.jdo.sql.mapping.MappingModel;
import com.sap.jdo.sql.mapping.MappingRelationship;
import com.sap.jdo.sql.mapping.MappingVisitor;
import com.sap.jdo.sql.mapping.impl.MappingDiscriminatorImpl;
import com.sap.jdo.sql.mapping.impl.MappingFieldImpl;
import com.sap.jdo.sql.mapping.impl.MappingModelChecker;
import com.sap.jdo.sql.mapping.impl.MappingModelImpl;
import com.sap.jdo.sql.mapping.xml.Renderer_0_3;
import com.sap.jdo.sql.mapping.xml.Renderer_1_0;
import com.sap.tc.logging.Location;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;

public class MappingClassImpl
implements MappingClass {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jdo$sql$mapping$impl$MappingClassImpl == null ? (class$com$sap$jdo$sql$mapping$impl$MappingClassImpl = MappingClassImpl.class$("com.sap.jdo.sql.mapping.impl.MappingClassImpl")) : class$com$sap$jdo$sql$mapping$impl$MappingClassImpl));
    private static final MappingFieldImpl[] __initialMappingFieldArray = new MappingFieldImpl[0];
    private static final MappingClassImpl[] __initialMappingClassArray = new MappingClassImpl[0];
    private static final Table[] __initialTableArray = new Table[0];
    private static final Column[] __initialColumnArray = new Column[0];
    private MappingModelImpl _declaringModel;
    private JDOModel _jdoModel;
    private String _name;
    private JDOClass _jdoClass;
    private Object _javaClass;
    private HashMap _mappingFieldsForFieldNumber;
    private HashMap _mappingFieldsForFieldName;
    private HashMap _mappingVirtualFieldsForFieldNumber;
    private HashMap _mappingVirtualFieldsForFieldName;
    private MappingDiscriminator _mappingDiscriminator;
    private boolean _isXMLRequired;
    private boolean _isChecked;
    private long _CID;
    private MappingField[] _mappingFields;
    private long _mappingFieldsCID;
    private MappingField[] _mappingFieldsInplace;
    private long _mappingFieldsInplaceCID;
    private MappingField[] _mappingFieldsForceInplace;
    private long _mappingFieldsForceInplaceCID;
    private Map _mappingFieldsInplaceForTable;
    private long _mappingFieldsInplaceForTableCID;
    private Map _mappingFieldsForceInplaceForTable;
    private long _mappingFieldsForceInplaceForTableCID;
    private MappingField[] _mappingPKFields;
    private long _mappingPKFieldsCID;
    private MappingField[] _mappingNonPKDFGFields;
    private long _mappingNonPKDFGFieldsCID;
    private MappingField[] _mappingNonPKDFGFieldsInplace;
    private long _mappingNonPKDFGFieldsInplaceCID;
    private Map _mappingNonPKDFGFieldsInplaceForTable;
    private long _mappingNonPKDFGFieldsInplaceForTableCID;
    private MappingField[] _mappingRelationshipFields;
    private long _mappingRelationshipFieldsCID;
    private MappingField[] _mappingNonPKDFGRelationshipFields;
    private long _mappingNonPKDFGRelationshipFieldsCID;
    private MappingClass _mappingSuperClass;
    private long _mappingSuperClassCID;
    private MappingClass _mappingRootClass;
    private long _mappingRootClassCID;
    private MappingClass[] _mappingSubClasses;
    private long _mappingSubClassesCID;
    private MappingClass[] _loadedMappingSubClasses;
    private long _loadedMappingSubClassesCID;
    private Table[] _tables;
    private long _tablesCID;
    private Table[] _tablesDFG;
    private long _tablesDFGCID;
    static /* synthetic */ Class class$com$sap$jdo$sql$mapping$impl$MappingClassImpl;

    public MappingClassImpl(MappingModelImpl mappingModel, JDOModel jdoModel, String className) {
        if (mappingModel == null) {
            throw new IllegalArgumentException("no mapping model given");
        }
        this._declaringModel = mappingModel;
        this._jdoModel = jdoModel;
        this._name = className;
        this._jdoClass = null;
        this._javaClass = null;
        this._mappingFieldsForFieldName = new HashMap();
        this._mappingFieldsForFieldNumber = null;
        this._mappingVirtualFieldsForFieldName = new HashMap();
        this._mappingVirtualFieldsForFieldNumber = null;
        this._mappingDiscriminator = null;
        this._isXMLRequired = true;
        this._isChecked = false;
    }

    public MappingClassImpl(MappingModelImpl mappingModel, JDOModel jdoModel, Object javaClass) {
        this(mappingModel, jdoModel, ((Class)javaClass).getName());
        this._javaClass = javaClass;
    }

    public MappingClassImpl(MappingModelImpl mappingModel, JDOModel jdoModel, JDOClass jdoClass) {
        this(mappingModel, jdoModel, jdoClass.getName());
        this._jdoClass = jdoClass;
    }

    public synchronized MappingModel getDeclaringModel() {
        return this._declaringModel;
    }

    public synchronized JDOClass getJDOClass() {
        String METHOD = "getJDOClass()";
        if (this._jdoClass != null) {
            return this._jdoClass;
        }
        if (this._jdoModel == null) {
            this._jdoModel = this.getDeclaringModel().getJDOModel();
            if (this._jdoModel == null) {
                if (LOCATION.beInfo()) {
                    LOCATION.infoT("getJDOClass()", "JDO Model not provided, JDO class " + this._name + " not accessible");
                }
                return null;
            }
        }
        try {
            this._jdoClass = this._jdoModel.getJDOClass(this._name, true);
            if (this._jdoClass == null) {
                throw new JDOFatalDataStoreException("can't access JDO class " + this._name + " in JDO Model");
            }
            return this._jdoClass;
        }
        catch (JDOModelException e) {
            throw new JDOFatalDataStoreException("JDO model error", (Throwable)e);
        }
    }

    public synchronized Object getJavaClass() {
        JDOClass jdoClass;
        if (this._javaClass == null && (jdoClass = this.getJDOClass()) != null) {
            this._javaClass = jdoClass.getJavaClass();
        }
        return this._javaClass;
    }

    public synchronized String getName() {
        return this._name;
    }

    public String getNonQualifiedName() {
        int i = this.getName().lastIndexOf(46);
        if (i != -1) {
            return this.getName().substring(i + 1);
        }
        return this.getName();
    }

    public String getPackageName() {
        int i = this.getName().lastIndexOf(46);
        if (i != -1) {
            return this.getName().substring(0, i);
        }
        return "";
    }

    public synchronized boolean isXMLRequired() {
        return this._isXMLRequired;
    }

    public synchronized void setXMLRequired(boolean isXMLRequired) {
        this._isXMLRequired = isXMLRequired;
    }

    public synchronized void checkConsistency() {
        MappingClassImpl mappingClassImpl = this;
        synchronized (mappingClassImpl) {
            if (!this._isChecked) {
                try {
                    this._isChecked = true;
                    if (this._declaringModel._checkConsistency.equals(Boolean.TRUE)) {
                        MappingModelChecker.checkMappingClass(this);
                    }
                }
                catch (Exception e) {
                    this._isChecked = false;
                    throw new JDOFatalUserException("consistency check error for " + this.getName(), (Throwable)e);
                }
            }
        }
    }

    private void checkXMLRequired() {
        if (this._isXMLRequired) {
            this._declaringModel.getMappingClass((Class)this._javaClass, true);
        } else {
            this.checkConsistency();
        }
    }

    public synchronized MappingField createMappingField(String fieldName) {
        MappingFieldImpl mf = new MappingFieldImpl(this, fieldName, false);
        MappingFieldImpl tmp = this._mappingFieldsForFieldName.put(fieldName, mf);
        if (tmp != null) {
            this._mappingFieldsForFieldName.put(fieldName, tmp);
            throw new JDOFatalInternalException("MappingField with name " + fieldName + " already exists");
        }
        this.invalidateClassCID();
        this._mappingFieldsForFieldNumber = null;
        return mf;
    }

    public synchronized MappingField createMappingVirtualField(String fieldName) {
        MappingFieldImpl mvf = new MappingFieldImpl(this, fieldName, true);
        MappingFieldImpl tmp = this._mappingVirtualFieldsForFieldName.put(fieldName, mvf);
        if (tmp != null) {
            this._mappingVirtualFieldsForFieldName.put(fieldName, tmp);
            throw new JDOFatalInternalException("MappingVirtualField with name " + fieldName + " already exists");
        }
        this.invalidateClassCID();
        this._mappingVirtualFieldsForFieldNumber = null;
        return mvf;
    }

    public synchronized MappingDiscriminator createMappingDiscriminator() {
        if (this._mappingDiscriminator == null) {
            this._mappingDiscriminator = new MappingDiscriminatorImpl(this);
            this.invalidateClassCID();
        }
        return this._mappingDiscriminator;
    }

    public synchronized MappingField getField(int fieldNum) {
        MappingClassImpl mappingSuperClass;
        this.checkXMLRequired();
        this.initializeForFieldNumber();
        MappingFieldImpl mf = null;
        mf = (MappingFieldImpl)this._mappingFieldsForFieldNumber.get(new Integer(fieldNum));
        if (mf == null && (mf = (MappingFieldImpl)this._mappingVirtualFieldsForFieldNumber.get(new Integer(fieldNum))) == null && (mappingSuperClass = (MappingClassImpl)this.getMappingSuperClass()) != null) {
            mf = (MappingFieldImpl)mappingSuperClass.getField(fieldNum);
        }
        return mf;
    }

    public synchronized MappingField getField(String fieldName) {
        MappingClassImpl mappingSuperClass;
        this.checkXMLRequired();
        MappingFieldImpl mf = null;
        if (this.getJDOClass() != null && (mf = (MappingFieldImpl)this._mappingFieldsForFieldName.get(fieldName)) == null && (mf = (MappingFieldImpl)this._mappingVirtualFieldsForFieldName.get(fieldName)) == null && (mappingSuperClass = (MappingClassImpl)this.getMappingSuperClass()) != null) {
            mf = (MappingFieldImpl)mappingSuperClass.getField(fieldName);
        }
        return mf;
    }

    public synchronized MappingField[] getMappingFields() {
        if (this._mappingFields == null || !this.isValidClassCID(this._mappingFieldsCID)) {
            this._mappingFields = this.getMappingFieldsInternal();
            this._mappingFieldsCID = this.getActualClassCID();
        }
        return this._mappingFields;
    }

    private MappingField[] getMappingFieldsInternal() {
        this.checkXMLRequired();
        MappingFieldImpl[] mfs = null;
        MappingClassImpl mappingSuperClass = (MappingClassImpl)this.getMappingSuperClass();
        MappingFieldImpl[] superMappingFields = null;
        if (mappingSuperClass != null) {
            superMappingFields = (MappingFieldImpl[])mappingSuperClass.getMappingFields();
        }
        if (superMappingFields == null) {
            mfs = this._mappingFieldsForFieldName.values().toArray(__initialMappingFieldArray);
        } else {
            MappingFieldImpl[] superMappingFieldsReplaced = this.replaceVirtualFields(superMappingFields);
            MappingFieldImpl[] thisMappingFields = this._mappingFieldsForFieldName.values().toArray(__initialMappingFieldArray);
            mfs = new MappingFieldImpl[superMappingFields.length + thisMappingFields.length];
            System.arraycopy(superMappingFieldsReplaced, 0, mfs, 0, superMappingFields.length);
            System.arraycopy(thisMappingFields, 0, mfs, superMappingFields.length, thisMappingFields.length);
        }
        return mfs;
    }

    public synchronized MappingField[] getMappingFieldsInplace() {
        if (this._mappingFieldsInplace == null || !this.isValidClassCID(this._mappingFieldsInplaceCID)) {
            this._mappingFieldsInplace = this.getMappingFieldsInplaceInternal(null, false);
            this._mappingFieldsInplaceCID = this.getActualClassCID();
        }
        return this._mappingFieldsInplace;
    }

    public synchronized MappingField[] getMappingFieldsForceInplace() {
        if (this._mappingFieldsForceInplace == null || !this.isValidClassCID(this._mappingFieldsForceInplaceCID)) {
            this._mappingFieldsForceInplace = this.getMappingFieldsInplaceInternal(null, true);
            this._mappingFieldsForceInplaceCID = this.getActualClassCID();
        }
        return this._mappingFieldsForceInplace;
    }

    public synchronized MappingField[] getMappingFieldsInplace(Table table) {
        MappingField[] result;
        if (this._mappingFieldsInplaceForTable == null) {
            this._mappingFieldsInplaceForTable = new HashMap();
        }
        if ((result = (MappingField[])this._mappingFieldsInplaceForTable.get(table)) == null || !this.isValidClassCID(this._mappingFieldsInplaceForTableCID)) {
            result = this.getMappingFieldsInplaceInternal(table, false);
            this._mappingFieldsInplaceForTable.put(table, result);
            this._mappingFieldsInplaceForTableCID = this.getActualClassCID();
        }
        return result;
    }

    public synchronized MappingField[] getMappingFieldsForceInplace(Table table) {
        MappingField[] result;
        if (this._mappingFieldsForceInplaceForTable == null) {
            this._mappingFieldsForceInplaceForTable = new HashMap();
        }
        if ((result = (MappingField[])this._mappingFieldsForceInplaceForTable.get(table)) == null || !this.isValidClassCID(this._mappingFieldsForceInplaceForTableCID)) {
            result = this.getMappingFieldsInplaceInternal(table, true);
            this._mappingFieldsForceInplaceForTable.put(table, result);
            this._mappingFieldsForceInplaceForTableCID = this.getActualClassCID();
        }
        return result;
    }

    private MappingField[] getMappingFieldsInplaceInternal(Table table, boolean forceInPlace) {
        MappingField[] mappingFields = this.getMappingFields();
        ArrayList<MappingField> mappingFieldsForTable = new ArrayList<MappingField>();
        if (mappingFields != null && mappingFields.length > 0) {
            int i = 0;
            while (i < mappingFields.length) {
                MappingField mf = mappingFields[i];
                Column[] columns = mf.getColumns();
                MappingRelationship mr = mf.getMappingRelationship();
                if (mr == null || mr.isInPlace(forceInPlace)) {
                    if (table == null) {
                        if (!mappingFieldsForTable.contains(mf)) {
                            mappingFieldsForTable.add(mf);
                        }
                    } else {
                        int j = 0;
                        while (j < columns.length) {
                            if (table == columns[j].getTable() && !mappingFieldsForTable.contains(mf)) {
                                mappingFieldsForTable.add(mf);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            return mappingFieldsForTable.toArray(__initialMappingFieldArray);
        }
        return __initialMappingFieldArray;
    }

    public synchronized MappingField[] getMappingPKFields() {
        if (this._mappingPKFields == null || !this.isValidClassCID(this._mappingPKFieldsCID)) {
            this._mappingPKFields = this.getMappingPKFieldsInternal();
            this._mappingPKFieldsCID = this.getActualClassCID();
        }
        return this._mappingPKFields;
    }

    private MappingField[] getMappingPKFieldsInternal() {
        this.checkXMLRequired();
        MappingClassImpl mappingSuperClass = (MappingClassImpl)this.getMappingSuperClass();
        MappingField[] mappingPKFields = null;
        if (mappingSuperClass != null) {
            mappingPKFields = this.replaceVirtualFields((MappingFieldImpl[])mappingSuperClass.getMappingPKFields());
        } else {
            MappingField[] mappingFields = this.getMappingFields();
            ArrayList<MappingField> result = new ArrayList<MappingField>();
            int i = 0;
            while (i < mappingFields.length) {
                if (mappingFields[i].getJDOField().isPrimaryKey()) {
                    result.add(mappingFields[i]);
                }
                ++i;
            }
            mappingPKFields = result.toArray(__initialMappingFieldArray);
        }
        return mappingPKFields;
    }

    public synchronized MappingField[] getMappingNonPKDFGFields() {
        if (this._mappingNonPKDFGFields == null || !this.isValidClassCID(this._mappingNonPKDFGFieldsCID)) {
            this._mappingNonPKDFGFields = this.getMappingNonPKDFGFieldsInternal(this.getMappingFields());
            this._mappingNonPKDFGFieldsCID = this.getActualClassCID();
        }
        return this._mappingNonPKDFGFields;
    }

    public synchronized MappingField[] getMappingNonPKDFGFieldsInplace() {
        if (this._mappingNonPKDFGFieldsInplace == null || !this.isValidClassCID(this._mappingNonPKDFGFieldsInplaceCID)) {
            this._mappingNonPKDFGFieldsInplace = this.getMappingNonPKDFGFieldsInternal(this.getMappingFieldsInplace());
            this._mappingNonPKDFGFieldsInplaceCID = this.getActualClassCID();
        }
        return this._mappingNonPKDFGFieldsInplace;
    }

    public synchronized MappingField[] getMappingNonPKDFGFieldsInplace(Table table) {
        MappingField[] result;
        if (this._mappingNonPKDFGFieldsInplaceForTable == null) {
            this._mappingNonPKDFGFieldsInplaceForTable = new HashMap();
        }
        if ((result = (MappingField[])this._mappingNonPKDFGFieldsInplaceForTable.get(table)) == null || !this.isValidClassCID(this._mappingNonPKDFGFieldsInplaceForTableCID)) {
            result = this.getMappingNonPKDFGFieldsInternal(this.getMappingFieldsInplace(table));
            this._mappingNonPKDFGFieldsInplaceForTable.put(table, result);
            this._mappingNonPKDFGFieldsInplaceForTableCID = this.getActualClassCID();
        }
        return result;
    }

    private MappingField[] getMappingNonPKDFGFieldsInternal(MappingField[] mappingFields) {
        ArrayList<MappingField> result = new ArrayList<MappingField>();
        int i = 0;
        while (i < mappingFields.length) {
            MappingField mappingField = mappingFields[i];
            JDOField jdoField = mappingField.getJDOField();
            if (!jdoField.isPrimaryKey() && jdoField.isDefaultFetchGroup()) {
                result.add(mappingField);
            }
            ++i;
        }
        return result.toArray(__initialMappingFieldArray);
    }

    public synchronized MappingField[] getMappingRelationshipFields() {
        if (this._mappingRelationshipFields == null || !this.isValidClassCID(this._mappingRelationshipFieldsCID)) {
            this._mappingRelationshipFields = this.getMappingRelationshipFieldsInternal(this.getMappingFields());
            this._mappingRelationshipFieldsCID = this.getActualClassCID();
        }
        return this._mappingRelationshipFields;
    }

    public synchronized MappingField[] getMappingNonPKDFGRelationshipFields() {
        if (this._mappingNonPKDFGRelationshipFields == null || !this.isValidClassCID(this._mappingNonPKDFGRelationshipFieldsCID)) {
            this._mappingNonPKDFGRelationshipFields = this.getMappingRelationshipFieldsInternal(this.getMappingNonPKDFGFields());
            this._mappingNonPKDFGRelationshipFieldsCID = this.getActualClassCID();
        }
        return this._mappingNonPKDFGRelationshipFields;
    }

    private MappingField[] getMappingRelationshipFieldsInternal(MappingField[] mappingFields) {
        ArrayList<MappingField> relationshipFields = new ArrayList<MappingField>();
        if (mappingFields != null) {
            int i = 0;
            while (i < mappingFields.length) {
                MappingField mf = mappingFields[i];
                MappingRelationship mr = mf.getMappingRelationship();
                if (mr != null) {
                    relationshipFields.add(mf);
                }
                ++i;
            }
        }
        return relationshipFields.toArray(__initialMappingFieldArray);
    }

    private synchronized void initializeForFieldNumber() {
        MappingField mf;
        Iterator i;
        if (this._mappingFieldsForFieldNumber == null) {
            this._mappingFieldsForFieldNumber = new HashMap();
            i = this._mappingFieldsForFieldName.values().iterator();
            while (i.hasNext()) {
                mf = (MappingField)i.next();
                this._mappingFieldsForFieldNumber.put(new Integer(mf.getJDOField().getFieldNumber()), mf);
            }
        }
        if (this._mappingVirtualFieldsForFieldNumber == null) {
            this._mappingVirtualFieldsForFieldNumber = new HashMap();
            i = this._mappingVirtualFieldsForFieldName.values().iterator();
            while (i.hasNext()) {
                mf = (MappingField)i.next();
                this._mappingVirtualFieldsForFieldNumber.put(new Integer(mf.getJDOField().getFieldNumber()), mf);
            }
        }
    }

    private MappingFieldImpl[] replaceVirtualFields(MappingFieldImpl[] mappingFields) {
        MappingFieldImpl[] result = new MappingFieldImpl[mappingFields.length];
        if (this._mappingVirtualFieldsForFieldName.size() == 0) {
            System.arraycopy(mappingFields, 0, result, 0, result.length);
        } else {
            int i = 0;
            while (i < mappingFields.length) {
                MappingFieldImpl mappingVirtualField = (MappingFieldImpl)this._mappingVirtualFieldsForFieldName.get(mappingFields[i].getName());
                result[i] = mappingVirtualField != null ? mappingVirtualField : mappingFields[i];
                ++i;
            }
        }
        return result;
    }

    public synchronized MappingDiscriminator getMappingDiscriminator() {
        this.checkXMLRequired();
        MappingClassImpl mappingSuperClass = (MappingClassImpl)this.getMappingSuperClass();
        if (mappingSuperClass != null) {
            return mappingSuperClass.getMappingDiscriminator();
        }
        return this._mappingDiscriminator;
    }

    public synchronized MappingClass getMappingSuperClass() {
        if (this._mappingSuperClass == null || !this.isValidModelCID(this._mappingSuperClassCID)) {
            this._mappingSuperClass = this.getMappingSuperClassInternal();
            this._mappingSuperClassCID = this.getActualModelCID();
        }
        return this._mappingSuperClass;
    }

    private MappingClass getMappingSuperClassInternal() {
        this.checkXMLRequired();
        JDOClass jdoClass = this.getJDOClass();
        if (jdoClass == null) {
            throw new JDOFatalInternalException("No JDO Model provided, super class can't be determined");
        }
        JDOClass jdoSuperClass = jdoClass.getPersistenceCapableSuperclass();
        if (jdoSuperClass != null) {
            Class superClass = (Class)jdoSuperClass.getJavaClass();
            if (superClass == null) {
                throw new JDOFatalInternalException("Java Class not loaded, super class can't be determined");
            }
            return this._declaringModel.getMappingClass(superClass);
        }
        return null;
    }

    public synchronized MappingClass getMappingRootClass() {
        if (this._mappingRootClass == null || !this.isValidModelCID(this._mappingRootClassCID)) {
            this._mappingRootClass = this.getMappingRootClassInternal();
            this._mappingRootClassCID = this.getActualModelCID();
        }
        return this._mappingRootClass;
    }

    private MappingClass getMappingRootClassInternal() {
        this.checkXMLRequired();
        if (this.getJDOClass() == null) {
            throw new JDOFatalInternalException("No JDO Model provided, root class can't be determined");
        }
        MappingClassImpl mappingRootClass = this;
        while (mappingRootClass.getMappingSuperClass() != null) {
            mappingRootClass = (MappingClassImpl)mappingRootClass.getMappingSuperClass();
        }
        return mappingRootClass;
    }

    public synchronized MappingClass[] getMappingSubClasses() {
        if (this._mappingSubClasses == null || !this.isValidModelCID(this._mappingSubClassesCID)) {
            this._mappingSubClasses = this.getMappingSubClassesInternal();
            this._mappingSubClassesCID = this.getActualModelCID();
        }
        return this._mappingSubClasses;
    }

    private MappingClass[] getMappingSubClassesInternal() {
        this.checkXMLRequired();
        JDOClass jdoClass = this.getJDOClass();
        if (jdoClass == null) {
            throw new JDOFatalInternalException("No JDO Model provided, sub classes can't be determined");
        }
        ArrayList<MappingClass> subClasses = new ArrayList<MappingClass>();
        JDOClass[] jdoClasses = jdoClass.getDeclaringModel().getDeclaredClasses();
        int i = 0;
        while (i < jdoClasses.length) {
            if (jdoClasses[i] != jdoClass && MappingClassImpl.isSuperClass(jdoClass, jdoClasses[i])) {
                JDOClass jdoSubClass = jdoClasses[i];
                Class<?> pcSubClass = (Class<?>)jdoSubClass.getJavaClass();
                String pcSubClassName = null;
                if (pcSubClass == null) {
                    try {
                        pcSubClassName = jdoSubClass.getName();
                        pcSubClass = Class.forName(pcSubClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new JDOFatalDataStoreException("Subclass " + pcSubClassName + " cannot be loaded", (Throwable)e);
                    }
                }
                if (pcSubClass != null) {
                    subClasses.add(this._declaringModel.getMappingClass(pcSubClass));
                }
            }
            ++i;
        }
        return subClasses.toArray(__initialMappingClassArray);
    }

    private MappingClass[] getLoadedMappingSubClasses() {
        if (this._loadedMappingSubClasses == null || !this.isValidModelCID(this._loadedMappingSubClassesCID)) {
            this._loadedMappingSubClasses = this.getLoadedMappingSubClassesInternal();
            this._loadedMappingSubClassesCID = this.getActualModelCID();
        }
        return this._loadedMappingSubClasses;
    }

    private MappingClass[] getLoadedMappingSubClassesInternal() {
        MappingClassImpl[] loadedMappingClasses = this._javaClass == null ? (MappingClassImpl[])this._declaringModel.getMappingClasses() : (MappingClassImpl[])this._declaringModel.getMappingClasses(((Class)this._javaClass).getClassLoader());
        ArrayList<MappingClassImpl> loadedMappingSubClasses = new ArrayList<MappingClassImpl>();
        int i = 0;
        while (i < loadedMappingClasses.length) {
            if (loadedMappingClasses[i] != this && MappingClassImpl.isSuperClass(this, loadedMappingClasses[i])) {
                loadedMappingSubClasses.add(loadedMappingClasses[i]);
            }
            ++i;
        }
        return loadedMappingSubClasses.toArray(__initialMappingClassArray);
    }

    private static boolean isSuperClass(JDOClass superClass, JDOClass subClass) {
        while (subClass != null) {
            if (superClass != (subClass = subClass.getPersistenceCapableSuperclass())) continue;
            return true;
        }
        return false;
    }

    private static boolean isSuperClass(MappingClass superClass, MappingClass subClass) {
        JDOClass superJdoClass = superClass.getJDOClass();
        if (superJdoClass == null) {
            throw new JDOFatalInternalException("No JDO Model provided for " + superClass.getName());
        }
        JDOClass subJdoClass = subClass.getJDOClass();
        if (subJdoClass == null) {
            throw new JDOFatalInternalException("No JDO Model provided for " + subClass.getName());
        }
        return MappingClassImpl.isSuperClass(superJdoClass, subJdoClass);
    }

    public synchronized Table[] getTables() {
        if (this._tables == null || !this.isValidClassCID(this._tablesCID)) {
            this._tables = this.getTablesInternal();
            this._tablesCID = this.getActualClassCID();
        }
        return this._tables;
    }

    private Table[] getTablesInternal() {
        Table discriminatorTable;
        MappingDiscriminator mappingDiscriminator;
        this.checkXMLRequired();
        MappingField[] mappingFields = this.getMappingFields();
        HashSet<Table> tables = new HashSet<Table>();
        int i = 0;
        while (i < mappingFields.length) {
            Column[] columns = mappingFields[i].getColumns();
            int j = 0;
            while (j < columns.length) {
                tables.add(columns[j].getTable());
                ++j;
            }
            ++i;
        }
        this._tables = tables.toArray(__initialTableArray);
        if (this._tables.length > 1 && (mappingDiscriminator = this.getMappingDiscriminator()) != null && this._tables[0] != (discriminatorTable = mappingDiscriminator.getColumns()[0].getTable())) {
            int i2 = 0;
            while (i2 < this._tables.length) {
                if (this._tables[i2] == discriminatorTable) {
                    this._tables[i2] = this._tables[0];
                    this._tables[0] = discriminatorTable;
                    break;
                }
                ++i2;
            }
        }
        return this._tables;
    }

    public synchronized Table[] getDFGTables() {
        if (this._tablesDFG == null || !this.isValidClassCID(this._tablesDFGCID)) {
            this._tablesDFG = this.getDFGTablesInternal();
            this._tablesDFGCID = this.getActualClassCID();
        }
        return this._tablesDFG;
    }

    private Table[] getDFGTablesInternal() {
        Table discriminatorTable;
        MappingDiscriminator mappingDiscriminator;
        this.checkXMLRequired();
        MappingField[] mappingFields = this.getMappingFields();
        HashSet<Table> tables = new HashSet<Table>();
        int i = 0;
        while (i < mappingFields.length) {
            if (mappingFields[i].getJDOField().isDefaultFetchGroup()) {
                Column[] columns = mappingFields[i].getColumns();
                int j = 0;
                while (j < columns.length) {
                    tables.add(columns[j].getTable());
                    ++j;
                }
            }
            ++i;
        }
        this._tablesDFG = tables.toArray(__initialTableArray);
        if (this._tablesDFG.length > 1 && (mappingDiscriminator = this.getMappingDiscriminator()) != null && this._tablesDFG[0] != (discriminatorTable = mappingDiscriminator.getColumns()[0].getTable())) {
            int i2 = 0;
            while (i2 < this._tablesDFG.length) {
                if (this._tablesDFG[i2] == discriminatorTable) {
                    this._tablesDFG[i2] = this._tablesDFG[0];
                    this._tablesDFG[0] = discriminatorTable;
                    break;
                }
                ++i2;
            }
        }
        return this._tablesDFG;
    }

    public synchronized void accept(MappingVisitor mappingVisitor) throws Exception {
        mappingVisitor.visitMappingClassPre(this);
        if (this._mappingDiscriminator != null) {
            this._mappingDiscriminator.accept(mappingVisitor);
        }
        Iterator i = this._mappingVirtualFieldsForFieldName.values().iterator();
        while (i.hasNext()) {
            ((MappingField)i.next()).accept(mappingVisitor);
        }
        Iterator i2 = this._mappingFieldsForFieldName.values().iterator();
        while (i2.hasNext()) {
            ((MappingField)i2.next()).accept(mappingVisitor);
        }
        mappingVisitor.visitMappingClassPost(this);
    }

    public synchronized String getUIDAsString() {
        return this.getName();
    }

    public synchronized char[] getUIDAsCharArray() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public synchronized byte[] getUIDAsByteArray() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void render(String fileName) {
        if (fileName == null) return;
        OutputStreamWriter osw = null;
        try {
            try {
                if (this._declaringModel._version == null) {
                    throw new JDOFatalInternalException("version not defined");
                }
                FileOutputStream os = new FileOutputStream(fileName);
                osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
                if (this._declaringModel._version.equals("0.3")) {
                    Renderer_0_3 renderer = new Renderer_0_3(osw);
                    renderer.render(this);
                } else {
                    if (!this._declaringModel._version.equals("1.0")) throw new JDOFatalUserException("version " + this._declaringModel._version + " unknown");
                    Renderer_1_0 renderer = new Renderer_1_0(osw);
                    renderer.render(this);
                }
                Object var6_8 = null;
            }
            catch (FileNotFoundException e) {
                throw new JDOUserException("file not found error", (Throwable)e);
            }
            catch (IOException e) {
                throw new JDOFatalDataStoreException("io error", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (osw == null) throw throwable;
                osw.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new JDOFatalDataStoreException("io error", (Throwable)e);
            }
        }
        try {}
        catch (IOException e) {
            throw new JDOFatalDataStoreException("io error", (Throwable)e);
        }
        if (osw == null) return;
        osw.close();
    }

    public synchronized String toString() {
        return "MappingClass[name = " + this.getName() + "]";
    }

    private boolean isValidModelCID(long CID) {
        return this._declaringModel.isValidModelCID(CID);
    }

    private void invalidateModelCID() {
        this._declaringModel.invalidateModelCID();
    }

    private long getActualModelCID() {
        return this._declaringModel.getActualModelCID();
    }

    synchronized boolean isValidClassCID(long CID) {
        return this._CID == CID;
    }

    synchronized void invalidateClassCID() {
        this.invalidateClassCID(true);
    }

    synchronized void invalidateClassCID(boolean subclasses) {
        ++this._CID;
        if (subclasses) {
            MappingClassImpl[] mappingSubClasses = (MappingClassImpl[])this.getLoadedMappingSubClasses();
            int i = 0;
            while (i < mappingSubClasses.length) {
                mappingSubClasses[i].invalidateClassCID(false);
                ++i;
            }
        }
    }

    synchronized long getActualClassCID() {
        return this._CID;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

