/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.catalog.proxy;

import com.sap.dictionary.database.catalog.DbCatalogReader;
import com.sap.jdo.EJBImplHelper;
import com.sap.jdo.sql.catalog.proxy.CatalogReaderProxy;
import com.sap.jdo.sql.catalog.proxy.ConnectionSource;
import com.sap.sql.catalog.Table;
import com.sap.sql.jdbc.common.CommonConnection;
import com.sap.sql.services.OpenSQLServices;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class ConnectedCatalogReaderProxy
extends CatalogReaderProxy {
    private ConnectionSource connectionSource;

    public static ConnectedCatalogReaderProxy getProxyFromUrl(String driver, String url, String user, String password) {
        return new ConnectedCatalogReaderProxy(new URLConnectionSource(driver, url, user, password));
    }

    public static ConnectedCatalogReaderProxy getProxyFromDataSource(String dataSourceName) {
        return new ConnectedCatalogReaderProxy(new DataSourceConnectionSource(dataSourceName));
    }

    private ConnectedCatalogReaderProxy(ConnectionSource aConnectionSource) {
        this.connectionSource = aConnectionSource;
    }

    Table getSQLTable(String tableName) throws SQLException {
        Connection conn = this.connectionSource.getConnection();
        Table table = null;
        try {
            Object reader = conn instanceof CommonConnection ? OpenSQLServices.getCatalogReader((CommonConnection)((CommonConnection)conn)) : new DbCatalogReader(conn);
            table = reader.getTable(tableName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
        return table;
    }

    private static class URLConnectionSource
    implements ConnectionSource {
        String url;
        String user;
        String password;

        URLConnectionSource(String driver, String anUrl, String anUser, String aPassword) {
            if (driver != null) {
                try {
                    Class.forName(driver);
                }
                catch (ClassNotFoundException e) {
                    throw new JDOFatalUserException("JDBC-Driver not found", (Throwable)e);
                }
            }
            this.url = anUrl;
            this.user = anUser;
            this.password = aPassword;
        }

        public Connection getConnection() throws SQLException {
            return DriverManager.getConnection(this.url, this.user, this.password);
        }
    }

    private static class DataSourceConnectionSource
    implements ConnectionSource {
        DataSource dataSource;

        DataSourceConnectionSource(String dataSourceName) {
            if (EJBImplHelper.isManaged()) {
                try {
                    InitialContext jndiCntx = new InitialContext();
                    this.dataSource = (DataSource)jndiCntx.lookup(dataSourceName);
                }
                catch (NamingException e) {
                    throw new JDOUserException("Cannot create JDBC-Connection", (Throwable)e);
                }
            } else {
                throw new JDOUserException("Cannot create JDBC-Connection");
            }
        }

        public Connection getConnection() throws SQLException {
            return this.dataSource.getConnection();
        }
    }
}

