/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.catalog.proxy;

import com.sap.jdo.sql.catalog.ForeignKey;
import com.sap.jdo.sql.catalog.JDOCatalogReader;
import com.sap.jdo.sql.catalog.Table;
import com.sap.jdo.sql.catalog.impl.AbstractCatalogReader;
import com.sap.jdo.sql.catalog.proxy.ForeignKeyProxy;
import com.sap.jdo.sql.catalog.proxy.TableProxy;
import java.sql.SQLException;
import java.util.HashMap;

public abstract class CatalogReaderProxy
extends AbstractCatalogReader
implements JDOCatalogReader {
    private HashMap _tableProxies = new HashMap();
    private HashMap _schemaTableProxies = new HashMap();

    public synchronized Table getTable(String tableName) throws SQLException {
        return this.getTable(tableName, this._tableProxies);
    }

    public synchronized Table getTable(String schemaName, String tableName) throws SQLException {
        HashMap tableProxies = (HashMap)this._schemaTableProxies.get(schemaName);
        if (tableProxies == null) {
            tableProxies = new HashMap();
            this._schemaTableProxies.put(schemaName, tableProxies);
        }
        return this.getTable(tableName, tableProxies);
    }

    abstract com.sap.sql.catalog.Table getSQLTable(String var1) throws SQLException;

    private Table getTable(String tableName, HashMap tableProxies) throws SQLException {
        com.sap.sql.catalog.Table table;
        TableProxy tableProxy = (TableProxy)tableProxies.get(tableName);
        if (tableProxy == null && (table = this.getSQLTable(tableName)) != null) {
            tableProxy = new TableProxy(table);
            tableProxies.put(tableName, tableProxy);
        }
        return tableProxy;
    }

    protected ForeignKey createConcreteForeignKey(JDOCatalogReader catalogReader, String foreignKeyName) {
        return new ForeignKeyProxy(catalogReader, foreignKeyName);
    }

    protected ForeignKey createConcreteForeignKey(JDOCatalogReader catalogReader, String schemaName, String foreignKeyName) {
        return new ForeignKeyProxy(catalogReader, schemaName, foreignKeyName);
    }
}

