/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.util;

import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.ResourceLocator;
import com.sap.jdo.enhancer.util.ResourceLocatorBase;
import com.sap.jdo.enhancer.util.Support;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class PathResourceLocator
extends ResourceLocatorBase
implements ResourceLocator {
    private final URLClassLoader classLoader;

    public PathResourceLocator(PrintWriter out, boolean verbose, String path) throws IOException {
        super(out, verbose);
        Assertion.affirm(path != null);
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer e = new StringTokenizer(path, File.pathSeparator);
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            File file = new File(s).getCanonicalFile();
            URL url = file.toURL();
            String canonicalName = url.toString();
            Assertion.affirm(canonicalName != null);
            if (!file.canRead()) {
                String msg = Support.getI18N("enhancer.metadata.cannot_read_resource", file.toString());
                throw new IOException(msg);
            }
            if (!(file.isDirectory() || file.isFile() && s.toLowerCase().endsWith("jar"))) {
                String msg = Support.getI18N("enhancer.metadata.illegal_path_element", file.toString());
                throw new IOException(msg);
            }
            urls.add(url);
            this.printMessage(Support.getI18N("enhancer.using_resource", canonicalName));
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        this.classLoader = new URLClassLoader(urlArray, null);
        Assertion.affirm(this.classLoader != null);
    }

    public InputStream getInputStreamForResource(String resourceName) {
        InputStream stream;
        this.printMessage("PathResourceLocator.getInputStreamForResource() : resourceName" + resourceName);
        Assertion.affirm(resourceName != null);
        URL url = this.classLoader.findResource(resourceName);
        if (url == null) {
            this.printMessage(Support.getI18N("enhancer.not_found_resource", resourceName));
            return null;
        }
        try {
            stream = url.openStream();
        }
        catch (IOException ex) {
            String msg = Support.getI18N("enhancer.io_error_while_reading_resource", url.toString(), ex.getMessage());
            throw new RuntimeException(msg);
        }
        Assertion.affirm(stream != null);
        this.printMessage(Support.getI18N("enhancer.found_resource", resourceName));
        return stream;
    }
}

