/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.util;

import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.ResourceLocator;
import com.sap.jdo.enhancer.util.ResourceLocatorBase;
import com.sap.jdo.enhancer.util.Support;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListResourceLocator
extends ResourceLocatorBase
implements ResourceLocator {
    final Map files = new HashMap();

    public ListResourceLocator(PrintWriter out, boolean verbose, List fileNames) throws IOException {
        super(out, verbose);
        Assertion.affirm(fileNames != null);
        Iterator i = fileNames.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            File file = new File(s).getCanonicalFile();
            URL url = file.toURL();
            String canonicalName = url.toString();
            Assertion.affirm(canonicalName != null);
            if (!file.canRead()) {
                String msg = Support.getI18N("enhancer.cannot_read_resource", file.toString());
                throw new IOException(msg);
            }
            this.files.put(canonicalName, file);
            this.printMessage(Support.getI18N("enhancer.using_resource", canonicalName));
        }
    }

    public InputStream getInputStreamForResource(String resourceName) {
        this.printMessage("ListResourceLocator.getInputStreamForResource() : resourceName" + resourceName);
        Assertion.affirm(resourceName != null);
        Set entries = this.files.entrySet();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            FileInputStream stream;
            Map.Entry entry = i.next();
            String fileName = (String)entry.getKey();
            if (!fileName.endsWith(resourceName)) continue;
            File file = (File)entry.getValue();
            try {
                stream = new FileInputStream(file);
            }
            catch (FileNotFoundException ex) {
                String msg = Support.getI18N("enhancer.io_error_while_reading_resource", file.toString(), ex.getMessage());
                throw new RuntimeException(msg);
            }
            Assertion.affirm(stream != null);
            this.printMessage(Support.getI18N("enhancer.found_resource", resourceName));
            return stream;
        }
        this.printMessage(Support.getI18N("enhancer.not_found_resource", resourceName));
        return null;
    }
}

