/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.test;

import com.sap.jdo.enhancer.meta.EnhancerMetaData;
import com.sap.jdo.enhancer.meta.EnhancerMetaDataFatalError;
import com.sap.jdo.enhancer.meta.EnhancerMetaDataUserException;
import com.sap.jdo.enhancer.meta.model.EnhancerMetaDataJDOModelImpl;
import com.sap.jdo.enhancer.meta.prop.EnhancerMetaDataPropertyImpl;
import com.sap.jdo.enhancer.meta.util.EnhancerMetaDataBaseModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class AugmentationTest {
    public static final int OK = 0;
    public static final int USAGE_ERROR = -1;
    public static final int METADATA_ERROR = -2;
    public static final int INTERNAL_ERROR = -3;
    public static final int AFFIRMATIVE = 1;
    public static final int NEGATIVE = 0;
    public static final int ERROR = -1;
    private static boolean debug = false;
    private static final PrintWriter out = new PrintWriter(System.out, true);
    private static final PrintWriter err = new PrintWriter(System.err, true);
    private static final String[] transientPrefixes = new String[]{"java.", "javax."};
    final EnhancerMetaData meta;
    private boolean verbose;
    private List classes;
    private String className;
    private String classPath;
    private Class classClass;
    private HashSet fields;
    private HashSet methods;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;
    static /* synthetic */ Class class$javax$jdo$spi$StateManager;
    static /* synthetic */ Class class$javax$jdo$PersistenceManager;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Class;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable$ObjectIdFieldSupplier;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable$ObjectIdFieldConsumer;
    static /* synthetic */ Class class$javax$jdo$InstanceCallbacks;

    static final void affirm(boolean cond) {
        if (debug && !cond) {
            throw new RuntimeException("Assertion failed.");
        }
    }

    static final void affirm(Object obj) {
        if (debug && obj == null) {
            throw new RuntimeException("Assertion failed: obj = null");
        }
    }

    static String toString(int mods, Class type, String name) {
        StringBuffer s = new StringBuffer();
        s.append(Modifier.toString(mods));
        s.append(" ");
        s.append(type.getName());
        s.append(" ");
        s.append(name);
        return s.toString();
    }

    static String toString(int mods, String name, Class[] params) {
        StringBuffer s = new StringBuffer();
        s.append(Modifier.toString(mods));
        s.append(" ");
        s.append(name);
        s.append("(");
        int j = params.length - 1;
        int i = 0;
        while (i <= j) {
            s.append(params[i].getName());
            if (i < j) {
                s.append(",");
            }
            ++i;
        }
        s.append(")");
        return s.toString();
    }

    static String toString(int mods, Class result, String name, Class[] params) {
        StringBuffer s = new StringBuffer();
        s.append(Modifier.toString(mods));
        s.append(" ");
        s.append(result.getName());
        s.append(" ");
        s.append(name);
        s.append("(");
        int j = params.length - 1;
        int i = 0;
        while (i <= j) {
            s.append(params[i].getName());
            if (i < j) {
                s.append(",");
            }
            ++i;
        }
        s.append(")");
        return s.toString();
    }

    static String toString(int mods, Class result, String name, Class[] params, Class[] ex) {
        StringBuffer s = new StringBuffer();
        s.append(AugmentationTest.toString(mods, result, name, params));
        s.append(" throws ");
        int j = ex.length - 1;
        int i = 0;
        while (i <= j) {
            s.append(ex[i].getName());
            if (i < j) {
                s.append(",");
            }
            ++i;
        }
        return s.toString();
    }

    public AugmentationTest(EnhancerMetaData jdoMetaData) {
        this.meta = jdoMetaData;
    }

    private int implementsInterface(PrintWriter out, Class intf) {
        Class<?>[] interfaces = this.classClass.getInterfaces();
        int i = interfaces.length - 1;
        while (i >= 0) {
            if (interfaces[i].equals(intf)) {
                out.println("        +++ implements interface: " + intf.getName());
                return 1;
            }
            --i;
        }
        out.println("        --- not implementing interface: " + intf.getName());
        return 0;
    }

    private int hasField(PrintWriter out, int mods, Class type, String name) {
        try {
            Field field = this.classClass.getDeclaredField(name);
            this.fields.remove(field);
            if ((field.getModifiers() & mods) != mods) {
                out.println("        !!! ERROR: field declaration: unmatched modifiers");
                out.println("            expected: " + AugmentationTest.toString(mods, type, name));
                out.println("            found:    " + field.toString());
                return -1;
            }
            if (!field.getType().equals(type)) {
                out.println("        !!! ERROR: field declaration: unexpected type");
                out.println("            expected: " + AugmentationTest.toString(mods, type, name));
                out.println("            found:    " + field.toString());
                return -1;
            }
            out.println("        +++ has field: " + field.toString());
            return 1;
        }
        catch (NoSuchFieldException ex) {
            out.println("        --- no field: " + AugmentationTest.toString(mods, type, name));
            return 0;
        }
    }

    private int hasConstructor(PrintWriter out, int mods, Class[] params) {
        try {
            Constructor ctor = this.classClass.getDeclaredConstructor(params);
            if ((ctor.getModifiers() & mods) != mods) {
                out.println("        !!! ERROR: constructor declaration: unmatched modifiers");
                out.println("            expected: " + AugmentationTest.toString(mods, this.className, params));
                out.println("            found:    " + ctor.toString());
                return -1;
            }
            out.println("        +++ has constructor: " + ctor.toString());
            return 1;
        }
        catch (NoSuchMethodException ex) {
            out.println("        --- no constructor: " + AugmentationTest.toString(mods, this.className, params));
            return 0;
        }
    }

    private int hasMethod(PrintWriter out, int mods, Class result, String name, Class[] params, Class[] exepts) {
        try {
            List<Class<Class>> c1;
            Method method = this.classClass.getDeclaredMethod(name, params);
            this.methods.remove(method);
            if ((method.getModifiers() & mods) != mods) {
                out.println("        !!! ERROR: method declaration: unmatched modifiers");
                out.println("            expected: " + AugmentationTest.toString(mods, result, name, params));
                out.println("            found:    " + method.toString());
                return -1;
            }
            if (!method.getReturnType().equals(result)) {
                out.println("        !!! ERROR: method declaration: unexpected result type");
                out.println("            expected: " + AugmentationTest.toString(mods, result, name, params));
                out.println("            found:    " + method.toString());
                return -1;
            }
            List<Class> c0 = Arrays.asList(exepts);
            if (!c0.containsAll(c1 = Arrays.asList(method.getExceptionTypes()))) {
                out.println("        !!! ERROR: method declaration: unexpected exceptions");
                out.println("            expected: " + AugmentationTest.toString(mods, result, name, params, exepts));
                out.println("            found:    " + method.toString());
                return -1;
            }
            if (!c1.containsAll(c0)) {
                out.println("        !!! ERROR: method declaration: unmatched exceptions");
                out.println("            expected: " + AugmentationTest.toString(mods, result, name, params, exepts));
                out.println("            found:    " + method.toString());
                return -1;
            }
            out.println("        +++ has method: " + method.toString());
            return 1;
        }
        catch (NoSuchMethodException ex) {
            out.println("        --- no method: " + AugmentationTest.toString(mods, result, name, params));
            return 0;
        }
    }

    private int hasMethod(PrintWriter out, int mods, Class result, String name, Class[] params) {
        return this.hasMethod(out, mods, result, name, params, new Class[0]);
    }

    private int evaluate(int nofFeatures, int[] r) {
        AugmentationTest.affirm(nofFeatures <= r.length);
        int res = 0;
        int i = 0;
        while (i < nofFeatures) {
            int j = r[i];
            AugmentationTest.affirm(-1 <= j && j <= 1);
            if (j < -1) {
                return -1;
            }
            if (j > 0) {
                ++res;
            }
            ++i;
        }
        AugmentationTest.affirm(res >= 0);
        if (res >= nofFeatures) {
            return 1;
        }
        return 0;
    }

    private int hasGenericAugmentation(PrintWriter out) {
        AugmentationTest.affirm(true);
        AugmentationTest.affirm(this.classClass);
        int nofFeatures = 17;
        int[] r = new int[17];
        int i = 0;
        r[i++] = this.implementsInterface(out, class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = AugmentationTest.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable);
        r[i++] = this.hasField(out, 132, class$javax$jdo$spi$StateManager == null ? (class$javax$jdo$spi$StateManager = AugmentationTest.class$("javax.jdo.spi.StateManager")) : class$javax$jdo$spi$StateManager, "jdoStateManager");
        r[i++] = this.hasField(out, 132, Byte.TYPE, "jdoFlags");
        r[i++] = this.hasMethod(out, 49, Void.TYPE, "jdoReplaceStateManager", new Class[]{class$javax$jdo$spi$StateManager == null ? (class$javax$jdo$spi$StateManager = AugmentationTest.class$("javax.jdo.spi.StateManager")) : class$javax$jdo$spi$StateManager});
        r[i++] = this.hasMethod(out, 17, Void.TYPE, "jdoReplaceFlags", new Class[0]);
        r[i++] = this.hasMethod(out, 17, class$javax$jdo$PersistenceManager == null ? (class$javax$jdo$PersistenceManager = AugmentationTest.class$("javax.jdo.PersistenceManager")) : class$javax$jdo$PersistenceManager, "jdoGetPersistenceManager", new Class[0]);
        r[i++] = this.hasMethod(out, 17, class$java$lang$Object == null ? (class$java$lang$Object = AugmentationTest.class$("java.lang.Object")) : class$java$lang$Object, "jdoGetObjectId", new Class[0]);
        r[i++] = this.hasMethod(out, 17, class$java$lang$Object == null ? (class$java$lang$Object = AugmentationTest.class$("java.lang.Object")) : class$java$lang$Object, "jdoGetTransactionalObjectId", new Class[0]);
        r[i++] = this.hasMethod(out, 17, Boolean.TYPE, "jdoIsPersistent", new Class[0]);
        r[i++] = this.hasMethod(out, 17, Boolean.TYPE, "jdoIsTransactional", new Class[0]);
        r[i++] = this.hasMethod(out, 17, Boolean.TYPE, "jdoIsNew", new Class[0]);
        r[i++] = this.hasMethod(out, 17, Boolean.TYPE, "jdoIsDeleted", new Class[0]);
        r[i++] = this.hasMethod(out, 17, Boolean.TYPE, "jdoIsDirty", new Class[0]);
        r[i++] = this.hasMethod(out, 17, Void.TYPE, "jdoMakeDirty", new Class[]{class$java$lang$String == null ? (class$java$lang$String = AugmentationTest.class$("java.lang.String")) : class$java$lang$String});
        r[i++] = this.hasMethod(out, 17, Void.TYPE, "jdoReplaceFields", new Class[]{array$I == null ? (array$I = AugmentationTest.class$("[I")) : array$I});
        r[i++] = this.hasMethod(out, 17, Void.TYPE, "jdoProvideFields", new Class[]{array$I == null ? (array$I = AugmentationTest.class$("[I")) : array$I});
        r[i++] = this.hasMethod(out, 20, Void.TYPE, "jdoPreSerialize", new Class[0]);
        AugmentationTest.affirm(i == 17);
        return this.evaluate(17, r);
    }

    private int hasSpecificAugmentation(PrintWriter out) {
        AugmentationTest.affirm(true);
        AugmentationTest.affirm(this.classClass);
        int nofFeatures = 14;
        int[] r = new int[14];
        int i = 0;
        r[i++] = this.hasField(out, 26, Integer.TYPE, "jdoInheritedFieldCount");
        r[i++] = this.hasField(out, 26, array$Ljava$lang$String == null ? (array$Ljava$lang$String = AugmentationTest.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, "jdoFieldNames");
        r[i++] = this.hasField(out, 26, array$Ljava$lang$Class == null ? (array$Ljava$lang$Class = AugmentationTest.class$("[Ljava.lang.Class;")) : array$Ljava$lang$Class, "jdoFieldTypes");
        r[i++] = this.hasField(out, 26, array$B == null ? (array$B = AugmentationTest.class$("[B")) : array$B, "jdoFieldFlags");
        r[i++] = this.hasField(out, 26, class$java$lang$Class == null ? (class$java$lang$Class = AugmentationTest.class$("java.lang.Class")) : class$java$lang$Class, "jdoPersistenceCapableSuperclass");
        r[i++] = this.hasMethod(out, 12, Integer.TYPE, "jdoGetManagedFieldCount", new Class[0]);
        r[i++] = this.hasMethod(out, 1, class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = AugmentationTest.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable, "jdoNewInstance", new Class[]{class$javax$jdo$spi$StateManager == null ? (class$javax$jdo$spi$StateManager = AugmentationTest.class$("javax.jdo.spi.StateManager")) : class$javax$jdo$spi$StateManager});
        r[i++] = this.hasMethod(out, 1, class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = AugmentationTest.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable, "jdoNewInstance", new Class[]{class$javax$jdo$spi$StateManager == null ? (class$javax$jdo$spi$StateManager = AugmentationTest.class$("javax.jdo.spi.StateManager")) : class$javax$jdo$spi$StateManager, class$java$lang$Object == null ? (class$java$lang$Object = AugmentationTest.class$("java.lang.Object")) : class$java$lang$Object});
        r[i++] = this.hasMethod(out, 1, Void.TYPE, "jdoReplaceField", new Class[]{Integer.TYPE});
        r[i++] = this.hasMethod(out, 1, Void.TYPE, "jdoProvideField", new Class[]{Integer.TYPE});
        r[i++] = this.hasMethod(out, 1, Void.TYPE, "jdoCopyFields", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = AugmentationTest.class$("java.lang.Object")) : class$java$lang$Object, array$I == null ? (array$I = AugmentationTest.class$("[I")) : array$I});
        r[i++] = this.hasMethod(out, 20, Void.TYPE, "jdoCopyField", new Class[]{this.classClass, Integer.TYPE});
        AugmentationTest.affirm(i == 14);
        return this.evaluate(12, r);
    }

    private int hasKeyHandlingAugmentation(PrintWriter out) {
        AugmentationTest.affirm(true);
        AugmentationTest.affirm(this.classClass);
        int nofFeatures = 6;
        int[] r = new int[6];
        int i = 0;
        r[i++] = this.hasMethod(out, 1, class$java$lang$Object == null ? (class$java$lang$Object = AugmentationTest.class$("java.lang.Object")) : class$java$lang$Object, "jdoNewObjectIdInstance", new Class[0]);
        r[i++] = this.hasMethod(out, 1, class$java$lang$Object == null ? (class$java$lang$Object = AugmentationTest.class$("java.lang.Object")) : class$java$lang$Object, "jdoNewObjectIdInstance", new Class[]{class$java$lang$String == null ? (class$java$lang$String = AugmentationTest.class$("java.lang.String")) : class$java$lang$String});
        r[i++] = this.hasMethod(out, 1, Void.TYPE, "jdoCopyKeyFieldsToObjectId", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = AugmentationTest.class$("java.lang.Object")) : class$java$lang$Object});
        r[i++] = this.hasMethod(out, 1, Void.TYPE, "jdoCopyKeyFieldsToObjectId", new Class[]{class$javax$jdo$spi$PersistenceCapable$ObjectIdFieldSupplier == null ? (class$javax$jdo$spi$PersistenceCapable$ObjectIdFieldSupplier = AugmentationTest.class$("javax.jdo.spi.PersistenceCapable$ObjectIdFieldSupplier")) : class$javax$jdo$spi$PersistenceCapable$ObjectIdFieldSupplier, class$java$lang$Object == null ? (class$java$lang$Object = AugmentationTest.class$("java.lang.Object")) : class$java$lang$Object});
        r[i++] = this.hasMethod(out, 4, Void.TYPE, "jdoCopyKeyFieldsFromObjectId", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = AugmentationTest.class$("java.lang.Object")) : class$java$lang$Object});
        r[i++] = this.hasMethod(out, 1, Void.TYPE, "jdoCopyKeyFieldsFromObjectId", new Class[]{class$javax$jdo$spi$PersistenceCapable$ObjectIdFieldConsumer == null ? (class$javax$jdo$spi$PersistenceCapable$ObjectIdFieldConsumer = AugmentationTest.class$("javax.jdo.spi.PersistenceCapable$ObjectIdFieldConsumer")) : class$javax$jdo$spi$PersistenceCapable$ObjectIdFieldConsumer, class$java$lang$Object == null ? (class$java$lang$Object = AugmentationTest.class$("java.lang.Object")) : class$java$lang$Object});
        AugmentationTest.affirm(i == 6);
        return this.evaluate(6, r);
    }

    private int hasAccessorMutators(PrintWriter out) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        Field field;
        String fieldName;
        AugmentationTest.affirm(this.classClass);
        int res = 0;
        HashSet<Field> managedFields = new HashSet<Field>();
        Iterator i = new HashSet(this.methods).iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            String name = method.getName();
            if (!name.startsWith("jdoGet") && !name.startsWith("jdoSet")) continue;
            fieldName = name.substring(6);
            try {
                field = this.classClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException ex) {
                out.println("        !!! ERROR: potential jdo accessor/mutator method doesn't match declared field");
                out.println("            found method: " + method);
                this.methods.remove(method);
                res = -1;
                continue;
            }
            int fieldMods = field.getModifiers();
            if ((fieldMods & 8) != 0) {
                out.println("        !!! ERROR: potential jdo accessor/mutator method matches a static field");
                out.println("            found method: " + method);
                out.println("            found field:  " + field);
                this.methods.remove(method);
                res = -1;
                continue;
            }
            if (this.meta != null && !this.meta.isManagedField(this.classPath, fieldName)) {
                out.println("        !!! ERROR: potential jdo accessor/mutator method matches a non-managed field");
                out.println("            found method: " + method);
                out.println("            found field:  " + field);
                this.methods.remove(method);
                res = -1;
                continue;
            }
            managedFields.add(field);
        }
        String[] metaFieldNames = this.meta != null ? this.meta.getManagedFields(this.classPath) : new String[]{};
        int i2 = 0;
        while (i2 < metaFieldNames.length) {
            block19: {
                fieldName = metaFieldNames[i2];
                try {
                    field = this.classClass.getDeclaredField(fieldName);
                    this.fields.remove(field);
                }
                catch (NoSuchFieldException ex) {
                    out.println("        !!! ERROR: field defined by jdo meta-data not declared in class");
                    out.println("            no declared field: " + fieldName);
                    res = -1;
                    break block19;
                }
                int fieldMods = field.getModifiers();
                if ((fieldMods & 8) != 0) {
                    out.println("        !!! ERROR: field defined by jdo meta-data is declared static in class");
                    out.println("            static field:  " + field);
                    res = -1;
                } else {
                    managedFields.add(field);
                }
            }
            ++i2;
        }
        HashSet methodSet = new HashSet(this.methods);
        Iterator i3 = managedFields.iterator();
        while (i3.hasNext()) {
            Field field2 = (Field)i3.next();
            String fieldName2 = field2.getName();
            Class<?> fieldType = field2.getType();
            int fieldMods = field2.getModifiers();
            int mods = 8 | fieldMods & 7;
            String accessorName = "jdoGet" + fieldName2;
            Class[] accessorParams = new Class[]{this.classClass};
            Class<?> accessorReturnType = fieldType;
            String mutatorName = "jdoSet" + fieldName2;
            Class[] mutatorParams = new Class[]{this.classClass, fieldType};
            Class<Void> mutatorReturnType = Void.TYPE;
            Class[] exeptions = new Class[0];
            int r0 = this.hasMethod(out, mods, accessorReturnType, accessorName, accessorParams, exeptions);
            if (r0 < 0) {
                res = -1;
            } else if (r0 == 0) {
                out.println("        !!! ERROR: missing or incorrect jdo accessor for declared field");
                out.println("            field:  " + field2);
                out.println("            expected: " + AugmentationTest.toString(mods, accessorReturnType, accessorName, accessorParams, exeptions));
                Iterator j = methodSet.iterator();
                while (j.hasNext()) {
                    Method method = (Method)j.next();
                    if (!method.getName().equals(accessorName)) continue;
                    out.println("            found:  " + method);
                    this.methods.remove(method);
                }
                res = -1;
            }
            int r1 = this.hasMethod(out, mods, mutatorReturnType, mutatorName, mutatorParams, exeptions);
            if (r1 < 0) {
                res = -1;
            } else if (r1 == 0) {
                out.println("        !!! ERROR: missing or incorrect jdo mutator for declared field");
                out.println("            field:  " + field2);
                out.println("            expected: " + AugmentationTest.toString(mods, mutatorReturnType, mutatorName, mutatorParams, exeptions));
                Iterator j = methodSet.iterator();
                while (j.hasNext()) {
                    Method method = (Method)j.next();
                    if (!method.getName().equals(accessorName)) continue;
                    out.println("            found:  " + method);
                    this.methods.remove(method);
                }
                res = -1;
            }
            if (res != 0) continue;
            res = 1;
        }
        return res;
    }

    private int hasInstanceCallbacks(PrintWriter out) {
        AugmentationTest.affirm(true);
        AugmentationTest.affirm(this.classClass);
        int nofFeatures = 5;
        int[] r = new int[5];
        int i = 0;
        r[i++] = this.implementsInterface(out, class$javax$jdo$InstanceCallbacks == null ? (class$javax$jdo$InstanceCallbacks = AugmentationTest.class$("javax.jdo.InstanceCallbacks")) : class$javax$jdo$InstanceCallbacks);
        r[i++] = this.hasMethod(out, 1, Void.TYPE, "jdoPostLoad", new Class[0]);
        r[i++] = this.hasMethod(out, 1, Void.TYPE, "jdoPreStore", new Class[0]);
        r[i++] = this.hasMethod(out, 1, Void.TYPE, "jdoPreClear", new Class[0]);
        r[i++] = this.hasMethod(out, 1, Void.TYPE, "jdoPreDelete", new Class[0]);
        AugmentationTest.affirm(i == 5);
        return this.evaluate(1, r);
    }

    private int testPCFeasibility(PrintWriter out) {
        AugmentationTest.affirm(this.classClass);
        int status = 1;
        int mods = this.classClass.getModifiers();
        StringWriter s = new StringWriter();
        int hasCtor = this.hasConstructor(new PrintWriter(s), 0, new Class[0]);
        if (hasCtor <= 0) {
            status = -1;
        } else if (this.verbose) {
            out.print(s.toString());
        }
        if (this.classClass.isInterface()) {
            out.println("        !!! ERROR: class is interface");
            status = -1;
        } else if (this.verbose) {
            out.println("        +++ is not an interface");
        }
        if (this.classClass.getDeclaringClass() != null && !Modifier.isStatic(mods)) {
            out.println("        !!! ERROR: class is inner class");
            status = -1;
        } else if (this.verbose) {
            out.println("        +++ is not an inner class");
        }
        int i = 0;
        while (i < transientPrefixes.length) {
            String typePrefix = transientPrefixes[i];
            if (this.className.startsWith(typePrefix)) {
                out.println("        !!! ERROR: class is in package: " + typePrefix + "..");
                status = -1;
            } else if (this.verbose) {
                out.println("        +++ is not in package: " + typePrefix + "..");
            }
            ++i;
        }
        if (this.classClass.isPrimitive()) {
            out.println("        !!! ERROR: class is of primitive type");
            status = -1;
        }
        if (this.classClass.isArray()) {
            out.println("        !!! ERROR: class is of array type");
            status = -1;
        }
        if (this.classClass.getSuperclass() == null) {
            out.println("        !!! ERROR: class doesn't have super class");
            status = -1;
        }
        return status;
    }

    private int hasNoIllegalJdoMembers(PrintWriter out) {
        AugmentationTest.affirm(this.classClass);
        int res = 1;
        Iterator i = new HashSet(this.methods).iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            String name = method.getName();
            if (!name.startsWith("jdo")) continue;
            out.println("        !!! ERROR: illegal jdo method");
            out.println("            found method: " + method);
            this.methods.remove(method);
            res = -1;
        }
        Iterator i2 = new HashSet(this.fields).iterator();
        while (i2.hasNext()) {
            Field field = (Field)i2.next();
            String name = field.getName();
            if (!name.startsWith("jdo")) continue;
            out.println("        !!! ERROR: illegal jdo field");
            out.println("            found field: " + field);
            this.fields.remove(field);
            res = -1;
        }
        return res;
    }

    private int testAugmentation(PrintWriter out) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        AugmentationTest.affirm(true);
        AugmentationTest.affirm(this.classClass);
        AugmentationTest.affirm(this.className);
        StringWriter s = new StringWriter();
        int r0 = this.hasSpecificAugmentation(new PrintWriter(s));
        if (r0 < 0) {
            out.println("    !!! ERROR: inconsistent \"class-specific\" augmentation");
            out.println(s.toString());
            r0 = -1;
        } else if (r0 == 0) {
            if (this.meta != null && this.meta.isPersistenceCapableClass(this.classPath)) {
                out.println("    !!! ERROR: missing \"class-specific\" augmentation");
                out.println(s.toString());
                r0 = -1;
            } else if (this.verbose) {
                out.println("    --- no \"class-specific\" augmentation");
                out.println(s.toString());
            }
        } else {
            AugmentationTest.affirm(r0 > 0);
            if (this.meta != null && !this.meta.isPersistenceCapableClass(this.classPath)) {
                out.println("    !!! ERROR: unexpected \"class-specific\" augmentation");
                out.println(s.toString());
                r0 = -1;
            } else if (this.verbose) {
                out.println("    +++ has correct \"class-specific\" augmentation");
                out.println(s.toString());
            }
        }
        s = new StringWriter();
        int r1 = this.hasKeyHandlingAugmentation(new PrintWriter(s));
        if (r1 < 0) {
            out.println("    !!! ERROR: inconsistent \"key-handling\" augmentation");
            out.println(s.toString());
            r1 = -1;
        } else if (r1 == 0) {
            if (this.meta != null && this.meta.isPersistenceCapableClass(this.classPath) && this.meta.getKeyClass(this.classPath) != null) {
                out.println("    !!! ERROR: missing \"key-handling\" augmentation");
                out.println(s.toString());
                r1 = -1;
            } else if (this.verbose) {
                out.println("    --- no \"key-handling\" augmentation");
                out.println(s.toString());
            }
        } else {
            AugmentationTest.affirm(r1 > 0);
            if (r0 == 0 || this.meta != null && !this.meta.isPersistenceCapableRootClass(this.classPath) && this.meta.getKeyClass(this.classPath) == null) {
                out.println("    !!! ERROR: unexpected \"key-handling\" augmentation");
                out.println(s.toString());
                r1 = -1;
            } else if (this.verbose) {
                out.println("    +++ has correct \"key-handling\" augmentation");
                out.println(s.toString());
            }
        }
        AugmentationTest.affirm(r0 != 0 || r1 <= 0);
        s = new StringWriter();
        int r2 = this.hasGenericAugmentation(new PrintWriter(s));
        if (r2 < 0) {
            out.println("    !!! ERROR: inconsistent \"generic\" augmentation");
            out.println(s.toString());
            r2 = -1;
        } else if (r2 == 0) {
            if (this.meta != null && this.meta.isPersistenceCapableRootClass(this.classPath)) {
                out.println("    !!! ERROR: missing \"generic\" augmentation");
                out.println(s.toString());
                r2 = -1;
            } else if (this.verbose) {
                out.println("    --- no \"generic\" augmentation");
                out.println(s.toString());
            }
        } else {
            AugmentationTest.affirm(r2 > 0);
            if (r0 == 0 || this.meta != null && !this.meta.isPersistenceCapableRootClass(this.classPath)) {
                out.println("    !!! ERROR: unexpected \"generic\" augmentation");
                out.println(s.toString());
                r2 = -1;
            } else if (this.verbose) {
                out.println("    +++ has correct \"generic\" augmentation");
                out.println(s.toString());
            }
        }
        AugmentationTest.affirm(r0 != 0 || r2 <= 0);
        s = new StringWriter();
        int r3 = this.hasAccessorMutators(new PrintWriter(s));
        if (r3 < 0) {
            out.println("    !!! ERROR: inconsistent \"accessor/mutator\" augmentation");
            out.println(s.toString());
        } else if (r3 == 0) {
            if (this.verbose) {
                out.println("    --- no \"accessor/mutator\" augmentation");
                out.println(s.toString());
            }
        } else {
            AugmentationTest.affirm(r3 > 0);
            if (r0 == 0) {
                out.println("    !!! ERROR: unexpected \"accessor/mutator\" augmentation");
                out.println(s.toString());
                r3 = -1;
            } else if (this.verbose) {
                out.println("    +++ has correct \"accessor/mutator\" augmentation");
                out.println(s.toString());
            }
        }
        AugmentationTest.affirm(r0 != 0 || r3 <= 0);
        s = new StringWriter();
        int r4 = this.hasInstanceCallbacks(new PrintWriter(s));
        if (r4 < 0) {
            out.println("    !!! ERROR: inconsistent instance callback features");
            out.println(s.toString());
        } else if (r4 == 0) {
            if (this.verbose) {
                out.println("    --- no instance callback features");
                out.println(s.toString());
            }
        } else {
            AugmentationTest.affirm(r4 > 0);
            if (this.verbose) {
                out.println("    +++ has instance callback features");
                out.println(s.toString());
            }
        }
        s = new StringWriter();
        int r5 = this.hasNoIllegalJdoMembers(new PrintWriter(s));
        if (r5 <= 0) {
            out.println("    !!! ERROR: illegal jdo member");
            out.println(s.toString());
        } else if (this.verbose) {
            out.println("    +++ no illegal jdo member");
            out.println(s.toString());
        }
        if (r0 < 0 || r1 < 0 || r2 < 0 || r3 < 0 || r4 < 0 || r5 < 0) {
            return -1;
        }
        if (r0 == 0) {
            AugmentationTest.affirm(r1 == 0);
            AugmentationTest.affirm(r2 == 0);
            AugmentationTest.affirm(r3 == 0);
            AugmentationTest.affirm(r4 >= 0);
            AugmentationTest.affirm(r5 > 0);
            return 0;
        }
        s = new StringWriter();
        int r6 = this.testPCFeasibility(new PrintWriter(s));
        if (r6 <= 0) {
            out.println("    !!! not feasible for persistence-capability");
            out.println(s.toString());
            r6 = -1;
        } else if (this.verbose) {
            out.println("    +++ is feasible for persistence-capability");
            out.println(s.toString());
        }
        if (r6 < 0) {
            return -1;
        }
        return 1;
    }

    private int testLoadingClass(PrintWriter out) {
        try {
            this.classClass = Class.forName(this.className);
            out.println("    +++ loaded class");
        }
        catch (LinkageError err) {
            out.println("    !!! ERROR: linkage error when loading class: " + this.className);
            out.println("        error: " + err);
            return -1;
        }
        catch (ClassNotFoundException ex) {
            out.println("    !!! ERROR: class not found: " + this.className);
            out.println("        exception: " + ex);
            return -1;
        }
        try {
            this.fields = new HashSet();
            this.fields.addAll(Arrays.asList(this.classClass.getDeclaredFields()));
            this.methods = new HashSet();
            this.methods.addAll(Arrays.asList(this.classClass.getDeclaredMethods()));
        }
        catch (SecurityException ex) {
            AugmentationTest.affirm(false);
            return -1;
        }
        return 1;
    }

    private int test(PrintWriter out, String className) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        int r;
        StringWriter s;
        AugmentationTest.affirm(className);
        this.className = className;
        this.classPath = className.replace('.', '/');
        if (this.verbose) {
            out.println("-------------------------------------------------------------------------------");
            out.println();
            out.println("Test class for augmentation: " + className + " ...");
        }
        if (this.testLoadingClass(new PrintWriter(s = new StringWriter())) <= 0) {
            out.println();
            out.println("!!! ERROR: failed loading class: " + className);
            out.println(s.toString());
            return -1;
        }
        if (this.verbose) {
            out.println();
            out.println("+++ loaded class: " + className);
            out.println(s.toString());
        }
        if ((r = this.testAugmentation(new PrintWriter(s = new StringWriter()))) < 0) {
            out.println();
            out.println("!!! ERROR: incorrect augmentation: " + className);
            out.println(s.toString());
            return -1;
        }
        if (r == 0) {
            out.println();
            out.println("--- class not augmented: " + className);
        } else {
            out.println();
            out.println("+++ class augmented: " + className);
        }
        if (this.verbose) {
            out.println(s.toString());
        }
        return r;
    }

    public int test(PrintWriter out, boolean verbose, List classes) {
        AugmentationTest.affirm(classes);
        this.verbose = verbose;
        int all = classes.size();
        out.println();
        out.println("AugmentationTest: Testing Classes for JDO Persistence-Capability Enhancement");
        int nofFailed = 0;
        int i = 0;
        while (i < all) {
            if (this.test(out, (String)classes.get(i)) < 0) {
                ++nofFailed;
            }
            ++i;
        }
        int nofPassed = all - nofFailed;
        out.println();
        out.println("AugmentationTest: Summary:  TESTED: " + all + "  PASSED: " + nofPassed + "  FAILED: " + nofFailed);
        return nofFailed;
    }

    private static void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                err.println("Exception caught: " + ex);
            }
        }
    }

    private static void usage() {
        err.println();
        err.println("Usage: AugmentationTest <options> <classes>...");
        err.println();
        err.println("This class tests if classes have been correctly enhanced");
        err.println("for persistence-capability (\"augmented\").");
        err.println();
        err.println("Options include:");
        err.println("    -h, --help               print usage");
        err.println("    -v, --verbose            enable verbose output");
        err.println("        --properties <file>  use property file for JDO meta data");
        err.println();
        err.println("Return value:");
        err.println("= 0   no errors");
        err.println("> 0   number of classes failing the test");
        err.println("< 0   severe errors preventing the test to complete");
        err.println();
    }

    public static void main(String[] argv) {
        boolean verbose = false;
        String jdoModelFileName = null;
        String jdoPropertiesFileName = null;
        ArrayList<String> classes = new ArrayList<String>();
        int i = 0;
        while (i < argv.length) {
            String arg = argv[i];
            if (arg.equals("-h") || arg.equals("--help")) {
                AugmentationTest.usage();
                System.exit(0);
            }
            if (arg.equals("-v") || arg.equals("--verbose")) {
                verbose = true;
            } else if (arg.equals("--properties")) {
                if (argv.length - i < 2) {
                    String msg = "Missing argument to the --properties option";
                    err.println("Missing argument to the --properties option");
                    AugmentationTest.usage();
                    System.exit(-1);
                }
                jdoPropertiesFileName = argv[++i];
            } else if (arg.equals("-d") || arg.equals("--debug")) {
                debug = true;
            } else {
                if (arg.startsWith("-")) {
                    err.println();
                    err.println("Unrecognized option: " + arg);
                    AugmentationTest.usage();
                    System.exit(-1);
                }
                classes.add(arg);
            }
            ++i;
        }
        if (classes.isEmpty()) {
            err.println();
            err.println("Missing classes argument.");
            AugmentationTest.usage();
            System.exit(-1);
            return;
        }
        if (jdoModelFileName != null && jdoPropertiesFileName != null) {
            err.println();
            err.println("More than one meta-data source specified");
            AugmentationTest.usage();
        }
        if (debug) {
            out.println("AugmentationTest: options:");
            out.println("    verbose = " + verbose);
            out.println("    jdoModelFileName = " + jdoModelFileName);
            out.println("    jdoPropertiesFileName = " + jdoPropertiesFileName);
            out.print("    classes =");
            int i2 = 0;
            while (i2 < classes.size()) {
                out.print(" " + classes.get(i2));
                ++i2;
            }
            out.println();
        }
        EnhancerMetaDataBaseModel jdoMetaData = null;
        if (jdoPropertiesFileName != null) {
            try {
                jdoMetaData = new EnhancerMetaDataPropertyImpl(out, verbose, jdoPropertiesFileName);
            }
            catch (EnhancerMetaDataFatalError ex) {
                err.println("Cannot read meta-data properties file;");
                err.println("Exception caught:" + ex);
                System.exit(-2);
            }
            if (verbose) {
                out.println("AugmentationTest: using meta-data from properties file: " + jdoPropertiesFileName);
            }
        } else if (jdoModelFileName != null) {
            try {
                AugmentationTest.affirm(false);
                jdoMetaData = new EnhancerMetaDataJDOModelImpl(out, verbose, null, null, null);
            }
            catch (EnhancerMetaDataFatalError ex) {
                err.println("Cannot read JDO XML meta-data file");
                err.println("Exception caught:" + ex);
                System.exit(-2);
            }
            if (verbose) {
                out.println("AugmentationTest: using meta-data from JDO model file: " + jdoModelFileName);
            }
        } else if (verbose) {
            out.println("AugmentationTest: using no JDO meta-data");
        }
        try {
            AugmentationTest test = new AugmentationTest(jdoMetaData);
            int res = test.test(out, verbose, classes);
            System.exit(res);
        }
        catch (EnhancerMetaDataUserException ex) {
            err.println("Problem with reading JDO meta-data;");
            err.println("Exception caught:" + ex);
            ex.printStackTrace(err);
            System.exit(-2);
        }
        catch (EnhancerMetaDataFatalError ex) {
            err.println("Problem with reading JDO meta-data;");
            err.println("Exception caught:" + ex);
            ex.printStackTrace(err);
            System.exit(-2);
        }
        catch (RuntimeException ex) {
            err.println("Internal error;");
            err.println("Exception caught:" + ex);
            ex.printStackTrace(err);
            System.exit(-3);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

