/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.meta.prop;

import com.sap.jdo.enhancer.meta.prop.JDOField;
import com.sap.jdo.enhancer.meta.prop.NameHelper;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class JDOClass {
    private final String name;
    private String superClassName = null;
    private String oidClassName = null;
    private int modifiers = 1;
    private boolean isPersistent = true;
    private final List fields = new ArrayList();
    private String[] managedFieldNames = null;
    private String[] fieldNames = null;

    JDOClass(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setSuperClassName(String classname) {
        this.superClassName = NameHelper.fromCanonicalClassName(classname);
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setOidClassName(String classname) {
        this.oidClassName = NameHelper.fromCanonicalClassName(classname);
    }

    public String getOidClassName() {
        return this.oidClassName;
    }

    public void setPersistent(boolean persistent) {
        this.isPersistent = persistent;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public boolean isTransient() {
        return !this.isPersistent();
    }

    public void addField(JDOField field) {
        this.fields.add(field);
    }

    public JDOField getField(String name) {
        int idx = this.getIndexOfField(name);
        return idx > -1 ? (JDOField)this.fields.get(idx) : null;
    }

    public int getIndexOfField(String name) {
        int i = 0;
        while (i < this.fields.size()) {
            JDOField field = (JDOField)this.fields.get(i);
            if (field.getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List getFields() {
        return this.fields;
    }

    public String[] getFieldNames() {
        if (this.fieldNames == null) {
            int n = this.fields.size();
            String[] fields = new String[n];
            int i = 0;
            while (i < n) {
                fields[i] = ((JDOField)this.fields.get(i)).getName();
                ++i;
            }
            this.fieldNames = fields;
        }
        return this.fieldNames;
    }

    final void sortFields() {
        Collections.sort(this.fields, new Comparator(){

            public int compare(Object f1, Object f2) {
                JDOField field1 = (JDOField)f1;
                JDOField field2 = (JDOField)f2;
                if (!field1.isManaged() || !field2.isManaged()) {
                    return field1.isManaged() ? -1 : 1;
                }
                return field1.getName().compareTo(field2.getName());
            }
        });
    }

    public String[] getManagedFieldNames() {
        if (this.managedFieldNames == null) {
            int n = this.fields.size();
            ArrayList<String> tmp = new ArrayList<String>(n);
            int i = 0;
            while (i < n) {
                JDOField field = (JDOField)this.fields.get(i);
                if (field.isManaged()) {
                    tmp.add(field.getName());
                }
                ++i;
            }
            this.managedFieldNames = tmp.toArray(new String[tmp.size()]);
        }
        return this.managedFieldNames;
    }

    public String toString() {
        return "<super:" + this.superClassName + "oid" + ':' + this.oidClassName + ',' + "access" + ':' + Modifier.toString(this.modifiers) + ',' + "jdo" + ':' + this.isPersistent + ',' + "fields:" + this.fields + '>';
    }
}

