/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.meta.model;

import com.sap.jdo.common.model.jdo.JDOModelFactoryImpl;
import com.sap.jdo.common.model.jdo.util.TypeSupport;
import com.sap.jdo.enhancer.meta.EnhancerMetaData;
import com.sap.jdo.enhancer.meta.EnhancerMetaDataFatalError;
import com.sap.jdo.enhancer.meta.EnhancerMetaDataUserException;
import com.sap.jdo.enhancer.meta.model.EnhancerJavaModel;
import com.sap.jdo.enhancer.meta.util.EnhancerMetaDataBaseModel;
import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.CombinedResourceLocator;
import com.sap.jdo.enhancer.util.ListResourceLocator;
import com.sap.jdo.enhancer.util.PathResourceLocator;
import com.sap.jdo.enhancer.util.ResourceLocatorBase;
import com.sap.jdo.enhancer.util.Support;
import com.sap.jdo.model.jdo.JDOClass;
import com.sap.jdo.model.jdo.JDOField;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.model.jdo.JDOModelFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EnhancerMetaDataJDOModelImpl
extends EnhancerMetaDataBaseModel
implements EnhancerMetaData {
    private final JDOModel model;

    private EnhancerMetaDataJDOModelImpl(PrintWriter out, boolean verbose) throws EnhancerMetaDataFatalError {
        super(out, verbose);
        try {
            JDOModelFactory factory = JDOModelFactoryImpl.getInstance();
            Assertion.affirm(factory != null);
            this.model = factory.createJDOModel();
        }
        catch (JDOModelException ex) {
            String msg = Support.getI18N("enhancer.metadata.jdomodel_error", ex.getMessage());
            throw new EnhancerMetaDataFatalError(msg, ex);
        }
        Assertion.affirm(this.model != null);
    }

    public EnhancerMetaDataJDOModelImpl(PrintWriter out, boolean verbose, List jdoFileNames, List jarFileNames, String sourcePath) throws EnhancerMetaDataFatalError {
        this(out, verbose);
        try {
            Iterator i;
            StringBuffer s;
            ArrayList<ResourceLocatorBase> locators = new ArrayList<ResourceLocatorBase>();
            if (jdoFileNames != null && !jdoFileNames.isEmpty()) {
                s = new StringBuffer();
                i = jdoFileNames.iterator();
                while (i.hasNext()) {
                    s.append(" " + i.next());
                }
                ListResourceLocator jdos = new ListResourceLocator(out, verbose, jdoFileNames);
                locators.add(jdos);
            }
            if (jarFileNames != null && !jarFileNames.isEmpty()) {
                s = new StringBuffer();
                i = jarFileNames.iterator();
                s.append(i.next());
                while (i.hasNext()) {
                    s.append(File.pathSeparator + i.next());
                }
                PathResourceLocator jars = new PathResourceLocator(out, verbose, s.toString());
                locators.add(jars);
            }
            if (sourcePath != null && sourcePath.length() > 0) {
                PathResourceLocator path = new PathResourceLocator(out, verbose, sourcePath);
                locators.add(path);
            }
            if (locators.isEmpty()) {
                this.printWarning(Support.getI18N("enhancer.metadata.using_no_metadata"));
            }
            CombinedResourceLocator locator = new CombinedResourceLocator(out, verbose, locators);
            this.model.setJavaModel(new EnhancerJavaModel(out, verbose, locator));
        }
        catch (IOException ex) {
            String msg = Support.getI18N("enhancer.metadata.io_error", ex.getMessage());
            throw new EnhancerMetaDataFatalError(msg, ex);
        }
    }

    private JDOClass getJDOClass(String classPath) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        try {
            String className = classPath.replace('/', '.');
            JDOClass clazz = this.model.getJDOClass(className);
            return clazz;
        }
        catch (JDOModelException ex) {
            throw new EnhancerMetaDataUserException(ex);
        }
    }

    private JDOField getJDOField(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOClass clazz = this.getJDOClass(classPath);
        if (clazz == null) {
            return null;
        }
        JDOField field = clazz.getDeclaredField(fieldName);
        Assertion.affirm(field == null || field.getDeclaringClass() == clazz, "field not declared in class: " + classPath + "." + fieldName);
        return field;
    }

    private boolean hasFieldModifier(String classPath, String fieldName, int fieldModifier) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOField field = this.getJDOField(classPath, fieldName);
        if (field == null) {
            return false;
        }
        int pm = field.getPersistenceModifier();
        Assertion.affirm(pm != 0, "field modifier 'UNSPECIFIED': " + classPath + "." + fieldName);
        return (pm & fieldModifier) != 0;
    }

    public void declareField(String classPath, String fieldName, String fieldSig) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        Assertion.affirm(classPath);
        Assertion.affirm(fieldName);
        Assertion.affirm(fieldSig);
        JDOClass clazz = this.getJDOClass(classPath);
        Assertion.affirm(clazz != null, "class is not persistence-capable: " + classPath);
        JDOField field = clazz.getDeclaredField(fieldName);
        try {
            if (field == null && TypeSupport.isPersistenceFieldType(this.model, fieldSig)) {
                field = clazz.createJDOField(fieldName);
                Assertion.affirm(field != null, "cannot create JDO field: " + classPath + "." + fieldName);
                Assertion.affirm(field.getPersistenceModifier() == 0, "unknown, specified JDO field: " + classPath + "." + fieldName);
            }
            field.setType(fieldSig);
            Assertion.affirm(fieldSig == field.getType());
        }
        catch (JDOModelException ex) {
            throw new EnhancerMetaDataUserException(ex);
        }
        Assertion.affirm(field.getPersistenceModifier() != 0, "known, unspecified JDO field: " + classPath + "." + fieldName);
    }

    public void passTypeInformation(String classPath, String fieldName, String fieldSig) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        Assertion.affirm(classPath);
        Assertion.affirm(fieldName);
        Assertion.affirm(fieldSig);
        JDOClass clazz = this.getJDOClass(classPath);
        Assertion.affirm(clazz != null, "class is not persistence-capable: " + classPath);
        JDOField field = clazz.getDeclaredField(fieldName);
        if (field != null) {
            try {
                field.setType(fieldSig);
            }
            catch (JDOModelException ex) {
                throw new EnhancerMetaDataUserException(ex);
            }
            Assertion.affirm(fieldSig == field.getType());
        }
    }

    public boolean isPersistenceCapableClass(String classPath) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOClass clazz = this.getJDOClass(classPath);
        return clazz != null;
    }

    public String getPersistenceCapableSuperClass(String classPath) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOClass clazz = this.getJDOClass(classPath);
        if (clazz == null) {
            return null;
        }
        String name = clazz.getPersistenceCapableSuperclassName();
        return name != null ? name.replace('.', '/') : null;
    }

    public String getKeyClass(String classPath) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOClass clazz = this.getJDOClass(classPath);
        if (clazz == null) {
            return null;
        }
        String name = clazz.getObjectIdClassName();
        return name != null ? name.replace('.', '/') : null;
    }

    public String[] getManagedFields(String classPath) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOClass clazz = this.getJDOClass(classPath);
        if (clazz == null) {
            return new String[0];
        }
        JDOField[] fields = clazz.getDeclaredManagedFields();
        if (fields == null) {
            return new String[0];
        }
        Assertion.affirm(fields.length == clazz.getDeclaredManagedFieldCount());
        int n = fields.length;
        String[] names = new String[n];
        int i = 0;
        while (i < n) {
            Assertion.affirm(fields[i] != null);
            Assertion.affirm(fields[i].getRelativeFieldNumber() == i);
            Assertion.affirm(fields[i].isManaged());
            names[i] = fields[i].getName();
            Assertion.affirm(names[i] != null);
            ++i;
        }
        return names;
    }

    public boolean isKnownNonManagedField(String classPath, String fieldName, String fieldSig) {
        Assertion.affirm(classPath);
        Assertion.affirm(fieldName);
        Assertion.affirm(fieldSig);
        JDOClass clazz = this.getJDOClass(classPath);
        if (clazz == null) {
            return true;
        }
        JDOField field = clazz.getDeclaredField(fieldName);
        if (field != null && field.getPersistenceModifier() != 0) {
            return !field.isManaged();
        }
        return !TypeSupport.isPersistenceFieldType(this.model, fieldSig);
    }

    public boolean isManagedField(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        return this.hasFieldModifier(classPath, fieldName, 14);
    }

    public boolean isPersistentField(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        return this.hasFieldModifier(classPath, fieldName, 12);
    }

    public boolean isTransactionalField(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        return this.hasFieldModifier(classPath, fieldName, 2);
    }

    public boolean isKeyField(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOField field = this.getJDOField(classPath, fieldName);
        if (field == null) {
            return false;
        }
        return field.isPrimaryKey();
    }

    public boolean isDefaultFetchGroupField(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOField field = this.getJDOField(classPath, fieldName);
        if (field == null) {
            return false;
        }
        return field.isDefaultFetchGroup();
    }

    public int getFieldNumber(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOField field = this.getJDOField(classPath, fieldName);
        if (field == null) {
            return -1;
        }
        return field.getRelativeFieldNumber();
    }
}

