/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.generator;

import com.sap.jdo.enhancer.generator.CodeWriter;
import com.sap.jdo.enhancer.generator.ImplHelper;
import com.sap.jdo.enhancer.generator.NameHelper;
import com.sap.jdo.enhancer.meta.ExtendedMetaData;
import com.sap.jdo.enhancer.meta.prop.EnhancerMetaDataPropertyImpl;
import com.sap.jdo.enhancer.util.Assertion;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class Main
extends Assertion {
    private final PrintWriter out = new PrintWriter(System.out, true);
    private final PrintWriter err = new PrintWriter(System.err, true);
    private final CmdLineOptions opts = new CmdLineOptions();
    private final CodeWriter writer = new CodeWriter();
    private ExtendedMetaData meta = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$io$IOException;
    static /* synthetic */ Class class$java$io$Serializable;

    public static final void main(String[] argv) {
        Main gen = new Main();
        try {
            gen.opts.processArgs(argv);
            gen.init();
            gen.generate();
        }
        catch (Exception ex) {
            gen.printError(null, ex);
        }
    }

    private void init() throws FileNotFoundException, IOException {
        Assertion.affirm(this.opts.jdoPropertiesFileName != null);
        this.meta = new EnhancerMetaDataPropertyImpl(this.out, this.opts.verbose, this.opts.jdoPropertiesFileName);
        Assertion.affirm(this.opts.destinationDirectory != null);
        File destinationDir = new File(this.opts.destinationDirectory);
        boolean res = destinationDir.mkdirs();
        if (!res) {
            throw new IOException("unable to create destination directory: '" + destinationDir + "'");
        }
    }

    private void generate() {
        String[] classes = this.meta.getKnownClasses();
        int i = 0;
        while (i < classes.length) {
            String classname = classes[i];
            try {
                Writer writer = this.createFileWriter(classname);
                this.writer.setWriter(writer);
                this.generateClass(classname);
                writer.close();
            }
            catch (IOException ex) {
                this.printError("Error generating class '" + classname + "'.", ex);
            }
            ++i;
        }
    }

    private void generateClass(String classname) throws IOException {
        Assertion.affirm(classname);
        String normClassName = NameHelper.normalizeClassName(classname);
        this.printMessage("generating '" + normClassName + "'...");
        String packageName = NameHelper.getPackageName(classname);
        this.writer.writePackage(packageName, null);
        this.writer.writeImports(null, null);
        String oidClassName = this.meta.getKeyClass(classname);
        if (oidClassName == null) {
            this.writeClassHeader(classname);
        } else {
            String oidPackageName = NameHelper.getPackageName(oidClassName);
            Assertion.affirm(packageName.equals(oidPackageName), "PC class and key class must be in same package.");
            boolean enclosedOid = oidClassName.startsWith(classname + "$");
            if (enclosedOid) {
                this.writeClassHeader(classname);
                this.writeOidClass(classname, oidClassName, enclosedOid);
            } else {
                this.writeOidClass(classname, oidClassName, enclosedOid);
                this.writeClassHeader(classname);
            }
        }
        this.writeClassMembers(classname);
        boolean isPC = this.meta.isPersistenceCapableClass(classname);
        if (isPC) {
            boolean isPCRoot = this.meta.isPersistenceCapableRootClass(classname);
            if (isPCRoot) {
                this.writePCRootMembers(classname);
            }
            this.writePCMembers(classname);
            this.writeClassMemberAccessors(classname);
        }
        this.writer.writeClassEnd();
    }

    private Writer createFileWriter(String classname) throws IOException {
        File file = new File(this.opts.destinationDirectory, classname + ".java");
        file.getAbsoluteFile().getParentFile().mkdirs();
        return new BufferedWriter(new FileWriter(file));
    }

    private void writeClassHeader(String classname) throws IOException {
        boolean isPCRoot = this.meta.isPersistenceCapableRootClass(classname);
        String superclass = this.meta.getSuperClass(classname);
        String[] interfaces = null;
        String[] comments = null;
        if (isPCRoot) {
            interfaces = new String[]{"javax.jdo.spi.PersistenceCapable"};
        }
        this.writer.writeClassHeader(this.meta.getClassModifiers(classname), NameHelper.getClassName(classname), superclass, interfaces, comments);
    }

    private void writeClassMembers(String classname) throws IOException {
        this.writer.writeComments(1, new String[]{"----------------------------------------------------------------------", "Class Members:", "----------------------------------------------------------------------"});
        this.writer.writeln();
        this.writer.writeConstructor(NameHelper.getClassName(classname), 1, null, null, null, ImplHelper.getDefaultConstructorImpl(), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        this.writer.writeConstructor(NameHelper.getClassName(classname), 1, new String[]{"str"}, new String[]{"String"}, null, ImplHelper.getDummyConstructorImpl(), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        String[] fieldnames = this.meta.getKnownFields(classname);
        int n = fieldnames != null ? fieldnames.length : 0;
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < n) {
            String fieldname = fieldnames[i];
            int access = this.meta.getFieldModifiers(classname, fieldname);
            if ((access & 8) == 0) {
                list.add(fieldname);
            }
            ++i;
        }
        String[] instanceFieldnames = list.toArray(new String[0]);
        this.writer.writeMethod("clone", 1, "Object", null, null, new String[]{"java.lang.CloneNotSupportedException"}, ImplHelper.getCloneImpl(classname, instanceFieldnames), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        int i2 = 0;
        while (i2 < n) {
            String fieldname = fieldnames[i2];
            this.writeFieldMember(classname, fieldname);
            ++i2;
        }
    }

    private void writeFieldMember(String classname, String fieldname) throws IOException {
        String fieldtype = this.meta.getFieldType(classname, fieldname);
        int access = this.meta.getFieldModifiers(classname, fieldname);
        ArrayList<String> impl = new ArrayList<String>();
        this.writer.writeField(fieldname, access, fieldtype, null, null);
        if ((access & 8) != 0) {
            return;
        }
        impl.clear();
        impl.add("return this." + fieldname + ';');
        this.writer.writeMethod(Main.createMethodName("get", fieldname), 1, fieldtype, null, null, null, impl, ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        impl.clear();
        impl.add("this." + fieldname + " = " + fieldname + ';');
        this.writer.writeMethod(Main.createMethodName("set", fieldname), 1, "void", new String[]{fieldname}, new String[]{fieldtype}, null, impl, ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
    }

    private void writeClassMemberAccessors(String classname) throws IOException {
        this.writer.writeComments(1, new String[]{"----------------------------------------------------------------------", "Augmentation for Field Accessors and Mutators (added by enhancer):", "----------------------------------------------------------------------"});
        this.writer.writeln();
        String[] fields = this.meta.getManagedFields(classname);
        int n = fields != null ? fields.length : 0;
        int i = 0;
        while (i < n) {
            String fieldname = fields[i];
            this.writeFieldAccessors(classname, fieldname);
            ++i;
        }
    }

    private void writeFieldAccessors(String classname, String fieldname) throws IOException {
        String fieldtype = this.meta.getFieldType(classname, fieldname);
        int fieldnumber = this.meta.getFieldNumber(classname, fieldname);
        boolean dfg = this.meta.isDefaultFetchGroupField(classname, fieldname);
        int access = this.meta.getFieldModifiers(classname, fieldname);
        int flags = this.meta.getFieldFlags(classname, fieldname);
        String accessor = ImplHelper.createJDOFieldAccessorName(classname, fieldname);
        String mutator = ImplHelper.createJDOFieldMutatorName(classname, fieldname);
        String instancename = "instance";
        Assertion.affirm((flags & 1) == 0 | (flags & 2) == 0);
        List impl = (flags & 1) != 0 ? ImplHelper.getJDOFieldCheckReadImpl(fieldname, fieldtype, fieldnumber, "instance") : ((flags & 2) != 0 ? ImplHelper.getJDOFieldMediateReadImpl(fieldname, fieldtype, fieldnumber, "instance") : ImplHelper.getJDOFieldDirectReadImpl(fieldname, fieldtype, fieldnumber, "instance"));
        this.writer.writeMethod(accessor, access | 8 | 0x10, fieldtype, new String[]{"instance"}, new String[]{classname}, null, impl, ImplHelper.COMMENT_ENHANCER_ADDED);
        Assertion.affirm((flags & 4) == 0 | (flags & 8) == 0);
        impl = (flags & 4) != 0 ? ImplHelper.getJDOFieldCheckWriteImpl(fieldname, fieldtype, fieldnumber, "instance", fieldname) : ((flags & 8) != 0 ? ImplHelper.getJDOFieldMediateWriteImpl(fieldname, fieldtype, fieldnumber, "instance", fieldname) : ImplHelper.getJDOFieldDirectWriteImpl(fieldname, fieldtype, fieldnumber, "instance", fieldname));
        this.writer.writeMethod(mutator, access | 8 | 0x10, "void", new String[]{"instance", fieldname}, new String[]{classname, fieldtype}, null, impl, ImplHelper.COMMENT_ENHANCER_ADDED);
    }

    private void writePCRootMembers(String classname) throws IOException {
        this.writer.writeComments(1, new String[]{"----------------------------------------------------------------------", "Augmentation for Persistence-Capable Root Classes (added by enhancer):", "----------------------------------------------------------------------"});
        this.writer.writeln();
        this.writer.writeField("jdoStateManager", 132, "javax.jdo.spi.StateManager", "null", ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeField("jdoFlags", 132, "byte", "0", ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoReplaceStateManager", 49, "void", new String[]{"sm"}, new String[]{"javax.jdo.spi.StateManager"}, null, ImplHelper.getJDOReplaceStateManagerImpl("sm"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoReplaceFlags", 17, "void", null, null, null, ImplHelper.getJDOReplaceFlagsImpl(), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoGetPersistenceManager", 17, "javax.jdo.PersistenceManager", null, null, null, ImplHelper.getJDOStateManagerObjectDelegationImpl("getPersistenceManager(this)"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoGetObjectId", 17, (class$java$lang$Object == null ? (class$java$lang$Object = Main.class$("java.lang.Object")) : class$java$lang$Object).getName(), null, null, null, ImplHelper.getJDOStateManagerObjectDelegationImpl("getObjectId(this)"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoGetTransactionalObjectId", 17, (class$java$lang$Object == null ? (class$java$lang$Object = Main.class$("java.lang.Object")) : class$java$lang$Object).getName(), null, null, null, ImplHelper.getJDOStateManagerObjectDelegationImpl("getTransactionalObjectId(this)"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoIsPersistent", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isPersistent(this)"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoIsTransactional", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isTransactional(this)"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoIsNew", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isNew(this)"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoIsDeleted", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isDeleted(this)"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoIsDirty", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isDirty(this)"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoMakeDirty", 17, "void", new String[]{"fieldname"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = Main.class$("java.lang.String")) : class$java$lang$String).getName()}, null, ImplHelper.getJDOStateManagerVoidDelegationImpl("makeDirty(this, fieldname)"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoReplaceFields", 17, "void", new String[]{"fieldnumbers"}, new String[]{"int[]"}, null, ImplHelper.getJDOFieldIterationImpl("fieldnumbers", "jdoReplaceField"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoProvideFields", 17, "void", new String[]{"fieldnumbers"}, new String[]{"int[]"}, null, ImplHelper.getJDOFieldIterationImpl("fieldnumbers", "jdoProvideField"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoPreSerialize", 20, "void", null, null, null, ImplHelper.getJDOStateManagerVoidDelegationImpl("preSerialize(this)"), ImplHelper.COMMENT_ENHANCER_ADDED);
    }

    private void writePCMembers(String classname) throws IOException {
        this.writer.writeComments(1, new String[]{"----------------------------------------------------------------------", "Augmentation for Persistence-Capable Classes (added by enhancer):", "----------------------------------------------------------------------"});
        this.writer.writeln();
        String[] managedFieldNames = this.meta.getManagedFields(classname);
        String[] managedFieldTypes = this.meta.getFieldType(classname, managedFieldNames);
        boolean isPCRoot = this.meta.isPersistenceCapableRootClass(classname);
        this.writePCStaticMembers(classname);
        this.writer.writeMethod("jdoNewInstance", 1, "javax.jdo.spi.PersistenceCapable", new String[]{"sm"}, new String[]{"javax.jdo.spi.StateManager"}, null, ImplHelper.getJDONewInstanceImpl(classname, "sm"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoNewInstance", 1, "javax.jdo.spi.PersistenceCapable", new String[]{"sm", "oid"}, new String[]{"javax.jdo.spi.StateManager", "Object"}, null, ImplHelper.getJDONewInstanceKeyImpl(classname, "sm", "oid"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoReplaceField", 1, "void", new String[]{"fieldnumber"}, new String[]{"int"}, null, ImplHelper.getJDOReplaceFieldImpl("fieldnumber", isPCRoot, managedFieldNames, managedFieldTypes), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoProvideField", 1, "void", new String[]{"fieldnumber"}, new String[]{"int"}, null, ImplHelper.getJDOProvideFieldImpl("fieldnumber", isPCRoot, managedFieldNames, managedFieldTypes), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoCopyFields", 1, "void", new String[]{"pc", "fieldnumbers"}, new String[]{(class$java$lang$Object == null ? (class$java$lang$Object = Main.class$("java.lang.Object")) : class$java$lang$Object).getName(), "int[]"}, null, ImplHelper.getJDOCopyFieldsImpl(classname, "pc", "fieldnumbers"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoCopyField", 20, "void", new String[]{"pc", "fieldnumber"}, new String[]{classname, "int"}, null, ImplHelper.getJDOCopyFieldImpl(classname, "pc", "fieldnumber", managedFieldNames, isPCRoot), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writePCKeyHandlingMembers(classname);
        this.writePCSerializationMembers(classname);
    }

    private void writePCStaticMembers(String classname) throws IOException {
        String[] managedFieldNames = this.meta.getManagedFields(classname);
        String superPC = this.meta.getPersistenceCapableSuperClass(classname);
        String[] managedFieldTypes = this.meta.getFieldType(classname, managedFieldNames);
        int[] managedFieldFlags = this.meta.getFieldFlags(classname, managedFieldNames);
        this.writer.writeField("jdoInheritedFieldCount", 26, "int", null, ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeField("jdoFieldNames", 26, "String[]", null, ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeField("jdoFieldTypes", 26, "Class[]", null, ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeField("jdoFieldFlags", 26, "byte[]", null, ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeField("jdoPersistenceCapableSuperclass", 26, "Class", null, ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeStaticInitializer(ImplHelper.getStaticInitializerImpl(classname, superPC, managedFieldNames, managedFieldTypes, managedFieldFlags), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoGetManagedFieldCount", 12, "int", null, null, null, ImplHelper.getJDOGetManagedFieldCountImpl(managedFieldNames.length), ImplHelper.COMMENT_ENHANCER_ADDED);
    }

    private void writePCKeyHandlingMembers(String classname) throws IOException {
        boolean isPCRoot = this.meta.isPersistenceCapableRootClass(classname);
        String oidClassName = NameHelper.normalizeClassName(this.meta.getKeyClass(classname));
        if (!isPCRoot && oidClassName == null) {
            return;
        }
        String superOidClassName = NameHelper.normalizeClassName(this.meta.getSuperKeyClass(classname));
        String[] keyFieldNames = this.meta.getKeyFields(classname);
        String[] keyFieldTypes = this.meta.getFieldType(classname, keyFieldNames);
        int[] keyFieldNumbers = this.meta.getFieldNumber(classname, keyFieldNames);
        this.writer.writeMethod("jdoNewObjectIdInstance", 1, (class$java$lang$Object == null ? (class$java$lang$Object = Main.class$("java.lang.Object")) : class$java$lang$Object).getName(), null, null, null, ImplHelper.getJDONewOidInstanceImpl(oidClassName), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoNewObjectIdInstance", 1, (class$java$lang$Object == null ? (class$java$lang$Object = Main.class$("java.lang.Object")) : class$java$lang$Object).getName(), new String[]{"str"}, new String[]{"String"}, null, ImplHelper.getJDONewOidInstanceImpl(oidClassName, "str"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoCopyKeyFieldsToObjectId", 1, "void", new String[]{"oid"}, new String[]{"Object"}, null, ImplHelper.getJDOCopyKeyFieldsToOid(oidClassName, superOidClassName, "oid", keyFieldNames), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoCopyKeyFieldsFromObjectId", 4, "void", new String[]{"oid"}, new String[]{"Object"}, null, ImplHelper.getJDOCopyKeyFieldsFromOid(oidClassName, superOidClassName, "oid", keyFieldNames), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoCopyKeyFieldsToObjectId", 1, "void", new String[]{"ofs", "oid"}, new String[]{"javax.jdo.spi.PersistenceCapable.ObjectIdFieldSupplier", "Object"}, null, ImplHelper.getJDOCopyKeyFieldsToOid(oidClassName, superOidClassName, "ofs", "oid", keyFieldNames, keyFieldTypes, keyFieldNumbers), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.writeMethod("jdoCopyKeyFieldsFromObjectId", 1, "void", new String[]{"ofc", "oid"}, new String[]{"javax.jdo.spi.PersistenceCapable.ObjectIdFieldConsumer", "Object"}, null, ImplHelper.getJDOCopyKeyFieldsFromOid(oidClassName, superOidClassName, "ofc", "oid", keyFieldNames, keyFieldTypes, keyFieldNumbers), ImplHelper.COMMENT_ENHANCER_ADDED);
    }

    private void writePCSerializationMembers(String classname) throws IOException {
        long serialUID = Main.createJDOVersionUID(classname);
        this.writer.writeField("serialVersionUID", 26, "long", ImplHelper.getSerialVersionUIDInitValue(serialUID), new String[]{"only a dummy value yet"});
        this.writer.writeMethod("writeObject", 2, "void", new String[]{"out"}, new String[]{(class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = Main.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream).getName()}, new String[]{(class$java$io$IOException == null ? (class$java$io$IOException = Main.class$("java.io.IOException")) : class$java$io$IOException).getName()}, ImplHelper.getWriteObjectImpl("out"), ImplHelper.COMMENT_ENHANCER_ADDED);
    }

    private void writeOidClass(String classname, String oidClassName, boolean enclosedOid) throws IOException {
        int indent = enclosedOid ? 1 : 0;
        this.writer.writeComments(indent, new String[]{"----------------------------------------------------------------------", "Key Class:", "----------------------------------------------------------------------"});
        this.writer.writeln();
        this.writer.setInitialIndents(indent);
        String superOidClassName = NameHelper.normalizeClassName(this.meta.getSuperKeyClass(classname));
        this.writer.writeClassHeader(enclosedOid ? 9 : 0, oidClassName, superOidClassName, new String[]{(class$java$io$Serializable == null ? (class$java$io$Serializable = Main.class$("java.io.Serializable")) : class$java$io$Serializable).getName()}, ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        boolean isPCRoot = this.meta.isPersistenceCapableRootClass(classname);
        String[] pknames = this.meta.getKeyFields(classname);
        String[] pktypes = this.meta.getFieldType(classname, pknames);
        int i = 0;
        while (i < pknames.length) {
            this.writer.writeField(pknames[i], 1, pktypes[i], null, null);
            ++i;
        }
        this.writer.writeConstructor(NameHelper.getClassName(oidClassName), 1, null, null, null, ImplHelper.getDefaultConstructorImpl(), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        this.writer.writeConstructor(NameHelper.getClassName(oidClassName), 1, new String[]{"str"}, new String[]{"String"}, null, ImplHelper.getOidStringArgConstructorImpl(superOidClassName, "str"), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        this.writer.writeMethod("hashCode", 1, "int", null, null, null, ImplHelper.getOidHashCodeImpl(pknames, pktypes, isPCRoot), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        this.writer.writeMethod("equals", 1, "boolean", new String[]{"pk"}, new String[]{(class$java$lang$Object == null ? (class$java$lang$Object = Main.class$("java.lang.Object")) : class$java$lang$Object).getName()}, null, ImplHelper.getOidEqualsImpl(oidClassName, pknames, pktypes, "pk", isPCRoot), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        this.writer.writeClassEnd();
        this.writer.setInitialIndents(0);
    }

    private static long createJDOVersionUID(String classname) {
        return classname.hashCode();
    }

    private static String createMethodName(String prefix, String fieldname) {
        return prefix + Character.toUpperCase(fieldname.charAt(0)) + fieldname.substring(1);
    }

    private void printMessage(String msg) {
        this.out.println(msg);
    }

    private void printError(String msg, Throwable ex) {
        if (msg != null) {
            this.err.println(msg + (ex != null ? ": " + ex.getMessage() : ""));
        }
        if (ex != null) {
            ex.printStackTrace(this.err);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CmdLineOptions {
        String destinationDirectory = null;
        String jdoXMLModelFileName = null;
        String jdoPropertiesFileName = null;
        boolean verbose = false;
        boolean quiet = false;
        boolean forceWrite = false;
        boolean noWrite = false;

        private CmdLineOptions() {
        }

        public void usage() {
            Main.this.err.println("Usage: Main <options> <arguments>...");
            Main.this.err.println("Options:");
            Main.this.err.println("  -v, --verbose            print verbose output");
            Main.this.err.println("  -d, --dest <dir>         destination directory for output files");
            Main.this.err.println("  -p, --properties <file>  use property file for meta data");
            Main.this.err.println();
            Main.this.err.println("Arguments:");
            Main.this.err.println();
            Main.this.err.println("Returns a non-zero value in case of errors.");
            System.exit(1);
        }

        protected int processArgs(String[] argv) {
            int i = 0;
            while (i < argv.length) {
                String arg = argv[i];
                if (arg.equals("-v") || arg.equals("--verbose")) {
                    this.verbose = true;
                    this.quiet = false;
                } else if (arg.equals("-d") || arg.equals("--dest")) {
                    if (argv.length - i < 2) {
                        Main.this.printError("Missing argument to the -d/-dest option", null);
                        this.usage();
                    }
                    this.destinationDirectory = argv[++i];
                } else if (arg.equals("-p") || arg.equals("--properties")) {
                    if (argv.length - i < 2) {
                        Main.this.printError("Missing argument to the -p/--properties option", null);
                        this.usage();
                    }
                    this.jdoPropertiesFileName = argv[++i];
                } else {
                    if (arg.length() > 0 && arg.charAt(0) == '-') {
                        Main.this.printError("Unrecognized option:" + arg, null);
                        this.usage();
                    }
                    if (arg.length() == 0) {
                        Main.this.printMessage("Ignoring empty command line argument.");
                    }
                }
                ++i;
            }
            if (this.jdoPropertiesFileName == null) {
                Main.this.printError("No destination directory specified", null);
                this.usage();
            }
            if (this.destinationDirectory == null) {
                Main.this.printError("No destination directory specified", null);
                this.usage();
            }
            return 0;
        }
    }
}

