/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.filter;

import com.sap.jdo.enhancer.ClassFileEnhancer;
import com.sap.jdo.enhancer.EnhancerFatalError;
import com.sap.jdo.enhancer.EnhancerUserException;
import com.sap.jdo.enhancer.OutputStreamWrapper;
import com.sap.jdo.enhancer.classfile.ClassFile;
import com.sap.jdo.enhancer.core.Controller;
import com.sap.jdo.enhancer.core.Environment;
import com.sap.jdo.enhancer.meta.EnhancerMetaData;
import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.Support;
import com.sap.jdo.enhancer.util.UserException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;

public class Enhancer
extends Support
implements ClassFileEnhancer {
    public static final String DO_TIMING_STATISTICS = "Enhancer.doTimingStatistics";
    public static final String DUMP_CLASS = "Enhancer.dumpClass";
    public static final String NO_AUGMENT = "Enhancer.noAugment";
    public static final String NO_ANNOTATE = "Enhancer.noAnnotate";
    public static final String VERBOSE_LEVEL = "Enhancer.verboseLevel";
    public static final String VERBOSE_LEVEL_QUIET = "quiet";
    public static final String VERBOSE_LEVEL_WARN = "warn";
    public static final String VERBOSE_LEVEL_VERBOSE = "verbose";
    public static final String VERBOSE_LEVEL_DEBUG = "debug";
    private Environment env = new Environment();

    protected void init(EnhancerMetaData metaData, Properties settings, PrintWriter out, PrintWriter err) throws EnhancerUserException, EnhancerFatalError {
        String verboseLevel;
        if (metaData == null) {
            throw new EnhancerFatalError(Support.getI18N("enhancer.internal_error", "Illegal argument: metaData == null"));
        }
        this.env.setEnhancerMetaData(metaData);
        String doTiming = settings == null ? null : settings.getProperty(DO_TIMING_STATISTICS);
        this.env.setDoTimingStatistics(Boolean.valueOf(doTiming));
        String dumpClass = settings == null ? null : settings.getProperty(DUMP_CLASS);
        this.env.setDumpClass(Boolean.valueOf(dumpClass));
        String noAugment = settings == null ? null : settings.getProperty(NO_AUGMENT);
        this.env.setNoAugment(Boolean.valueOf(noAugment));
        String noAnnotate = settings == null ? null : settings.getProperty(NO_ANNOTATE);
        this.env.setNoAnnotate(Boolean.valueOf(noAnnotate));
        if (err != null) {
            this.env.setErrorWriter(err);
        }
        if (out != null) {
            this.env.setOutputWriter(out);
        }
        String string = verboseLevel = settings == null ? null : settings.getProperty(VERBOSE_LEVEL);
        if (VERBOSE_LEVEL_QUIET.equals(verboseLevel)) {
            this.env.setVerbose(false);
            this.env.setQuiet(true);
        } else if (VERBOSE_LEVEL_WARN.equals(verboseLevel)) {
            this.env.setVerbose(false);
            this.env.setQuiet(false);
        } else if (VERBOSE_LEVEL_VERBOSE.equals(verboseLevel)) {
            this.env.setVerbose(true);
            this.env.setQuiet(false);
        } else if (VERBOSE_LEVEL_DEBUG.equals(verboseLevel)) {
            this.env.setVerbose(true);
            this.env.setQuiet(false);
        } else {
            this.env.setVerbose(false);
            this.env.setQuiet(false);
        }
    }

    public Enhancer(EnhancerMetaData metaData, Properties settings, PrintWriter out, PrintWriter err) throws EnhancerUserException, EnhancerFatalError {
        this.init(metaData, settings, out, err);
    }

    private boolean enhanceClassFile1(InputStream inClassFile, OutputStreamWrapper outClassFile) {
        Controller cc;
        ClassFile cf;
        Assertion.affirm(inClassFile, "Illegal argument: inClassFile == null.");
        Assertion.affirm(outClassFile, "Illegal argument: outClassFile == null.");
        try {
            DataInputStream dis = new DataInputStream(inClassFile);
            boolean allowJDK12ClassFiles = true;
            cf = new ClassFile(dis, true);
            cc = new Controller(cf, this.env);
            String className = cf.classNameString();
        }
        catch (ClassFormatError ex) {
            throw new UserException(Support.getI18N("enhancer.class_format_error"), ex);
        }
        cc.enhanceClass();
        if (this.env.errorCount() > 0) {
            this.env.getErrorWriter().flush();
            throw new UserException(this.env.getLastErrorMessage());
        }
        Assertion.affirm(this.env.errorCount() == 0);
        boolean changed = cc.updated();
        try {
            if (changed) {
                this.env.message("writing enhanced class " + cf.userClassName() + " to output stream");
            } else {
                this.env.message("no changes to class " + cf.userClassName());
            }
            outClassFile.setClassName(cf.userClassName());
            DataOutputStream dos = new DataOutputStream(outClassFile.getStream());
            cf.write(dos);
            dos.flush();
        }
        catch (IOException ex) {
            throw new UserException(Support.getI18N("enhancer.io_error_while_writing_stream"), ex);
        }
        return changed;
    }

    public boolean enhanceClassFile(InputStream inClassFile, OutputStreamWrapper outClassFile) throws EnhancerUserException, EnhancerFatalError {
        boolean changed;
        this.env.verbose("---------------------------------------------------------------------------");
        this.env.messageNL("Enhancer: enhancing classfile ...");
        this.env.reset();
        try {
            changed = this.enhanceClassFile1(inClassFile, outClassFile);
        }
        catch (UserException ex) {
            this.env.reset();
            throw new EnhancerUserException(Support.getI18N("enhancer.error", ex.getMessage()), ex);
        }
        catch (RuntimeException ex) {
            this.env.reset();
            ex.printStackTrace();
            throw new EnhancerFatalError(Support.getI18N("enhancer.internal_error", ex.getMessage()), ex);
        }
        this.env.messageNL(changed ? "Enhancer: classfile enhanced successfully." : "Enhancer: classfile not changed.");
        return changed;
    }

    public boolean enhanceClassFile(InputStream in, OutputStream out) throws EnhancerUserException, EnhancerFatalError {
        return this.enhanceClassFile(in, new OutputStreamWrapper(out));
    }
}

