/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.core;

import com.sap.jdo.enhancer.classfile.ClassFile;
import com.sap.jdo.enhancer.classfile.GenericAttribute;
import com.sap.jdo.enhancer.core.Analyzer;
import com.sap.jdo.enhancer.core.Annotater;
import com.sap.jdo.enhancer.core.Augmenter;
import com.sap.jdo.enhancer.core.EnhancerConstants;
import com.sap.jdo.enhancer.core.Environment;
import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.Support;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public final class Controller
extends Support
implements EnhancerConstants {
    private final Environment env;
    private final ClassFile classFile;
    private final String userClassName;
    private final Analyzer analyzer;
    private final Augmenter augmenter;
    private final Annotater annotater;
    private boolean classUpdated = false;

    public Controller(ClassFile classFile, Environment env) {
        Assertion.affirm(classFile != null);
        Assertion.affirm(env != null);
        this.classFile = classFile;
        this.userClassName = classFile.userClassName();
        this.env = env;
        this.analyzer = new Analyzer(this, env);
        this.augmenter = new Augmenter(this, this.analyzer, env);
        this.annotater = new Annotater(this, this.analyzer, env);
        Assertion.affirm(this.userClassName != null);
        Assertion.affirm(this.analyzer != null);
        Assertion.affirm(this.augmenter != null);
        Assertion.affirm(this.annotater != null);
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public boolean updated() {
        return this.classUpdated;
    }

    void noteUpdate() {
        this.classUpdated = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enhanceClass() {
        block8: {
            block7: {
                block6: {
                    try {
                        if (this.env.doTimingStatistics()) {
                            Support.timer.push("Controller.enhanceClass()");
                        }
                        this.scan();
                        if (this.env.errorCount() > 0) {
                            Object var2_1 = null;
                            if (!this.env.doTimingStatistics()) return;
                            Support.timer.pop();
                            return;
                        }
                        this.augment();
                        if (this.env.errorCount() > 0) {
                            break block6;
                        }
                        this.annotate();
                        if (this.env.errorCount() > 0) {
                            break block7;
                        }
                        this.update();
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var2_5 = null;
                        if (!this.env.doTimingStatistics()) throw throwable;
                        Support.timer.pop();
                        throw throwable;
                    }
                }
                Object var2_2 = null;
                if (!this.env.doTimingStatistics()) return;
                Support.timer.pop();
                return;
            }
            Object var2_3 = null;
            if (!this.env.doTimingStatistics()) return;
            Support.timer.pop();
            return;
        }
        Object var2_4 = null;
        if (!this.env.doTimingStatistics()) return;
        Support.timer.pop();
    }

    private void scan() {
        if (this.analyzer.isAnalyzed()) {
            return;
        }
        try {
            if (this.env.doTimingStatistics()) {
                Support.timer.push("Controller.scan()");
            }
            if (this.env.dumpClass()) {
                this.dumpClass();
            }
            this.analyzer.scan();
            Object var2_1 = null;
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
            throw throwable;
        }
    }

    private void augment() {
        if (!this.analyzer.isAugmentable() || this.env.noAugment()) {
            return;
        }
        try {
            if (this.env.doTimingStatistics()) {
                Support.timer.push("Controller.augment()");
            }
            this.augmenter.augment();
            if (this.env.dumpClass()) {
                this.dumpClass();
            }
            Object var2_1 = null;
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
            throw throwable;
        }
    }

    private void annotate() {
        if (!this.analyzer.isAnnotateable() || this.env.noAnnotate()) {
            return;
        }
        try {
            if (this.env.doTimingStatistics()) {
                Support.timer.push("Controller.annotate()");
            }
            this.annotater.annotate();
            if (this.env.dumpClass()) {
                this.dumpClass();
            }
            Object var2_1 = null;
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
            throw throwable;
        }
    }

    private void update() {
        if (!this.classUpdated) {
            return;
        }
        Assertion.affirm(this.analyzer.isAugmentable() && !this.env.noAugment() || this.analyzer.isAnnotateable() && !this.env.noAnnotate());
        byte[] data = new byte[]{0, 1};
        GenericAttribute annotatedAttr = new GenericAttribute(this.classFile.pool().addUtf8("com.sap.jdo.enhancer.enhanced"), data);
        this.classFile.attributes().addElement(annotatedAttr);
    }

    private void dumpClass() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bs);
        this.env.messageNL("dumping class " + this.userClassName + " {");
        this.classFile.print(ps);
        this.env.getOutputWriter().println(bs.toString());
        this.env.messageNL("} // end of class " + this.userClassName);
    }
}

