/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.InsnError;
import com.sap.jdo.enhancer.classfile.VMConstants;

public class VMOp
implements VMConstants {
    private int opcodeValue;
    private String opcodeName;
    private int stackArgs;
    private int stackResults;
    private String stackArgTypes;
    private String stackResultTypes;
    static VMOp[] ops = new VMOp[]{new VMOp(0, "nop", 0, 0, "", ""), new VMOp(1, "aconst_null", 0, 1, "", "A"), new VMOp(2, "iconst_m1", 0, 1, "", "I"), new VMOp(3, "iconst_0", 0, 1, "", "I"), new VMOp(4, "iconst_1", 0, 1, "", "I"), new VMOp(5, "iconst_2", 0, 1, "", "I"), new VMOp(6, "iconst_3", 0, 1, "", "I"), new VMOp(7, "iconst_4", 0, 1, "", "I"), new VMOp(8, "iconst_5", 0, 1, "", "I"), new VMOp(9, "lconst_0", 0, 2, "", "J"), new VMOp(10, "lconst_1", 0, 2, "", "J"), new VMOp(11, "fconst_0", 0, 1, "", "F"), new VMOp(12, "fconst_1", 0, 1, "", "F"), new VMOp(13, "fconst_2", 0, 1, "", "F"), new VMOp(14, "dconst_0", 0, 2, "", "D"), new VMOp(15, "dconst_1", 0, 2, "", "D"), new VMOp(16, "bipush", 0, 1, "", "I"), new VMOp(17, "sipush", 0, 1, "", "I"), new VMOp(18, "ldc", 0, 1, "", "W"), new VMOp(19, "ldc_w", 0, 1, "", "W"), new VMOp(20, "ldc2_w", 0, 2, "", "X"), new VMOp(21, "iload", 0, 1, "", "I"), new VMOp(22, "lload", 0, 2, "", "J"), new VMOp(23, "fload", 0, 1, "", "F"), new VMOp(24, "dload", 0, 2, "", "D"), new VMOp(25, "aload", 0, 1, "", "A"), new VMOp(26, "iload_0", 0, 1, "", "I"), new VMOp(27, "iload_1", 0, 1, "", "I"), new VMOp(28, "iload_2", 0, 1, "", "I"), new VMOp(29, "iload_3", 0, 1, "", "I"), new VMOp(30, "lload_0", 0, 2, "", "J"), new VMOp(31, "lload_1", 0, 2, "", "J"), new VMOp(32, "lload_2", 0, 2, "", "J"), new VMOp(33, "lload_3", 0, 2, "", "J"), new VMOp(34, "fload_0", 0, 1, "", "F"), new VMOp(35, "fload_1", 0, 1, "", "F"), new VMOp(36, "fload_2", 0, 1, "", "F"), new VMOp(37, "fload_3", 0, 1, "", "F"), new VMOp(38, "dload_0", 0, 2, "", "D"), new VMOp(39, "dload_1", 0, 2, "", "D"), new VMOp(40, "dload_2", 0, 2, "", "D"), new VMOp(41, "dload_3", 0, 2, "", "D"), new VMOp(42, "aload_0", 0, 1, "", "A"), new VMOp(43, "aload_1", 0, 1, "", "A"), new VMOp(44, "aload_2", 0, 1, "", "A"), new VMOp(45, "aload_3", 0, 1, "", "A"), new VMOp(46, "iaload", 2, 1, "AI", "I"), new VMOp(47, "laload", 2, 2, "AI", "J"), new VMOp(48, "faload", 2, 1, "AI", "F"), new VMOp(49, "daload", 2, 2, "AI", "D"), new VMOp(50, "aaload", 2, 1, "AI", "A"), new VMOp(51, "baload", 2, 1, "AI", "I"), new VMOp(52, "caload", 2, 1, "AI", "I"), new VMOp(53, "saload", 2, 1, "AI", "I"), new VMOp(54, "istore", 1, 0, "I", ""), new VMOp(55, "lstore", 2, 0, "J", ""), new VMOp(56, "fstore", 1, 0, "F", ""), new VMOp(57, "dstore", 2, 0, "D", ""), new VMOp(58, "astore", 1, 0, "A", ""), new VMOp(59, "istore_0", 1, 0, "I", ""), new VMOp(60, "istore_1", 1, 0, "I", ""), new VMOp(61, "istore_2", 1, 0, "I", ""), new VMOp(62, "istore_3", 1, 0, "I", ""), new VMOp(63, "lstore_0", 2, 0, "J", ""), new VMOp(64, "lstore_1", 2, 0, "J", ""), new VMOp(65, "lstore_2", 2, 0, "J", ""), new VMOp(66, "lstore_3", 2, 0, "J", ""), new VMOp(67, "fstore_0", 1, 0, "F", ""), new VMOp(68, "fstore_1", 1, 0, "F", ""), new VMOp(69, "fstore_2", 1, 0, "F", ""), new VMOp(70, "fstore_3", 1, 0, "F", ""), new VMOp(71, "dstore_0", 2, 0, "D", ""), new VMOp(72, "dstore_1", 2, 0, "D", ""), new VMOp(73, "dstore_2", 2, 0, "D", ""), new VMOp(74, "dstore_3", 2, 0, "D", ""), new VMOp(75, "astore_0", 1, 0, "A", ""), new VMOp(76, "astore_1", 1, 0, "A", ""), new VMOp(77, "astore_2", 1, 0, "A", ""), new VMOp(78, "astore_3", 1, 0, "A", ""), new VMOp(79, "iastore", 3, 0, "AII", ""), new VMOp(80, "lastore", 4, 0, "AIJ", ""), new VMOp(81, "fastore", 3, 0, "AIF", ""), new VMOp(82, "dastore", 4, 0, "AID", ""), new VMOp(83, "aastore", 3, 0, "AIA", ""), new VMOp(84, "bastore", 3, 0, "AII", ""), new VMOp(85, "castore", 3, 0, "AII", ""), new VMOp(86, "sastore", 3, 0, "AII", ""), new VMOp(87, "pop", 1, 0, "W", ""), new VMOp(88, "pop2", 2, 0, "WW", ""), new VMOp(89, "dup", 1, 2, "W", "WW"), new VMOp(90, "dup_x1", 2, 3, "WW", "WWW"), new VMOp(91, "dup_x2", 3, 4, "WWW", "WWWW"), new VMOp(92, "dup2", 2, 4, "WW", "WWWW"), new VMOp(93, "dup2_x1", 3, 5, "WWW", "WWWWW"), new VMOp(94, "dup2_x2", 4, 6, "WWWW", "WWWWWW"), new VMOp(95, "swap", 2, 2, "WW", "WW"), new VMOp(96, "iadd", 2, 1, "II", "I"), new VMOp(97, "ladd", 4, 2, "JJ", "J"), new VMOp(98, "fadd", 2, 1, "FF", "F"), new VMOp(99, "dadd", 4, 2, "DD", "D"), new VMOp(100, "isub", 2, 1, "II", "I"), new VMOp(101, "lsub", 4, 2, "JJ", "J"), new VMOp(102, "fsub", 2, 1, "FF", "F"), new VMOp(103, "dsub", 4, 2, "DD", "D"), new VMOp(104, "imul", 2, 1, "II", "I"), new VMOp(105, "lmul", 4, 2, "JJ", "J"), new VMOp(106, "fmul", 2, 1, "FF", "F"), new VMOp(107, "dmul", 4, 2, "DD", "D"), new VMOp(108, "idiv", 2, 1, "II", "I"), new VMOp(109, "ldiv", 4, 2, "JJ", "J"), new VMOp(110, "fdiv", 2, 1, "FF", "F"), new VMOp(111, "ddiv", 4, 2, "DD", "D"), new VMOp(112, "irem", 2, 1, "II", "I"), new VMOp(113, "lrem", 4, 2, "JJ", "J"), new VMOp(114, "frem", 2, 1, "FF", "F"), new VMOp(115, "drem", 4, 2, "DD", "D"), new VMOp(116, "ineg", 1, 1, "I", "I"), new VMOp(117, "lneg", 2, 2, "J", "J"), new VMOp(118, "fneg", 1, 1, "F", "F"), new VMOp(119, "dneg", 2, 2, "D", "D"), new VMOp(120, "ishl", 2, 1, "II", "I"), new VMOp(121, "lshl", 3, 2, "JI", "J"), new VMOp(122, "ishr", 2, 1, "II", "I"), new VMOp(123, "lshr", 3, 2, "JI", "J"), new VMOp(124, "iushr", 2, 1, "II", "I"), new VMOp(125, "lushr", 3, 2, "JI", "J"), new VMOp(126, "iand", 2, 1, "II", "I"), new VMOp(127, "land", 4, 2, "JJ", "J"), new VMOp(128, "ior", 2, 1, "II", "I"), new VMOp(129, "lor", 4, 2, "JJ", "J"), new VMOp(130, "ixor", 2, 1, "II", "I"), new VMOp(131, "lxor", 4, 2, "JJ", "J"), new VMOp(132, "iinc", 0, 0, "", ""), new VMOp(133, "i2l", 1, 2, "I", "J"), new VMOp(134, "i2f", 1, 1, "I", "F"), new VMOp(135, "i2d", 1, 2, "I", "D"), new VMOp(136, "l2i", 2, 1, "J", "I"), new VMOp(137, "l2f", 2, 1, "J", "F"), new VMOp(138, "l2d", 2, 2, "J", "D"), new VMOp(139, "f2i", 1, 1, "F", "I"), new VMOp(140, "f2l", 1, 2, "F", "J"), new VMOp(141, "f2d", 1, 2, "F", "D"), new VMOp(142, "d2i", 2, 1, "D", "I"), new VMOp(143, "d2l", 2, 2, "D", "J"), new VMOp(144, "d2f", 2, 1, "D", "F"), new VMOp(145, "i2b", 1, 1, "I", "I"), new VMOp(146, "i2c", 1, 1, "I", "I"), new VMOp(147, "i2s", 1, 1, "I", "I"), new VMOp(148, "lcmp", 4, 1, "JJ", "I"), new VMOp(149, "fcmpl", 2, 1, "FF", "I"), new VMOp(150, "fcmpg", 2, 1, "FF", "I"), new VMOp(151, "dcmpl", 4, 1, "DD", "I"), new VMOp(152, "dcmpg", 4, 1, "DD", "I"), new VMOp(153, "ifeq", 1, 0, "I", ""), new VMOp(154, "ifne", 1, 0, "I", ""), new VMOp(155, "iflt", 1, 0, "I", ""), new VMOp(156, "ifge", 1, 0, "I", ""), new VMOp(157, "ifgt", 1, 0, "I", ""), new VMOp(158, "ifle", 1, 0, "I", ""), new VMOp(159, "if_icmpeq", 2, 0, "II", ""), new VMOp(160, "if_icmpne", 2, 0, "II", ""), new VMOp(161, "if_icmplt", 2, 0, "II", ""), new VMOp(162, "if_icmpge", 2, 0, "II", ""), new VMOp(163, "if_icmpgt", 2, 0, "II", ""), new VMOp(164, "if_icmple", 2, 0, "II", ""), new VMOp(165, "if_acmpeq", 2, 0, "AA", ""), new VMOp(166, "if_acmpne", 2, 0, "AA", ""), new VMOp(167, "goto", 0, 0, "", ""), new VMOp(168, "jsr", 0, 1, "", "W"), new VMOp(169, "ret", 0, 0, "", ""), new VMOp(170, "tableswitch", 1, 0, "I", ""), new VMOp(171, "lookupswitch", 1, 0, "I", ""), new VMOp(172, "ireturn", 1, 0, "I", ""), new VMOp(173, "lreturn", 2, 0, "J", ""), new VMOp(174, "freturn", 1, 0, "F", ""), new VMOp(175, "dreturn", 2, 0, "D", ""), new VMOp(176, "areturn", 1, 0, "A", ""), new VMOp(177, "return", 0, 0, "", ""), new VMOp(178, "getstatic", 0, -1, "", "?"), new VMOp(179, "putstatic", -1, 0, "?", ""), new VMOp(180, "getfield", 1, -1, "A", "?"), new VMOp(181, "putfield", -1, 0, "A?", ""), new VMOp(182, "invokevirtual", -1, -1, "A?", "?"), new VMOp(183, "invokespecial", -1, -1, "A?", "?"), new VMOp(184, "invokestatic", -1, -1, "?", "?"), new VMOp(185, "invokeinterface", -1, -1, "A?", "?"), new VMOp(186, "xxxunusedxxx", 0, 0, "", ""), new VMOp(187, "new", 0, 1, "", "A"), new VMOp(188, "newarray", 1, 1, "I", "A"), new VMOp(189, "anewarray", 1, 1, "I", "A"), new VMOp(190, "arraylength", 1, 1, "A", "I"), new VMOp(191, "athrow", 1, 0, "A", "?"), new VMOp(192, "checkcast", 1, 1, "A", "A"), new VMOp(193, "instanceof", 1, 1, "A", "I"), new VMOp(194, "monitorenter", 1, 0, "A", ""), new VMOp(195, "monitorexit", 1, 0, "A", ""), new VMOp(196, "wide", 0, 0, "", ""), new VMOp(197, "multianewarray", -1, 1, "?", "A"), new VMOp(198, "ifnull", 1, 0, "A", ""), new VMOp(199, "ifnonnull", 1, 0, "A", ""), new VMOp(200, "goto_w", 0, 0, "", ""), new VMOp(201, "jsr_w", 0, 1, "", "W")};

    public final int opcode() {
        return this.opcodeValue;
    }

    public final String name() {
        return this.opcodeName;
    }

    public final int nStackArgs() {
        return this.stackArgs;
    }

    public final int nStackResults() {
        return this.stackResults;
    }

    public final String argTypes() {
        return this.stackArgTypes;
    }

    public final String resultTypes() {
        return this.stackResultTypes;
    }

    public VMOp(int theOpcode, String theOpcodeName, int nArgs, int nResults, String argDescr, String resultDescr) {
        this.opcodeValue = theOpcode;
        this.opcodeName = theOpcodeName;
        this.stackArgs = nArgs;
        this.stackResults = nResults;
        this.stackArgTypes = argDescr;
        this.stackResultTypes = resultDescr;
    }

    private static void check() {
        int i = 0;
        while (i <= 201) {
            VMOp op = ops[i];
            if (op == null) {
                throw new InsnError("null VMOp for " + i);
            }
            if (op.opcode() != i) {
                throw new InsnError("bad opcode for " + i);
            }
            ++i;
        }
    }

    private static void checkTypes(String types, int n, VMOp op) {
        int i = 0;
        while (i < types.length()) {
            char c = types.charAt(i);
            if (c == '?') {
                return;
            }
            n = c == 'J' || c == 'X' || c == 'D' ? (n -= 2) : --n;
            ++i;
        }
        if (n != 0) {
            throw new InsnError("Bad arg/result for VMOp " + op.opcodeName);
        }
    }

    static {
        VMOp.check();
    }
}

