/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ClassAttribute;
import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.ConstUtf8;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class SourceFileAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "SourceFile";
    private ConstUtf8 sourceFileName;

    public ConstUtf8 fileName() {
        return this.sourceFileName;
    }

    public void setFileName(ConstUtf8 name) {
        this.sourceFileName = name;
    }

    public SourceFileAttribute(ConstUtf8 attrName, ConstUtf8 sourceName) {
        super(attrName);
        this.sourceFileName = sourceName;
    }

    static SourceFileAttribute read(ConstUtf8 attrName, DataInputStream data, ConstantPool pool) throws IOException {
        int index = 0;
        index = data.readUnsignedShort();
        return new SourceFileAttribute(attrName, (ConstUtf8)pool.constantAt(index));
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        out.writeInt(2);
        out.writeShort(this.sourceFileName.getIndex());
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println("SourceFile: " + this.sourceFileName.asString());
    }
}

