/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ClassAttribute;
import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.CodeEnv;
import com.sap.jdo.enhancer.classfile.ConstUtf8;
import com.sap.jdo.enhancer.classfile.InsnTarget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Stack;

public class LineNumberTableAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "LineNumberTable";
    private short[] lineNumbers;
    private InsnTarget[] targets;

    public LineNumberTableAttribute(ConstUtf8 nameAttr, short[] lineNums, InsnTarget[] targets) {
        super(nameAttr);
        this.lineNumbers = lineNums;
        this.targets = targets;
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof LineNumberTableAttribute)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        LineNumberTableAttribute other = (LineNumberTableAttribute)obj;
        return super.isEqual(msg, other);
    }

    static LineNumberTableAttribute read(ConstUtf8 attrName, DataInputStream data, CodeEnv env) throws IOException {
        int nLnums = data.readUnsignedShort();
        short[] lineNums = new short[nLnums];
        InsnTarget[] targs = new InsnTarget[nLnums];
        int i = 0;
        while (i < nLnums) {
            targs[i] = env.getTarget(data.readShort());
            lineNums[i] = data.readShort();
            ++i;
        }
        return new LineNumberTableAttribute(attrName, lineNums, targs);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        int nlines = this.lineNumbers.length;
        out.writeInt(2 + 4 * nlines);
        out.writeShort(nlines);
        int i = 0;
        while (i < nlines) {
            out.writeShort(this.targets[i].offset());
            out.writeShort(this.lineNumbers[i]);
            ++i;
        }
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println("Line Numbers: ");
        int i = 0;
        while (i < this.lineNumbers.length) {
            ClassPrint.spaces(out, indent + 2);
            out.println(Integer.toString(this.lineNumbers[i]) + " @ " + Integer.toString(this.targets[i].offset()));
            ++i;
        }
    }
}

