/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.Insn;
import com.sap.jdo.enhancer.classfile.InsnError;
import com.sap.jdo.enhancer.classfile.InsnReadEnv;
import com.sap.jdo.enhancer.classfile.InsnTarget;
import java.io.PrintStream;
import java.util.Stack;

public class InsnTableSwitch
extends Insn {
    private int lowOp;
    private InsnTarget defaultOp;
    private InsnTarget[] targetsOp;

    public int nStackArgs() {
        return 1;
    }

    public int nStackResults() {
        return 0;
    }

    public String argTypes() {
        return "I";
    }

    public String resultTypes() {
        return "";
    }

    public boolean branches() {
        return true;
    }

    public void markTargets() {
        this.defaultOp.setBranchTarget();
        int i = 0;
        while (i < this.targetsOp.length) {
            this.targetsOp[i].setBranchTarget();
            ++i;
        }
    }

    public int lowCase() {
        return this.lowOp;
    }

    public InsnTarget defaultTarget() {
        return this.defaultOp;
    }

    public InsnTarget[] switchTargets() {
        return this.targetsOp;
    }

    public InsnTableSwitch(int lowOp, InsnTarget defaultOp, InsnTarget[] targetsOp) {
        this(lowOp, defaultOp, targetsOp, -1);
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof InsnTableSwitch)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        InsnTableSwitch other = (InsnTableSwitch)obj;
        if (!super.isEqual(msg, other)) {
            return false;
        }
        if (this.lowOp != other.lowOp) {
            msg.push(String.valueOf("lowOp = " + other.lowOp));
            msg.push(String.valueOf("lowOp = " + this.lowOp));
            return false;
        }
        if (!this.defaultOp.isEqual(msg, other.defaultOp)) {
            msg.push(String.valueOf("defaultOp = " + other.defaultOp));
            msg.push(String.valueOf("defaultOp = " + this.defaultOp));
            return false;
        }
        if (this.targetsOp.length != other.targetsOp.length) {
            msg.push("targetsOp.length " + String.valueOf(other.targetsOp.length));
            msg.push("targetsOp.length " + String.valueOf(this.targetsOp.length));
            return false;
        }
        int i = 0;
        while (i < this.targetsOp.length) {
            InsnTarget t1 = this.targetsOp[i];
            InsnTarget t2 = other.targetsOp[i];
            if (!t1.isEqual(msg, t2)) {
                msg.push("targetsOp[" + i + "] = " + String.valueOf(t2));
                msg.push("targetsOp[" + i + "] = " + String.valueOf(t1));
                return false;
            }
            ++i;
        }
        return true;
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println(this.offset() + "  opc_tableswitch  ");
        int i = 0;
        while (i < this.targetsOp.length) {
            int index = i + this.lowOp;
            if (this.targetsOp[i].offset() != this.defaultOp.offset()) {
                ClassPrint.spaces(out, indent + 2);
                out.println(index + " -> " + this.targetsOp[i].offset());
            }
            ++i;
        }
        ClassPrint.spaces(out, indent + 2);
        out.println("default -> " + this.defaultOp.offset());
    }

    int store(byte[] buf, int index) {
        buf[index++] = (byte)this.opcode();
        index = index + 3 & 0xFFFFFFFC;
        index = Insn.storeInt(buf, index, this.defaultOp.offset() - this.offset());
        index = Insn.storeInt(buf, index, this.lowOp);
        index = Insn.storeInt(buf, index, this.lowOp + this.targetsOp.length - 1);
        int i = 0;
        while (i < this.targetsOp.length) {
            index = Insn.storeInt(buf, index, this.targetsOp[i].offset() - this.offset());
            ++i;
        }
        return index;
    }

    int size() {
        int basic = (this.offset() + 4 & 0xFFFFFFFC) - this.offset() + 12;
        return basic + this.targetsOp.length * 4;
    }

    InsnTableSwitch(int lowOp, InsnTarget defaultOp, InsnTarget[] targetsOp, int offset) {
        super(170, offset);
        this.lowOp = lowOp;
        this.defaultOp = defaultOp;
        this.targetsOp = targetsOp;
        if (defaultOp == null || targetsOp == null) {
            throw new InsnError("attempt to create an opc_tableswitch with invalid operands");
        }
    }

    static InsnTableSwitch read(InsnReadEnv insnEnv, int myPC) {
        int thisPC = myPC + 1;
        int pads = (thisPC + 3 & 0xFFFFFFFC) - thisPC;
        while (pads > 0) {
            insnEnv.getByte();
            --pads;
        }
        InsnTarget defaultTarget = insnEnv.getTarget(insnEnv.getInt() + myPC);
        int low = insnEnv.getInt();
        int high = insnEnv.getInt();
        InsnTarget[] offsets = new InsnTarget[high - low + 1];
        int i = 0;
        while (i < offsets.length) {
            offsets[i] = insnEnv.getTarget(insnEnv.getInt() + myPC);
            ++i;
        }
        return new InsnTableSwitch(low, defaultTarget, offsets, myPC);
    }
}

