/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ConstBasic;
import com.sap.jdo.enhancer.classfile.InsnConstOp;
import com.sap.jdo.enhancer.classfile.InsnError;
import com.sap.jdo.enhancer.classfile.InsnIInc;
import com.sap.jdo.enhancer.classfile.InsnIntOp;
import com.sap.jdo.enhancer.classfile.InsnInterfaceInvoke;
import com.sap.jdo.enhancer.classfile.InsnLookupSwitch;
import com.sap.jdo.enhancer.classfile.InsnMultiDimArrayNew;
import com.sap.jdo.enhancer.classfile.InsnReadEnv;
import com.sap.jdo.enhancer.classfile.InsnSingle;
import com.sap.jdo.enhancer.classfile.InsnTableSwitch;
import com.sap.jdo.enhancer.classfile.InsnTarget;
import com.sap.jdo.enhancer.classfile.InsnTargetOp;
import com.sap.jdo.enhancer.classfile.VMConstants;
import com.sap.jdo.enhancer.classfile.VMOp;
import java.io.PrintStream;
import java.util.Stack;

public abstract class Insn
implements VMConstants {
    static final int NO_OFFSET = -1;
    public static final int opc_target = -1;
    private int insnOpcode;
    private int insnOffset = -1;
    private Insn nextInsn = null;
    private Insn prevInsn = null;

    public Insn next() {
        return this.nextInsn;
    }

    public Insn prev() {
        return this.prevInsn;
    }

    public void remove() {
        if (this.nextInsn != null) {
            this.nextInsn.prevInsn = this.prevInsn;
        }
        if (this.prevInsn != null) {
            this.prevInsn.nextInsn = this.nextInsn;
        }
        this.prevInsn = null;
        this.nextInsn = null;
    }

    public Insn setNext(Insn i) {
        if (this.nextInsn != null) {
            this.nextInsn.prevInsn = i;
        }
        if (i != null) {
            i.nextInsn = this.nextInsn;
            i.prevInsn = this;
        }
        this.nextInsn = i;
        return i;
    }

    public Insn insert(Insn i) {
        if (i == null) {
            return this;
        }
        Insn theNextInsn = this.nextInsn;
        this.nextInsn = i;
        i.prevInsn = this;
        while (i.nextInsn != null) {
            i = i.nextInsn;
        }
        i.nextInsn = theNextInsn;
        if (theNextInsn != null) {
            theNextInsn.prevInsn = i;
        }
        return i;
    }

    public Insn append(Insn i) {
        Insn thisInsn = this;
        while (thisInsn.nextInsn != null) {
            thisInsn = thisInsn.nextInsn;
        }
        return thisInsn.insert(i);
    }

    public int opcode() {
        return this.insnOpcode;
    }

    public int offset() {
        return this.insnOffset;
    }

    public abstract int nStackArgs();

    public abstract int nStackResults();

    public abstract String argTypes();

    public abstract String resultTypes();

    public abstract boolean branches();

    public void markTargets() {
    }

    public static String opName(int opcode) {
        if (opcode == -1) {
            return "target:";
        }
        if (opcode >= 0 && opcode <= VMOp.ops.length) {
            return VMOp.ops[opcode].name();
        }
        throw new InsnError("invalid opcode for opName: " + opcode);
    }

    public static Insn create(int theOpCode) {
        return new InsnSingle(theOpCode);
    }

    public static Insn create(int theOpCode, ConstBasic constValue) {
        return new InsnConstOp(theOpCode, constValue);
    }

    public static Insn create(int theOpCode, int intValue) {
        return new InsnIntOp(theOpCode, intValue);
    }

    public static Insn create(int theOpCode, InsnTarget target) {
        return new InsnTargetOp(theOpCode, target);
    }

    public void printList(PrintStream out) {
        Insn insn = this;
        while (insn != null) {
            insn.print(out, 0);
            insn = insn.next();
        }
    }

    public void printInsn(PrintStream out) {
        this.print(out, 0);
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof Insn)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        Insn other = (Insn)obj;
        if (this.insnOpcode != other.insnOpcode && (this.insnOpcode != 18 && this.insnOpcode != 19 || other.insnOpcode != 18 && other.insnOpcode != 19)) {
            msg.push(String.valueOf("insnOpcode = " + other.insnOpcode));
            msg.push(String.valueOf("insnOpcode = " + this.insnOpcode));
            return false;
        }
        return true;
    }

    public String toString() {
        return "Insn: insnOpcode(" + Insn.opName(this.insnOpcode) + ")" + "  insnOffset(" + this.insnOffset + ")";
    }

    abstract void print(PrintStream var1, int var2);

    abstract int store(byte[] var1, int var2);

    abstract int size();

    final int resolveOffset(int pc) {
        this.insnOffset = pc;
        return pc + this.size();
    }

    Insn(int theOpcode, int theOffset) {
        this.insnOpcode = theOpcode;
        this.insnOffset = theOffset;
    }

    static int storeInt(byte[] buf, int index, int v) {
        buf[index++] = (byte)(v >> 24);
        buf[index++] = (byte)(v >> 16 & 0xFF);
        buf[index++] = (byte)(v >> 8 & 0xFF);
        buf[index++] = (byte)(v & 0xFF);
        return index;
    }

    static int storeShort(byte[] buf, int index, short v) {
        buf[index++] = (byte)(v >> 8 & 0xFF);
        buf[index++] = (byte)(v & 0xFF);
        return index;
    }

    static Insn read(InsnReadEnv insnEnv) {
        boolean widen = false;
        int pc = insnEnv.currentPC();
        int op = insnEnv.getUByte();
        if (op == 196) {
            widen = true;
            op = insnEnv.getUByte();
        }
        switch (op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 186: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                return new InsnSingle(op, pc);
            }
            case 18: {
                return new InsnConstOp(op, insnEnv.pool().constantAt(insnEnv.getUByte()), pc);
            }
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                return new InsnConstOp(op, insnEnv.pool().constantAt(insnEnv.getUShort()), pc);
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                if (widen) {
                    return new InsnIntOp(op, insnEnv.getShort(), pc);
                }
                return new InsnIntOp(op, insnEnv.getByte(), pc);
            }
            case 16: 
            case 188: {
                return new InsnIntOp(op, insnEnv.getByte(), pc);
            }
            case 17: {
                return new InsnIntOp(op, insnEnv.getShort(), pc);
            }
            case 132: {
                if (widen) {
                    return new InsnIInc(insnEnv.getUShort(), insnEnv.getShort(), pc);
                }
                return new InsnIInc(insnEnv.getUByte(), insnEnv.getByte(), pc);
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                return new InsnTargetOp(op, insnEnv.getTarget(insnEnv.getShort() + pc), pc);
            }
            case 200: 
            case 201: {
                return new InsnTargetOp(op, insnEnv.getTarget(insnEnv.getInt() + pc), pc);
            }
            case 170: {
                return InsnTableSwitch.read(insnEnv, pc);
            }
            case 171: {
                return InsnLookupSwitch.read(insnEnv, pc);
            }
            case 185: {
                return InsnInterfaceInvoke.read(insnEnv, pc);
            }
            case 197: {
                return InsnMultiDimArrayNew.read(insnEnv, pc);
            }
        }
        throw new InsnError("Invalid byte code (" + op + ")");
    }

    public static final int loadStoreDataType(int opcode) {
        switch (opcode) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 79: 
            case 84: 
            case 85: 
            case 86: {
                return 10;
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 47: 
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 80: {
                return 11;
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 48: 
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 81: {
                return 6;
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 49: 
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 82: {
                return 7;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 50: 
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 83: {
                return 12;
            }
        }
        throw new InsnError("not a load/store");
    }
}

