/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ClassAttribute;
import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.ConstUtf8;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Stack;

public class GenericAttribute
extends ClassAttribute {
    byte[] attributeBytes;

    public GenericAttribute(ConstUtf8 attrName, byte[] attrBytes) {
        super(attrName);
        this.attributeBytes = attrBytes;
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof GenericAttribute)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        GenericAttribute other = (GenericAttribute)obj;
        if (!super.isEqual(msg, other)) {
            return false;
        }
        if (this.attributeBytes.length != other.attributeBytes.length) {
            msg.push("attributeBytes.length " + String.valueOf(other.attributeBytes.length));
            msg.push("attributeBytes.length " + String.valueOf(this.attributeBytes.length));
            return false;
        }
        int i = 0;
        while (i < this.attributeBytes.length) {
            byte b1 = this.attributeBytes[i];
            byte b2 = other.attributeBytes[i];
            if (b1 != b2) {
                msg.push("attributeBytes[" + i + "] = " + String.valueOf(b2));
                msg.push("attributeBytes[" + i + "] = " + String.valueOf(b1));
                return false;
            }
            ++i;
        }
        return true;
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        out.writeInt(this.attributeBytes.length);
        out.write(this.attributeBytes, 0, this.attributeBytes.length);
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println("Generic Attribute(" + this.attrName().asString() + "): " + Integer.toString(this.attributeBytes.length) + " in length");
        int i = 0;
        while (i < this.attributeBytes.length) {
            if (i % 16 == 0) {
                if (i != 0) {
                    out.println();
                }
                out.print(i + " :");
            }
            out.print(" " + Integer.toString(this.attributeBytes[i] & 0xFF, 16));
            ++i;
        }
        out.println();
    }
}

