/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ClassAttribute;
import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.ConstClass;
import com.sap.jdo.enhancer.classfile.ConstUtf8;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import com.sap.jdo.enhancer.classfile.ExceptionsAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class ExceptionsAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "Exceptions";
    private Vector exceptionTable;

    public Enumeration exceptions() {
        return this.exceptionTable.elements();
    }

    public Vector getExceptions() {
        return this.exceptionTable;
    }

    public ExceptionsAttribute(ConstUtf8 attrName, Vector excTable) {
        super(attrName);
        this.exceptionTable = excTable;
    }

    public ExceptionsAttribute(ConstUtf8 attrName, ConstClass exc) {
        super(attrName);
        this.exceptionTable = new Vector(1);
        this.exceptionTable.addElement(exc);
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof ExceptionsAttribute)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        ExceptionsAttribute other = (ExceptionsAttribute)obj;
        if (!super.isEqual(msg, other)) {
            return false;
        }
        if (this.exceptionTable.size() != other.exceptionTable.size()) {
            msg.push("exceptionTable.size() " + String.valueOf(other.exceptionTable.size()));
            msg.push("exceptionTable.size() " + String.valueOf(this.exceptionTable.size()));
            return false;
        }
        class ConstClassComparator
        implements Comparator {
            private final /* synthetic */ ExceptionsAttribute this$0;

            ConstClassComparator(ExceptionsAttribute this$0) {
                this.this$0 = this$0;
            }

            public int compare(Object o1, Object o2) {
                ConstClass c1 = (ConstClass)o1;
                ConstClass c2 = (ConstClass)o2;
                String s1 = c1.className().asString();
                String s2 = c2.className().asString();
                return s1.compareTo(s2);
            }
        }
        ConstClassComparator comparator = new ConstClassComparator(this);
        ConstClass[] thisExceptionTable = this.exceptionTable.toArray(new ConstClass[0]);
        ConstClass[] otherExceptionTable = other.exceptionTable.toArray(new ConstClass[0]);
        Arrays.sort(thisExceptionTable, comparator);
        Arrays.sort(otherExceptionTable, comparator);
        int i = 0;
        while (i < this.exceptionTable.size()) {
            ConstClass c1 = thisExceptionTable[i];
            ConstClass c2 = otherExceptionTable[i];
            if (!c1.isEqual(msg, c2)) {
                msg.push("exceptionTable[i] = " + String.valueOf(c2));
                msg.push("exceptionTable[i] = " + String.valueOf(c1));
                return false;
            }
            ++i;
        }
        return true;
    }

    static ExceptionsAttribute read(ConstUtf8 attrName, DataInputStream data, ConstantPool pool) throws IOException {
        int nExcepts = data.readUnsignedShort();
        Vector<ConstClass> excTable = new Vector<ConstClass>();
        while (nExcepts-- > 0) {
            int excIndex = data.readUnsignedShort();
            ConstClass exc_class = null;
            if (excIndex != 0) {
                exc_class = (ConstClass)pool.constantAt(excIndex);
            }
            excTable.addElement(exc_class);
        }
        return new ExceptionsAttribute(attrName, excTable);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        out.writeInt(2 + 2 * this.exceptionTable.size());
        out.writeShort(this.exceptionTable.size());
        int i = 0;
        while (i < this.exceptionTable.size()) {
            out.writeShort(((ConstClass)this.exceptionTable.elementAt(i)).getIndex());
            ++i;
        }
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.print("Exceptions:");
        int i = 0;
        while (i < this.exceptionTable.size()) {
            out.print(" " + ((ConstClass)this.exceptionTable.elementAt(i)).asString());
            ++i;
        }
        out.println();
    }
}

