/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ClassAttribute;
import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.CodeEnv;
import com.sap.jdo.enhancer.classfile.ExceptionRange;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class ExceptionTable {
    private Vector handlers = new Vector();

    public Enumeration handlers() {
        return this.handlers.elements();
    }

    public void addElement(ExceptionRange range) {
        this.handlers.addElement(range);
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof ExceptionTable)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        ExceptionTable other = (ExceptionTable)obj;
        if (this.handlers.size() != other.handlers.size()) {
            msg.push("handlers.size() " + String.valueOf(other.handlers.size()));
            msg.push("handlers.size() " + String.valueOf(this.handlers.size()));
            return false;
        }
        int i = 0;
        while (i < this.handlers.size()) {
            ClassAttribute h2;
            ClassAttribute h1 = (ClassAttribute)this.handlers.get(i);
            if (!h1.isEqual(msg, h2 = (ClassAttribute)other.handlers.get(i))) {
                msg.push("handlers[" + i + "] = " + String.valueOf(h2));
                msg.push("handlers[" + i + "] = " + String.valueOf(h1));
                return false;
            }
            ++i;
        }
        return true;
    }

    static ExceptionTable read(DataInputStream data, CodeEnv env) throws IOException {
        ExceptionTable excTable = new ExceptionTable();
        int nExcepts = data.readUnsignedShort();
        while (nExcepts-- > 0) {
            excTable.addElement(ExceptionRange.read(data, env));
        }
        return excTable;
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.handlers.size());
        int i = 0;
        while (i < this.handlers.size()) {
            ((ExceptionRange)this.handlers.elementAt(i)).write(out);
            ++i;
        }
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println("Exception Table: ");
        int i = 0;
        while (i < this.handlers.size()) {
            ((ExceptionRange)this.handlers.elementAt(i)).print(out, indent + 2);
            ++i;
        }
    }
}

