/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ClassAttribute;
import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.ConstUtf8;
import com.sap.jdo.enhancer.classfile.ConstValue;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Stack;

public class ConstantValueAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "ConstantValue";
    private ConstValue constantValue;

    public ConstValue value() {
        return this.constantValue;
    }

    public ConstantValueAttribute(ConstUtf8 attrName, ConstValue value) {
        super(attrName);
        this.constantValue = value;
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof ConstantValueAttribute)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        ConstantValueAttribute other = (ConstantValueAttribute)obj;
        if (!super.isEqual(msg, other)) {
            return false;
        }
        if (!this.constantValue.isEqual(msg, other.constantValue)) {
            msg.push(String.valueOf("constantValue = " + other.constantValue));
            msg.push(String.valueOf("constantValue = " + this.constantValue));
            return false;
        }
        return true;
    }

    static ConstantValueAttribute read(ConstUtf8 attrName, DataInputStream data, ConstantPool pool) throws IOException {
        int index = 0;
        index = data.readUnsignedShort();
        return new ConstantValueAttribute(attrName, (ConstValue)pool.constantAt(index));
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        out.writeInt(2);
        out.writeShort(this.constantValue.getIndex());
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println("ConstantValue: " + this.constantValue.toString());
    }
}

