/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ConstBasic;
import com.sap.jdo.enhancer.classfile.ConstClass;
import com.sap.jdo.enhancer.classfile.ConstNameAndType;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Stack;

public abstract class ConstBasicMemberRef
extends ConstBasic {
    protected ConstClass theClassName;
    protected int theClassNameIndex;
    protected ConstNameAndType theNameAndType;
    protected int theNameAndTypeIndex;

    public ConstClass className() {
        return this.theClassName;
    }

    public ConstNameAndType nameAndType() {
        return this.theNameAndType;
    }

    public String toString() {
        return "className(" + this.theClassName.toString() + ")" + " nameAndType(" + this.theNameAndType.toString() + ")";
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof ConstBasicMemberRef)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        ConstBasicMemberRef other = (ConstBasicMemberRef)obj;
        if (!super.isEqual(msg, other)) {
            return false;
        }
        if (!this.theClassName.isEqual(msg, other.theClassName)) {
            msg.push(String.valueOf("theClassName = " + other.theClassName));
            msg.push(String.valueOf("theClassName = " + this.theClassName));
            return false;
        }
        if (!this.theNameAndType.isEqual(msg, other.theNameAndType)) {
            msg.push(String.valueOf("theNameAndType = " + other.theNameAndType));
            msg.push(String.valueOf("theNameAndType = " + this.theNameAndType));
            return false;
        }
        return true;
    }

    ConstBasicMemberRef(ConstClass cname, ConstNameAndType NT) {
        this.theClassName = cname;
        this.theNameAndType = NT;
    }

    ConstBasicMemberRef(int cnameIndex, int NT_index) {
        this.theClassNameIndex = cnameIndex;
        this.theNameAndTypeIndex = NT_index;
    }

    void formatData(DataOutputStream b) throws IOException {
        b.writeShort(this.theClassName.getIndex());
        b.writeShort(this.theNameAndType.getIndex());
    }

    void resolve(ConstantPool p) {
        this.theClassName = (ConstClass)p.constantAt(this.theClassNameIndex);
        this.theNameAndType = (ConstNameAndType)p.constantAt(this.theNameAndTypeIndex);
    }
}

