/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.AttributeVector;
import com.sap.jdo.enhancer.classfile.ClassAttribute;
import com.sap.jdo.enhancer.classfile.ClassMember;
import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.CodeAttribute;
import com.sap.jdo.enhancer.classfile.ConstUtf8;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import com.sap.jdo.enhancer.classfile.ExceptionsAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Stack;

public class ClassMethod
extends ClassMember {
    public static final String intializerName = "<init>";
    public static final String staticIntializerName = "<clinit>";
    private int accessFlags;
    private ConstUtf8 methodName;
    private ConstUtf8 methodSignature;
    private AttributeVector methodAttributes;

    public int access() {
        return this.accessFlags;
    }

    public void setAccess(int newFlags) {
        this.accessFlags = newFlags;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isNative() {
        return (this.accessFlags & 0x100) != 0;
    }

    public ConstUtf8 name() {
        return this.methodName;
    }

    public void changeName(ConstUtf8 name) {
        this.methodName = name;
    }

    public ConstUtf8 signature() {
        return this.methodSignature;
    }

    public void changeSignature(ConstUtf8 newSig) {
        this.methodSignature = newSig;
    }

    public AttributeVector attributes() {
        return this.methodAttributes;
    }

    public ClassMethod(int accFlags, ConstUtf8 name, ConstUtf8 sig, AttributeVector methodAttrs) {
        this.accessFlags = accFlags;
        this.methodName = name;
        this.methodSignature = sig;
        this.methodAttributes = methodAttrs;
    }

    int codeSize() {
        CodeAttribute codeAttr = this.codeAttribute();
        return codeAttr == null ? 0 : codeAttr.codeSize();
    }

    public CodeAttribute codeAttribute() {
        Enumeration e = this.methodAttributes.elements();
        while (e.hasMoreElements()) {
            ClassAttribute attr = (ClassAttribute)e.nextElement();
            if (!(attr instanceof CodeAttribute)) continue;
            return (CodeAttribute)attr;
        }
        return null;
    }

    public ExceptionsAttribute exceptionsAttribute() {
        Enumeration e = this.methodAttributes.elements();
        while (e.hasMoreElements()) {
            ClassAttribute attr = (ClassAttribute)e.nextElement();
            if (!(attr instanceof ExceptionsAttribute)) continue;
            return (ExceptionsAttribute)attr;
        }
        return null;
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof ClassMethod)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        ClassMethod other = (ClassMethod)obj;
        if (!super.isEqual(msg, other)) {
            return false;
        }
        if (this.accessFlags != other.accessFlags) {
            msg.push(String.valueOf("accessFlags = 0x" + Integer.toHexString(other.accessFlags)));
            msg.push(String.valueOf("accessFlags = 0x" + Integer.toHexString(this.accessFlags)));
            return false;
        }
        if (!this.methodName.isEqual(msg, other.methodName)) {
            msg.push(String.valueOf("methodName = " + other.methodName));
            msg.push(String.valueOf("methodName = " + this.methodName));
            return false;
        }
        if (!this.methodSignature.isEqual(msg, other.methodSignature)) {
            msg.push(String.valueOf("methodSignature = " + other.methodSignature));
            msg.push(String.valueOf("methodSignature = " + this.methodSignature));
            return false;
        }
        if (!this.methodAttributes.isEqual(msg, other.methodAttributes)) {
            msg.push(String.valueOf("methodAttributes = " + other.methodAttributes));
            msg.push(String.valueOf("methodAttributes = " + this.methodAttributes));
            return false;
        }
        return true;
    }

    public void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.print("'" + this.methodName.asString() + "'");
        out.print(" sig = " + this.methodSignature.asString());
        out.print(" accessFlags = " + Integer.toString(this.accessFlags));
        out.println(" attributes:");
        this.methodAttributes.print(out, indent + 2);
    }

    static ClassMethod read(DataInputStream data, ConstantPool pool) throws IOException {
        int accessFlags = data.readUnsignedShort();
        int nameIndex = data.readUnsignedShort();
        int sigIndex = data.readUnsignedShort();
        ClassMethod f = new ClassMethod(accessFlags, (ConstUtf8)pool.constantAt(nameIndex), (ConstUtf8)pool.constantAt(sigIndex), null);
        f.methodAttributes = AttributeVector.readAttributes(data, pool);
        return f;
    }

    void write(DataOutputStream data) throws IOException {
        CodeAttribute codeAttr = this.codeAttribute();
        data.writeShort(this.accessFlags);
        data.writeShort(this.methodName.getIndex());
        data.writeShort(this.methodSignature.getIndex());
        this.methodAttributes.write(data);
    }
}

