/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.AnnotatedClassAttribute;
import com.sap.jdo.enhancer.classfile.AnnotatedMethodAttribute;
import com.sap.jdo.enhancer.classfile.CodeAttribute;
import com.sap.jdo.enhancer.classfile.CodeEnv;
import com.sap.jdo.enhancer.classfile.ConstUtf8;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import com.sap.jdo.enhancer.classfile.ConstantValueAttribute;
import com.sap.jdo.enhancer.classfile.ExceptionsAttribute;
import com.sap.jdo.enhancer.classfile.GenericAttribute;
import com.sap.jdo.enhancer.classfile.LineNumberTableAttribute;
import com.sap.jdo.enhancer.classfile.LocalVariableTableAttribute;
import com.sap.jdo.enhancer.classfile.SourceFileAttribute;
import com.sap.jdo.enhancer.classfile.SyntheticAttribute;
import com.sap.jdo.enhancer.classfile.VMConstants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Stack;

public abstract class ClassAttribute
implements VMConstants {
    private ConstUtf8 attributeName;

    public ConstUtf8 attrName() {
        return this.attributeName;
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof ClassAttribute)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        ClassAttribute other = (ClassAttribute)obj;
        if (!this.attributeName.isEqual(msg, other.attributeName)) {
            msg.push(String.valueOf("attributeName = " + other.attributeName));
            msg.push(String.valueOf("attributeName = " + this.attributeName));
            return false;
        }
        return true;
    }

    ClassAttribute(ConstUtf8 theAttrName) {
        this.attributeName = theAttrName;
    }

    static ClassAttribute read(DataInputStream data, ConstantPool pool) throws IOException {
        ClassAttribute attr = null;
        int attrNameIndex = data.readUnsignedShort();
        ConstUtf8 attrName8 = (ConstUtf8)pool.constantAt(attrNameIndex);
        String attrName = attrName8.asString();
        int attrLength = data.readInt();
        if (attrName.equals("Code")) {
            attr = CodeAttribute.read(attrName8, attrLength, data, pool);
        } else if (attrName.equals("SourceFile")) {
            attr = SourceFileAttribute.read(attrName8, data, pool);
        } else if (attrName.equals("ConstantValue")) {
            attr = ConstantValueAttribute.read(attrName8, data, pool);
        } else if (attrName.equals("Exceptions")) {
            attr = ExceptionsAttribute.read(attrName8, data, pool);
        } else if (attrName.equals("filter.annotatedClass")) {
            attr = AnnotatedClassAttribute.read(attrName8, data, pool);
        } else {
            byte[] attrBytes = new byte[attrLength];
            data.readFully(attrBytes);
            attr = new GenericAttribute(attrName8, attrBytes);
        }
        return attr;
    }

    static ClassAttribute read(DataInputStream data, CodeEnv env) throws IOException {
        ClassAttribute attr = null;
        int attrNameIndex = data.readUnsignedShort();
        ConstUtf8 attrName8 = (ConstUtf8)env.pool().constantAt(attrNameIndex);
        String attrName = attrName8.asString();
        int attrLength = data.readInt();
        if (attrName.equals("LineNumberTable")) {
            attr = LineNumberTableAttribute.read(attrName8, data, env);
        } else if (attrName.equals("LocalVariableTable")) {
            attr = LocalVariableTableAttribute.read(attrName8, data, env);
        } else if (attrName.equals("filter.annotatedMethod")) {
            attr = AnnotatedMethodAttribute.read(attrName8, data, env);
        } else if (attrName.equals("Synthetic")) {
            attr = SyntheticAttribute.read(attrName8, data, env.pool());
        } else {
            byte[] attrBytes = new byte[attrLength];
            data.readFully(attrBytes);
            attr = new GenericAttribute(attrName8, attrBytes);
        }
        return attr;
    }

    abstract void write(DataOutputStream var1) throws IOException;

    abstract void print(PrintStream var1, int var2);
}

