/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer;

import com.sap.jdo.enhancer.OptionSet;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MetaDataOptions
extends OptionSet {
    final OptionSet.UsageOption help = this.createUsageOption("help", "h", "              : print usage message and exit");
    final OptionSet.BooleanOption verbose = this.createBooleanOption("verbose", "v", "           : print verbose messages");
    final OptionSet.BooleanOption doTiming = this.createBooleanOption("timing", "t", "            : do timing messures");
    final OptionSet.StringOption sourcePath = this.createStringOption("sourcepath", "s", "<path>  : source path for jdo and classfiles");
    final OptionSet.StringOption propFileName = this.createStringOption("properties", null, "<file>  : use property file for jdo meta data");
    final List classNames = new ArrayList();
    final List classFileNames = new ArrayList();
    final List zipFileNames = new ArrayList();
    final List jdoFileNames = new ArrayList();

    public MetaDataOptions(PrintWriter out, PrintWriter err) {
        super(out, err);
    }

    public static String asString(List list) {
        StringBuffer s = new StringBuffer();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            s.append(" " + i.next());
        }
        return s.toString();
    }

    public void printArgumentUsage() {
        this.printlnErr(this.indent + "<class>       the fully qualified name of a Java class");
        this.printlnErr(this.indent + "<jdofile>     the name of a .jdo file");
        this.printlnErr(this.indent + "<classfile>   the name of a .class file");
        this.printlnErr(this.indent + "<zipfile>     the name of a .zip or .jar file");
    }

    public void printArguments() {
        this.println();
        this.println(this.argumentsHeader);
        this.printListArgument("classNames", this.classNames);
        this.printListArgument("jdoFileNames", this.jdoFileNames);
        this.printListArgument("classFileNames", this.classFileNames);
        this.printListArgument("zipFileNames", this.zipFileNames);
    }

    public void printListArgument(String name, List list) {
        this.print(this.indent);
        this.println(name + " =" + MetaDataOptions.asString(list));
        this.println();
    }

    public int check() {
        Iterator names = this.arguments.iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            if (MetaDataOptions.isJdoFileName(name)) {
                this.jdoFileNames.add(name);
                continue;
            }
            if (MetaDataOptions.isClassFileName(name)) {
                this.classFileNames.add(name);
                continue;
            }
            if (MetaDataOptions.isZipFileName(name)) {
                this.zipFileNames.add(name);
                continue;
            }
            this.classNames.add(name);
        }
        if (this.verbose.value) {
            this.printAll();
        }
        if (this.classNames.isEmpty() && this.classFileNames.isEmpty() && this.zipFileNames.isEmpty()) {
            String msg = "No classes specified";
            this.printlnErr("No classes specified");
            this.printUsage();
            return -1;
        }
        return 0;
    }

    private static boolean isClassFileName(String filename) {
        return filename.endsWith(".class");
    }

    private static boolean isZipFileName(String filename) {
        int n = filename.length();
        if (n < 5) {
            return false;
        }
        String ext = filename.substring(n - 4);
        return ext.equalsIgnoreCase(".zip") || ext.equalsIgnoreCase(".jar");
    }

    private static boolean isJarFileName(String filename) {
        int n = filename.length();
        if (n < 5) {
            return false;
        }
        String ext = filename.substring(n - 4);
        return ext.equalsIgnoreCase(".jar");
    }

    private static boolean isJdoFileName(String filename) {
        return filename.endsWith(".jdo");
    }

    public static void main(String[] args) {
        PrintWriter out = new PrintWriter(System.out, true);
        MetaDataOptions options = new MetaDataOptions(out, out);
        options.parse(args);
    }
}

