/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.sco.sap;

import com.sap.jdo.StateManagerInternal;
import com.sap.jdo.common.model.jdo.RuntimeJDOModelFactoryImpl;
import com.sap.jdo.common.model.jdo.util.TypeSupport;
import com.sap.jdo.common.sco.ScoCollection;
import com.sap.jdo.common.sco.sap.SCOCollectionElements;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.spi.PersistenceCapable;

public class HashSet
extends com.sap.jdo.common.sco.HashSet
implements SCOCollectionElements {
    private transient java.util.HashSet added = new java.util.HashSet();
    private transient java.util.HashSet removed = new java.util.HashSet();
    private transient Object clonedInstance = null;
    private transient java.util.HashSet nonPCObjects = null;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;

    public HashSet(Class elementType, boolean allowNulls) {
        super(elementType, allowNulls);
        if (!(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = HashSet.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(elementType)) {
            this.nonPCObjects = new java.util.HashSet();
        }
    }

    public HashSet(Class elementType, boolean allowNulls, int initialCapacity) {
        super(elementType, allowNulls, initialCapacity);
        if (!(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = HashSet.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(elementType)) {
            this.nonPCObjects = new java.util.HashSet();
        }
    }

    public HashSet(Class elementType, boolean allowNulls, int initialCapacity, float loadFactor) {
        super(elementType, allowNulls, initialCapacity, loadFactor);
        if (!(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = HashSet.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(elementType)) {
            this.nonPCObjects = new java.util.HashSet();
        }
    }

    public boolean add(Object o) {
        boolean modified = super.add(o);
        if (modified) {
            if (o instanceof PersistenceCapable) {
                if (!this.removed.remove(o)) {
                    this.added.add(o);
                }
            } else if (this.nonPCObjects != null) {
                this.nonPCObjects.add(o);
            }
        }
        return modified;
    }

    public boolean addAll(Collection c) {
        boolean modified = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (super.contains(o)) continue;
            super.add(o);
            if (o instanceof PersistenceCapable) {
                if (!this.removed.remove(o)) {
                    this.added.add(o);
                }
            } else if (this.nonPCObjects != null) {
                this.nonPCObjects.add(o);
            }
            modified = true;
        }
        return modified;
    }

    public boolean remove(Object o) {
        boolean modified = super.remove(o);
        if (modified) {
            if (o instanceof PersistenceCapable) {
                if (!this.added.remove(o)) {
                    this.removed.add(o);
                }
            } else if (this.nonPCObjects != null) {
                this.nonPCObjects.remove(o);
            }
        }
        return modified;
    }

    public boolean removeAll(Collection c) {
        boolean modified = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!super.contains(o)) continue;
            super.remove(o);
            modified = true;
            if (o instanceof PersistenceCapable) {
                if (this.added.remove(o)) continue;
                this.removed.add(o);
                continue;
            }
            if (this.nonPCObjects == null) continue;
            this.nonPCObjects.remove(o);
        }
        return modified;
    }

    public boolean retainAll(Collection c) {
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (c.contains(o) || !(o instanceof PersistenceCapable) || this.added.remove(o)) continue;
            this.removed.add(o);
        }
        if (this.nonPCObjects != null) {
            this.nonPCObjects.retainAll(c);
        }
        return super.retainAll(c);
    }

    public void clear() {
        this.removed.clear();
        this.added.clear();
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof PersistenceCapable)) continue;
            this.removed.add(o);
        }
        if (this.nonPCObjects != null) {
            this.nonPCObjects.clear();
        }
        super.clear();
    }

    public void resetElements() {
        this.added.clear();
        this.removed.clear();
    }

    public Collection getAddedSetElements(Object lastImage) {
        if (this.isClonedLastImage(lastImage)) {
            return this.added;
        }
        java.util.HashSet added = new java.util.HashSet();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof PersistenceCapable)) continue;
            added.add(o);
        }
        if (lastImage != null) {
            Iterator it2 = ((Collection)lastImage).iterator();
            while (it2.hasNext()) {
                Object entry = it2.next();
                if (!this.contains(entry)) continue;
                added.remove(entry);
            }
        }
        return added;
    }

    public HashMap getAddedColElements(Object lastImage) {
        if (lastImage == null || this.isClonedLastImage(lastImage)) {
            HashMap addedSet = new HashMap(this.added.size());
            Iterator it = this.added.iterator();
            while (it.hasNext()) {
                Object o;
                Object oid = o = it.next();
                if (o instanceof PersistenceCapable && (oid = ((PersistenceCapable)o).jdoGetObjectId()) == null) {
                    oid = o;
                }
                addedSet.put(oid, new ScoCollection.EntryPair(1, o));
            }
            return addedSet;
        }
        HashMap addedSet = new HashMap(this.added.size());
        Iterator it = this.added.iterator();
        while (it.hasNext()) {
            Object o;
            Object oid = o = it.next();
            if (((Collection)lastImage).contains(o)) continue;
            if (o instanceof PersistenceCapable && (oid = ((PersistenceCapable)o).jdoGetObjectId()) == null) {
                oid = o;
            }
            addedSet.put(oid, new ScoCollection.EntryPair(1, o));
        }
        return addedSet;
    }

    public Collection getRemovedElements(Object lastImage) {
        if (this.isClonedLastImage(lastImage)) {
            return this.removed;
        }
        java.util.HashSet removed = new java.util.HashSet();
        if (lastImage != null) {
            Iterator it = ((Collection)lastImage).iterator();
            while (it.hasNext()) {
                Object entry = it.next();
                if (this.contains(entry)) continue;
                removed.add(entry);
            }
        }
        return removed;
    }

    public void clearInternal() {
        super.clearInternal();
        if (this.nonPCObjects != null) {
            this.nonPCObjects.clear();
        }
        this.resetElements();
    }

    public Object clone() {
        Object obj = super.clone();
        if (((HashSet)obj).nonPCObjects != null) {
            ((HashSet)obj).nonPCObjects = (java.util.HashSet)this.nonPCObjects.clone();
        }
        ((HashSet)obj).setClonedInstance(this);
        return obj;
    }

    private boolean isClonedLastImage(Object lastImage) {
        return lastImage instanceof HashSet && ((HashSet)lastImage).isClonedFrom(this);
    }

    private void setClonedInstance(Object obj) {
        this.clonedInstance = obj;
    }

    private boolean isClonedFrom(Object obj) {
        return this.clonedInstance == obj;
    }

    public HashMap getChangedColElements(Object lastImage) {
        return null;
    }

    public Collection getNonPCObjects() {
        return this.nonPCObjects;
    }

    public byte getNonPCObjectsChanges(Object lastImage) {
        java.util.HashSet lastSet = null;
        if (lastImage != null) {
            lastSet = ((HashSet)lastImage).nonPCObjects;
        }
        if (this.nonPCObjects != null && this.nonPCObjects.size() != 0 && lastSet != null) {
            if (this.nonPCObjects.equals(lastSet)) {
                return 0;
            }
            return 2;
        }
        if ((this.nonPCObjects == null || this.nonPCObjects.size() == 0) && lastSet != null) {
            return 3;
        }
        if (this.nonPCObjects != null && lastSet == null) {
            return 1;
        }
        return 0;
    }

    public void addAllInternal(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.addInternal(it.next());
        }
    }

    public void addInternal(Object o) {
        if (!(o instanceof PersistenceCapable)) {
            this.nonPCObjects.add(o);
        }
        super.addInternal(o);
    }

    public void setOwner(Object owner, int fieldNumber) {
        super.setOwner(owner, fieldNumber);
        if (owner != null && owner instanceof StateManagerInternal) {
            try {
                JDOModel jdoModel = RuntimeJDOModelFactoryImpl.getInstance().getJDOModel(((StateManagerInternal)owner).getPCClass().getClassLoader());
                if (TypeSupport.isValueType(jdoModel, super.getElementType())) {
                    this.nonPCObjects = null;
                }
            }
            catch (JDOModelException e) {
                throw new JDOFatalInternalException("Error during JDOModel access.", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

