/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.sco;

import com.sap.jdo.StateManagerInternal;
import com.sap.tc.logging.Location;
import javax.jdo.I18NHelper;
import javax.jdo.JDOUserException;

class SCOHelper {
    private static final String EXC_ElementNullsNotAllowed = "EXC_ElementNullsNotAllowed";
    private static final String EXC_KeyNullsNotAllowed = "EXC_KeyNullsNotAllowed";
    private static final String EXC_ValueNullsNotAllowed = "EXC_ValueNullsNotAllowed";
    private static final String EXC_ElementClassCastException = "EXC_ElementClassCastException";
    private static final String EXC_KeyClassCastException = "EXC_KeyClassCastException";
    private static final String EXC_ValueClassCastException = "EXC_ValueClassCastException";
    private static final I18NHelper msg = I18NHelper.getInstance((String)"com.sap.jdo.common.sco.Bundle");
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jdo$common$sco$SCOHelper == null ? (class$com$sap$jdo$common$sco$SCOHelper = SCOHelper.class$("com.sap.jdo.common.sco.SCOHelper")) : class$com$sap$jdo$common$sco$SCOHelper));
    static /* synthetic */ Class class$com$sap$jdo$common$sco$SCOHelper;

    SCOHelper() {
    }

    protected static void assertNullsAllowed(Object o, boolean allowNulls) {
        SCOHelper.assertNulls(o, allowNulls, EXC_ElementNullsNotAllowed);
    }

    protected static void assertNullKeysAllowed(Object o, boolean allowNulls) {
        SCOHelper.assertNulls(o, allowNulls, EXC_KeyNullsNotAllowed);
    }

    protected static void assertNullValuesAllowed(Object o, boolean allowNulls) {
        SCOHelper.assertNulls(o, allowNulls, EXC_ValueNullsNotAllowed);
    }

    protected static void assertElementType(Object o, Class elementType) {
        SCOHelper.assertType(o, elementType, EXC_ElementClassCastException);
    }

    protected static void assertKeyType(Object o, Class keyType) {
        SCOHelper.assertType(o, keyType, EXC_KeyClassCastException);
    }

    protected static void assertValueType(Object o, Class valueType) {
        SCOHelper.assertType(o, valueType, EXC_ValueClassCastException);
    }

    protected static void validateResult(int l, Throwable[] err) {
        if (l > 0) {
            Throwable[] t = new Throwable[l];
            System.arraycopy(err, 0, t, 0, l);
            throw new JDOUserException(msg.msg("EXC_FailedToProcessAll"), t);
        }
    }

    protected static void assertNulls(Object o, boolean allowNulls, String exc) {
        if (!allowNulls && o == null) {
            throw new JDOUserException(msg.msg(exc));
        }
    }

    private static void assertType(Object o, Class type, String exc) {
        if (type != null && !type.isAssignableFrom(o.getClass())) {
            throw new JDOUserException(msg.msg(exc, (Object)type.getName()), (Throwable[])new Exception[]{new ClassCastException()}, o);
        }
    }

    protected static Object getOwner(StateManagerInternal owner) {
        return owner == null ? null : owner.getObject();
    }

    protected static String getFieldName(StateManagerInternal owner, int fieldNumber) {
        return owner == null ? null : owner.getFieldName(fieldNumber);
    }

    protected static void debug(String subLocation, String msg) {
        if (LOCATION.bePath()) {
            LOCATION.pathT(subLocation, msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

