/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.sco;

import com.sap.jdo.SCO;
import com.sap.jdo.SCOCollection;
import com.sap.jdo.StateManagerInternal;
import com.sap.jdo.common.sco.SCOHelper;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.jdo.I18NHelper;

public class ArrayList
extends java.util.ArrayList
implements SCOCollection {
    private transient StateManagerInternal owner;
    private transient int fieldNumber = -1;
    private transient Class elementType;
    private transient boolean allowNulls;
    private transient Vector added = new Vector();
    private transient Vector removed = new Vector();
    private static final I18NHelper msg = I18NHelper.getInstance((String)"com.sap.jdo.common.sco.Bundle");
    private static final String _ArrayList = "ArrayList";

    public ArrayList(Class elementType, boolean allowNulls) {
        this.elementType = elementType;
        this.allowNulls = allowNulls;
    }

    public ArrayList(Class elementType, boolean allowNulls, int initialCapacity) {
        super(initialCapacity);
        this.elementType = elementType;
        this.allowNulls = allowNulls;
    }

    public Object set(int index, Object element) {
        SCOHelper.debug(_ArrayList, "set");
        if (element == null) {
            SCOHelper.assertNullsAllowed(element, this.allowNulls);
            return this.remove(index);
        }
        SCOHelper.assertElementType(element, this.elementType);
        this.makeDirty();
        Object o = super.set(index, element);
        if (!this.added.remove(o)) {
            this.removed.add(o);
        }
        if (!this.removed.remove(element)) {
            this.added.add(element);
        }
        this.trackUpdates(true);
        return o;
    }

    public boolean add(Object o) {
        SCOHelper.debug(_ArrayList, "add");
        SCOHelper.assertNullsAllowed(o, this.allowNulls);
        SCOHelper.assertElementType(o, this.elementType);
        this.makeDirty();
        if (!this.removed.remove(o)) {
            this.added.add(o);
        }
        boolean modified = super.add(o);
        this.trackUpdates(modified);
        return modified;
    }

    public boolean remove(Object o) {
        SCOHelper.debug(_ArrayList, "remove");
        this.makeDirty();
        int i = super.indexOf(o);
        Object obj = null;
        if (i > -1) {
            obj = super.remove(i);
            if (!this.added.remove(obj)) {
                this.removed.add(obj);
            }
            this.trackUpdates(true);
            return true;
        }
        return false;
    }

    public void add(int index, Object element) {
        SCOHelper.debug(_ArrayList, "add by index");
        SCOHelper.assertNullsAllowed(element, this.allowNulls);
        SCOHelper.assertElementType(element, this.elementType);
        this.makeDirty();
        super.add(index, element);
        if (!this.removed.remove(element)) {
            this.added.add(element);
        }
        this.trackUpdates(true);
    }

    public Object remove(int index) {
        SCOHelper.debug(_ArrayList, "remove by index");
        this.makeDirty();
        Object obj = super.remove(index);
        if (!this.added.remove(obj)) {
            this.removed.add(obj);
        }
        this.trackUpdates(true);
        return obj;
    }

    public void clear() {
        SCOHelper.debug(_ArrayList, "clear");
        this.makeDirty();
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (this.added.remove(o)) continue;
            this.removed.add(o);
        }
        this.added.clear();
        super.clear();
        this.trackUpdates(true);
    }

    public boolean addAll(Collection c) {
        SCOHelper.debug(_ArrayList, "addAll");
        Throwable[] err = new Throwable[c.size()];
        int l = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            try {
                SCOHelper.assertNullsAllowed(o, this.allowNulls);
                SCOHelper.assertElementType(o, this.elementType);
            }
            catch (Throwable e) {
                err[l++] = e;
            }
        }
        SCOHelper.validateResult(l, err);
        this.makeDirty();
        this.removed.removeAll(c);
        this.added.addAll(c);
        boolean modified = super.addAll(c);
        this.trackUpdates(modified);
        return modified;
    }

    public boolean removeAll(Collection c) {
        SCOHelper.debug(_ArrayList, "removeAll");
        boolean modified = false;
        this.makeDirty();
        Iterator e = c.iterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (!super.contains(o)) continue;
            this.removeInternal(o);
            if (!this.added.remove(o)) {
                this.removed.add(o);
            }
            modified = true;
        }
        this.trackUpdates(modified);
        return modified;
    }

    public boolean addAll(int index, Collection c) {
        SCOHelper.debug(_ArrayList, "addAll from index");
        Throwable[] err = new Throwable[c.size()];
        int l = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            try {
                SCOHelper.assertNullsAllowed(o, this.allowNulls);
                SCOHelper.assertElementType(o, this.elementType);
            }
            catch (Throwable e) {
                err[l++] = e;
            }
        }
        SCOHelper.validateResult(l, err);
        this.makeDirty();
        this.removed.removeAll(c);
        this.added.addAll(c);
        boolean modified = super.addAll(index, c);
        this.trackUpdates(modified);
        return modified;
    }

    public boolean retainAll(Collection c) {
        SCOHelper.debug(_ArrayList, "retainAll");
        boolean modified = false;
        java.util.ArrayList v = new java.util.ArrayList();
        this.makeDirty();
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (c.contains(o)) continue;
            v.add(o);
            if (!this.added.remove(o)) {
                this.removed.add(o);
            }
            modified = true;
        }
        Iterator iter2 = ((AbstractList)v).iterator();
        while (iter2.hasNext()) {
            this.removeInternal(iter2.next());
        }
        this.trackUpdates(modified);
        return modified;
    }

    public Object clone() {
        SCOHelper.debug(_ArrayList, "clone");
        Object obj = super.clone();
        if (obj instanceof SCO) {
            ((SCO)obj).unsetOwner(this.owner, this.fieldNumber);
        }
        return obj;
    }

    public void reset() {
        this.added.clear();
        this.removed.clear();
    }

    public void addInternal(Object o) {
        super.add(o);
    }

    public void addAllInternal(Collection c) {
        super.addAll(c);
    }

    public Collection getAdded() {
        return this.added;
    }

    public Collection getRemoved() {
        return this.removed;
    }

    public void clearInternal() {
        super.clear();
        this.reset();
    }

    public void removeInternal(Object o) {
        int i = super.indexOf(o);
        super.remove(i);
    }

    public void unsetOwner(Object owner, int fieldNumber) {
        if (this.owner == owner && this.fieldNumber == fieldNumber) {
            this.owner = null;
            this.fieldNumber = -1;
        }
    }

    private void makeDirty() {
        if (this.owner != null) {
            this.owner.makeDirty(this.fieldNumber);
        }
    }

    private void trackUpdates(boolean modified) {
        if (modified && this.owner != null) {
            this.owner.trackUpdates(this.fieldNumber, this);
        }
    }

    public void setOwner(Object owner, int fieldNumber) {
        if (this.owner == null && owner instanceof StateManagerInternal) {
            this.owner = (StateManagerInternal)owner;
            this.fieldNumber = fieldNumber;
        }
    }

    public Object getOwner() {
        return SCOHelper.getOwner(this.owner);
    }

    public String getFieldName() {
        return SCOHelper.getFieldName(this.owner, this.fieldNumber);
    }

    public Class getElementType() {
        return this.elementType;
    }

    public boolean allowNulls() {
        return this.allowNulls;
    }
}

