/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.model.jdo.xml;

import com.sap.jdo.common.model.jdo.xml.JDOHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Stack;
import javax.jdo.JDOFatalInternalException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class JDOParser
implements ContentHandler {
    private StringBuffer buffer;
    private JDOHandler handler;
    private Stack context;
    static /* synthetic */ Class class$com$sap$jdo$common$model$jdo$xml$JDOParser;

    public JDOParser(JDOHandler handler) {
        this.handler = handler;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String ns, String name, String qname, Attributes attrs) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{qname, new AttributesImpl(attrs)});
        if ("package".equals(name)) {
            this.handler.start_package(attrs);
        } else if ("jdo".equals(name)) {
            this.handler.start_jdo(attrs);
        } else if ("class".equals(name)) {
            this.handler.start_class(attrs);
        } else if ("map".equals(name)) {
            this.handler.start_map(attrs);
        } else if ("field".equals(name)) {
            this.handler.start_field(attrs);
        } else if ("collection".equals(name)) {
            this.handler.start_collection(attrs);
        } else if ("extension".equals(name)) {
            this.handler.start_extension(attrs);
        } else if ("array".equals(name)) {
            this.handler.start_array(attrs);
        }
    }

    public void endElement(String ns, String name, String qname) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        if ("package".equals(name)) {
            this.handler.end_package();
        } else if ("jdo".equals(name)) {
            this.handler.end_jdo();
        } else if ("class".equals(name)) {
            this.handler.end_class();
        } else if ("map".equals(name)) {
            this.handler.end_map();
        } else if ("field".equals(name)) {
            this.handler.end_field();
        } else if ("collection".equals(name)) {
            this.handler.end_collection();
        } else if ("extension".equals(name)) {
            this.handler.end_extension();
        } else if ("array".equals(name)) {
            this.handler.end_array();
        }
    }

    public void characters(char[] chars, int start, int len) throws SAXException {
        this.buffer.append(chars, start, len);
    }

    public void ignorableWhitespace(char[] chars, int start, int len) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
        if (fireOnlyIfMixed && this.buffer.length() == 0) {
            return;
        }
        Object[] ctx = (Object[])this.context.peek();
        String here = (String)ctx[0];
        Attributes attrs = (Attributes)ctx[1];
        this.buffer.delete(0, this.buffer.length());
    }

    public void parse(InputSource input) throws SAXException, ParserConfigurationException, IOException {
        JDOParser.parse(input, this);
    }

    public void parse(URL url) throws SAXException, ParserConfigurationException, IOException {
        JDOParser.parse(new InputSource(url.toExternalForm()), this);
    }

    public static void parse(InputSource input, JDOHandler handler) throws SAXException, ParserConfigurationException, IOException {
        JDOParser.parse(input, new JDOParser(handler));
    }

    public static void parse(URL url, JDOHandler handler) throws SAXException, ParserConfigurationException, IOException {
        JDOParser.parse(new InputSource(url.toExternalForm()), handler);
    }

    private static void parse(InputSource input, JDOParser recognizer) throws SAXException, ParserConfigurationException, IOException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((class$com$sap$jdo$common$model$jdo$xml$JDOParser == null ? (class$com$sap$jdo$common$model$jdo$xml$JDOParser = JDOParser.class$("com.sap.jdo.common.model.jdo.xml.JDOParser")) : class$com$sap$jdo$common$model$jdo$xml$JDOParser).getClassLoader());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        XMLReader parser = factory.newSAXParser().getXMLReader();
        parser.setEntityResolver(new JDOEntityResolver());
        parser.setContentHandler(recognizer);
        parser.setErrorHandler(recognizer.getDefaultErrorHandler());
        parser.parse(input);
        Thread.currentThread().setContextClassLoader(contextClassLoader);
    }

    private ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            public void error(SAXParseException ex) throws SAXException {
                if (JDOParser.this.context.isEmpty()) {
                    System.err.println("Missing DOCTYPE.");
                }
                throw ex;
            }

            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            public void warning(SAXParseException ex) throws SAXException {
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JDOEntityResolver
    implements EntityResolver {
        private JDOEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId != null && systemId.endsWith("jdo.dtd")) {
                InputStream stream = this.getClass().getClassLoader().getResourceAsStream("javax/jdo/jdo.dtd");
                if (stream == null) {
                    throw new JDOFatalInternalException("cannot find JDO DTD");
                }
                return new InputSource(new InputStreamReader(stream));
            }
            return null;
        }
    }
}

