/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.model.jdo.util;

import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.model.jdo.JavaModel;
import com.sap.tc.logging.Location;
import java.util.HashSet;
import java.util.Set;

public class TypeSupport {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jdo$common$model$jdo$util$TypeSupport == null ? (class$com$sap$jdo$common$model$jdo$util$TypeSupport = TypeSupport.class$("com.sap.jdo.common.model.jdo.util.TypeSupport")) : class$com$sap$jdo$common$model$jdo$util$TypeSupport));
    private static Set primitiveTypes = new HashSet();
    private static Set valueClasses = new HashSet();
    private static Set collectionTypes = new HashSet();
    private static Set mapTypes = new HashSet();
    static /* synthetic */ Class class$com$sap$jdo$common$model$jdo$util$TypeSupport;

    public static boolean isPrimitiveTypeName(String typeName) {
        return primitiveTypes.contains(typeName);
    }

    public static boolean isCollectionType(JDOModel jdoModel, Object type) {
        JavaModel javaModel = jdoModel.getJavaModel();
        String typeName = javaModel.getTypeName(type);
        return collectionTypes.contains(typeName);
    }

    public static boolean isMapType(JDOModel jdoModel, Object type) {
        JavaModel javaModel = jdoModel.getJavaModel();
        String typeName = javaModel.getTypeName(type);
        return mapTypes.contains(typeName);
    }

    public static boolean isArrayType(JDOModel jdoModel, Object type) {
        JavaModel javaModel = jdoModel.getJavaModel();
        return javaModel.isArray(type);
    }

    public static boolean isValueType(JDOModel jdoModel, Object type) {
        JavaModel javaModel = jdoModel.getJavaModel();
        String typeName = javaModel.getTypeName(type);
        return TypeSupport.isPrimitiveTypeName(typeName) || valueClasses.contains(typeName);
    }

    public static boolean isValueArrayType(JDOModel jdoModel, Object type) {
        JavaModel javaModel = jdoModel.getJavaModel();
        if (javaModel.isArray(type)) {
            Object componentType = javaModel.getArrayComponentType(type);
            String componentTypeName = javaModel.getTypeName(componentType);
            return TypeSupport.isPrimitiveTypeName(componentTypeName) || valueClasses.contains(componentTypeName);
        }
        return false;
    }

    public static boolean isPersistenceFieldType(JDOModel jdoModel, Object type) {
        JavaModel javaModel = jdoModel.getJavaModel();
        String typeName = javaModel.getTypeName(type);
        return TypeSupport.isPrimitiveTypeName(typeName) || valueClasses.contains(typeName) || collectionTypes.contains(typeName) || mapTypes.contains(typeName) || TypeSupport.isPersistenceCapableTypeName(jdoModel, typeName) || TypeSupport.isPersistenceArrayType(jdoModel, type);
    }

    public static boolean isEmbeddedElementType(JDOModel jdoModel, Object type) {
        JavaModel javaModel = jdoModel.getJavaModel();
        String typeName = javaModel.getTypeName(type);
        return !TypeSupport.isPersistenceCapableTypeName(jdoModel, typeName) && !javaModel.isInterface(type);
    }

    public static boolean isEmbeddedFieldType(JDOModel jdoModel, Object type) {
        JavaModel javaModel = jdoModel.getJavaModel();
        String typeName = javaModel.getTypeName(type);
        return TypeSupport.isPrimitiveTypeName(typeName) || valueClasses.contains(typeName) || TypeSupport.isPersistenceArrayType(jdoModel, type);
    }

    public static boolean isPersistenceCapableTypeName(JDOModel jdoModel, String className) {
        if (TypeSupport.isPrimitiveTypeName(className) || valueClasses.contains(className) || collectionTypes.contains(className) || mapTypes.contains(className)) {
            return false;
        }
        try {
            return jdoModel.getJDOClass(className) != null;
        }
        catch (JDOModelException ex) {
            LOCATION.traceThrowableT(100, "isPersistenceCapableTypeName", (Throwable)ex);
            return false;
        }
    }

    public static Object resolveType(JDOModel jdoModel, String typeName, String packagePrefix) {
        Object type = null;
        JavaModel javaModel = jdoModel.getJavaModel();
        if (TypeSupport.isPrimitiveTypeName(typeName) || typeName.lastIndexOf(46) != -1) {
            type = javaModel.getTypeForName(typeName);
        } else {
            if (packagePrefix != null) {
                type = javaModel.getTypeForName(packagePrefix + typeName);
            }
            if (type == null) {
                type = javaModel.getTypeForName("java.lang." + typeName);
            }
            if (type == null) {
                return javaModel.getTypeForName(typeName);
            }
        }
        return type;
    }

    private static boolean isPersistenceArrayType(JDOModel jdoModel, Object type) {
        JavaModel javaModel = jdoModel.getJavaModel();
        if (javaModel.isArray(type)) {
            Object componentType = javaModel.getArrayComponentType(type);
            String componentTypeName = javaModel.getTypeName(componentType);
            return TypeSupport.isPrimitiveTypeName(componentTypeName) || valueClasses.contains(componentTypeName) || TypeSupport.isPersistenceCapableTypeName(jdoModel, componentTypeName);
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitiveTypes.add("boolean");
        primitiveTypes.add("byte");
        primitiveTypes.add("short");
        primitiveTypes.add("int");
        primitiveTypes.add("long");
        primitiveTypes.add("char");
        primitiveTypes.add("float");
        primitiveTypes.add("double");
        valueClasses.add("java.lang.Boolean");
        valueClasses.add("java.lang.Byte");
        valueClasses.add("java.lang.Short");
        valueClasses.add("java.lang.Integer");
        valueClasses.add("java.lang.Long");
        valueClasses.add("java.lang.Character");
        valueClasses.add("java.lang.Float");
        valueClasses.add("java.lang.Double");
        valueClasses.add("java.lang.String");
        valueClasses.add("java.lang.Number");
        valueClasses.add("java.math.BigDecimal");
        valueClasses.add("java.math.BigInteger");
        valueClasses.add("java.sql.Date");
        valueClasses.add("java.sql.Time");
        valueClasses.add("java.sql.Timestamp");
        valueClasses.add("java.util.Date");
        valueClasses.add("java.util.Locale");
        collectionTypes.add("java.util.ArrayList");
        collectionTypes.add("java.util.HashSet");
        collectionTypes.add("java.util.LinkedList");
        collectionTypes.add("java.util.TreeSet");
        collectionTypes.add("java.util.Vector");
        collectionTypes.add("java.util.Collection");
        collectionTypes.add("java.util.Set");
        collectionTypes.add("java.util.List");
        mapTypes.add("java.util.Map");
        mapTypes.add("java.util.HashMap");
        mapTypes.add("java.util.Hashtable");
        mapTypes.add("java.util.TreeMap");
    }
}

