/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.model.jdo.util;

import com.sap.jdo.model.jdo.JDOArray;
import com.sap.jdo.model.jdo.JDOClass;
import com.sap.jdo.model.jdo.JDOCollection;
import com.sap.jdo.model.jdo.JDOExtension;
import com.sap.jdo.model.jdo.JDOField;
import com.sap.jdo.model.jdo.JDOIdentityType;
import com.sap.jdo.model.jdo.JDOMap;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOReference;
import com.sap.jdo.model.jdo.JDORelationship;
import com.sap.jdo.model.jdo.NullValueTreatment;
import com.sap.jdo.model.jdo.PersistenceModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PrintSupport {
    public static void printJDOModel(JDOModel jdoModel) {
        JDOClass[] jdoClasses = jdoModel.getDeclaredClasses();
        int i = 0;
        while (i < jdoClasses.length) {
            PrintSupport.printJDOClass(0, jdoClasses[i]);
            ++i;
        }
    }

    public static void printJDOClass(JDOClass jdoClass) {
        PrintSupport.printJDOClass(0, jdoClass);
    }

    public static void printJDOFields(JDOField[] jdoFields) {
        PrintSupport.printJDOFields(0, jdoFields);
    }

    public static void printJDOField(JDOField jdoField) {
        PrintSupport.printJDOField(0, jdoField);
    }

    public static void printJDORelationship(JDORelationship jdoRelationship) {
        PrintSupport.printJDORelationship(0, jdoRelationship);
    }

    public static void printJDOExtensions(JDOExtension[] jdoExtensions) {
        PrintSupport.printJDOExtensions(0, jdoExtensions);
    }

    public static void printJDOExtension(JDOExtension jdoExtension) {
        PrintSupport.printJDOExtension(0, jdoExtension);
    }

    private static void printJDOClass(int indent, JDOClass jdoClass) {
        if (jdoClass == null) {
            return;
        }
        PrintSupport.println(indent, "--> JDOClass ");
        PrintSupport.println(indent + 1, "name                       = " + jdoClass.getName());
        PrintSupport.println(indent + 1, "packagePrefix              = " + jdoClass.getPackagePrefix());
        PrintSupport.println(indent + 1, "identityType               = " + JDOIdentityType.toString(jdoClass.getIdentityType()));
        PrintSupport.println(indent + 1, "objectIdClass              = " + jdoClass.getObjectIdClass());
        PrintSupport.println(indent + 1, "objectIdClassName          = " + jdoClass.getObjectIdClassName());
        PrintSupport.println(indent + 1, "requiresExtent             = " + jdoClass.requiresExtent());
        PrintSupport.println(indent + 1, "pcSuperclassName           = " + jdoClass.getPersistenceCapableSuperclassName());
        PrintSupport.println(indent + 1, "pcSuperclass               = " + jdoClass.getPersistenceCapableSuperclass());
        PrintSupport.println(indent + 1, "pcRootClass                = " + jdoClass.getPersistenceCapableRootClass());
        PrintSupport.println(indent + 1, "javaClass                  = " + jdoClass.getJavaClass());
        PrintSupport.println(indent + 1, "declaredManagedFieldCount  = " + jdoClass.getDeclaredManagedFieldCount());
        PrintSupport.println(indent + 1, "inheritedManagedFieldCount = " + jdoClass.getInheritedManagedFieldCount());
        PrintSupport.println(indent + 1, "managedFields              = " + Arrays.asList(jdoClass.getManagedFields()));
        PrintSupport.println(indent + 1, "managedFieldNumbers        = " + PrintSupport.asList(jdoClass.getManagedFieldNumbers()));
        PrintSupport.println(indent + 1, "persistentFieldNumbers     = " + PrintSupport.asList(jdoClass.getPersistentFieldNumbers()));
        PrintSupport.println(indent + 1, "primaryKeyFieldNumers      = " + PrintSupport.asList(jdoClass.getPrimaryKeyFieldNumbers()));
        PrintSupport.println(indent + 1, "nonPrimaryKeyFieldNumbers  = " + PrintSupport.asList(jdoClass.getNonPrimaryKeyFieldNumbers()));
        PrintSupport.println(indent + 1, "persistentRelshipFieldNs   = " + PrintSupport.asList(jdoClass.getPersistentRelationshipFieldNumbers()));
        PrintSupport.println(indent + 1, "declaredFields");
        PrintSupport.printJDOFields(indent + 1, jdoClass.getDeclaredFields());
        PrintSupport.printJDOExtensions(indent + 1, jdoClass.getJDOExtensions());
        PrintSupport.println(0, "<-- JDOClass\n ");
    }

    private static void printJDOFields(int indent, JDOField[] jdoFields) {
        if (jdoFields != null && jdoFields.length > 0) {
            int i = 0;
            while (i < jdoFields.length) {
                PrintSupport.printJDOField(indent, jdoFields[i]);
                ++i;
            }
        }
    }

    private static void printJDOField(int indent, JDOField jdoField) {
        if (jdoField == null) {
            return;
        }
        PrintSupport.println(indent, "--> JDOField ");
        PrintSupport.println(indent + 1, "name                = " + jdoField.getName());
        PrintSupport.println(indent + 1, "declaringClass      = " + jdoField.getDeclaringClass().getName());
        PrintSupport.println(indent + 1, "persistenceModifier = " + PersistenceModifier.toString(jdoField.getPersistenceModifier()));
        PrintSupport.println(indent + 1, "primaryKey          = " + jdoField.isPrimaryKey());
        PrintSupport.println(indent + 1, "nullValue           = " + NullValueTreatment.toString(jdoField.getNullValueTreatment()));
        PrintSupport.println(indent + 1, "defaultFetchGroup   = " + jdoField.isDefaultFetchGroup());
        PrintSupport.println(indent + 1, "embedded            = " + jdoField.isEmbedded());
        PrintSupport.println(indent + 1, "type                = " + jdoField.getType());
        PrintSupport.println(indent + 1, "typeName            = " + jdoField.getTypeName());
        PrintSupport.println(indent + 1, "javaField           = " + jdoField.getJavaField());
        PrintSupport.println(indent + 1, "serializable        = " + jdoField.isSerializable());
        PrintSupport.println(indent + 1, "fieldNumber         = " + jdoField.getFieldNumber());
        PrintSupport.println(indent + 1, "relativeFieldNumber = " + jdoField.getRelativeFieldNumber());
        PrintSupport.printJDORelationship(indent + 1, jdoField.getRelationship());
        PrintSupport.printJDOExtensions(indent + 1, jdoField.getJDOExtensions());
        PrintSupport.println(indent, "<-- JDOField ");
    }

    private static void printJDORelationship(int indent, JDORelationship jdoRelationship) {
        if (jdoRelationship == null) {
            return;
        }
        if (jdoRelationship instanceof JDOReference) {
            PrintSupport.printJDOReference(indent, (JDOReference)jdoRelationship);
        } else if (jdoRelationship instanceof JDOCollection) {
            PrintSupport.printJDOCollection(indent, (JDOCollection)jdoRelationship);
        } else if (jdoRelationship instanceof JDOArray) {
            PrintSupport.printJDOArray(indent, (JDOArray)jdoRelationship);
        } else if (jdoRelationship instanceof JDOMap) {
            PrintSupport.printJDOMap(indent, (JDOMap)jdoRelationship);
        }
    }

    private static void printJDORelationshipHelper(int indent, JDORelationship jdoRelationship) {
        if (jdoRelationship == null) {
            return;
        }
        JDORelationship inverse = jdoRelationship.getInverseRelationship();
        PrintSupport.println(indent + 1, "declaringField  = " + jdoRelationship.getDeclaringField().getName());
        PrintSupport.println(indent + 1, "bounds          = " + jdoRelationship.getLowerBound() + " / " + jdoRelationship.getUpperBound());
        PrintSupport.println(indent + 1, "inverse         = " + (inverse == null ? "null" : inverse.getDeclaringField().getDeclaringClass().getName() + "." + inverse.getDeclaringField().getName()));
    }

    private static void printJDOReference(int indent, JDOReference jdoReference) {
        if (jdoReference == null) {
            return;
        }
        PrintSupport.println(indent, "--> JDOReference");
        PrintSupport.printJDORelationshipHelper(indent, jdoReference);
        PrintSupport.printJDOExtensions(indent + 1, jdoReference.getJDOExtensions());
        PrintSupport.println(indent, "<-- JDOReference");
    }

    private static void printJDOCollection(int indent, JDOCollection jdoCollection) {
        if (jdoCollection == null) {
            return;
        }
        PrintSupport.println(indent, "--> JDOCollection");
        PrintSupport.printJDORelationshipHelper(indent, jdoCollection);
        PrintSupport.println(indent + 1, "embeddedElement = " + jdoCollection.isEmbeddedElement());
        PrintSupport.println(indent + 1, "elementType     = " + jdoCollection.getElementType());
        PrintSupport.println(indent + 1, "elementTypeName = " + jdoCollection.getElementTypeName());
        PrintSupport.printJDOExtensions(indent + 1, jdoCollection.getJDOExtensions());
        PrintSupport.println(indent, "<-- JDOCollection");
    }

    private static void printJDOArray(int indent, JDOArray jdoArray) {
        if (jdoArray == null) {
            return;
        }
        PrintSupport.println(indent, "--> JDOArray");
        PrintSupport.printJDORelationshipHelper(indent, jdoArray);
        PrintSupport.println(indent + 1, "embeddedElement = " + jdoArray.isEmbeddedElement());
        PrintSupport.printJDOExtensions(indent + 1, jdoArray.getJDOExtensions());
        PrintSupport.println(indent, "<-- JDOArray");
    }

    private static void printJDOMap(int indent, JDOMap jdoMap) {
        if (jdoMap == null) {
            return;
        }
        PrintSupport.println(indent, "--> JDOMap");
        PrintSupport.printJDORelationshipHelper(indent, jdoMap);
        PrintSupport.println(indent + 1, "embeddedKey     = " + jdoMap.isEmbeddedKey());
        PrintSupport.println(indent + 1, "keyType         = " + jdoMap.getKeyType());
        PrintSupport.println(indent + 1, "keyTypeName     = " + jdoMap.getKeyTypeName());
        PrintSupport.println(indent + 1, "embeddedValue   = " + jdoMap.isEmbeddedValue());
        PrintSupport.println(indent + 1, "valueType       = " + jdoMap.getValueType());
        PrintSupport.println(indent + 1, "valueTypeName   = " + jdoMap.getValueTypeName());
        PrintSupport.printJDOExtensions(indent + 1, jdoMap.getJDOExtensions());
        PrintSupport.println(indent, "<-- JDOMap");
    }

    private static void printJDOExtensions(int indent, JDOExtension[] jdoExtensions) {
        if (jdoExtensions != null && jdoExtensions.length > 0) {
            int i = 0;
            while (i < jdoExtensions.length) {
                PrintSupport.printJDOExtension(indent, jdoExtensions[i]);
                ++i;
            }
        }
    }

    private static void printJDOExtension(int indent, JDOExtension jdoExtension) {
        if (jdoExtension == null) {
            return;
        }
        PrintSupport.println(indent, "--> JDOExtension");
        PrintSupport.println(indent + 1, "vendorName = " + jdoExtension.getVendorName());
        PrintSupport.println(indent + 1, "key        = " + jdoExtension.getKey());
        PrintSupport.println(indent + 1, "value      = " + jdoExtension.getValue());
        PrintSupport.println(indent, "<-- JDOExtension");
    }

    static void println(int indent, String text) {
        int i = 0;
        while (i < indent) {
            System.out.print("    ");
            ++i;
        }
        System.out.println(text);
    }

    public static List asList(int[] array) {
        int length = array == null ? 0 : array.length;
        ArrayList<Integer> list = new ArrayList<Integer>(length);
        int i = 0;
        while (i < length) {
            list.add(new Integer(array[i]));
            ++i;
        }
        return list;
    }
}

