/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.model.jdo;

import com.sap.jdo.model.jdo.JavaModel;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.util.HashMap;

public class RuntimeJavaModel
implements JavaModel {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jdo$common$model$jdo$RuntimeJavaModel == null ? (class$com$sap$jdo$common$model$jdo$RuntimeJavaModel = RuntimeJavaModel.class$("com.sap.jdo.common.model.jdo.RuntimeJavaModel")) : class$com$sap$jdo$common$model$jdo$RuntimeJavaModel));
    private ClassLoader classLoader;
    private HashMap primitiveTypes;
    static /* synthetic */ Class class$com$sap$jdo$common$model$jdo$RuntimeJavaModel;

    public RuntimeJavaModel(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.primitiveTypes = new HashMap();
        this.primitiveTypes.put("boolean", Boolean.TYPE);
        this.primitiveTypes.put("byte", Byte.TYPE);
        this.primitiveTypes.put("short", Short.TYPE);
        this.primitiveTypes.put("char", Character.TYPE);
        this.primitiveTypes.put("int", Integer.TYPE);
        this.primitiveTypes.put("long", Long.TYPE);
        this.primitiveTypes.put("float", Float.TYPE);
        this.primitiveTypes.put("double", Double.TYPE);
        this.primitiveTypes.put("void", Void.TYPE);
    }

    public InputStream getInputStreamForResource(String resourceName) {
        return this.classLoader.getResourceAsStream(resourceName);
    }

    public boolean isInterface(Object type) {
        if (type instanceof Class) {
            return ((Class)type).isInterface();
        }
        return false;
    }

    public boolean isArray(Object type) {
        if (type instanceof Class) {
            return ((Class)type).isArray();
        }
        return false;
    }

    public Object getArrayComponentType(Object type) {
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        return null;
    }

    public String getTypeName(Object type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return null;
    }

    public Object getTypeForName(String typeName) {
        Class clazz = (Class)this.primitiveTypes.get(typeName);
        if (clazz != null) {
            return clazz;
        }
        try {
            return Class.forName(typeName, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            LOCATION.traceThrowableT(100, "getTypeForName with classLoader " + this.classLoader, (Throwable)e);
            try {
                return Class.forName(typeName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ex) {
                LOCATION.traceThrowableT(100, "getTypeForName with current thread context class loader", (Throwable)ex);
                return null;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

