/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.model.jdo;

import com.sap.jdo.model.jdo.JDOClass;
import com.sap.jdo.model.jdo.JDOField;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.model.jdo.JDOModelFactory;
import com.sap.tc.logging.Location;
import javax.jdo.JDOFatalUserException;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.RegisterClassEvent;

public class RegisterClassListener
implements javax.jdo.spi.RegisterClassListener {
    JDOImplHelper helper;
    JDOModelFactory factory;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jdo$common$model$jdo$RegisterClassListener == null ? (class$com$sap$jdo$common$model$jdo$RegisterClassListener = RegisterClassListener.class$("com.sap.jdo.common.model.jdo.RegisterClassListener")) : class$com$sap$jdo$common$model$jdo$RegisterClassListener));
    static /* synthetic */ Class class$com$sap$jdo$common$model$jdo$RegisterClassListener;

    public RegisterClassListener(JDOImplHelper helper, JDOModelFactory factory) {
        this.helper = helper;
        this.factory = factory;
    }

    public void registerClass(RegisterClassEvent event) {
        LOCATION.debugT("registerClass: " + event.getRegisteredClass());
        try {
            this.updateJDOClass(this.createJDOClass(event.getRegisteredClass()), event.getFieldNames(), event.getFieldTypes(), event.getFieldFlags(), event.getPersistenceCapableSuperclass());
        }
        catch (JDOModelException ex) {
            throw new JDOFatalUserException("Unable to register class " + event.getRegisteredClass().getName() + ".", (Throwable)ex);
        }
    }

    private JDOClass createJDOClass(Class pcClass) throws JDOModelException {
        JDOModel jdoModel = this.factory.getJDOModel(pcClass.getClassLoader());
        JDOClass jdoClass = jdoModel.createJDOClass(pcClass.getName(), false);
        jdoClass.setJavaClass(pcClass);
        return jdoClass;
    }

    private void updateJDOClass(JDOClass jdoClass, String[] fieldNames, Class[] fieldTypes, byte[] fieldFlags, Class pcSuperclass) throws JDOModelException {
        if (pcSuperclass != null) {
            JDOModel superJDOModel = this.factory.getJDOModel(pcSuperclass.getClassLoader());
            JDOClass superJDOClass = superJDOModel.getJDOClass(pcSuperclass.getName(), false);
            jdoClass.setPersistenceCapableSuperclass(superJDOClass);
        }
        int i = 0;
        while (i < fieldNames.length) {
            JDOField jdoField = jdoClass.createJDOField(fieldNames[i]);
            if (jdoField.getPersistenceModifier() == 0) {
                jdoField.setPersistenceModifier(4);
            }
            jdoField.setType(fieldTypes[i]);
            jdoField.setSerializable((fieldFlags[i] & 0x10) > 0);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

