/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.model.jdo;

import com.sap.jdo.common.model.jdo.JDOClassImpl;
import com.sap.jdo.common.model.jdo.JDOElementImpl;
import com.sap.jdo.common.model.jdo.JDOPackageImpl;
import com.sap.jdo.common.model.jdo.util.Assertion;
import com.sap.jdo.common.model.jdo.util.TypeSupport;
import com.sap.jdo.common.model.jdo.xml.JDOHandlerImpl;
import com.sap.jdo.common.model.jdo.xml.JDOParser;
import com.sap.jdo.model.jdo.JDOClass;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.model.jdo.JDOPackage;
import com.sap.jdo.model.jdo.JavaModel;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jdo.I18NHelper;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JDOModelImpl
extends JDOElementImpl
implements JDOModel {
    private Map jdoPackages = new HashMap();
    private Map jdoClasses = new HashMap();
    private Map jdoClassesByObjectIdClasses = new HashMap();
    private Set nonPCClasses = new HashSet();
    private Set resourceNames = new HashSet();
    private JDOModel parent;
    private Set children = new HashSet();
    private JavaModel javaModel;
    private static final I18NHelper msg = I18NHelper.getInstance((String)"com.sap.jdo.common.model.jdo.Bundle");
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jdo$common$model$jdo$JDOModelImpl == null ? (class$com$sap$jdo$common$model$jdo$JDOModelImpl = JDOModelImpl.class$("com.sap.jdo.common.model.jdo.JDOModelImpl")) : class$com$sap$jdo$common$model$jdo$JDOModelImpl));
    static /* synthetic */ Class class$com$sap$jdo$common$model$jdo$JDOModelImpl;

    protected JDOModelImpl() {
    }

    public JDOPackage createJDOPackage(String packageName) throws JDOModelException {
        JDOPackage jdoPackage = this.getJDOPackage(packageName);
        if (jdoPackage == null) {
            jdoPackage = new JDOPackageImpl();
            jdoPackage.setName(packageName);
            jdoPackage.setDeclaringModel(this);
            this.jdoPackages.put(packageName, jdoPackage);
        }
        return jdoPackage;
    }

    public JDOPackage getJDOPackage(String packageName) {
        return (JDOPackage)this.jdoPackages.get(packageName);
    }

    public JDOPackage[] getDeclaredPackages() {
        return this.jdoPackages.values().toArray(new JDOPackage[this.jdoPackages.size()]);
    }

    public JDOClass createJDOClass(String className) throws JDOModelException {
        return this.createJDOClass(className, true);
    }

    public synchronized JDOClass createJDOClass(String className, boolean loadXMLMetadata) throws JDOModelException {
        JDOClass jdoClass = this.getJDOClass(className, loadXMLMetadata);
        if (jdoClass == null) {
            LOCATION.debugT("JDOModelImpl.createJDOClass: create new JDOClass instance " + className);
            jdoClass = new JDOClassImpl();
            jdoClass.setName(className);
            jdoClass.setDeclaringModel(this);
            this.jdoClasses.put(className, jdoClass);
            this.nonPCClasses.remove(className);
            jdoClass.setJDOPackage(this.createJDOPackage(this.getPackageName(className)));
        }
        return jdoClass;
    }

    public JDOClass getJDOClass(String className) throws JDOModelException {
        return this.getJDOClass(className, true);
    }

    public synchronized JDOClass getJDOClass(String className, boolean loadXMLMetadata) throws JDOModelException {
        boolean beDebug = LOCATION.beDebug();
        if (this.isKnownNonPC(className)) {
            if (beDebug) {
                LOCATION.debugT("getJDOClass: " + className + " known to be non-persistence-capable");
            }
            return null;
        }
        JDOClassImpl jdoClass = (JDOClassImpl)this.jdoClasses.get(className);
        if (beDebug) {
            if (jdoClass == null) {
                LOCATION.infoT("getJDOClass: " + className + " is not cached");
            } else {
                LOCATION.infoT("getJDOClass: " + className + " is cached: " + jdoClass);
            }
        }
        if (loadXMLMetadata && (jdoClass == null || jdoClass.isXMLRequired())) {
            if (beDebug) {
                LOCATION.infoT("check XML for " + className);
            }
            this.lookupXMLMetaData(className);
            jdoClass = (JDOClassImpl)this.jdoClasses.get(className);
            if (jdoClass == null) {
                this.nonPCClasses.add(className);
            } else {
                jdoClass.setXMLRequired(false);
                this.checkSuperclass(jdoClass);
            }
        }
        return jdoClass;
    }

    public synchronized JDOClass[] getDeclaredClasses() {
        return this.jdoClasses.values().toArray(new JDOClass[this.jdoClasses.size()]);
    }

    public JDOModel getParent() {
        return this.parent;
    }

    public void setParent(JDOModel parent) {
        if (this.parent == parent) {
            return;
        }
        if (this.parent != null) {
            ((JDOModelImpl)this.parent).children.remove(this);
            ((JDOModelImpl)parent).children.add(this);
        }
        this.parent = parent;
    }

    public JDOModel[] getChildren() {
        return this.children.toArray(new JDOModel[this.children.size()]);
    }

    public JavaModel getJavaModel() {
        return this.javaModel;
    }

    public void setJavaModel(JavaModel javaModel) {
        this.javaModel = javaModel;
    }

    public synchronized JDOClass getJDOClassForObjectIdClass(Object objectIdClass) {
        if (objectIdClass == null) {
            return null;
        }
        JDOClass jdoClass = (JDOClass)this.jdoClassesByObjectIdClasses.get(objectIdClass);
        if (jdoClass == null) {
            Iterator i = this.jdoClasses.values().iterator();
            while (i.hasNext()) {
                JDOClass next = (JDOClass)i.next();
                if (!objectIdClass.equals(next.getObjectIdClass())) continue;
                this.jdoClassesByObjectIdClasses.put(objectIdClass, next);
                jdoClass = next;
                break;
            }
        }
        return jdoClass;
    }

    private boolean isKnownNonPC(String typeName) {
        return TypeSupport.isPrimitiveTypeName(typeName) || typeName.startsWith("java.") || typeName.startsWith("javax.") || this.nonPCClasses.contains(typeName);
    }

    private void lookupXMLMetaData(String className) throws JDOModelException {
        InputStream stream = this.getXMLMetaDataInputStream(className);
        if (stream == null) {
            return;
        }
        JDOHandlerImpl handler = new JDOHandlerImpl(this);
        JDOParser parser = new JDOParser(handler);
        try {
            parser.parse(new InputSource(new InputStreamReader(stream)));
            try {
                stream.close();
            }
            catch (IOException ex) {
                LOCATION.traceThrowableT(500, "IOException during close()", (Throwable)ex);
            }
            stream = null;
            Collection newJDOClasses = handler.handledJDOClasses();
            Iterator i = newJDOClasses.iterator();
            while (i.hasNext()) {
                JDOClassImpl jdoClass = (JDOClassImpl)i.next();
                this.checkSuperclass(jdoClass);
            }
        }
        catch (SAXException ex) {
            throw new JDOModelException(msg.msg("EXC_XMLError"), ex);
        }
        catch (ParserConfigurationException ex) {
            throw new JDOModelException(msg.msg("EXC_XMLError"), ex);
        }
        catch (IOException ex) {
            throw new JDOModelException(msg.msg("EXC_XMLError"), ex);
        }
    }

    private InputStream getXMLMetaDataInputStream(String className) throws JDOModelException {
        String resourceName;
        boolean beDebug = LOCATION.beDebug();
        Assertion.affirm(this.javaModel, msg.msg("ERR_MissingJavaModel"));
        if (beDebug) {
            LOCATION.infoT("getXMLMetaDataInputStream: " + className);
        }
        if (this.resourceNames.contains(resourceName = className.replace('.', '/') + ".jdo")) {
            if (beDebug) {
                LOCATION.infoT("class xml " + resourceName + " processed already");
            }
            return null;
        }
        InputStream stream = this.javaModel.getInputStreamForResource(resourceName);
        while (stream == null) {
            int index = resourceName.lastIndexOf(47);
            if (index == -1) {
                if (beDebug) {
                    LOCATION.infoT("no xml for " + className);
                }
                return null;
            }
            if (this.resourceNames.contains(resourceName = resourceName.substring(0, index) + ".jdo")) {
                if (beDebug) {
                    LOCATION.infoT("package xml " + resourceName + " processed already");
                }
                return null;
            }
            stream = this.javaModel.getInputStreamForResource(resourceName);
        }
        if (beDebug) {
            LOCATION.infoT("found xml " + resourceName);
        }
        this.resourceNames.add(resourceName);
        return stream;
    }

    private void checkSuperclass(JDOClass jdoClass) throws JDOModelException {
        String superclassName = jdoClass.getPersistenceCapableSuperclassName();
        JDOClass superclass = jdoClass.getPersistenceCapableSuperclass();
        if (superclassName != null) {
            int index = superclassName.lastIndexOf(46);
            if (index == -1) {
                superclass = this.getJDOClass(jdoClass.getPackagePrefix() + superclassName);
                if (superclass == null) {
                    superclass = this.getJDOClass(superclassName);
                }
            } else {
                superclass = this.getJDOClass(superclassName);
            }
            if (superclass == null) {
                throw new JDOModelException(msg.msg("EXC_NonPCSuperclass", (Object)superclassName, (Object)jdoClass.getName()));
            }
            jdoClass.setPersistenceCapableSuperclass(superclass);
            this.checkSuperclass(superclass);
        }
    }

    private String getPackageName(String className) {
        int index = className.lastIndexOf(46);
        return index == -1 ? "" : className.substring(0, index);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

