/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.model.jdo;

import com.sap.jdo.common.model.jdo.JDOModelImpl;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.model.jdo.JDOModelFactory;
import java.util.HashMap;
import java.util.Map;

public class JDOModelFactoryImpl
implements JDOModelFactory {
    private JDOModel defaultModel = null;
    private Map modelCache = new HashMap();
    private static JDOModelFactory jdoModelFactory;

    protected JDOModelFactoryImpl() {
    }

    public static synchronized JDOModelFactory getInstance() throws JDOModelException {
        if (jdoModelFactory == null) {
            jdoModelFactory = new JDOModelFactoryImpl();
        }
        return jdoModelFactory;
    }

    public JDOModel createJDOModel() {
        return new JDOModelImpl();
    }

    public JDOModel getJDOModel(Object key) throws JDOModelException {
        JDOModel model = null;
        Map map = this.modelCache;
        synchronized (map) {
            model = (JDOModel)this.modelCache.get(key);
        }
        if (model == null) {
            model = this.createJDOModel();
            this.updateCache(key, model);
        }
        return model;
    }

    public JDOModel getDefault() throws JDOModelException {
        if (this.defaultModel == null) {
            this.defaultModel = this.createJDOModel();
        }
        return this.defaultModel;
    }

    protected void updateCache(Object key, JDOModel model) throws JDOModelException {
        Map map = this.modelCache;
        synchronized (map) {
            this.modelCache.put(key, model);
        }
    }
}

