/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.model.jdo;

import com.sap.jdo.common.model.jdo.JDORelationshipImpl;
import com.sap.jdo.common.model.jdo.util.TypeSupport;
import com.sap.jdo.model.jdo.JDOClass;
import com.sap.jdo.model.jdo.JDOMap;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JavaModel;

public class JDOMapImpl
extends JDORelationshipImpl
implements JDOMap {
    private Boolean embeddedKey;
    private transient Object keyType;
    private String keyTypeName = "java.lang.Object";
    private Boolean embeddedValue;
    private transient Object valueType;
    private String valueTypeName = "java.lang.Object";

    public boolean isEmbeddedKey() {
        return this.embeddedKey == null ? false : this.embeddedKey;
    }

    public void setEmbeddedKey(boolean embeddedKey) {
        this.embeddedKey = embeddedKey ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object getKeyType() {
        return this.keyType;
    }

    public void setKeyType(Object keyType) {
        JDOModel declaringModel;
        JavaModel javaModel;
        this.keyType = keyType;
        if (keyType != null && (javaModel = (declaringModel = this.getDeclaringField().getDeclaringClass().getDeclaringModel()).getJavaModel()) != null) {
            this.setKeyTypeName(javaModel.getTypeName(keyType));
            this.checkKeyDefaults(declaringModel);
        }
    }

    public String getKeyTypeName() {
        return this.keyTypeName;
    }

    public void setKeyTypeName(String keyTypeName) {
        this.keyTypeName = keyTypeName;
    }

    public boolean isEmbeddedValue() {
        return this.embeddedValue == null ? false : this.embeddedValue;
    }

    public void setEmbeddedValue(boolean embeddedValue) {
        this.embeddedValue = embeddedValue ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object getValueType() {
        return this.valueType;
    }

    public void setValueType(Object valueType) {
        JDOModel declaringModel;
        JavaModel javaModel;
        this.valueType = valueType;
        if (valueType != null && (javaModel = (declaringModel = this.getDeclaringField().getDeclaringClass().getDeclaringModel()).getJavaModel()) != null) {
            this.setKeyTypeName(javaModel.getTypeName(valueType));
            this.checkValueDefaults(declaringModel);
        }
    }

    public String getValueTypeName() {
        return this.valueTypeName;
    }

    public void setValueTypeName(String valueTypeName) {
        this.valueTypeName = valueTypeName;
    }

    protected void checkRelationship() {
        Object type;
        JDOClass declaringClass = this.getDeclaringField().getDeclaringClass();
        JDOModel declaringModel = declaringClass.getDeclaringModel();
        JavaModel javaModel = declaringModel.getJavaModel();
        if (this.keyTypeName != null && (type = TypeSupport.resolveType(declaringModel, this.keyTypeName, declaringClass.getPackagePrefix())) != null) {
            this.setKeyType(type);
        }
        if (this.valueTypeName != null && (type = TypeSupport.resolveType(declaringModel, this.valueTypeName, declaringClass.getPackagePrefix())) != null) {
            this.setValueType(type);
        }
    }

    private void checkKeyDefaults(JDOModel declaringModel) {
        if (this.embeddedKey == null) {
            this.embeddedKey = TypeSupport.isEmbeddedElementType(declaringModel, this.keyType) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private void checkValueDefaults(JDOModel declaringModel) {
        if (this.embeddedValue == null) {
            this.embeddedKey = TypeSupport.isEmbeddedElementType(declaringModel, this.valueType) ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

