/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.model.jdo;

import com.sap.jdo.common.model.jdo.JDOFieldImpl;
import com.sap.jdo.common.model.jdo.JDOMemberImpl;
import com.sap.jdo.common.model.jdo.util.Assertion;
import com.sap.jdo.common.model.jdo.util.TypeSupport;
import com.sap.jdo.model.jdo.JDOClass;
import com.sap.jdo.model.jdo.JDOField;
import com.sap.jdo.model.jdo.JDOMember;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.model.jdo.JDOPackage;
import com.sap.jdo.model.jdo.JavaModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.I18NHelper;

public class JDOClassImpl
extends JDOMemberImpl
implements JDOClass {
    private int identityType = 0;
    private transient Object objectIdClass;
    private String objectIdClassName;
    private boolean requiresExtent = true;
    private String pcSuperclassName;
    private JDOClassImpl pcSuperclass;
    private transient Object javaClass;
    private JDOModel declaringModel;
    private Map declaredFields = new HashMap();
    private Map declaredClasses = new HashMap();
    private JDOPackage jdoPackage;
    private JDOField[] declaredManagedFields;
    private JDOField[] managedFields;
    private JDOField[] persistentFields;
    private JDOField[] primaryKeyFields;
    private JDOField[] persistentRelationshipFields;
    private int inheritedManagedFieldCount = -1;
    private int[] managedFieldNumbers;
    private int[] persistentFieldNumbers;
    private int[] primaryKeyFieldNumbers;
    private int[] nonPrimaryKeyFieldNumbers;
    private int[] persistentRelationshipFieldNumbers;
    private int[] persistentSerializableFieldNumbers;
    private boolean isXMLRequired = true;
    private static final I18NHelper msg = I18NHelper.getInstance((String)"com.sap.jdo.common.model.jdo.Bundle");

    public synchronized int getIdentityType() {
        if (this.identityType == 0) {
            JDOClass pcRoot = this.getPersistenceCapableRootClass();
            this.identityType = pcRoot == this ? (pcRoot.getObjectIdClassName() != null ? 2 : 1) : pcRoot.getIdentityType();
        }
        return this.identityType;
    }

    public synchronized void setIdentityType(int identityType) {
        this.identityType = identityType;
    }

    public synchronized Object getObjectIdClass() {
        this.checkObjectIdClass();
        return this.objectIdClass;
    }

    public synchronized void setObjectIdClass(Object objectIdClass) {
        JavaModel javaModel = this.getDeclaringModel().getJavaModel();
        if (javaModel != null && objectIdClass != null) {
            this.setObjectIdClassName(javaModel.getTypeName(objectIdClass));
        }
        this.objectIdClass = objectIdClass;
    }

    public synchronized String getObjectIdClassName() {
        this.checkObjectIdClass();
        return this.objectIdClassName;
    }

    public synchronized void setObjectIdClassName(String objectIdClassName) {
        this.objectIdClassName = objectIdClassName;
    }

    public synchronized boolean requiresExtent() {
        return this.requiresExtent;
    }

    public synchronized void setRequiresExtent(boolean requiresExtent) {
        this.requiresExtent = requiresExtent;
    }

    public synchronized String getPersistenceCapableSuperclassName() {
        return this.pcSuperclassName;
    }

    public synchronized void setPersistenceCapableSuperclassName(String pcSuperclassName) {
        this.pcSuperclassName = pcSuperclassName;
    }

    public synchronized Object getJavaClass() {
        return this.javaClass;
    }

    public synchronized void setJavaClass(Object javaClass) {
        this.javaClass = javaClass;
    }

    public synchronized void removeDeclaredMember(JDOMember member) throws JDOModelException {
        if (member instanceof JDOField) {
            if (this.declaredManagedFields != null) {
                throw new JDOModelException(msg.msg("EXC_CannotRemoveJDOField"));
            }
            this.declaredFields.remove(member.getName());
        } else if (member instanceof JDOClass) {
            this.declaredClasses.remove(member.getName());
        } else {
            String name = member == null ? "null" : member.getName();
            throw new JDOModelException(msg.msg("EXC_InvalidMember", (Object)name));
        }
    }

    public synchronized JDOMember[] getDeclaredMembers() {
        ArrayList copy = new ArrayList(this.declaredFields.values());
        copy.addAll(this.declaredClasses.values());
        return copy.toArray(new JDOMember[copy.size()]);
    }

    public synchronized JDOModel getDeclaringModel() {
        return this.declaringModel;
    }

    public synchronized void setDeclaringModel(JDOModel model) {
        this.declaringModel = model;
    }

    public synchronized JDOClass getPersistenceCapableSuperclass() {
        return this.pcSuperclass;
    }

    public synchronized void setPersistenceCapableSuperclass(JDOClass pcSuperclass) {
        this.pcSuperclass = (JDOClassImpl)pcSuperclass;
        this.pcSuperclassName = pcSuperclass != null ? pcSuperclass.getName() : null;
    }

    public synchronized JDOPackage getJDOPackage() {
        return this.jdoPackage;
    }

    public synchronized void setJDOPackage(JDOPackage jdoPackage) {
        this.jdoPackage = jdoPackage;
    }

    public synchronized JDOField createJDOField(String name) throws JDOModelException {
        JDOField field = (JDOField)this.declaredFields.get(name);
        if (field == null) {
            if (this.declaredManagedFields != null) {
                throw new JDOModelException(msg.msg("EXC_CannotCreateJDOField"));
            }
            field = new JDOFieldImpl();
            field.setName(name);
            field.setDeclaringClass(this);
            this.declaredFields.put(name, field);
        }
        return field;
    }

    public synchronized JDOClass createJDOClass(String name) throws JDOModelException {
        JDOClass innerClass = (JDOClass)this.declaredClasses.get(name);
        if (innerClass == null) {
            innerClass = new JDOClassImpl();
            innerClass.setName(name);
            innerClass.setDeclaringClass(this);
            this.declaredClasses.put(name, innerClass);
        }
        return innerClass;
    }

    public synchronized JDOClass[] getDeclaredClasses() {
        return this.declaredClasses.values().toArray(new JDOClass[this.declaredClasses.size()]);
    }

    public synchronized JDOField[] getDeclaredFields() {
        Collection tmp = this.declaredFields.values();
        return tmp.toArray(new JDOField[tmp.size()]);
    }

    public synchronized JDOField[] getDeclaredManagedFields() {
        this.sortDeclaredManagedFields();
        return this.declaredManagedFields;
    }

    public synchronized JDOField[] getManagedFields() {
        if (this.managedFields == null) {
            JDOField[] declared = this.getDeclaredManagedFields();
            this.checkSuperclass();
            if (this.pcSuperclass == null) {
                this.managedFields = declared;
            } else {
                JDOField[] inherited = this.pcSuperclass.getManagedFields();
                this.managedFields = new JDOField[inherited.length + declared.length];
                System.arraycopy(inherited, 0, this.managedFields, 0, inherited.length);
                System.arraycopy(declared, 0, this.managedFields, inherited.length, declared.length);
            }
        }
        return this.managedFields;
    }

    public synchronized JDOField[] getPersistentFields() {
        if (this.persistentFields == null) {
            this.calculatePersistentFields();
        }
        return this.persistentFields;
    }

    public synchronized JDOField[] getPrimaryKeyFields() {
        if (this.primaryKeyFields == null) {
            this.calculatePrimaryKeyFields();
        }
        return this.primaryKeyFields;
    }

    public synchronized JDOField[] getPersistentRelationshipFields() {
        if (this.persistentRelationshipFields == null) {
            this.calculatePersistentRelationshipFields();
        }
        return this.persistentRelationshipFields;
    }

    public synchronized int[] getManagedFieldNumbers() {
        if (this.managedFieldNumbers == null) {
            JDOField[] fields = this.getManagedFields();
            this.managedFieldNumbers = new int[fields.length];
            int i = 0;
            while (i < fields.length) {
                this.managedFieldNumbers[i] = i;
                ++i;
            }
        }
        return this.managedFieldNumbers;
    }

    public synchronized int[] getPersistentFieldNumbers() {
        if (this.persistentFieldNumbers == null) {
            this.calculatePersistentFields();
        }
        return this.persistentFieldNumbers;
    }

    public synchronized int[] getPrimaryKeyFieldNumbers() {
        if (this.primaryKeyFieldNumbers == null) {
            this.calculatePrimaryKeyFields();
        }
        return this.primaryKeyFieldNumbers;
    }

    public synchronized int[] getNonPrimaryKeyFieldNumbers() {
        if (this.nonPrimaryKeyFieldNumbers == null) {
            JDOField[] fields = this.getManagedFields();
            int[] tmp = new int[fields.length];
            int length = 0;
            int i = 0;
            while (i < fields.length) {
                if (!fields[i].isPrimaryKey()) {
                    tmp[length++] = i;
                }
                ++i;
            }
            this.nonPrimaryKeyFieldNumbers = new int[length];
            System.arraycopy(tmp, 0, this.nonPrimaryKeyFieldNumbers, 0, length);
        }
        return this.nonPrimaryKeyFieldNumbers;
    }

    public synchronized int[] getPersistentRelationshipFieldNumbers() {
        if (this.persistentRelationshipFieldNumbers == null) {
            this.calculatePersistentRelationshipFields();
        }
        return this.persistentRelationshipFieldNumbers;
    }

    public synchronized int[] getPersistentSerializableFieldNumbers() {
        if (this.persistentSerializableFieldNumbers == null) {
            this.calculatePersistentSerializableFields();
        }
        return this.persistentSerializableFieldNumbers;
    }

    public synchronized JDOField getManagedField(String fieldName) {
        JDOField field = this.getField(fieldName);
        if (field != null && !field.isManaged()) {
            return null;
        }
        return field;
    }

    public synchronized JDOField getField(String fieldName) {
        if (fieldName == null || fieldName.length() == 0) {
            return null;
        }
        JDOField field = null;
        int index = fieldName.lastIndexOf(46);
        if (index != -1) {
            String className = fieldName.substring(0, index);
            fieldName = fieldName.substring(index + 1);
            JDOClassImpl next = this;
            while (next != null) {
                if (className.equals(next.getName())) {
                    field = next.getFieldInternal(fieldName);
                }
                next = (JDOClassImpl)next.getPersistenceCapableSuperclass();
            }
        } else {
            field = this.getFieldInternal(fieldName);
        }
        return field;
    }

    public synchronized JDOField getField(int fieldNumber) {
        JDOField field = null;
        JDOField[] fields = this.getManagedFields();
        if (0 <= fieldNumber && fieldNumber < fields.length) {
            field = fields[fieldNumber];
        }
        return field;
    }

    public synchronized JDOField getDeclaredField(String fieldName) {
        return (JDOField)this.declaredFields.get(fieldName);
    }

    public synchronized int getDeclaredManagedFieldCount() {
        return this.getDeclaredManagedFields().length;
    }

    public synchronized int getInheritedManagedFieldCount() {
        this.checkSuperclass();
        return this.inheritedManagedFieldCount;
    }

    public synchronized String getPackagePrefix() {
        String className = this.getName();
        int index = className.lastIndexOf(46);
        return index == -1 ? "" : className.substring(0, index + 1);
    }

    public synchronized JDOClass getPersistenceCapableRootClass() {
        this.checkSuperclass();
        if (this.pcSuperclass == null) {
            return this;
        }
        return this.pcSuperclass.getPersistenceCapableRootClass();
    }

    boolean isXMLRequired() {
        return this.isXMLRequired;
    }

    void setXMLRequired(boolean isXMLRequired) {
        this.isXMLRequired = isXMLRequired;
    }

    protected JDOField getFieldInternal(String fieldName) {
        JDOField field = (JDOField)this.declaredFields.get(fieldName);
        if (field != null) {
            return field;
        }
        this.checkSuperclass();
        if (this.pcSuperclass != null) {
            return this.pcSuperclass.getFieldInternal(fieldName);
        }
        return null;
    }

    private void checkSuperclass() {
        if (this.inheritedManagedFieldCount < 0) {
            if (this.pcSuperclassName != null) {
                Assertion.affirm(this.pcSuperclass, msg.msg("ERR_InconsistentSuperclass", (Object)this.pcSuperclassName, (Object)(this.pcSuperclass == null ? "null" : this.pcSuperclass.getName())));
                this.inheritedManagedFieldCount = this.pcSuperclass.getInheritedManagedFieldCount() + this.pcSuperclass.getDeclaredManagedFieldCount();
            } else {
                this.inheritedManagedFieldCount = 0;
            }
        }
    }

    protected void sortDeclaredManagedFields() {
        if (this.declaredManagedFields == null) {
            ArrayList<JDOField> fields = new ArrayList<JDOField>();
            Iterator i = this.declaredFields.values().iterator();
            while (i.hasNext()) {
                JDOField field = (JDOField)i.next();
                if (!field.isManaged()) continue;
                fields.add(field);
            }
            Collections.sort(fields);
            this.declaredManagedFields = new JDOField[fields.size()];
            fields.toArray(this.declaredManagedFields);
            int i2 = 0;
            while (i2 < this.declaredManagedFields.length) {
                ((JDOFieldImpl)this.declaredManagedFields[i2]).setRelativeFieldNumber(i2);
                ++i2;
            }
        }
    }

    private void calculatePersistentFields() {
        JDOField[] fields = this.getManagedFields();
        int[] tmpNumbers = new int[fields.length];
        JDOField[] tmpFields = new JDOField[fields.length];
        int length = 0;
        int i = 0;
        while (i < fields.length) {
            JDOField field = fields[i];
            if (fields[i].isPersistent()) {
                tmpFields[length] = field;
                tmpNumbers[length] = i;
                ++length;
            }
            ++i;
        }
        this.persistentFields = new JDOField[length];
        System.arraycopy(tmpFields, 0, this.persistentFields, 0, length);
        this.persistentFieldNumbers = new int[length];
        System.arraycopy(tmpNumbers, 0, this.persistentFieldNumbers, 0, length);
    }

    private void calculatePrimaryKeyFields() {
        JDOField[] fields = this.getManagedFields();
        int[] tmpNumbers = new int[fields.length];
        JDOField[] tmpFields = new JDOField[fields.length];
        int length = 0;
        int i = 0;
        while (i < fields.length) {
            JDOField field = fields[i];
            if (fields[i].isPrimaryKey()) {
                tmpFields[length] = field;
                tmpNumbers[length] = i;
                ++length;
            }
            ++i;
        }
        this.primaryKeyFields = new JDOField[length];
        System.arraycopy(tmpFields, 0, this.primaryKeyFields, 0, length);
        this.primaryKeyFieldNumbers = new int[length];
        System.arraycopy(tmpNumbers, 0, this.primaryKeyFieldNumbers, 0, length);
    }

    private void calculatePersistentRelationshipFields() {
        JDOField[] fields = this.getPersistentFields();
        int[] tmpNumbers = new int[fields.length];
        JDOField[] tmpFields = new JDOField[fields.length];
        int length = 0;
        int i = 0;
        while (i < fields.length) {
            JDOField field = fields[i];
            if (field.isPersistent() && field.isRelationship()) {
                tmpFields[length] = field;
                tmpNumbers[length] = i;
                ++length;
            }
            ++i;
        }
        this.persistentRelationshipFields = new JDOField[length];
        System.arraycopy(tmpFields, 0, this.persistentRelationshipFields, 0, length);
        this.persistentRelationshipFieldNumbers = new int[length];
        System.arraycopy(tmpNumbers, 0, this.persistentRelationshipFieldNumbers, 0, length);
    }

    private void calculatePersistentSerializableFields() {
        JDOField[] fields = this.getManagedFields();
        int[] tmpNumbers = new int[fields.length];
        int length = 0;
        int i = 0;
        while (i < fields.length) {
            JDOField field = fields[i];
            if (field.isPersistent() && field.isSerializable()) {
                tmpNumbers[length] = i;
                ++length;
            }
            ++i;
        }
        this.persistentSerializableFieldNumbers = new int[length];
        System.arraycopy(tmpNumbers, 0, this.persistentSerializableFieldNumbers, 0, length);
    }

    private void checkObjectIdClass() {
        if (this.objectIdClass == null && this.objectIdClassName != null) {
            Object type = TypeSupport.resolveType(this.getDeclaringModel(), this.objectIdClassName, this.getPackagePrefix());
            Assertion.affirm(type, msg.msg("ERR_CannotResolveClass", (Object)this.objectIdClassName));
            this.setObjectIdClass(type);
        }
    }
}

