/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common;

import com.sap.jdo.Connector;
import com.sap.jdo.EJBImplHelper;
import com.sap.jdo.StoreManager;
import com.sap.jdo.common.ExtendedTransaction;
import com.sap.jdo.common.PersistenceManagerFactoryImpl;
import com.sap.jdo.common.PersistenceManagerImpl;
import com.sap.jdo.common.TransactionSynchronization;
import com.sap.tc.logging.Location;
import javax.jdo.I18NHelper;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;

class TransactionImpl
implements ExtendedTransaction {
    private int status = 6;
    private boolean startedCommit = false;
    private Object synchronization;
    private Synchronization jcaSynchronization;
    private Object txSync = null;
    private TransactionSynchronization ownSynch = null;
    private PersistenceManagerFactoryImpl pmFactory = null;
    private PersistenceManagerImpl persistenceManager = null;
    private Connector connector = null;
    private Transaction jta = null;
    private boolean retainValues = true;
    private boolean restoreValues = true;
    private boolean optimistic = true;
    private boolean nontransactionalRead = true;
    private boolean nontransactionalWrite = true;
    private String username = null;
    private String password = null;
    protected static final int NON_MGD = 0;
    protected static final int CMT = 1;
    protected static final int BMT_UT = 2;
    protected static final int BMT_JDO = 3;
    private int txType = -1;
    private boolean synchronizedWithServerTransaction = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jdo$common$TransactionImpl == null ? (class$com$sap$jdo$common$TransactionImpl = TransactionImpl.class$("com.sap.jdo.common.TransactionImpl")) : class$com$sap$jdo$common$TransactionImpl));
    private boolean _bePath;
    private boolean _beDebug;
    private boolean _beWarn;
    private boolean _beInfo;
    private static final String commonBundle = "com.sap.jdo.common.Bundle";
    private static final I18NHelper msg = I18NHelper.getInstance((String)"com.sap.jdo.common.Bundle");
    static /* synthetic */ Class class$com$sap$jdo$common$TransactionImpl;

    TransactionImpl(PersistenceManagerImpl pm, PersistenceManagerFactoryImpl pmf, String username, String password) {
        this.persistenceManager = pm;
        this.pmFactory = pmf;
        this.optimistic = this.pmFactory.getOptimistic();
        this.retainValues = this.pmFactory.getRetainValues();
        this.restoreValues = this.pmFactory.getRestoreValues();
        this.nontransactionalRead = this.pmFactory.getNontransactionalRead();
        this.nontransactionalWrite = this.pmFactory.getNontransactionalWrite();
        this.username = username;
        this.password = password;
    }

    public PersistenceManager getPersistenceManager() {
        this.persistenceManager.assertIsOpen();
        return this.persistenceManager.getCurrentWrapper();
    }

    public boolean isActive() {
        this.persistenceManager.assertIsOpen();
        return !this.isTerminated();
    }

    public void setRetainValues(boolean flag) {
        this.persistenceManager.assertIsOpen();
        if (this.startedCommit) {
            String METHOD = "setRetainValues(boolean)";
            this.handleJDOUserException(null, msg.msg("EXC_CannotSetFlag"), LOCATION, "setRetainValues(boolean)");
        }
        this.retainValues = flag;
    }

    public boolean getRetainValues() {
        this.persistenceManager.assertIsOpen();
        return this.retainValues;
    }

    public void setRestoreValues(boolean flag) {
        this.persistenceManager.assertIsOpen();
        if (this.isActive()) {
            String METHOD = "setRestoreValues(boolean)";
            this.handleJDOUserException(null, msg.msg("EXC_CannotSetFlagIfActive"), LOCATION, "setRestoreValues(boolean)");
        }
        this.restoreValues = flag;
    }

    public boolean getRestoreValues() {
        this.persistenceManager.assertIsOpen();
        return this.restoreValues;
    }

    public synchronized void setNontransactionalRead(boolean flag) {
        this.persistenceManager.assertIsOpen();
        if (this.startedCommit) {
            String METHOD = "setNontransactionalRead(boolean)";
            this.handleJDOUserException(null, msg.msg("EXC_CannotSetFlag"), LOCATION, "setNontransactionalRead(boolean)");
        }
        this.nontransactionalRead = flag;
    }

    public boolean getNontransactionalRead() {
        this.persistenceManager.assertIsOpen();
        return this.nontransactionalRead;
    }

    public synchronized void setNontransactionalWrite(boolean flag) {
        this.persistenceManager.assertIsOpen();
        if (this.startedCommit) {
            String METHOD = "setNontransactionalWrite(boolean)";
            this.handleJDOUserException(null, msg.msg("EXC_CannotSetFlag"), LOCATION, "setNontransactionalWrite(boolean)");
        }
        this.nontransactionalWrite = flag;
    }

    public boolean getNontransactionalWrite() {
        this.persistenceManager.assertIsOpen();
        return this.nontransactionalWrite;
    }

    public synchronized void setOptimistic(boolean flag) {
        this.persistenceManager.assertIsOpen();
        if (this.isTerminated()) {
            this.optimistic = flag;
        } else {
            String METHOD = "setOptimistic(boolean)";
            this.handleJDOUserException(null, msg.msg("EXC_CannotChangeType"), LOCATION, "setOptimistic(boolean)");
        }
        this.persistenceManager.notifyOptimistic(flag);
    }

    public boolean getOptimistic() {
        this.persistenceManager.assertIsOpen();
        return this.optimistic;
    }

    public void setSynchronization(Synchronization sync) {
        this.persistenceManager.assertIsOpen();
        if (sync == this.synchronization) {
            return;
        }
        if (sync != null && this.synchronization != null) {
            String METHOD = "setSynchronization(Synchronization)";
            this.handleJDOUserException(null, msg.msg("EXC_SynchronizationNotNull"), LOCATION, "setSynchronization(Synchronization)");
        }
        this.registerSynchronization(sync);
    }

    public void setJcaSynchronization(Synchronization sync) {
        this.persistenceManager.assertIsOpen();
        if (sync == this.jcaSynchronization) {
            return;
        }
        if (sync != null && this.jcaSynchronization != null) {
            String METHOD = "setJcaSynchronization(Synchronization)";
            this.handleJDOUserException(null, msg.msg("EXC_SynchronizationNotNull"), LOCATION, "setJcaSynchronization(Synchronization)");
        }
        this.jcaSynchronization = sync;
    }

    public Synchronization getJcaSynchronization() {
        this.persistenceManager.assertIsOpen();
        return this.jcaSynchronization;
    }

    public Synchronization getOwnSynchronization() {
        this.persistenceManager.assertIsOpen();
        if (this.ownSynch == null) {
            this.ownSynch = new TransactionSynchronization(this);
        }
        return this.ownSynch;
    }

    public Synchronization getSynchronization() {
        this.persistenceManager.assertIsOpen();
        return (Synchronization)this.synchronization;
    }

    public void begin() {
        String stateString;
        this._bePath = LOCATION.bePath();
        this._beDebug = LOCATION.beDebug();
        String METHOD = "begin()";
        if (this._bePath) {
            LOCATION.entering("begin()");
        }
        if (this._beDebug) {
            stateString = TransactionImpl.statusString(this.status);
            LOCATION.debugT("begin()", "TransactionImpl{0}.begin(): {1}", new Object[]{new Integer(System.identityHashCode(this)), stateString});
        }
        this.beginInternal();
        this.txType = EJBImplHelper.isManaged() ? 3 : 0;
        if (this._beDebug) {
            stateString = TransactionImpl.statusString(this.status);
            LOCATION.debugT("begin()", "TransactionImpl{0}.begin(): {1}", new Object[]{new Integer(System.identityHashCode(this)), stateString});
        }
        if (this._bePath) {
            LOCATION.exiting();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() {
        block20: {
            this._bePath = LOCATION.bePath();
            this._beDebug = LOCATION.beDebug();
            String METHOD = "commit()";
            if (this._bePath) {
                LOCATION.entering("commit()");
            }
            if (this._beDebug) {
                String stateString = TransactionImpl.statusString(this.status);
                LOCATION.debugT("commit()", "TransactionImpl{0}.commit(): {1}", new Object[]{new Integer(System.identityHashCode(this)), stateString});
                this.traceCall("commit()");
            }
            this.persistenceManager.assertIsOpen();
            if (this.status != 0) {
                this.handleJDOUserException(null, msg.msg("EXC_TransactionNotActive"), LOCATION, "commit()");
            }
            if (this.txType == 1 || this.txType == 2) {
                this.handleJDOUserException(null, msg.msg("EXC_WrongMgdOperation", (Object)"commit"), LOCATION, "commit()");
            }
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                if (this.txType == 0) {
                    if (this.startedCommit) {
                        this.handleJDOUserException(null, msg.msg("EXC_TransactionCommitting"), LOCATION, "commit()");
                    }
                    this.startedCommit = true;
                }
            }
            try {
                try {
                    if (this.txType == 0) {
                        this.prepareFlush(true);
                        this.commitComplete();
                    } else {
                        this.commitComplete();
                    }
                }
                catch (JDOException jdoEx) {
                    this.connector.setRollbackOnly();
                    this.internalRollback();
                    this.startedCommit = false;
                    throw jdoEx;
                }
                catch (Exception e) {
                    LOCATION.traceThrowableT(500, "commit()", (Throwable)e);
                    this.connector.setRollbackOnly();
                    this.internalRollback();
                    this.startedCommit = false;
                    JDOException jdoEx = new JDOException("Exception in TransactionImpl.commit() caught.", (Throwable)e);
                    LOCATION.throwing("commit()", (Throwable)jdoEx);
                    throw jdoEx;
                }
                Object var7_3 = null;
                if (this.txType == 0 && this.status != 6) {
                    this.internalAfterCompletion();
                }
                if (!this._beDebug) break block20;
            }
            catch (Throwable throwable) {
                Object var7_4 = null;
                if (this.txType == 0 && this.status != 6) {
                    this.internalAfterCompletion();
                }
                if (this._beDebug) {
                    String stateString = TransactionImpl.statusString(this.status);
                    LOCATION.debugT("commit()", "TransactionImpl{0}.commit(): {1}", new Object[]{new Integer(System.identityHashCode(this)), stateString});
                }
                if (!this._bePath) throw throwable;
                LOCATION.exiting();
                throw throwable;
            }
            String stateString = TransactionImpl.statusString(this.status);
            LOCATION.debugT("commit()", "TransactionImpl{0}.commit(): {1}", new Object[]{new Integer(System.identityHashCode(this)), stateString});
        }
        if (!this._bePath) return;
        LOCATION.exiting();
    }

    public void rollback() {
        this._bePath = LOCATION.bePath();
        this._beDebug = LOCATION.beDebug();
        String METHOD = "rollback()";
        if (this._bePath) {
            LOCATION.entering("rollback()");
        }
        this.persistenceManager.assertIsOpen();
        if (this._beDebug) {
            String stateString = TransactionImpl.statusString(this.status);
            LOCATION.debugT("rollback()", "TransactionImpl{0}.rollback(): {1}", new Object[]{new Integer(System.identityHashCode(this)), stateString});
        }
        if (this.status != 0 && this.status != 1) {
            this.handleJDOUserException(null, msg.msg("EXC_TransactionNotActive"), LOCATION, "rollback()");
        }
        if (this.txType == 1 || this.txType == 2) {
            this.handleJDOUserException(null, msg.msg("EXC_WrongMgdOperation", (Object)"rollback"), LOCATION, "rollback()");
        }
        if (this._beDebug) {
            this.traceCall("rollback()");
        }
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            if (this.txType == 0) {
                if (this.startedCommit) {
                    this.handleJDOFatalInternalException(null, null, LOCATION, "rollback()");
                }
            } else if (!this.startedCommit) {
                this.handleJDOFatalInternalException(null, null, LOCATION, "rollback()");
            }
            this.startedCommit = true;
        }
        this.internalRollback();
        this.startedCommit = false;
        if (this.txType == 0) {
            this.internalAfterCompletion();
        }
        if (this._beDebug) {
            String stateString = TransactionImpl.statusString(this.status);
            LOCATION.debugT("rollback()", "TransactionImpl{0}.rollback(): {1}", new Object[]{new Integer(System.identityHashCode(this)), stateString});
        }
        if (this._bePath) {
            LOCATION.exiting();
        }
    }

    public void setRollbackOnly() {
        String METHOD = "setRollbackOnly()";
        boolean _beDebug = LOCATION.beDebug();
        if (_beDebug) {
            this.traceCall("setRollbackOnly()");
        }
        if (this.status == 9 || this.status == 4 || this.status == 1) {
            return;
        }
        if (this.txType != 0) {
            try {
                this.jta.setRollbackOnly();
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(100, "setRollbackOnly()", (Throwable)e);
                JDOException jdoExc = new JDOException("", (Throwable)e);
                LOCATION.throwing("setRollbackOnly()", (Throwable)jdoExc);
                throw jdoExc;
            }
        } else {
            this.connector = this.getConnector();
            if (!this.connector.getRollbackOnly()) {
                this.connector.setRollbackOnly();
            }
            this.setStatus(1);
        }
    }

    public int getStatus() {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            int n = this.status;
            return n;
        }
    }

    public static String statusString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
        }
        return "STATUS_Invalid[" + status + "]";
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("  Transaction: \n   status        = " + TransactionImpl.statusString(this.status) + "\n");
        if (this.startedCommit) {
            s.append("   startedCommit = true\n");
        }
        if (this.synchronization != null) {
            s.append("   sync          = " + this.synchronization.getClass().getName() + "\n");
        }
        return s.toString();
    }

    protected int getTransactionType() {
        return this.txType;
    }

    protected boolean verify(String username, String password) {
        return !(this.username != null && !this.username.equals(username) || this.username == null && username != null || this.password != null && !this.password.equals(password)) && (this.password != null || password == null);
    }

    protected boolean startedCommit() {
        return this.startedCommit;
    }

    protected void internalFlush() {
        String METHOD = "internalFlush()";
        if (this.status != 0) {
            this.handleJDOUserException(null, msg.msg("EXC_TransactionNotActive"), LOCATION, "internalFlush()");
        }
        this.prepareFlush(false);
        this.flushConnector();
    }

    public void begin(Transaction t) {
        String stateString;
        this._bePath = LOCATION.bePath();
        this._beDebug = LOCATION.beDebug();
        String METHOD = "begin(Transaction)";
        if (this._bePath) {
            LOCATION.entering("begin(Transaction)", new Object[]{t});
        }
        if (this._beDebug) {
            stateString = TransactionImpl.statusString(this.status);
            LOCATION.debugT("begin(Transaction)", "TransactionImpl{0}.begin(1): {2}", new Object[]{new Integer(System.identityHashCode(this)), t, stateString});
        }
        this.beginInternal();
        try {
            this.jta = t;
            if (this.txSync == null) {
                this.txSync = new TransactionSynchronization(this);
            }
            this.jta.registerSynchronization((Synchronization)this.txSync);
            this.setSynchronizedWithServerTransaction(true);
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "begin(Transaction)", (Throwable)e);
            this.handleJDOFatalInternalException(e, msg.msg("EXC_ErrorRegister"), LOCATION, "begin(Transaction)");
        }
        this.txType = 1;
        if (this._beDebug) {
            stateString = TransactionImpl.statusString(this.status);
            LOCATION.debugT("begin(Transaction)", "TransactionImpl{0}.begin(1): {2}", new Object[]{new Integer(System.identityHashCode(this)), t, stateString});
        }
        if (this._bePath) {
            LOCATION.exiting();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void beforeCompletion() {
        String METHOD = "beforeCompletion()";
        this._bePath = LOCATION.bePath();
        this._beDebug = LOCATION.beDebug();
        if (this._bePath) {
            LOCATION.entering("beforeCompletion()");
        }
        if (this.txType == 0) {
            this.handleJDOUserException(null, msg.msg("EXC_WrongNonMgdOperation", (Object)"beforeCompletion"), LOCATION, "beforeCompletion()");
        }
        if (this._beDebug) {
            String stateString = TransactionImpl.statusString(this.status);
            LOCATION.debugT("beforeCompletion()", "TransactionImpl{0}.beforeCompletion(): {1}", new Object[]{new Integer(System.identityHashCode(this)), stateString});
        }
        Object o = null;
        this.startedCommit = true;
        try {
            try {
                o = EJBImplHelper.enlistBeforeCompletion(new Object[]{this, this.persistenceManager, this.jta});
                this.prepareFlush(true);
                this.flushConnector();
            }
            catch (Exception exc) {
                LOCATION.traceThrowableT(500, "beforeCompletion()", (Throwable)exc);
                this.connector.setRollbackOnly();
                this.internalRollback();
                this.startedCommit = false;
                if (exc instanceof JDOException) {
                    LOCATION.throwing("beforeCompletion()", (Throwable)exc);
                    throw (JDOException)((Object)exc);
                }
                JDOException jdoExc = new JDOException("Catched Exception in TransactionImpl.beforeCompletion()", (Throwable)exc);
                LOCATION.throwing("beforeCompletion()", (Throwable)jdoExc);
                Object var6_4 = null;
                EJBImplHelper.delistBeforeCompletion(o);
                if (this._beDebug) {
                    String stateString = TransactionImpl.statusString(this.status);
                    LOCATION.debugT("beforeCompletion()", "TransactionImpl{0}.beforeCompletion(): {1}", new Object[]{new Integer(System.identityHashCode(this)), stateString});
                }
                if (!this._bePath) return;
                LOCATION.exiting();
                return;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            EJBImplHelper.delistBeforeCompletion(o);
            if (this._beDebug) {
                String stateString = TransactionImpl.statusString(this.status);
                LOCATION.debugT("beforeCompletion()", "TransactionImpl{0}.beforeCompletion(): {1}", new Object[]{new Integer(System.identityHashCode(this)), stateString});
            }
            if (!this._bePath) throw throwable;
            LOCATION.exiting();
            throw throwable;
        }
        EJBImplHelper.delistBeforeCompletion(o);
        if (this._beDebug) {
            String stateString = TransactionImpl.statusString(this.status);
            LOCATION.debugT("beforeCompletion()", "TransactionImpl{0}.beforeCompletion(): {1}", new Object[]{new Integer(System.identityHashCode(this)), stateString});
        }
        if (!this._bePath) return;
        LOCATION.exiting();
    }

    protected void afterCompletion(int st) {
        block12: {
            String METHOD = "afterCompletion(int)";
            this._bePath = LOCATION.bePath();
            this._beDebug = LOCATION.beDebug();
            if (this._bePath) {
                LOCATION.entering("afterCompletion(int)", new Object[]{new Integer(st)});
            }
            if (this._beDebug) {
                String paramString = TransactionImpl.statusString(st);
                String stateString = TransactionImpl.statusString(this.status);
                LOCATION.debugT("afterCompletion(int)", "TransactionImpl{0}.afterCompletion({1}): {2}", new Object[]{new Integer(System.identityHashCode(this)), paramString, stateString});
            }
            if (this.txType == 0) {
                this.handleJDOUserException(null, msg.msg("EXC_WrongNonMgdOperation", (Object)"afterCompletion"), LOCATION, "afterCompletion(int)");
            }
            st = EJBImplHelper.translateStatus(st);
            if (this._beDebug) {
                this.traceCall("afterCompletion(int)", st);
            }
            try {
                if (this.synchronizedWithServerTransaction) {
                    this.setStatus(st);
                } else if (st != this.status) {
                    this.handleJDOUserException(null, msg.msg("EXC_InvalidStatus", (Object)"afterCompletion", (Object)TransactionImpl.statusString(this.status), (Object)TransactionImpl.statusString(st)), LOCATION, "afterCompletion(int)");
                }
                this.internalAfterCompletion();
                Object var6_5 = null;
                this.setSynchronizedWithServerTransaction(false);
                if (!this._beDebug) break block12;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.setSynchronizedWithServerTransaction(false);
                if (this._beDebug) {
                    String paramString = TransactionImpl.statusString(st);
                    String stateString = TransactionImpl.statusString(this.status);
                    LOCATION.debugT("afterCompletion(int)", "TransactionImpl{0}.afterCompletion({1}): {2}", new Object[]{new Integer(System.identityHashCode(this)), paramString, stateString});
                }
                if (this._bePath) {
                    LOCATION.exiting();
                }
                throw throwable;
            }
            String paramString = TransactionImpl.statusString(st);
            String stateString = TransactionImpl.statusString(this.status);
            LOCATION.debugT("afterCompletion(int)", "TransactionImpl{0}.afterCompletion({1}): {2}", new Object[]{new Integer(System.identityHashCode(this)), paramString, stateString});
        }
        if (this._bePath) {
            LOCATION.exiting();
        }
    }

    private void beginInternal() {
        String METHOD = "beginInternal()";
        this._beDebug = LOCATION.beDebug();
        this.persistenceManager.assertIsOpen();
        if (this._beDebug) {
            this.traceCall("beginInternal()");
        }
        if (this.isActive()) {
            this.handleJDOUserException(null, msg.msg("EXC_ErrorBegin"), LOCATION, "beginInternal()");
        }
        this.setStatus(0);
        this.connector = this.getConnector();
        this.connector.begin(this.optimistic);
    }

    private void prepareFlush(boolean _commit) {
        String METHOD = "prepareFlush(boolean)";
        boolean _beDebug = LOCATION.beDebug();
        boolean rollbackOnly = false;
        if (_beDebug) {
            this.traceCall("prepareFlush(boolean)");
        }
        this.connector = this.getConnector();
        if (this.status == 9 || this.status == 4) {
            this.handleJDOUserException(null, msg.msg("EXC_TransactionRolledback"), LOCATION, "prepareFlush(boolean)");
        }
        if (this.connector.getRollbackOnly() || this.status == 1) {
            rollbackOnly = true;
        } else if (this.status != 0) {
            this.handleJDOUserException(null, msg.msg("EXC_TransactionNotActive"), LOCATION, "prepareFlush(boolean)");
        }
        if (!rollbackOnly) {
            this.flushInstances(_commit);
            if (this.status == 1) {
                rollbackOnly = true;
            } else if (this.status != 0) {
                this.handleJDOUserException(null, msg.msg("EXC_TransactionRolledback"), LOCATION, "prepareFlush(boolean)");
            }
        }
        if (rollbackOnly) {
            this.setRollbackOnly();
            this.handleJDOUserException(null, msg.msg("EXC_MarkedRolledback"), LOCATION, "prepareFlush(boolean)");
        }
    }

    private void commitComplete() {
        String METHOD = "commitComplete()";
        boolean _beDebug = LOCATION.beDebug();
        if (_beDebug) {
            this.traceCall("commitComplete()");
        }
        if (this.status == 9) {
            this.setStatus(4);
        } else if (this.status == 0) {
            this.setStatus(8);
            this.commitConnector();
            this.setStatus(3);
        } else {
            this.handleJDOUserException(null, msg.msg("EXC_WrongStateCommit"), LOCATION, "commitComplete()");
        }
    }

    private void internalRollback() {
        String METHOD = "internalRollback";
        boolean _beDebug = LOCATION.beDebug();
        if (_beDebug) {
            this.traceCall("internalRollback");
        }
        this.setStatus(9);
        try {
            block5: {
                try {
                    if (this.txType != 0 && this.synchronizedWithServerTransaction) break block5;
                    this.rollbackConnector();
                }
                catch (Exception ex) {
                    LOCATION.traceThrowableT(100, "internalRollback", (Throwable)ex);
                    Object var5_4 = null;
                    this.setStatus(4);
                }
            }
            Object var5_3 = null;
            this.setStatus(4);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setStatus(4);
            throw throwable;
        }
    }

    private void registerSynchronization(Synchronization sync) {
        String METHOD = "registerSynchronization(Synchronization)";
        boolean _beDebug = LOCATION.beDebug();
        if (_beDebug) {
            this.traceCall("registerSynchronization(Synchronization)");
        }
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            if (this.startedCommit) {
                this.handleJDOUserException(null, msg.msg("EXC_TransactionCommitting"), LOCATION, "registerSynchronization(Synchronization)");
            }
            this.synchronization = sync;
            if (_beDebug) {
                this.traceCall("registerSynchronization(Synchronization)");
            }
        }
    }

    private boolean isTerminated() {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            boolean bl = this.status == 3 || this.status == 4 || this.status == 6;
            return bl;
        }
    }

    private void flushInstances(boolean commit) {
        this.getConnector().beforeCompletion();
        if (commit && this.synchronization != null) {
            ((Synchronization)this.synchronization).beforeCompletion();
        }
        this.persistenceManager.flushInstances();
        if (this.jcaSynchronization != null) {
            this.jcaSynchronization.beforeCompletion();
        }
    }

    private void internalAfterCompletion() {
        this.persistenceManager.afterCompletion(this.status);
        try {
            if (this.jcaSynchronization != null) {
                this.jcaSynchronization.afterCompletion(this.status);
            }
            if (this.synchronization != null) {
                ((Synchronization)this.synchronization).afterCompletion(this.status);
            }
        }
        catch (Exception ex) {
            LOCATION.traceThrowableT(500, "internalAfterCompletion,synchronization", (Throwable)ex);
        }
        this.finish();
    }

    private void setStatus(int status) {
        String METHOD = "setStatus(int)";
        this._bePath = LOCATION.bePath();
        this._beInfo = LOCATION.beDebug();
        if (this._bePath) {
            LOCATION.entering("setStatus(int)", new Object[]{new Integer(status)});
        }
        if (this._beInfo) {
            String before = TransactionImpl.statusString(this.status);
            String after = TransactionImpl.statusString(status);
            LOCATION.infoT("setStatus(int)", "TransactionImpl{0}.setStatus({1}): {2} --> {3}", new Object[]{new Integer(System.identityHashCode(this)), new Integer(status), before, after});
        }
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            this.status = status;
            this.persistenceManager.notifyStatusChange(!this.isTerminated());
        }
        if (this._bePath) {
            LOCATION.exiting();
        }
    }

    private void finish() {
        String METHOD = "finish()";
        boolean _beDebug = LOCATION.beDebug();
        if (_beDebug) {
            this.traceCall("finish()");
        }
        this.startedCommit = false;
        if (this.txType != 0) {
            // empty if block
        }
        this.jta = null;
        this.txType = 0;
    }

    private Connector getConnector() {
        StoreManager srm = this.persistenceManager.getStoreManager();
        if (this.username != null) {
            return srm.getConnector(this.username, this.password);
        }
        return srm.getConnector();
    }

    private void flushConnector() {
        this.connector = this.getConnector();
        this.connector.flush();
    }

    private void rollbackConnector() {
        this.connector = this.getConnector();
        this.connector.rollback();
    }

    private void commitConnector() {
        this.connector = this.getConnector();
        this.connector.commit();
    }

    private void traceCall(String method) {
        String statusString = TransactionImpl.statusString(this.status);
        String txString = this.txTypeString();
        LOCATION.debugT(method, "TransactionImpl{0}: this.status = {1}, txType = {2}", new Object[]{new Integer(System.identityHashCode(this)), statusString, txString});
    }

    private void traceCall(String method, int st) {
        String paramStatusString = TransactionImpl.statusString(this.status);
        String statusString = TransactionImpl.statusString(st);
        String txString = this.txTypeString();
        LOCATION.debugT(method, "TransactionImpl{0}: parameter status = {1}, this.status = {2}, txType = {3}", new Object[]{new Integer(System.identityHashCode(this)), paramStatusString, statusString, txString});
    }

    private String txTypeString() {
        switch (this.txType) {
            case 0: {
                return "NON_MGD";
            }
            case 1: {
                return "CMT";
            }
            case 2: {
                return "BMT_UT";
            }
            case 3: {
                return "BMT_JDO";
            }
        }
        return "UNKNOWN";
    }

    public boolean isSynchronizedWithServerTransaction() {
        return this.synchronizedWithServerTransaction;
    }

    public void setSynchronizedWithServerTransaction(boolean synchronizedWithServerTransaction) {
        this.synchronizedWithServerTransaction = synchronizedWithServerTransaction;
    }

    private void handleJDOUserException(Exception nestedExc, String msg, Location location, String method) {
        JDOUserException jdoExc = nestedExc != null ? new JDOUserException(msg == null ? "" : msg, (Throwable)nestedExc) : new JDOUserException(msg == null ? "" : msg);
        location.throwing(method, (Throwable)jdoExc);
        throw jdoExc;
    }

    private void handleJDOFatalInternalException(Exception nestedExc, String msg, Location location, String method) {
        JDOFatalInternalException jdoExc = nestedExc != null ? new JDOFatalInternalException(msg == null ? "" : msg, (Throwable)nestedExc) : new JDOFatalInternalException(msg == null ? "" : msg);
        location.throwing(method, (Throwable)jdoExc);
        throw jdoExc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

