/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common;

import com.sap.jdo.ClassDescriptor;
import com.sap.jdo.EJBImplHelper;
import com.sap.jdo.PersistenceManagerFactoryInternal;
import com.sap.jdo.PersistenceManagerInternal;
import com.sap.jdo.SCOCollection;
import com.sap.jdo.SCOMap;
import com.sap.jdo.StateManagerInternal;
import com.sap.jdo.StoreManager;
import com.sap.jdo.common.CacheManagerImpl;
import com.sap.jdo.common.JDORIVersion;
import com.sap.jdo.common.PersistenceManagerFactoryImpl;
import com.sap.jdo.common.PersistenceManagerWrapper;
import com.sap.jdo.common.TransactionImpl;
import com.sap.jdo.common.model.jdo.RuntimeJDOModelFactoryImpl;
import com.sap.jdo.common.query.QueryImpl;
import com.sap.jdo.model.jdo.JDOClass;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.model.jdo.JDOModelFactory;
import com.sap.tc.logging.Location;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jdo.Extent;
import javax.jdo.I18NHelper;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.spi.PersistenceCapable;

public class PersistenceManagerImpl
implements PersistenceManagerInternal {
    private boolean _isClosed = true;
    private TransactionImpl _transaction = null;
    private Object _jta = null;
    private PersistenceManagerWrapper current = null;
    private PersistenceManagerFactoryImpl pmf = null;
    private CacheManagerImpl _txCache = null;
    private boolean _ignoreCache = true;
    private boolean _activeTransaction = false;
    private boolean optimistic = true;
    private boolean multithreaded = true;
    private Object _userObject = null;
    private boolean _flushing = false;
    private final ClassLoader myClassLoader;
    private static final Class[] sigSCO_Collection = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = PersistenceManagerImpl.class$("java.lang.Class")) : class$java$lang$Class, Boolean.TYPE, Integer.TYPE};
    private static final Class[] sigSCO_Map = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = PersistenceManagerImpl.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$Class == null ? (class$java$lang$Class = PersistenceManagerImpl.class$("java.lang.Class")) : class$java$lang$Class, Boolean.TYPE, Integer.TYPE};
    private static final Class[] sigSCO_HashSet = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = PersistenceManagerImpl.class$("java.lang.Class")) : class$java$lang$Class, Boolean.TYPE, Integer.TYPE, Float.TYPE};
    private static final Class[] sigSCO_TreeSet = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = PersistenceManagerImpl.class$("java.lang.Class")) : class$java$lang$Class, Boolean.TYPE, class$java$util$Comparator == null ? (class$java$util$Comparator = PersistenceManagerImpl.class$("java.util.Comparator")) : class$java$util$Comparator};
    private static final Class[] sigSCO_HashMap = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = PersistenceManagerImpl.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$Class == null ? (class$java$lang$Class = PersistenceManagerImpl.class$("java.lang.Class")) : class$java$lang$Class, Boolean.TYPE, Integer.TYPE, Float.TYPE};
    private static final Class[] sigSCO_TreeMap = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = PersistenceManagerImpl.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$Class == null ? (class$java$lang$Class = PersistenceManagerImpl.class$("java.lang.Class")) : class$java$lang$Class, Boolean.TYPE, class$java$util$Comparator == null ? (class$java$util$Comparator = PersistenceManagerImpl.class$("java.util.Comparator")) : class$java$util$Comparator};
    private static final Integer int11 = new Integer(11);
    private static final Integer int10 = new Integer(10);
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jdo$common$PersistenceManagerImpl == null ? (class$com$sap$jdo$common$PersistenceManagerImpl = PersistenceManagerImpl.class$("com.sap.jdo.common.PersistenceManagerImpl")) : class$com$sap$jdo$common$PersistenceManagerImpl));
    private static final String commonBundle = "com.sap.jdo.common.Bundle";
    private static final I18NHelper msg = I18NHelper.getInstance((String)"com.sap.jdo.common.Bundle");
    private StateManagerInternal lookingFor = null;
    private PersistenceCapable pc = null;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$util$Comparator;
    static /* synthetic */ Class class$com$sap$jdo$common$PersistenceManagerImpl;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;
    static /* synthetic */ Class class$com$sap$jdo$common$sco$TreeSet;
    static /* synthetic */ Class class$com$sap$jdo$common$sco$HashSet;
    static /* synthetic */ Class class$com$sap$jdo$common$sco$TreeMap;
    static /* synthetic */ Class class$com$sap$jdo$common$sco$HashMap;
    static /* synthetic */ Class class$com$sap$jdo$common$sco$Hashtable;

    public PersistenceManagerImpl(PersistenceManagerFactoryInternal pmf, String username, String password) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("constructor");
        }
        this.pmf = (PersistenceManagerFactoryImpl)pmf;
        this._transaction = new TransactionImpl(this, this.pmf, username, password);
        this._txCache = new CacheManagerImpl(this);
        this.optimistic = pmf.getOptimistic();
        this._isClosed = false;
        this.myClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void setIgnoreCache(boolean flag) {
        this.assertIsOpen();
        this._ignoreCache = flag;
    }

    public boolean getIgnoreCache() {
        this.assertIsOpen();
        return this._ignoreCache;
    }

    public void setMultithreaded(boolean flag) {
        this.assertIsOpen();
        this.multithreaded = flag;
    }

    public boolean getMultithreaded() {
        this.assertIsOpen();
        return this.multithreaded;
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public synchronized void cleanup() {
        if (LOCATION.bePath()) {
            LOCATION.pathT("cleanup");
        }
        this.assertIsOpen();
        if (this._isClosed) {
            return;
        }
        if (this.current != null) {
            return;
        }
        this._txCache.close();
    }

    public synchronized void close() {
        if (LOCATION.bePath()) {
            LOCATION.pathT("close");
        }
        this.assertIsOpen();
        if (this._activeTransaction) {
            throw new JDOUserException(msg.msg("EXC_ActiveTransaction"));
        }
        if (this._isClosed) {
            return;
        }
        if (this.current != null) {
            return;
        }
        this._txCache.close();
        this.pmf.releasePersistenceManager(this, this._jta);
        this.pmf = null;
        this._jta = null;
        this._isClosed = true;
        this._transaction = null;
        this._txCache = null;
        this._userObject = null;
        this._isClosed = true;
    }

    public Transaction currentTransaction() {
        this.assertIsOpen();
        return this._transaction;
    }

    public Object getObjectById(Object oid, boolean validate) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getObjectById " + oid);
        }
        this.assertIsOpen();
        if (oid == null) {
            return null;
        }
        return this._txCache.getObjectById(oid, validate);
    }

    public Object getObjectId(Object pc) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getObjectId");
        }
        return this.getExternalObjectId(pc, false);
    }

    public Class loadClass(String name, ClassLoader given) throws ClassNotFoundException {
        if (null == given) {
            return this.loadClassInternal(name);
        }
        try {
            return Class.forName(name, true, given);
        }
        catch (ClassNotFoundException ex) {
            LOCATION.traceThrowableT(100, "loadClass,givenClassLoader", (Throwable)ex);
            return this.loadClassInternal(name);
        }
    }

    private Class loadClassInternal(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ex) {
            LOCATION.traceThrowableT(100, "loadClassInternal,ContextClassLoader", (Throwable)ex);
            return Class.forName(name, true, this.myClassLoader);
        }
    }

    public Class loadPCClassForObjectIdClass(Class objectIdClass) throws ClassNotFoundException {
        JDOClass jdoClass;
        if (LOCATION.bePath()) {
            LOCATION.pathT("loadPCClassForObjectIdClass: " + objectIdClass.getName());
        }
        JDOModelFactory factory = null;
        try {
            factory = RuntimeJDOModelFactoryImpl.getInstance();
        }
        catch (JDOModelException ex) {
            LOCATION.traceThrowableT(100, "RuntimeJDOModelFactoryImpl.getInstance", (Throwable)ex);
            return null;
        }
        try {
            jdoClass = factory.getJDOModel(objectIdClass.getClassLoader()).getJDOClassForObjectIdClass(objectIdClass);
        }
        catch (JDOModelException ex) {
            LOCATION.traceThrowableT(100, "factory.getJDOModel", (Throwable)ex);
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                jdoClass = factory.getJDOModel(classLoader).getJDOClassForObjectIdClass(objectIdClass);
            }
            catch (JDOModelException ex2) {
                LOCATION.traceThrowableT(100, "factory.getJDOModel", (Throwable)ex2);
                try {
                    jdoClass = factory.getJDOModel(this.myClassLoader).getJDOClassForObjectIdClass(objectIdClass);
                }
                catch (JDOModelException ex3) {
                    LOCATION.traceThrowableT(500, "factory.getJDOModel", (Throwable)ex3);
                    throw new ClassNotFoundException(msg.msg("EXC_CannotFindPCClassForObjectIdClass", (Object)objectIdClass.getName()));
                }
            }
        }
        return (Class)jdoClass.getJavaClass();
    }

    public Object getInternalObjectId(Object pc) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getInternalObjectId for " + pc.getClass().getName());
        }
        this.assertIsOpen();
        Object rc = null;
        if (pc instanceof PersistenceCapable) {
            PersistenceCapable p = (PersistenceCapable)pc;
            if (!p.jdoIsPersistent()) {
                throw new JDOFatalInternalException(msg.msg("EXC_TransientInstance", (Object)pc.getClass().getName()));
            }
            StateManagerInternal sm = this.findStateManager(p);
            if (sm == null) {
                throw new JDOFatalInternalException(msg.msg("EXC_CannotFindSM", (Object)pc.getClass().getName()));
            }
            rc = sm.getInternalObjectId();
        }
        return rc;
    }

    public Object getTransactionalObjectId(Object pc) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getTransactionalObjectId");
        }
        return this.getExternalObjectId(pc, true);
    }

    public Object newObjectIdInstance(Class pcClass, String str) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("newObjectIdInstance for: " + pcClass + ", and " + str);
        }
        this.assertIsOpen();
        return this.getStoreManager().newObjectIdInstance(pcClass, str);
    }

    public Class getObjectIdClass(Class cls) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getObjectIdClass for: " + cls);
        }
        this.assertIsOpen();
        return this.pmf.getObjectIdClass(cls);
    }

    public Query newQuery() {
        this.assertIsOpen();
        return new QueryImpl((PersistenceManagerInternal)this);
    }

    public Query newQuery(Object compiled) {
        this.assertIsOpen();
        return new QueryImpl((PersistenceManagerInternal)this, compiled);
    }

    public Query newQuery(String language, Object query) {
        this.assertIsOpen();
        if ("javax.jdo.query.JDOQL".equals(language)) {
            return new QueryImpl((PersistenceManagerInternal)this, query);
        }
        throw new JDOUserException(msg.msg("EXC_UnsupportedQueryLanguage", (Object)language));
    }

    public Query newQuery(Class cls) {
        this.assertIsOpen();
        return new QueryImpl((PersistenceManagerInternal)this, cls);
    }

    public Query newQuery(Extent cln) {
        this.assertIsOpen();
        return new QueryImpl((PersistenceManagerInternal)this, cln);
    }

    public Query newQuery(Class cls, Collection cln) {
        this.assertIsOpen();
        return new QueryImpl((PersistenceManagerInternal)this, cls, cln);
    }

    public Query newQuery(Class cls, String filter) {
        this.assertIsOpen();
        return new QueryImpl((PersistenceManagerInternal)this, cls, filter);
    }

    public Query newQuery(Class cls, Collection cln, String filter) {
        this.assertIsOpen();
        return new QueryImpl((PersistenceManagerInternal)this, cls, cln, filter);
    }

    public Query newQuery(Extent cln, String filter) {
        this.assertIsOpen();
        return new QueryImpl((PersistenceManagerInternal)this, cln, filter);
    }

    public Extent getExtent(Class persistenceCapableClass, boolean subclasses) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getExtent for: " + persistenceCapableClass + ", subclasses: " + subclasses);
        }
        this.assertIsOpen();
        Extent rc = null;
        if (!(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = PersistenceManagerImpl.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(persistenceCapableClass)) {
            throw new JDOUserException(msg.msg("EXC_ClassNotPersistenceCapable1", (Object)persistenceCapableClass.getName()));
        }
        rc = this.getStoreManager().getExtent(persistenceCapableClass, subclasses, this);
        if (null == rc) {
            rc = new EmptyExtent(persistenceCapableClass, subclasses);
        }
        return rc;
    }

    public void makePersistent(Object pc) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("makePersistent");
        }
        this.assertIsOpen();
        EJBImplHelper.registerOnActiveJTATransaction(this);
        this.assertActiveTransaction(false);
        this.makePersistentInternal(pc);
    }

    public void makePersistentAll(Object[] pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("makePersistentAll");
        }
        this.assertIsOpen();
        this.assertIsOpen();
        EJBImplHelper.registerOnActiveJTATransaction(this);
        this.assertActiveTransaction(false);
        this.makePersistentAllInternal(pcs);
    }

    public void makePersistentAll(Collection pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("makePersistentAll");
        }
        this.assertIsOpen();
        EJBImplHelper.registerOnActiveJTATransaction(this);
        this.assertActiveTransaction(false);
        this.makePersistentAllInternal(pcs.toArray());
    }

    public void deletePersistent(Object pc) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("deletePersistent");
        }
        this.assertIsOpen();
        EJBImplHelper.registerOnActiveJTATransaction(this);
        this.assertActiveTransaction(false);
        this.deletePersistentInternal(pc);
    }

    public void deletePersistentAll(Object[] pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("deletePersistentAll");
        }
        this.assertIsOpen();
        EJBImplHelper.registerOnActiveJTATransaction(this);
        this.assertActiveTransaction(false);
        this.deletePersistentAllInternal(pcs);
    }

    public void deletePersistentAll(Collection pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("deletePersistentAll");
        }
        this.assertIsOpen();
        EJBImplHelper.registerOnActiveJTATransaction(this);
        this.assertActiveTransaction(false);
        this.deletePersistentAllInternal(pcs.toArray());
    }

    public void makeTransient(Object pc) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("makeTransient");
        }
        this.assertIsOpen();
        this.makeTransientInternal(pc);
    }

    public void makeTransientAll(Object[] pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("makeTransientAll");
        }
        this.assertIsOpen();
        this.makeTransientAllInternal(pcs);
    }

    public void makeTransientAll(Collection pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("makeTransientAll");
        }
        this.assertIsOpen();
        this.makeTransientAll(pcs.toArray());
    }

    public void makeTransactional(Object pc) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("makeTransactional");
        }
        this.assertIsOpen();
        this.makeTransactionalInternal(pc);
    }

    public void makeTransactionalAll(Object[] pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("makeTransactionalAll");
        }
        this.assertIsOpen();
        this.makeTransactionalAllInternal(pcs);
    }

    public void makeTransactionalAll(Collection pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("makeTransactionalAll");
        }
        this.assertIsOpen();
        this.makeTransactionalAllInternal(pcs.toArray());
    }

    public void makeNontransactional(Object pc) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("makeNontransactional");
        }
        this.assertIsOpen();
        this.makeNontransactionalInternal(pc);
    }

    public void makeNontransactionalAll(Object[] pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("makeNontransactionalAll");
        }
        this.assertIsOpen();
        this.makeNontransactionalAllInternal(pcs);
    }

    public void makeNontransactionalAll(Collection pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("makeNontransactionalAll");
        }
        this.assertIsOpen();
        this.makeNontransactionalAllInternal(pcs.toArray());
    }

    public void evict(Object pc) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("evict");
        }
        this.assertIsOpen();
        this.evictInternal(pc);
    }

    public void evictAll(Object[] pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("evictAll");
        }
        this.assertIsOpen();
        this.evictAllInternal(pcs);
    }

    public void evictAll(Collection pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("evictAll");
        }
        this.assertIsOpen();
        this.evictAllInternal(pcs.toArray());
    }

    public void evictAll() {
        if (LOCATION.bePath()) {
            LOCATION.pathT("evictAll()");
        }
        this.assertIsOpen();
        this._txCache.evictAll();
    }

    public void refresh(Object pc) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("refresh");
        }
        this.assertIsOpen();
        this.refreshInternal(pc);
    }

    public void refreshAll(Object[] pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("refreshAll");
        }
        this.assertIsOpen();
        this.refreshAllInternal(pcs);
    }

    public void refreshAll(Collection pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("refreshAll");
        }
        this.assertIsOpen();
        this.refreshAllInternal(pcs.toArray());
    }

    public void refreshAll() {
        if (LOCATION.bePath()) {
            LOCATION.pathT("refreshAll()");
        }
        this.assertIsOpen();
        if (this._activeTransaction) {
            this._txCache.refreshAllTransactional();
        } else {
            this._txCache.refreshAllNontransactional();
        }
    }

    public void retrieve(Object pc) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("retrieve");
        }
        this.assertIsOpen();
        this.retrieveInternal(pc);
    }

    public void retrieveAll(Object[] pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("retrieveAll");
        }
        this.assertIsOpen();
        this.retrieveAllInternal(pcs);
    }

    public void retrieveAll(Collection pcs) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("retrieveAll");
        }
        this.assertIsOpen();
        this.retrieveAllInternal(pcs.toArray());
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        this.assertIsOpen();
        return this.pmf;
    }

    public void setUserObject(Object o) {
        this.assertIsOpen();
        this._userObject = o;
    }

    public Object getUserObject() {
        this.assertIsOpen();
        return this._userObject;
    }

    public Properties getProperties() {
        this.assertIsOpen();
        return JDORIVersion.getVendorProperties();
    }

    public void assertIsOpen() {
        if (this._isClosed) {
            throw new JDOFatalUserException(msg.msg("EXC_PersistenceManagerClosed"));
        }
    }

    public StoreManager getStoreManager() {
        this.assertIsOpen();
        return this.pmf.getStoreManager(this);
    }

    public Object newSCOInstanceInternal(Class type) {
        Class newType;
        if (LOCATION.bePath()) {
            LOCATION.pathT("newSCOInstanceInternal for: " + type);
        }
        if ((newType = this.pmf.getTrackedClass(type)) == null) {
            return null;
        }
        Object obj = null;
        try {
            Constructor constr = newType.getConstructor(null);
            if (constr != null) {
                obj = constr.newInstance(null);
            }
        }
        catch (Exception e) {
            throw new JDOUserException(msg.msg("EXC_CannotConstructSCO", (Object)newType.getName()), (Throwable)e);
        }
        return obj;
    }

    public Collection newCollectionInstanceInternal(Class type, Class elementType, boolean allowNulls, Integer initialSize, Float loadFactor, Collection initialContents, Comparator comparator) {
        Class newType;
        if (LOCATION.bePath()) {
            LOCATION.pathT("newCollectionInstanceInternal for: " + type);
        }
        if ((newType = this.pmf.getTrackedClass(type)) == null) {
            return null;
        }
        Object obj = null;
        SCOCollection rc = null;
        try {
            if ((class$com$sap$jdo$common$sco$TreeSet == null ? (class$com$sap$jdo$common$sco$TreeSet = PersistenceManagerImpl.class$("com.sap.jdo.common.sco.TreeSet")) : class$com$sap$jdo$common$sco$TreeSet) == newType) {
                Constructor constr = newType.getConstructor(sigSCO_TreeSet);
                if (constr != null) {
                    obj = constr.newInstance(elementType, new Boolean(allowNulls), comparator);
                }
            } else if (null == loadFactor) {
                Constructor constr = newType.getConstructor(sigSCO_Collection);
                if (constr != null) {
                    if (initialSize == null) {
                        initialSize = this.getInitialSize(newType);
                    }
                    obj = constr.newInstance(elementType, new Boolean(allowNulls), initialSize);
                }
            } else if ((class$com$sap$jdo$common$sco$HashSet == null ? (class$com$sap$jdo$common$sco$HashSet = PersistenceManagerImpl.class$("com.sap.jdo.common.sco.HashSet")) : class$com$sap$jdo$common$sco$HashSet) == newType) {
                Constructor constr = newType.getConstructor(sigSCO_HashSet);
                if (constr != null) {
                    if (initialSize == null) {
                        initialSize = this.getInitialSize(newType);
                    }
                    obj = constr.newInstance(elementType, new Boolean(allowNulls), initialSize, loadFactor);
                }
            } else {
                throw new IllegalArgumentException(msg.msg("EXC_IllegalArguments", (Object)type.getName()));
            }
            rc = obj;
            if (initialContents != null && initialContents.size() > 0) {
                rc.addAll(initialContents);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JDOUserException(msg.msg("EXC_CannotConstructSCO", (Object)newType.getName()), (Throwable)e);
        }
        return rc;
    }

    public Map newMapInstanceInternal(Class type, Class keyType, Class valueType, boolean allowNulls, Integer initialSize, Float loadFactor, Map initialContents, Comparator comparator) {
        Class newType;
        if (LOCATION.bePath()) {
            LOCATION.pathT("newMapInstanceInternal for: " + type);
        }
        if ((newType = this.pmf.getTrackedClass(type)) == null) {
            return null;
        }
        Object obj = null;
        SCOMap rc = null;
        try {
            if ((class$com$sap$jdo$common$sco$TreeMap == null ? (class$com$sap$jdo$common$sco$TreeMap = PersistenceManagerImpl.class$("com.sap.jdo.common.sco.TreeMap")) : class$com$sap$jdo$common$sco$TreeMap) == newType) {
                Constructor constr = newType.getConstructor(sigSCO_TreeMap);
                if (constr != null) {
                    obj = constr.newInstance(keyType, valueType, new Boolean(allowNulls), comparator);
                }
            } else if (null == loadFactor) {
                Constructor constr = newType.getConstructor(sigSCO_Map);
                if (constr != null) {
                    if (initialSize == null) {
                        initialSize = this.getInitialSize(newType);
                    }
                    obj = constr.newInstance(keyType, valueType, new Boolean(allowNulls), initialSize);
                }
            } else if ((class$com$sap$jdo$common$sco$HashMap == null ? (class$com$sap$jdo$common$sco$HashMap = PersistenceManagerImpl.class$("com.sap.jdo.common.sco.HashMap")) : class$com$sap$jdo$common$sco$HashMap) == newType || (class$com$sap$jdo$common$sco$Hashtable == null ? (class$com$sap$jdo$common$sco$Hashtable = PersistenceManagerImpl.class$("com.sap.jdo.common.sco.Hashtable")) : class$com$sap$jdo$common$sco$Hashtable) == newType) {
                Constructor constr = newType.getConstructor(sigSCO_HashMap);
                if (constr != null) {
                    if (initialSize == null) {
                        initialSize = this.getInitialSize(newType);
                    }
                    obj = constr.newInstance(keyType, valueType, new Boolean(allowNulls), initialSize, loadFactor);
                }
            } else {
                throw new IllegalArgumentException(msg.msg("EXC_IllegalArguments", (Object)type.getName()));
            }
            rc = obj;
            if (initialContents != null && initialContents.size() > 0) {
                rc.putAll(initialContents);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JDOUserException(msg.msg("EXC_CannotConstructSCO", (Object)newType.getName()), (Throwable)e);
        }
        return rc;
    }

    public boolean isSupportedSCOType(Class type) {
        return this.pmf.getTrackedClass(type) != null;
    }

    public void register(StateManagerInternal sm, Object oid, boolean transactional, boolean throwDuplicateException) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("register" + oid);
        }
        this._txCache.register(sm, oid, transactional, throwDuplicateException);
    }

    public void registerTransient(StateManagerInternal sm) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("registerTransient");
        }
        this._txCache.registerTransient(sm);
    }

    public void deregister(Object oid) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("deregister" + oid);
        }
        this._txCache.deregister(oid);
    }

    public void deregisterTransient(StateManagerInternal sm) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("deregisterTransient");
        }
        this._txCache.deregisterTransient(sm);
    }

    public void replaceObjectId(Object oldId, Object newId) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("replaceObjectId old: " + oldId + " new: " + newId);
        }
        if (!newId.equals(oldId)) {
            this._txCache.replaceObjectId(oldId, newId);
        }
    }

    public void markAsFlushed(StateManagerInternal sm) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("markAsFlushed");
        }
        if (!this._flushing) {
            this._txCache.markAsFlushed(sm);
        }
    }

    public boolean insideCommit() {
        return this._transaction.startedCommit();
    }

    public synchronized void hereIsStateManager(StateManagerInternal sm, PersistenceCapable pc) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("hereIsStateManager");
        }
        if (this.pc == pc) {
            this.lookingFor = sm;
        }
    }

    public StateManagerInternal getStateManager(Object oid, Class pcClass) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getStateManager");
        }
        return this._txCache.getStateManager(oid, pcClass);
    }

    public synchronized StateManagerInternal findStateManager(PersistenceCapable pc) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("findStateManager");
        }
        this.lookingFor = null;
        this.pc = pc;
        PersistenceManager pm = pc.jdoGetPersistenceManager();
        if (pm != null && !this.equals(pm)) {
            throw new JDOUserException(msg.msg("EXC_AnotherPersistenceManager"));
        }
        return this.lookingFor;
    }

    public PersistenceManager getCurrentWrapper() {
        if (EJBImplHelper.isManaged()) {
            return this;
        }
        return this.current;
    }

    public Collection getInsertedInstances() {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getInsertedInstances");
        }
        return this._txCache.getInsertedInstances();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PersistenceManagerWrapper) {
            return ((PersistenceManagerWrapper)obj).getPersistenceManager() == this;
        }
        if (obj instanceof PersistenceManagerImpl) {
            return (PersistenceManagerImpl)obj == this;
        }
        return false;
    }

    public ClassDescriptor getClassDescriptor(Class type) {
        return this.pmf.getClassDescriptor(type);
    }

    protected void pushCurrentWrapper(PersistenceManagerWrapper pmw) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("pushCurrentWrapper");
        }
        this.current = pmw;
    }

    protected void popCurrentWrapper(PersistenceManagerWrapper prev) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("popCurrentWrapper");
        }
        this.current = prev;
        if (this._jta == null && this.current == null) {
            this.close();
        }
    }

    protected void setJTATransaction(Object t) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("setJTATransaction");
        }
        if (this._jta != null) {
            throw new JDOFatalInternalException(msg.msg("EXC_NotNullJTATransaction"));
        }
        this._jta = t;
    }

    protected boolean verify(String username, String password) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("verify");
        }
        return this._transaction.verify(username, password);
    }

    protected void flushInstances() {
        if (LOCATION.bePath()) {
            LOCATION.pathT("flushInstances");
        }
        this.assertIsOpen();
        this.assertActiveTransaction(false);
        this._flushing = true;
        try {
            this._txCache.flushInstances();
            Object var2_1 = null;
            this._flushing = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._flushing = false;
            throw throwable;
        }
    }

    protected void afterCompletion(int status) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("afterCompletion");
        }
        this.assertIsOpen();
        this._flushing = true;
        boolean abort = status == 4 || status == 9 || status == 1;
        this._txCache.afterCompletion(abort);
        this._flushing = false;
    }

    public synchronized void flush() {
        if (LOCATION.bePath()) {
            LOCATION.pathT("flush");
        }
        this._transaction.internalFlush();
    }

    protected synchronized void notifyStatusChange(boolean isActive) {
        this._activeTransaction = isActive;
    }

    protected synchronized void notifyOptimistic(boolean optimistic) {
        this.optimistic = optimistic;
    }

    private Object getExternalObjectId(Object pc, boolean transactional) {
        PersistenceCapable p;
        if (LOCATION.bePath()) {
            LOCATION.pathT("getExternalObjectId");
        }
        this.assertIsOpen();
        if (pc != null && pc instanceof PersistenceCapable && (p = (PersistenceCapable)pc).jdoIsPersistent()) {
            return this._txCache.getExternalObjectId(p, transactional);
        }
        return null;
    }

    private void assertActiveTransaction(boolean insideQuery) {
        if (this._flushing || insideQuery && this._transaction.getNontransactionalRead()) {
            return;
        }
        if (!this._activeTransaction) {
            throw new JDOUserException(msg.msg("EXC_TransactionNotActive"));
        }
    }

    private void assertPersistenceCapable(Object pc) {
        if (!(pc instanceof PersistenceCapable)) {
            throw new JDOUserException(msg.msg("EXC_NotPersistenceCapable"), pc);
        }
    }

    private void validateResult(int l, Exception[] err) {
        if (l > 0) {
            Throwable[] t = new Exception[l];
            System.arraycopy(err, 0, t, 0, l);
            throw new JDOUserException(msg.msg("EXC_FailedToProcessAll"), t);
        }
    }

    private Integer getInitialSize(Class type) {
        if (type.equals(class$com$sap$jdo$common$sco$HashSet == null ? (class$com$sap$jdo$common$sco$HashSet = PersistenceManagerImpl.class$("com.sap.jdo.common.sco.HashSet")) : class$com$sap$jdo$common$sco$HashSet) || type.equals(class$com$sap$jdo$common$sco$HashMap == null ? (class$com$sap$jdo$common$sco$HashMap = PersistenceManagerImpl.class$("com.sap.jdo.common.sco.HashMap")) : class$com$sap$jdo$common$sco$HashMap) || type.equals(class$com$sap$jdo$common$sco$Hashtable == null ? (class$com$sap$jdo$common$sco$Hashtable = PersistenceManagerImpl.class$("com.sap.jdo.common.sco.Hashtable")) : class$com$sap$jdo$common$sco$Hashtable)) {
            return int11;
        }
        return int10;
    }

    private void makePersistentInternal(Object pc) {
        if (pc == null) {
            if (LOCATION.bePath()) {
                LOCATION.pathT("makePersistentInternal null");
            }
            return;
        }
        if (LOCATION.bePath()) {
            LOCATION.pathT("makePersistentInternal for " + pc.getClass().getName());
        }
        this.assertPersistenceCapable(pc);
        if (LOCATION.bePath()) {
            LOCATION.pathT("makePersistentInternal is pc");
        }
        PersistenceCapable p = (PersistenceCapable)pc;
        this._txCache.makePersistent(p);
    }

    private void makePersistentAllInternal(Object[] pcs) {
        Exception[] err = new Exception[pcs.length];
        int l = 0;
        if (LOCATION.bePath()) {
            LOCATION.pathT("makePersistentAllInternal " + pcs.length);
        }
        int i = 0;
        while (i < pcs.length) {
            try {
                this.makePersistentInternal(pcs[i]);
            }
            catch (Exception e) {
                err[l++] = e;
            }
            ++i;
        }
        this.validateResult(l, err);
    }

    private void deletePersistentInternal(Object pc) {
        if (pc == null) {
            return;
        }
        this.assertPersistenceCapable(pc);
        PersistenceCapable p = (PersistenceCapable)pc;
        if (!p.jdoIsPersistent()) {
            throw new JDOUserException(msg.msg("EXC_TransientInstance", (Object)pc.getClass().getName()));
        }
        StateManagerInternal sm = this.findStateManager(p);
        sm.deletePersistent();
    }

    private void deletePersistentAllInternal(Object[] pcs) {
        Exception[] err = new Exception[pcs.length];
        int l = 0;
        int i = 0;
        while (i < pcs.length) {
            try {
                this.deletePersistentInternal(pcs[i]);
            }
            catch (Exception e) {
                err[l++] = e;
            }
            ++i;
        }
        this.validateResult(l, err);
    }

    private void makeTransientInternal(Object pc) {
        if (pc == null) {
            return;
        }
        this.assertPersistenceCapable(pc);
        PersistenceCapable p = (PersistenceCapable)pc;
        this._txCache.makeTransient(p);
    }

    private void makeTransientAllInternal(Object[] pcs) {
        Exception[] err = new Exception[pcs.length];
        int l = 0;
        int i = 0;
        while (i < pcs.length) {
            try {
                this.makeTransientInternal(pcs[i]);
            }
            catch (Exception e) {
                err[l++] = e;
            }
            ++i;
        }
        this.validateResult(l, err);
    }

    private void makeTransactionalInternal(Object pc) {
        if (pc == null) {
            return;
        }
        this.assertPersistenceCapable(pc);
        PersistenceCapable p = (PersistenceCapable)pc;
        if (p.jdoIsPersistent()) {
            this.assertActiveTransaction(false);
        }
        this._txCache.makeTransactional(p);
    }

    private void makeTransactionalAllInternal(Object[] pcs) {
        Exception[] err = new Exception[pcs.length];
        int l = 0;
        int i = 0;
        while (i < pcs.length) {
            try {
                this.makeTransactionalInternal(pcs[i]);
            }
            catch (Exception e) {
                err[l++] = e;
            }
            ++i;
        }
        this.validateResult(l, err);
    }

    private void makeNontransactionalInternal(Object pc) {
        if (pc == null) {
            return;
        }
        this.assertPersistenceCapable(pc);
        PersistenceCapable p = (PersistenceCapable)pc;
        this._txCache.makeNontransactional(p);
    }

    private void makeNontransactionalAllInternal(Object[] pcs) {
        Exception[] err = new Exception[pcs.length];
        int l = 0;
        int i = 0;
        while (i < pcs.length) {
            try {
                this.makeNontransactionalInternal(pcs[i]);
            }
            catch (Exception e) {
                err[l++] = e;
            }
            ++i;
        }
        this.validateResult(l, err);
    }

    private void evictInternal(Object pc) {
        if (pc == null) {
            return;
        }
        this.assertPersistenceCapable(pc);
        PersistenceCapable p = (PersistenceCapable)pc;
        this._txCache.evict(p);
    }

    private void evictAllInternal(Object[] pcs) {
        Exception[] err = new Exception[pcs.length];
        int l = 0;
        int i = 0;
        while (i < pcs.length) {
            try {
                this.evict(pcs[i]);
            }
            catch (Exception e) {
                err[l++] = e;
            }
            ++i;
        }
        this.validateResult(l, err);
    }

    private void refreshInternal(Object pc) {
        if (pc == null) {
            return;
        }
        this.assertPersistenceCapable(pc);
        PersistenceCapable p = (PersistenceCapable)pc;
        this._txCache.refresh(p);
    }

    private void refreshAllInternal(Object[] pcs) {
        Exception[] err = new Exception[pcs.length];
        int l = 0;
        int i = 0;
        while (i < pcs.length) {
            try {
                this.refresh(pcs[i]);
            }
            catch (Exception e) {
                err[l++] = e;
            }
            ++i;
        }
        this.validateResult(l, err);
    }

    private void retrieveInternal(Object pc) {
        if (pc == null) {
            return;
        }
        this.assertPersistenceCapable(pc);
        PersistenceCapable p = (PersistenceCapable)pc;
        this._txCache.retrieve(p);
    }

    private void retrieveAllInternal(Object[] pcs) {
        Exception[] err = new Exception[pcs.length];
        int l = 0;
        int i = 0;
        while (i < pcs.length) {
            try {
                this.retrieve(pcs[i]);
            }
            catch (Exception e) {
                err[l++] = e;
            }
            ++i;
        }
        this.validateResult(l, err);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class EmptyExtent
    implements Extent {
        private final Class cls;
        private final boolean subclasses;

        EmptyExtent(Class cls, boolean subclasses) {
            this.cls = cls;
            this.subclasses = subclasses;
        }

        public Iterator iterator() {
            return new Iterator(this){
                private final /* synthetic */ EmptyExtent this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    return null;
                }

                public void remove() {
                }
            };
        }

        public boolean hasSubclasses() {
            return false;
        }

        public Class getCandidateClass() {
            return this.cls;
        }

        public boolean subclasses() {
            return this.subclasses;
        }

        public PersistenceManager getPersistenceManager() {
            return PersistenceManagerImpl.this.current;
        }

        public void closeAll() {
        }

        public void close(Iterator it) {
        }
    }
}

