/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.anttasks;

import com.sap.jdo.enhancer.Main;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class JDOEnhance
extends Task {
    private String destdir = null;
    private String classfile = null;
    private String metadata = null;
    private boolean verbose = false;
    private boolean force = false;
    private Path classpath = null;

    public void setClasspath(Path cp) {
        if (this.classpath == null) {
            this.classpath = cp;
        } else {
            this.classpath.append(cp);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.classpath.createPath();
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setVerbose(boolean aVerbose) {
        this.verbose = aVerbose;
    }

    public void setForce(boolean aForce) {
        this.force = aForce;
    }

    public void setDst(String aDst) {
        this.destdir = aDst;
    }

    public void setClassfile(String aClassfile) {
        this.classfile = aClassfile;
    }

    public void setMetadata(String aMetadata) {
        this.metadata = aMetadata;
    }

    public void execute() throws BuildException {
        int err;
        if (this.classfile == null || this.metadata == null) {
            throw new BuildException("The values of the \"classfile\" and \"metadata\" attributes must be provided.");
        }
        this.log("Using classfile: " + this.classfile, 2);
        this.log("Using metadata : " + this.metadata, 2);
        if (this.destdir != null) {
            this.log("Using dst      : " + this.destdir, 2);
        }
        if ((err = this.run(this.createCommand())) > 0) {
            switch (err) {
                case -2: {
                    throw new BuildException("JDO enhancer failed because of metadata error.");
                }
                case -1: {
                    throw new BuildException("JDO enhancer failed because of usage error.");
                }
            }
            throw new BuildException("JDO enhancer failed because of internal Error.");
        }
    }

    private int run(String[] command) throws BuildException {
        try {
            Main enhancer = new Main();
            return enhancer.process(command);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.out);
            throw new BuildException("JDO enhancer failed with internal exception", (Throwable)ex);
        }
    }

    String[] createCommand() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.verbose) {
            list.add("-v");
        }
        if (this.force) {
            list.add("-f");
        }
        if (this.destdir != null) {
            list.add("-d");
            list.add(this.destdir);
        }
        if (this.classpath != null) {
            list.add("-s");
            list.add(this.classpath.toString());
        }
        list.add(this.metadata);
        list.add(this.classfile);
        int size = list.size();
        String[] command = new String[size];
        String commandLine = "";
        int i = 0;
        while (i < size) {
            String commandPart;
            command[i] = commandPart = (String)list.get(i);
            commandLine = commandLine + " " + commandPart;
            ++i;
        }
        this.log("using command:" + commandLine, 3);
        return command;
    }
}

