/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo;

import com.sap.jdo.Connector;
import com.sap.jdo.PersistenceManagerInternal;
import com.sap.jdo.SAPJDOImplHelper;
import com.sap.jdo.SAPStoreManager;
import com.sap.jdo.StateManagerInternal;
import com.sap.jdo.StoreManager;
import com.sap.jdo.common.model.jdo.RuntimeJDOModelFactoryImpl;
import com.sap.jdo.model.jdo.JDOClass;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.model.jdo.JDOModelFactory;
import com.sap.jdo.query.QueryResult;
import com.sap.jdo.query.QueryResultHelper;
import com.sap.jdo.sql.jdbc.JDBCStoreManager;
import com.sap.tc.logging.Location;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Properties;
import javax.jdo.Extent;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.sql.DataSource;

public class StoreManagerAdapter
implements StoreManager {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jdo$StoreManagerAdapter == null ? (class$com$sap$jdo$StoreManagerAdapter = StoreManagerAdapter.class$("com.sap.jdo.StoreManagerAdapter")) : class$com$sap$jdo$StoreManagerAdapter));
    private boolean _bePath;
    private SAPStoreManager _storeManager = null;
    private JDOModelFactory _mf = null;
    static /* synthetic */ Class class$com$sap$jdo$StoreManagerAdapter;

    private StoreManagerAdapter(Properties properties) {
        try {
            this._mf = RuntimeJDOModelFactoryImpl.getInstance();
        }
        catch (JDOModelException e) {
            throw new JDOFatalInternalException("Cannot get instance of JDOModelFactory", (Throwable)e);
        }
    }

    public StoreManagerAdapter(PersistenceManagerInternal pm, String URL2, String userName, String password, String driverName, Properties properties) {
        this(properties);
        this._storeManager = new JDBCStoreManager(pm, URL2, userName, password, driverName, properties);
    }

    public StoreManagerAdapter(PersistenceManagerInternal pm, DataSource ds, Properties properties) {
        this(properties);
        this._storeManager = new JDBCStoreManager(pm, ds, properties);
    }

    public SAPStoreManager getSAPStoreManager() {
        return this._storeManager;
    }

    public Connector getConnector() {
        return this._storeManager.getConnector();
    }

    public Connector getConnector(String userid, String password) {
        return this._storeManager.getConnector(userid, password);
    }

    public int insert(BitSet loadedFields, BitSet dirtyFields, StateManagerInternal sm) {
        PersistenceCapable pc = sm.getObject();
        return this._storeManager.insert(loadedFields, loadedFields, pc, sm);
    }

    public int update(BitSet loadedFields, BitSet dirtyFields, StateManagerInternal sm) {
        String METHOD = "update(BitSet loadedFields, BitSet dirtyFields, StateManagerInternal sm)";
        this._bePath = LOCATION.bePath();
        if (this._bePath) {
            LOCATION.entering("update(BitSet loadedFields, BitSet dirtyFields, StateManagerInternal sm)", new Object[]{loadedFields, dirtyFields});
        }
        PersistenceCapable pc = sm.getObject();
        boolean keyFlag = false;
        boolean dfgFlag = false;
        boolean nonDfgFlag = false;
        byte[] fieldFlags = SAPJDOImplHelper.getInstance().getAllFieldFlags(pc.getClass());
        int i = 0;
        while (i < dirtyFields.length()) {
            if (dirtyFields.get(i)) {
                if ((fieldFlags[i] & 1) != 0 && (fieldFlags[i] & 4) != 0) {
                    dfgFlag = true;
                } else if ((fieldFlags[i] & 2) != 0 && (fieldFlags[i] & 8) != 0) {
                    nonDfgFlag = true;
                } else if ((fieldFlags[i] & 8) != 0) {
                    keyFlag = true;
                }
            }
            ++i;
        }
        if (keyFlag && !dfgFlag && !nonDfgFlag) {
            throw new JDOFatalDataStoreException("RESOLVE: update key fields not allowed?");
        }
        if (dfgFlag) {
            this._storeManager.updateDFG(pc, sm);
        }
        if (nonDfgFlag) {
            int i2 = 0;
            while (i2 < dirtyFields.length()) {
                if (dirtyFields.get(i2) && (fieldFlags[i2] & 2) != 0 && (fieldFlags[i2] & 8) != 0) {
                    this._storeManager.updateNonDFG(pc, sm, i2);
                }
                ++i2;
            }
        }
        if (this._bePath) {
            LOCATION.exiting();
        }
        return 1;
    }

    public int verifyFields(BitSet loadedFields, BitSet dirtyFields, StateManagerInternal sm) {
        String METHOD = "verifyFields(BitSet loadedFields, BitSet dirtyFields, StateManagerInternal sm)";
        this._bePath = LOCATION.bePath();
        if (this._bePath) {
            LOCATION.entering("verifyFields(BitSet loadedFields, BitSet dirtyFields, StateManagerInternal sm)", new Object[]{loadedFields, dirtyFields});
        }
        PersistenceCapable pc = sm.getObject();
        boolean keyFlag = false;
        boolean dfgFlag = false;
        boolean nonDfgFlag = false;
        byte[] fieldFlags = SAPJDOImplHelper.getInstance().getAllFieldFlags(pc.getClass());
        int i = 0;
        while (i < loadedFields.length()) {
            if (loadedFields.get(i)) {
                if ((fieldFlags[i] & 1) != 0 && (fieldFlags[i] & 4) != 0) {
                    dfgFlag = true;
                } else if ((fieldFlags[i] & 2) != 0 && (fieldFlags[i] & 8) != 0) {
                    nonDfgFlag = true;
                } else if ((fieldFlags[i] & 8) != 0) {
                    keyFlag = true;
                }
            }
            ++i;
        }
        if (keyFlag && !dfgFlag) {
            this._storeManager.verifyExistence(pc, sm);
        }
        if (dfgFlag) {
            this._storeManager.verifyDFG(pc, sm);
        }
        if (nonDfgFlag) {
            int i2 = 0;
            while (i2 < dirtyFields.length()) {
                if (loadedFields.get(i2) && (fieldFlags[i2] & 2) != 0 && (fieldFlags[i2] & 8) != 0) {
                    this._storeManager.verifyNonDFG(pc, sm, i2);
                }
                ++i2;
            }
        }
        if (this._bePath) {
            LOCATION.exiting();
        }
        return 1;
    }

    public int delete(BitSet loadedFields, BitSet dirtyFields, StateManagerInternal sm) {
        PersistenceCapable pc = sm.getObject();
        return this._storeManager.delete(loadedFields, loadedFields, pc, sm);
    }

    public void fetch(StateManagerInternal sm, int[] fieldNums) {
        String METHOD = "fetch(StateManagerInternal sm, int fieldNums[])";
        PersistenceCapable pc = sm.getObject();
        boolean keyFlag = false;
        boolean dfgFlag = false;
        boolean nonDfgFlag = false;
        byte[] fieldFlags = SAPJDOImplHelper.getInstance().getAllFieldFlags(pc.getClass());
        int i = 0;
        while (i < fieldNums.length) {
            if ((fieldFlags[fieldNums[i]] & 1) != 0 && (fieldFlags[fieldNums[i]] & 4) != 0) {
                dfgFlag = true;
            } else if ((fieldFlags[fieldNums[i]] & 2) != 0 && (fieldFlags[fieldNums[i]] & 8) != 0) {
                nonDfgFlag = true;
            } else if ((fieldFlags[fieldNums[i]] & 8) != 0) {
                keyFlag = true;
            }
            ++i;
        }
        if (keyFlag && !dfgFlag && !nonDfgFlag) {
            this._storeManager.fetchDFG(pc, sm);
        }
        if (dfgFlag) {
            this._storeManager.fetchDFG(pc, sm);
        }
        if (nonDfgFlag) {
            int i2 = 0;
            while (i2 < fieldNums.length) {
                if ((fieldFlags[fieldNums[i2]] & 2) != 0 && (fieldFlags[fieldNums[i2]] & 8) != 0) {
                    this._storeManager.fetchNonDFG(pc, sm, fieldNums[i2]);
                }
                ++i2;
            }
        }
    }

    public Extent getExtent(Class pcClass, boolean subclasses, PersistenceManagerInternal pm) {
        try {
            JDOModel jdoModel = this._mf.getJDOModel(pcClass.getClassLoader());
            if (!jdoModel.getJDOClass(pcClass.getName(), true).requiresExtent()) {
                throw new JDOUserException("Class " + pcClass.getName() + " is not enhanced with requires-extent=\"true\".");
            }
        }
        catch (JDOModelException e) {
            throw new JDOFatalInternalException("Cannot get instance of JDO model", (Throwable)e);
        }
        return this._storeManager.getExtent(pcClass, subclasses, pm);
    }

    public Object createObjectId(StateManagerInternal sm, PersistenceManagerInternal pm) {
        Object oid;
        PersistenceCapable pc = sm.getObject();
        Class<?> pcClass = pc.getClass();
        try {
            JDOModel jdoModel = this._mf.getJDOModel(pcClass.getClassLoader());
            JDOClass jdoClass = jdoModel.getJDOClass(pcClass.getName());
            Class oidClass = (Class)jdoClass.getPersistenceCapableRootClass().getObjectIdClass();
            if (oidClass == null) {
                throw new JDOFatalUserException("objectid-class unknown (probably no metadata provided)");
            }
            oid = oidClass.newInstance();
        }
        catch (JDOModelException e) {
            throw new JDOFatalInternalException("Cannot get instance of JDO model", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JDOFatalInternalException("Cannot access no-argument-constructor", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new JDOFatalInternalException("Cannot create new instance", (Throwable)e);
        }
        pc.jdoCopyKeyFieldsToObjectId(oid);
        return oid;
    }

    public Object getExternalObjectId(Object objectId, PersistenceCapable pc) {
        Object externalObjectId = pc.jdoNewObjectIdInstance();
        pc.jdoCopyKeyFieldsToObjectId(externalObjectId);
        return externalObjectId;
    }

    public Object getInternalObjectId(Object objectId, PersistenceManagerInternal pm) {
        return objectId;
    }

    public Object getInternalObjectId(Object objectId, PersistenceCapable pc) {
        return objectId;
    }

    public Object newObjectIdInstance(Class pcClass, String string) {
        String METHOD = "newObjectIdInstance(Class pcClass, String string)";
        if (LOCATION.beDebug()) {
            LOCATION.debugT("newObjectIdInstance(Class pcClass, String string)", "new OID for {0} and \"{1}\"", new Object[]{pcClass, string});
        }
        return JDOImplHelper.getInstance().newObjectIdInstance(pcClass, string);
    }

    public void copyKeyFieldsFromObjectId(StateManagerInternal sm, Class pcClass) {
        throw new UnsupportedOperationException();
    }

    public boolean hasActualPCClass(Object objectId) {
        return true;
    }

    public Class getPCClassForOid(Object oid, PersistenceManagerInternal pm) {
        String METHOD = "getPCClassForOid(Object oid, PersistenceManagerInternal pm)";
        Class pcClass = null;
        Class rootPCClass = null;
        try {
            rootPCClass = pm.loadPCClassForObjectIdClass(oid.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new JDOFatalInternalException("PC Class for OID class " + oid.getClass().getName() + " not found", (Throwable)e);
        }
        if (rootPCClass == null) {
            throw new JDOFatalInternalException("PC Class for OID class " + oid.getClass().getName() + " not loaded");
        }
        pcClass = this._storeManager.fetchDiscriminator(rootPCClass, oid);
        if (pcClass == null) {
            throw new JDOFatalInternalException("ASSERTION FAILED");
        }
        if (LOCATION.beInfo()) {
            LOCATION.infoT("getPCClassForOid(Object oid, PersistenceManagerInternal pm)", "Oid \"{1}\" has type {0}", new Object[]{pcClass.getName(), oid});
        }
        return pcClass;
    }

    public void flush(Iterator it, PersistenceManagerInternal pm) {
        String METHOD = "flush(Iterator it, PersistenceManagerInternal pm)";
        this._bePath = LOCATION.bePath();
        if (this._bePath) {
            LOCATION.entering("flush(Iterator it, PersistenceManagerInternal pm)");
        }
        while (it.hasNext()) {
            StateManagerInternal sm = (StateManagerInternal)it.next();
            sm.preStore();
            sm.replaceSCOFields();
            sm.flush(this);
            if (!sm.isFlushed()) break;
        }
        this._storeManager.flush();
        if (this._bePath) {
            LOCATION.exiting();
        }
    }

    public QueryResult newQueryResult(QueryResultHelper qrh) {
        return this._storeManager.newQueryResult(qrh);
    }

    public void close() {
        this._storeManager.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

